/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GraphConf.h,v 1.7 2010/07/08 18:16:24 bowkenken Exp $
***************************************************************/

#ifndef GRAPH_CONF_H
#define GRAPH_CONF_H	1

////////////////////////////////////////////////////////////////
// եå
////////////////////////////////////////////////////////////////

#ifdef D_WS
# include <WSCstring.h>
#endif // D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif // D_GTK

#ifdef D_IPHONE
# include "IPhoneWSCstring.h"
#endif // D_IPHONE

#ifdef D_MFC
# include "MfcWSCstring.h"
#endif // D_GTK

#include "GraphConfToken.h"

////////////////////////////////////////////////////////////////

class GraphConf {

	// ץ饤١ȡСѿ
private:

	GraphConf *prev;
	GraphConf *next;

	WSCstring sDir;

	WSCstring title;
	long scale;
	long tile_size_x;
	long tile_size_y;
	WSCstring character_patern;
	WSCstring pc_patern;
	WSCstring monster_patern;
	WSCstring wall_patern;
	WSCstring town_wall_patern;
	WSCstring dungeon_wall_patern;
	WSCstring door_patern;
	WSCstring signboard_patern;
	bool text_mode;
	long font_size_point;
	long font_size_dot;

	// ѥ֥åСѿ
public:

	// ѥ֥åСؿ
public:

	GraphConf();
	~GraphConf();

	void setHead();
	GraphConf *getPrev();
	GraphConf *getNext();
	void insert( GraphConf *ls );

	void setDir( WSCstring dir );
	WSCstring getDir();

	bool setNum( GraphConfToken token, long n );
	bool setStr( GraphConfToken token, WSCstring str );
	long getNum( GraphConfToken token );
	WSCstring getStr( GraphConfToken token );

	// ץ饤١ȡСؿ
private:

};

#endif /* GRAPH_CONF_H */
