/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: MouseMotion.h,v 1.9 2010/01/07 07:22:37 bowkenken Exp $
***************************************************************/

#ifndef MOUSE_MOTION_H
#define MOUSE_MOTION_H

////////////////////////////////////////////////////////////////
// ޥ⡼
////////////////////////////////////////////////////////////////

class MouseMotion {
private:
	// ɥåΤ X Ⱦ¤Υǥե
	static const long nDefaultDragXR = 32;
	// ɥåΤ Y Ⱦ¤Υǥե
	static const long nDefaultDragYR = 32;
	// åΤ X Ⱦ¤Υǥե
	static const long nDefaultClickXR = 8;
	// åΤ Y Ⱦ¤Υǥե
	static const long nDefaultClickYR = 8;

public:
	// ܥֹ
	enum MouseButtonN {
		nMouseButton0,
		nMouseButton1,
		nMouseButton2,
		nMouseButton3,
		nMouseButton4,
		nMouseButton5,
		nMouseButton6,
		nMouseButton7,
		nMouseButton8,
		nMouseButton9,
		nMouseButton10,
		nMouseButton11,
		nMouseButton12,
		nMouseButton13,
		nMouseButton14,
		nMouseButton15,
		nMouseButtonMaxN,

		nMouseButtonMinN = nMouseButton0,
		nMouseButtonL = nMouseButton0,
		nMouseButtonM = nMouseButton1,
		nMouseButtonR = nMouseButton2,
	};

	// ⡼μ
	enum MotionKind {
		// ɥå
		nMotionDrag,
		// Υɥå
		nMotionLeft,
		// Υɥå
		nMotionRight,
		// Υɥå
		nMotionUp,
		// Υɥå
		nMotionDown,

		nMotionKindMaxN,

		nMotionKindMinN = nMotionDrag,
	};

	// μ
	enum ScrollKind {
		// 
		nScrollLeft,
		// 
		nScrollRight,
		// 她
		nScrollUp,
		// 
		nScrollDown,

		nScrollKindMaxN,

		nScrollKindMinN = nScrollLeft,
	};

	// Хåؿη
	typedef void (*tFunc)(
			long n,
			long nBgnX, long nBgnY,
			long nCurX, long nCurY );

private:
	// ɥåϺɸ
	long nBgnX[nMouseButtonMaxN], nBgnY[nMouseButtonMaxN];
	// ɥåΤȾ
	long nDragXR, nDragYR;
	// åΤȾ
	long nClickXR, nClickYR;
	// Ϣ³ƥ⡼ʤ٤Υե饰
	bool bFlagOnce[nMotionKindMaxN];
	// ץ쥹Υե饰
	bool bFlagPress[nMouseButtonMaxN];

	// ݥȤΥХåؿ
	tFunc pFuncPoint;
	// ⡼ΥХåؿ
	tFunc pFunc[nMouseButtonMaxN][nMotionKindMaxN];
	// åΥХåؿ
	tFunc pFuncClick[nMouseButtonMaxN];
	// ֥롦åΥХåؿ
	tFunc pFuncDoubleClick[nMouseButtonMaxN];
	// +åΥХåؿ
	tFunc pFuncClickLR;
	// +åΥХåؿ
	tFunc pFuncClickRL;
	// ץ쥹ΥХåؿ
	tFunc pFuncPress[nMouseButtonMaxN];
	// ꡼ΥХåؿ
	tFunc pFuncRelease[nMouseButtonMaxN];
	// ΥХåؿ
	tFunc pFuncScroll[nScrollKindMaxN];

public:
	MouseMotion();

	void setFuncPoint( tFunc func );
	void setFunc(
			MouseButtonN btn, MotionKind mot,
			tFunc func );
	void setFuncClick( MouseButtonN btn, tFunc func );
	void setFuncDoubleClick( MouseButtonN btn, tFunc func );
	void setFuncClickLR(
			MouseButtonN btnPress,
			tFunc func );
	void setFuncPress( MouseButtonN btn, tFunc func );
	void setFuncRelease( MouseButtonN btn, tFunc func );
	void setFuncScroll( ScrollKind dir, tFunc func );

	void setRegionSize(
			long dxr, long dyr,
			long cxr, long cyr );

	bool begin( MouseButtonN n, long x, long y );
	bool end( MouseButtonN n, long x, long y );
	bool checkPressAndClick(
			MouseButtonN pressN,
			MouseButtonN clickN );
	bool move( long x, long y );

	bool point( long x, long y );
	bool drag( MouseButtonN n, long x, long y );
	bool click( MouseButtonN n, long x, long y );
	bool doubleClick( MouseButtonN n, long x, long y );
	bool clickLR(
			MouseButtonN pressN,
			MouseButtonN clickN,
			long x, long y );
	bool press( MouseButtonN n, long x, long y );
	bool release( MouseButtonN n, long x, long y );
	void releaseAll( long x, long y );
	bool mouseScroll( ScrollKind dir );
};

#endif /* MOUSE_MOTION_H */
