/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
/*#include	<sys/stat.h>*/

#ifdef	D_UNIX
#include	<unistd.h>
#endif	/* D_UNIX */

#ifdef	D_X68K
#include	<doslib.h>
#endif

#include	"gmain.h"
/*#include	"dun.h"*/
#include	"town.h"
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
#include	"msg.h"
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"menu_prot.h"
#include	"tmenu_prot.h"
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
#include	"msg_prot.h"

/**/

#ifdef	D_CLK_TCK
#undef	CLK_TCK
#define	CLK_TCK	D_CLK_TCK
#endif	/* D_CLK_TCK */

/**/

#include	"draw_tab.h"

/**/

#define	STR_ERROR	"ERROR: %s\n"
#define	STR_WARNING	"WARNING: %s\n"

#define	FLG_PRINT_ERR	(1 << 0)
#define	FLG_PRINT_REV	(1 << 1)

#define	ESC_KEY_WAIT_FRAME	50

/**/

/* list message begin */

typedef struct {
	char	msg[SCREEN_WIDTH * 2 + 1];
	curs_attr_t	attr;
} ls_msg_t;

ls_msg_t	ls_msg[LS_MSG_MAX_N];

long	ls_msg_idx;
long	ls_msg_n;

bool_t	flg_ls_msg;
bool_t	flg_msg_mul_line;

/* list message end */

bool_t	flg_draw_menu;

pos_t	map_draw_pos;

rate_t	vfx_wait;
flg_vfx_mbr_t	flg_vfx_mbr;
flg_vfx_mnstr_t	flg_vfx_mnstr;

curs_attr_t	g_vfx_attr;

/**/

void	init_draw( void )
{
	ls_msg_idx = -1;
	ls_msg_n = 0;
	flg_ls_msg = FALSE;

	flg_draw_menu = FALSE;
	set_msg_mul_line( TRUE );

	vfx_wait = 100;

	flg_vfx_mbr |= FLG_VFX_MBR_HP_ADD;
	flg_vfx_mbr |= FLG_VFX_MBR_HP_SUB;
	flg_vfx_mbr |= FLG_VFX_MBR_HP_SUB_CRTCL;
	flg_vfx_mbr |= FLG_VFX_MBR_ARW;

	flg_vfx_mnstr |= FLG_VFX_MNSTR_HP_ADD;
	flg_vfx_mnstr |= FLG_VFX_MNSTR_HP_SUB;
	flg_vfx_mnstr |= FLG_VFX_MNSTR_HP_SUB_CRTCL;
	flg_vfx_mnstr |= FLG_VFX_MNSTR_ARW;
}

/**/

void	print_wrn( const char *s, ... )
{
	static char	str[SCREEN_WIDTH * 2 + 1];
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( str, s, argptr );
	va_end( argptr );

	dis_scrn();

	fprintf( stderr, STR_WARNING, str );
	fflush( stderr );

	ena_scrn( FALSE );
}

/**/

void	print_err( const char *s, ... )
{
	static char	str[SCREEN_WIDTH * 2 + 1];
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( str, s, argptr );
	va_end( argptr );

	dis_scrn();

	fprintf( stderr, STR_ERROR, str );
	fflush( stderr );

	ena_scrn( FALSE );
}

/**/

void	print_msg( flg_msg_t flg, const char *s, ... )
{
	static char	buf[SCREEN_WIDTH * 2 + 1];
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	print_msg_n( CURS_ATTR_N_NORMAL, flg, MSG_S, buf );
}

/**/

void	print_msg_mbr( chr_t *chr, flg_msg_t flg, const char *s, ... )
{
	static char	buf[SCREEN_WIDTH * 2 + 1];
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	if( (chr == NULL) || (chr->kind == CHR_KIND_MBR) )
		print_msg_n( CURS_ATTR_N_NORMAL, flg, MSG_S, buf );
}

/**/

void	print_msg_n(
	curs_attr_n_t attr_n, flg_msg_t flg, const char *s, ...
)
{
	static char	buf[SCREEN_WIDTH * 2 + 1];
	va_list	argptr;
	curs_attr_t	*attr;

	attr = get_curs_attr();

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	print_msg_attr( &(attr[attr_n]), flg, MSG_S, buf );
}

/**/

void	print_msg_attr(
	curs_attr_t *attr, flg_msg_t flg, const char *s, ...
)
{
	static char	buf[SCREEN_WIDTH * 2 + 1];
	bool_t	flg_mul;
	va_list	argptr;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	flg_mul = chk_msg_mul_line();

	if( !flg_mul )
		more( (flg & ~FLG_MSG_MORE), flg_mul );

	if( chk_curs() )
		wipe_msg();

	if( buf[0] == '\0' ){
		flg_ls_msg = FALSE;
	} else {
		flg_ls_msg = TRUE;

		ls_msg_idx++;
		ls_msg_n++;
		if( ls_msg_n > LS_MSG_MAX_N )
			ls_msg_n = LS_MSG_MAX_N;

		strncpy( ls_msg[ls_msg_idx % LS_MSG_MAX_N].msg, buf,
				SCREEN_WIDTH * 2 );
		ls_msg[ls_msg_idx % LS_MSG_MAX_N].attr = *attr;

		if( flg_mul ){
			print_log();
		} else {
			print_str_attr( WIN_MSG_DRAW_MIN_X,
					WIN_MSG_DRAW_MIN_Y,
					attr, MSG_FMT_MSG,
					WIN_MSG_DRAW_WIDTH, buf );
		}
	}

	if( chk_flg( flg, FLG_MSG_MORE ) ){
		more( flg, flg_mul );
		if( !flg_mul )
			wipe_msg();
	}
}

/**/

void	more( flg_msg_t flg, bool_t flg_mul )
{
	static flg_msg_t	prev_flg;
	static long	prev_turn = -1;
	long	turn;
	bool_t	flg_ret;
	long	y;

	turn = get_turn();

	if( flg_mul )
		y = get_max_line() - 1;
	else
		y = WIN_MORE_DRAW_MIN_Y;

	/* Check More begin */

	flg_ret = FALSE;

	if( flg_mul )
		flg_ret = TRUE;
	if( prev_turn != turn )
		flg_ret = TRUE;
	if( chk_flg( flg, FLG_MSG_NO_MORE_PREV ) )
		flg_ret = TRUE;
	if( chk_flg( prev_flg, FLG_MSG_NO_MORE_NEXT ) )
		flg_ret = TRUE;
	if( chk_flg( flg, FLG_MSG_MORE ) )
		flg_ret = FALSE;

	prev_flg = flg;
	prev_turn = turn;

	if( flg_ret )
		return;

	/* Check More end */

	print_str( WIN_MORE_DRAW_MIN_X, y, FLG_PRINT_REV, MSG_MORE );

	get_key( FALSE );

	print_str( WIN_MORE_DRAW_MIN_X, y, FLG_NULL, MSG_MORE_CLEAR );
}

/**/

void	wipe_msg( void )
{
	if( chk_msg_mul_line() )
		return;

	print_str( WIN_MSG_DRAW_MIN_X, WIN_MSG_DRAW_MIN_Y,
			FLG_NULL, MSG_FMT_MSG,
			WIN_MSG_DRAW_WIDTH, MSG_NULL );
}

/**/

void	clr_msg( void )
{
	print_msg( FLG_MSG_NO_MORE_PREV | FLG_MSG_NO_MORE_NEXT, MSG_NULL );
}

/**/

void	redraw_msg( void )
{
	if( chk_msg_mul_line() ){
		print_log();
		return;
	}

	if( chk_curs() ){
		print_str( WIN_MSG_DRAW_MIN_X, WIN_MSG_DRAW_MIN_Y,
				FLG_NULL, MSG_FMT_MSG,
				WIN_MSG_DRAW_WIDTH, MSG_NULL );
	}

	if( ls_msg_idx < 0 )
		return;
	if( !flg_ls_msg )
		return;

	print_str_attr( WIN_MSG_DRAW_MIN_X, WIN_MSG_DRAW_MIN_Y,
			&(ls_msg[ls_msg_idx % LS_MSG_MAX_N].attr),
			MSG_FMT_MSG, WIN_MSG_DRAW_WIDTH,
			ls_msg[ls_msg_idx % LS_MSG_MAX_N].msg );
}

/**/

void	print_log( void )
{
	print_log_back( ls_msg_idx );
}

void	print_log_back( long idx )
{
	long	y, max_y;
	long	n;

	max_y = get_max_line();
	n = idx - get_ls_msg_page() + 2;

	for( y = WIN_MSG_DRAW_MIN_Y; y < max_y; y++, n++ ){
		if( chk_curs() ){
			print_str( WIN_MSG_DRAW_MIN_X, y,
					FLG_NULL, MSG_FMT_MSG,
					WIN_MSG_DRAW_WIDTH, MSG_NULL );
		}

		if( n < 0 )
			continue;

		print_str_attr( WIN_MSG_DRAW_MIN_X, y,
				&(ls_msg[n % LS_MSG_MAX_N].attr),
				MSG_FMT_MSG,
				WIN_MSG_DRAW_WIDTH,
				ls_msg[n % LS_MSG_MAX_N].msg );
	}
}

/**/

long	get_ls_msg_idx( void )
{
	return ls_msg_idx;
}

/**/

long	get_ls_msg_page( void )
{
	return( get_max_line() - WIN_MSG_DRAW_MIN_Y + 1);
}

/**/

bool_t	set_msg_mul_line( bool_t flg )
{
	flg_msg_mul_line = flg;

	return flg_msg_mul_line;
}

/**/

bool_t	chk_msg_mul_line( void )
{
	return flg_msg_mul_line;
}

/**/

long	get_ls_msg_n( void )
{
	return ls_msg_n;
}

/**/

void	draw_ls_msg( long n )
{
	long	i;
	long	msg_n;
	char	spc[SCREEN_WIDTH * 2 + 1];

	flg_draw_menu = TRUE;

	for( i = 0; i < SCREEN_WIDTH * 2; i++ )
		spc[i] = ' ';
	spc[i] = '\0';

	wipe_all();

	for( i = 0; i < LS_MSG_DRAW_N; i++ ){
		if( n + i >= ls_msg_n ){
			print_str( WIN_MSG_DRAW_MIN_X,
					LS_MSG_DRAW_N - i - 1,
					FLG_NULL, spc );
		} else {
			msg_n = ls_msg_idx - (n + i);
			msg_n += LS_MSG_MAX_N;
			msg_n %= LS_MSG_MAX_N;
			print_str_attr( WIN_MSG_DRAW_MIN_X,
					LS_MSG_DRAW_N - i - 1,
					&(ls_msg[msg_n].attr),
					MSG_S, ls_msg[msg_n].msg );
		}
	}

	print_str( SCREEN_MIN_X, WIN_MAP_DRAW_MAX_Y + 1,
			FLG_NULL, MSG_S, MSG_H_FRAME );
}

/**/

void	print_str(
	long scrn_x, long scrn_y, flg_print_t flg,
	const char *s, ...
)
{
	va_list	argptr;
	static char	buf[SCREEN_WIDTH * 2 + 1];
	curs_attr_t	*p, attr;

	p = get_curs_attr();
	if( p == NULL )
		return;
	attr = p[CURS_ATTR_N_NORMAL];

	if( chk_flg( flg, FLG_PRINT_REV ) )
		attr.attr |= A_REVERSE;

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	print_str_attr( scrn_x, scrn_y, &attr, MSG_S, buf );
}

/**/

void	print_str_n(
	long scrn_x, long scrn_y, curs_attr_n_t attr_n,
	const char *s, ...
)
{
	va_list	argptr;
	static char	buf[SCREEN_WIDTH * 2 + 1];
	curs_attr_t	*ls_attr;

	ls_attr = get_curs_attr();

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	print_str_attr( scrn_x, scrn_y, &(ls_attr[attr_n]), MSG_S, buf );
}

/**/

void	print_str_attr(
	long scrn_x, long scrn_y, curs_attr_t *attr,
	const char *s, ...
)
{
	va_list	argptr;
	static char	buf[SCREEN_WIDTH * 2 + 1];

	va_start( argptr, s );
	vsprintf( buf, s, argptr );
	va_end( argptr );

	if( (scrn_x < SCREEN_MIN_X)
			|| (scrn_y < SCREEN_MIN_Y)
			|| (scrn_x > SCREEN_MAX_X)
			|| (scrn_x > SCREEN_MAX_X) ){
		return;
	}
	buf[SCREEN_WIDTH - scrn_x] = '\0';

	curs_move( scrn_y, scrn_x );
	curs_attrset_dir( attr );

	curs_printw( MSG_S, buf );

	curs_attrset_n( CURS_ATTR_N_NORMAL );
	curs_refresh();
}

/**/

void	wipe_all( void )
{
	curs_clear();
	curs_refresh();
}

/**/

void	redraw_all( void )
{
	wipe_all();
	redraw_map();
	draw_all_mbr_stat();
	redraw_msg();
}

/**/

void	draw_map( long map_x, long map_y, long dx, long dy )
{
	dun_t *dun;
	long	i, j;
	long	mjr, mnr;
	long	scrn_x, scrn_y, pre_x;
	flg_print_t	flg, pre_flg;
	static char	buf[WIN_MAP_DRAW_WIDTH * 8 + 1];

	dun = get_dun();

	set_map_total( map_x, map_y, dx, dy );

	pre_flg = FLG_NULL;
	flg = FLG_NULL;
	for( i = 0; i < dy; i++ ){
		if( !clip_y( map_y + i ) )
			continue;

		buf[0] = '\0';
		pre_x = -128;
		for( j = 0; j < dx; j++ ){
			if( !clip_x( map_x + j ) )
				continue;

			mjr = dun->map.total.mjr[map_y + i][map_x + j];
			mnr = dun->map.total.mnr[map_y + i][map_x + j];

			scrn_x = (map_x - map_draw_pos.x + j) * 2;
			scrn_y = map_y - map_draw_pos.y + i;
			if( scrn_x < 0 )
				continue;
			if( scrn_x > WIN_MAP_DRAW_MAX_X )
				continue;
			if( scrn_y < 0 )
				continue;
			if( scrn_y > WIN_MAP_DRAW_MAX_Y )
				continue;

			curs_attrset_dir( &(dun->map.attr
					[map_y + i][map_x + j]) );

			if( pre_x != scrn_x - 1 ){
				curs_move( scrn_y, scrn_x );
			}

			pre_x = scrn_x;
			curs_printw( "%c%c", mjr, mnr );

			curs_attrset_n( CURS_ATTR_N_NORMAL );
		}
	}

	curs_attroff( A_REVERSE );

	curs_refresh();
}

/**/

void	redraw_map( void )
{
	pos_t	*draw;
	long	x, y;

	draw = get_map_draw_pos();
	draw_map( draw->x, draw->y, WIN_MAP_WIDTH, WIN_MAP_HEIGHT );

	/* ɥ */
	x = WIN_MAP_DRAW_MAX_X + 1;
	y = WIN_MAP_DRAW_MIN_Y;

	for( ; y <= WIN_MAP_DRAW_MAX_Y; y++ ){
		curs_move( y, x );
		curs_printw( MSG_S, MSG_V_LINE );
	}

	x = WIN_MAP_DRAW_MIN_X;
	y = WIN_MAP_DRAW_MAX_Y + 1;
	curs_move( y, x );
	for( ; x <= WIN_MAP_DRAW_MAX_X; x++ ){
		curs_printw( MSG_S, MSG_H_LINE );
	}
	curs_printw( MSG_S, MSG_CROSS );

	curs_refresh();
}

/**/

void	draw_party( void )
{
	party_t	*pty;
	long	i;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ )
		draw_mbr( pty->mbr[i] );

	draw_square();
}

/**/

void	draw_mbr( mbr_t *mbr )
{
	if( mbr == NULL )
		return;

	draw_map( mbr->pre_x - 1, mbr->pre_y - 1, 3, 3 );
	draw_map( mbr->x - 1, mbr->y - 1, 3, 3 );
}

/**/

void	draw_square( void )
{
	party_t	*pty;

	pty = get_party();

	draw_map( pty->square.pre_x - 1,
			pty->square.pre_y - 1, 3, 3 );
	draw_map( pty->square.x - 1,
			pty->square.y - 1, 3, 3 );
}

/**/

void	draw_all_mnstr( void )
{
	mnstr_t	*used, *p;

	used = get_mnstr_used();

	for( p = used->next; (p != NULL) && (p != used); p = p->next )
		draw_mnstr( p );
}

/**/

void	draw_mnstr( mnstr_t *p )
{
	if( p == NULL )
		return;

	draw_map( p->pre_x, p->pre_y, 1, 1 );
	draw_map( p->x, p->y, 1, 1 );
}

/**/

void	draw_door( long dr_n )
{
	dun_t	*dun;

	dun = get_dun();

	draw_map( dun->door[dr_n].x, dun->door[dr_n].y,
			dun->door[dr_n].dx, dun->door[dr_n].dy );
}

/**/

void	draw_item( item_t *p )
{
	draw_map( p->x, p->y, 1, 1 );
}

/**/

void	draw_trap( trap_t *p )
{
	draw_map( p->x, p->y, 1, 1 );
}

/**/

void	draw_menu( draw_menu_t *data )
{
	long	x, y;
	long	height, width;
	long	width_contents, width_accel;
	long	len_ttl, len_chk, len_direct, len_v_line, len_line;
	long	len_head_corner, len_foot_corner, len_foot;
	long	len_open_win, len_branch;
	static char	str_contents[SCREEN_WIDTH * 2 + 1];
	static char	str_head[SCREEN_WIDTH * 2 + 1];
	static char	str_foot[SCREEN_WIDTH * 2 + 1];
	static char	str_accel[SCREEN_WIDTH * 2 + 1];
	static char	str_direct[SCREEN_WIDTH * 2 + 1];
	char	*str_chk, *str_open_win, *str_branch;
	bool_t	flg_use_on_off;
	long	i;

	if( data == NULL )
		return;

	flg_draw_menu = TRUE;

	/* ɥȹ⤵Ȥ */
	sprintf( str_direct, MSG_MENU_DIRECT_FMT, 'A' );
	len_direct = str_len_draw( str_direct );
	len_chk = max( str_len_draw( MSG_MENU_FLG_LS_CHK_ON ),
			str_len_draw( MSG_MENU_FLG_LS_CHK_OFF ) );
	len_v_line = str_len_draw( MSG_MENU_V_LINE );
	len_head_corner = str_len_draw( MSG_MENU_CORNER ) * 2;
	len_foot_corner = str_len_draw( MSG_MENU_LEFT_PREV )
			+ str_len_draw( MSG_MENU_RIGHT_NEXT );
	if( data->ttl == NULL )
		len_ttl = 0;
	else
		len_ttl = str_len_draw( data->ttl );

	len_open_win = 0;
	len_branch = 0;
	width_contents = 0;
	width_accel = 0;
	height = 0;
	flg_use_on_off = FALSE;
	for( i = 0; i < MENU_MAX_N_PER_PAGE; i++ ){
		long	len, len_open_win_tmp;

		if( data->ls[i] == NULL )
			break;

		len_open_win_tmp = 0;

		if( strcmp( data->ls[i]->kind, "<CheckItem>" ) == 0 ){
			flg_use_on_off = TRUE;
		} else if( strcmp( data->ls[i]->kind, "<RadioItem>" ) == 0 ){
			flg_use_on_off = TRUE;
		} else if( strcmp( data->ls[i]->kind, "<Branch>" ) == 0 ){
			len_branch = str_len_draw( MSG_MENU_KIND_BRANCH );
		} else if( strcmp( data->ls[i]->kind,
				"<OpenWinItem>" ) == 0 ){
			len_open_win = str_len_draw(
					MSG_MENU_KIND_OPEN_WIN_ITEM );
			len_open_win_tmp = len_open_win;
		}

		len = str_len_draw( data->ls[i]->msg );
		len += len_open_win_tmp;
		width_contents = max( width_contents, len );

		if( data->ls[i]->accel_key[0] != '\0' ){
			sprintf( str_accel, MSG_MENU_ACCEL_KEY_FMT,
					data->ls[i]->accel_key );
			len = str_len_draw( str_accel );
			width_accel = max( width_accel, len );
		}

		height++;
	}
	if( !flg_use_on_off )
		len_chk = 0;

	width = max( len_head_corner, len_foot_corner );
	width -= (len_v_line * 2) + 2;
	width = max( width, width_contents
			+ width_accel + len_branch );
	width = max( width, len_ttl );

	width_contents = width - width_accel - len_branch;

	x = WIN_MENU_DRAW_MIN_X + (WIN_MENU_DRAW_WIDTH - width) / 2;
	y = WIN_MENU_DRAW_MIN_Y + (WIN_MENU_DRAW_HEIGHT - height) / 2;


	/*  */

	strcpy( str_head, MSG_MENU_CORNER );

	if( data->ttl != NULL ){
		strcat( str_head, data->ttl );
		len_ttl = str_len_draw( data->ttl );
	}

	strncat( str_head, MSG_MENU_FRAME,
			len_chk + len_direct + 2
			+ width - len_ttl );

	strcat( str_head, MSG_MENU_CORNER );


	/*  */

	if( data->flg_min_page )
		strcpy( str_foot, MSG_MENU_LEFT_PREV );
	else
		strcpy( str_foot, MSG_MENU_LEFT );

	len_foot = len_chk + len_direct + 2 + (len_v_line * 2)
			+ width - len_foot_corner;
	if( len_foot > 0 )
		strncat( str_foot, MSG_MENU_FRAME, len_foot );

	if( data->flg_max_page )
		strcat( str_foot, MSG_MENU_RIGHT_NEXT );
	else
		strcat( str_foot, MSG_MENU_RIGHT );

	/*  */

	len_line = width + len_chk + len_direct + (len_v_line * 2) + 2;

	/* դ */
#ifdef	D_UNIX
	i = -1;
	print_str( x - len_v_line, y + i, FLG_NULL,
			MSG_MENU_CLR_FMT, len_line, "" );
#endif	/* D_UNIX */
	print_str( x - len_v_line, y - 1, FLG_NULL, str_head );

	for( i = 0; data->ls[i] != NULL; i++ ){
		if( !data->flg_redraw )
			if( (i != data->sel_n) && (i != data->prev_sel_n) )
				continue;

		/* 硼ȥåȡ */
		sprintf( str_direct, MSG_MENU_DIRECT_FMT,
				data->ls[i]->key );
		len_direct = str_len_draw( str_direct );

		/* 졼 */
		if( data->ls[i]->accel_key[0] == '\0' ){
			str_accel[0] = '\0';
		} else {
			sprintf( str_accel, MSG_MENU_ACCEL_KEY_FMT,
					data->ls[i]->accel_key );
		}

		/* åܥå */
		if( !flg_use_on_off )
			str_chk = MSG_NULL;
		else if( chk_flg( data->ls[i]->flg, FLG_MENU_CHK_ON ) )
			str_chk = MSG_MENU_FLG_LS_CHK_ON;
		else if( chk_flg( data->ls[i]->flg, FLG_MENU_CHK_OFF ) )
			str_chk = MSG_MENU_FLG_LS_CHK_OFF;
		else
			str_chk = MSG_MENU_FLG_LS_CHK_NULL;
		len_chk = str_len_draw( str_chk );

		/* <Branch> */
		if( strcmp( data->ls[i]->kind, "<Branch>" ) == 0 )
			str_branch = MSG_MENU_KIND_BRANCH;
		else
			str_branch = MSG_NULL;

		/* <OpenWinItem> */
		if( strcmp( data->ls[i]->kind, "<OpenWinItem>" ) == 0 )
			str_open_win = MSG_MENU_KIND_OPEN_WIN_ITEM;
		else
			str_open_win = MSG_NULL;
		len_open_win = str_len_draw( str_open_win );

#ifdef	D_UNIX
		print_str( x - len_v_line, y + i, FLG_NULL,
				MSG_MENU_CLR_FMT, len_line, "" );
#endif	/* D_UNIX */

		/* ü */
		print_str( x - len_v_line, y + i, FLG_NULL,
				MSG_MENU_V_LINE );

		/* ܤ */
		sprintf( str_contents, MSG_MENU_CONTENTS_FMT,
				data->ls[i]->msg,
				len_open_win, str_open_win );
		if( i == data->sel_n ){
			print_str_n( x, y + i, CURS_ATTR_N_MENU_SEL,
					MSG_MENU_SELECT_FMT,
					str_chk, str_direct,
					width_contents, str_contents,
					width_accel, str_accel,
					len_branch, str_branch );
		} else {
			print_str_n( x, y + i, CURS_ATTR_N_NORMAL,
					MSG_MENU_NOT_SELECT_FMT,
					str_chk, str_direct,
					width_contents, str_contents,
					width_accel, str_accel,
					len_branch, str_branch );
		}

		/* ü */
		print_str( x + len_chk + len_direct + width + 2, y + i,
				FLG_NULL, MSG_MENU_V_LINE );
	}

	/* դ */

#ifdef	D_UNIX
	print_str( x - len_v_line, y + i, FLG_NULL,
			MSG_MENU_CLR_FMT, len_line, "" );
#endif	/* D_UNIX */
	print_str( x - len_v_line, y + i, FLG_NULL, str_foot );

	data->prev_sel_n = data->sel_n;
}

/**/

void	draw_menu_num( long figure, long sel_n, char num[] )
{
	long	i, n;
	long	x, y;
	flg_print_t	flg;
	long	width;
	static char	box_str[SCREEN_WIDTH * 2 + 1];

	flg_draw_menu = TRUE;

	/* ɥȤ */
	width = 1 + figure
			+ str_len_draw( MSG_MENU_MIN )
			+ str_len_draw( MSG_MENU_MAX )
			+ str_len_draw( MSG_MENU_OK );

	x = WIN_MENU_DRAW_MIN_X + (WIN_MENU_DRAW_WIDTH - width) / 2;
	y = WIN_MENU_DRAW_MIN_Y + (WIN_MENU_DRAW_HEIGHT) / 2;

	strcpy( box_str, MSG_MENU_CORNER );
	for( i = 0; i < width; i++ )
		strcat( box_str, MSG_MENU_H_LINE );
	strcat( box_str, MSG_MENU_CORNER );

	print_str( x, y - 1, FLG_NULL, box_str );

	i = 0;
	print_str( x + i, y, FLG_NULL,
			MSG_MENU_V_LINE );
	i++;

	for( n = 0; num[n] != '\0'; n++, i++ ){
		if( sel_n == n )
			flg = FLG_PRINT_REV;
		else
			flg = FLG_NULL;

		print_str( x + i, y, flg, "%1c", num[n] );
	}

	if( sel_n == 1 + figure + MENU_NUM_MIN )
		flg = FLG_PRINT_REV;
	else
		flg = FLG_NULL;
	print_str( x + i, y, flg, MSG_S, MSG_MENU_MIN );
	i += str_len_draw( MSG_MENU_MIN );

	if( sel_n == 1 + figure + MENU_NUM_MAX )
		flg = FLG_PRINT_REV;
	else
		flg = FLG_NULL;
	print_str( x + i, y, flg, MSG_S, MSG_MENU_MAX );
	i += str_len_draw( MSG_MENU_MAX );

	if( sel_n == 1 + figure + MENU_NUM_OK )
		flg = FLG_PRINT_REV;
	else
		flg = FLG_NULL;
	print_str( x + i, y, flg, MSG_S, MSG_MENU_OK );
	i += str_len_draw( MSG_MENU_OK );

	print_str( x + i, y, FLG_NULL,
			MSG_MENU_V_LINE );

	print_str( x, y + 1, FLG_NULL, box_str );
}

/**/

char	*get_str_open_win_item( char *kind )
{
	if( strcmp( kind, "<OpenWinItem>" ) == 0 )
		return MSG_MENU_KIND_OPEN_WIN_ITEM;

	return MSG_MENU_KIND_ITEM;
}

/**/

char	*get_str_branch( char *kind )
{
	if( strcmp( kind, "<Branch>" ) == 0 )
		return MSG_MENU_KIND_BRANCH;

	return MSG_MENU_KIND_ITEM;
}

/**/

bool_t	wipe_menu( void )
{
	if( flg_draw_menu ){
		flg_draw_menu = FALSE;
		redraw_all();

		return TRUE;
	} else {
		return FALSE;
	}
}

/**/

void	draw_all_mbr_stat( void )
{
	party_t	*pty;
	long	i;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ )
		draw_mbr_stat( pty->mbr[i] );

	draw_misc_stat();
}

/**/

void	draw_mbr_stat( mbr_t *mbr )
{
	long	x, y;
	long	mbr_n;
	curs_attr_t	*attr_p, attr;

	if( mbr->kind != CHR_KIND_MBR )
		return;

	mbr_n = mbr->mbr_n;
	if( (mbr_n < 0) || (MBR_MAX_N <= mbr_n) )
		return;

	attr_p = get_curs_attr();
	if( attr_p == NULL )
		return;
	attr_p = &(attr_p[CURS_ATTR_N_MBR_1]);
	attr = attr_p[mbr->mbr_n];
	attr.attr &= ~(A_REVERSE);

	/* ɥ */
	x = WIN_STAT_DRAW_MIN_X;
	y = WIN_STAT_DRAW_MIN_Y + (mbr_n * WIN_STAT_DRAW_HEIGHT) + 2;
	print_str( x, y, FLG_NULL, MSG_S, MSG_STAT_FRAME );

	if( mbr->mbr_n == MBR_N_NOT_JOIN )
		return;

	if( chk_flg( mbr->stat, FLG_STAT_NOT_EXIST ) ){
		y = WIN_STAT_DRAW_MIN_Y;
		y += mbr->mbr_n * WIN_STAT_DRAW_HEIGHT;
		for( ; y <= WIN_STAT_DRAW_MAX_Y; y++ ){
			x = WIN_STAT_DRAW_MIN_X;
			for( ; x <= WIN_STAT_DRAW_MAX_X; x++ ){
				print_str( x, y, FLG_NULL, " " );
			}
		}
	} else {
		/* ̾ */
		x = WIN_STAT_DRAW_MIN_X + WIN_STAT_NAME_DRAW_MIN_X;
		y = WIN_STAT_DRAW_MIN_Y + mbr->mbr_n
				* WIN_STAT_DRAW_HEIGHT
				+ WIN_STAT_NAME_DRAW_MIN_Y;
		print_str_attr( x, y, &attr, "%-*s ",
				WIN_STAT_NAME_DRAW_WIDTH,
				mbr->name );


		/* HP, MP */
		x = WIN_STAT_DRAW_MIN_X + WIN_STAT_HP_DRAW_MIN_X;
		y = WIN_STAT_DRAW_MIN_Y + mbr->mbr_n
				* WIN_STAT_DRAW_HEIGHT
				+ WIN_STAT_HP_DRAW_MIN_Y;
		print_str( x, y, FLG_NULL, "HP%*d/%*d MP%*d/%*d ",
				WIN_STAT_CURE_HP_DRAW_WIDTH,
				mbr->abl.hp.n,
				WIN_STAT_MAX_HP_DRAW_WIDTH,
				mbr->abl.hp.max,
				WIN_STAT_CURE_MP_DRAW_WIDTH,
				mbr->abl.mp.n,
				WIN_STAT_MAX_MP_DRAW_WIDTH,
				mbr->abl.mp.max );

		/*  */
		x = WIN_STAT_DRAW_MIN_X + WIN_STAT_ACT_DRAW_MIN_X;
		y = WIN_STAT_DRAW_MIN_Y + mbr->mbr_n
				* WIN_STAT_DRAW_HEIGHT
				+ WIN_STAT_ACT_DRAW_MIN_Y;
		print_str( x, y, FLG_NULL, "%-*s",
				WIN_STAT_ACT_DRAW_WIDTH,
				mbr->act.msg );


		/* Ĵ */
		x = WIN_STAT_DRAW_MIN_X + WIN_STAT_COND_DRAW_MIN_X;
		y = WIN_STAT_DRAW_MIN_Y + mbr->mbr_n
				* WIN_STAT_DRAW_HEIGHT
				+ WIN_STAT_COND_DRAW_MIN_Y;
		print_str( x, y, FLG_NULL, "%-*s",
				WIN_STAT_COND_DRAW_WIDTH, "" );

		if( chk_flg( mbr->stat, FLG_STAT_DEAD ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_DEAD );
		else if( chk_flg( mbr->stat, FLG_STAT_STONE ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_STONE );
		else if( chk_flg( mbr->stat, FLG_STAT_FAINT ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_FAINT );
		else if( chk_flg( mbr->stat, FLG_STAT_PARALYZE ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_PARALYZE );
		else if( chk_flg( mbr->stat, FLG_STAT_POISON ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_POISON );
		else if( chk_flg( mbr->stat, FLG_STAT_CONFUSION ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_CONFUSION );
		else if( chk_flg( mbr->stat, FLG_STAT_BLIND ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_BLIND );
		else if( chk_flg( mbr->stat, FLG_STAT_SLEEP ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_SLEEP );
		else if( chk_flg( mbr->stat, FLG_STAT_SILENCE ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_SILENCE );
		else if( chk_flg( mbr->stat, FLG_STAT_FEAR ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_FEAR );
		else if( chk_flg( mbr->stat, FLG_STAT_HALLUCINATION ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_HALLUCINATION );
		else if( chk_flg( mbr->stat, FLG_STAT_CHARM ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_CHARM );
		else if( chk_flg( mbr->stat, FLG_STAT_DRUNK ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_DRUNK );
		else if( chk_flg( mbr->stat, FLG_STAT_FLY ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_FLY );
		else if( chk_flg( mbr->stat, FLG_STAT_STARVATION ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_STARVATION );
		else if( chk_flg( mbr->stat, FLG_STAT_HUNGRY ) )
			print_str( x, y, FLG_NULL,
					MSG_S, MSG_STAT_HUNGRY );
	}
}

/**/

void	draw_misc_stat( void )
{
	long	x, y;
	dun_t	*dun;
	char	*ttl;

	dun = get_dun();

	x = WIN_STAT_DRAW_MIN_X
			+ WIN_STAT_DUN_LEV_DRAW_MIN_X;
	y = WIN_STAT_DRAW_MIN_Y
			+ MBR_MAX_N * WIN_STAT_DRAW_HEIGHT
			+ WIN_STAT_DUN_LEV_DRAW_MIN_Y;

	if( sgn( dun->lev ) >= +1 )
		ttl = MSG_STAT_DUN_LEV_TTL_FLOOR;
	else if( sgn( dun->lev ) <= -1 )
		ttl = MSG_STAT_DUN_LEV_TTL_BASE;
	else
		ttl = MSG_STAT_DUN_LEV_TTL_0;

	print_str( x, y, FLG_NULL, "%*s%*ld",
			WIN_STAT_DUN_LEV_TTL_DRAW_WIDTH,
			ttl,
			WIN_STAT_DUN_LEV_VAL_DRAW_WIDTH,
			abs( dun->lev ) );

	/* ɥ */
	x = WIN_STAT_DRAW_MIN_X;
	y = WIN_STAT_DRAW_MIN_Y
			+ MBR_MAX_N * WIN_STAT_DRAW_HEIGHT + 2;
	for( ; x <= WIN_STAT_DRAW_MAX_X; x++ ){
		print_str( x, y, FLG_NULL, "-" );
	}
}

/**/

void	vfx_crtcl( chr_kind_t kind, long x, long y )
{
	long	r;
	long	len;
	pos_t	bgn, end;
	long	frame, clr_frame;

	if( kind == CHR_KIND_MBR ){
		if( !chk_flg( get_flg_vfx_mbr(),
				FLG_VFX_MBR_HP_SUB_CRTCL ) ){
			return;
		}
		set_vfx_attr( CURS_ATTR_N_FX_MBR_CRTCL );
	}
	if( kind == CHR_KIND_MNSTR ){
		if( !chk_flg( get_flg_vfx_mnstr(),
				FLG_VFX_MNSTR_HP_SUB_CRTCL ) ){
			return;
		}
		set_vfx_attr( CURS_ATTR_N_FX_MNSTR_CRTCL );
	}

	r = ANIM_CRTCL_R;
	len = r * 2 + 1;
	len += 4;

	frame = ANIM_CRTCL_FRAME_N;
	clr_frame = ANIM_CRTCL_CLR_FRAME_N;

	bgn.x = x * 2 + r;
	bgn.y = y - r;
	end.x = x * 2 - r;
	end.y = y + r;
	vfx_arw_line( &bgn, &end, STR_ANIM_CRTCL_1,
			len, frame, clr_frame, FALSE );

	bgn.x = x * 2 - r;
	bgn.y = y - r;
	end.x = x * 2 + r;
	end.y = y + r;
	vfx_arw_line( &bgn, &end, STR_ANIM_CRTCL_2,
			len, frame, clr_frame, FALSE );

	wait_clock( ANIM_CRTCL_WAIT_CLOCK );

	draw_map( x - ((r + 1) / 2), y - r,
			r + 1, r * 2 + 1 );
}

/**/

void	set_vfx_attr( curs_attr_n_t n )
{
	curs_attr_t	*attr;

	attr = get_curs_attr();
	if( attr == NULL )
		return;

	g_vfx_attr = attr[n];
	g_vfx_attr.attr &= ~(A_REVERSE);
}

/**/

void	vfx_arw( chr_kind_t kind, pos_t *bgn, pos_t *end, long c, long len )
{
	char	str[1 + 1];
	pos_t	bgn_scrn, end_scrn;
	long	frame, clr_frame;

	if( kind == CHR_KIND_MBR )
		if( !chk_flg( get_flg_vfx_mbr(), FLG_VFX_MBR_ARW ) )
			return;
	if( kind == CHR_KIND_MNSTR )
		if( !chk_flg( get_flg_vfx_mnstr(), FLG_VFX_MNSTR_ARW ) )
			return;

	str[0] = c;
	str[1] = '\0';

	frame = ANIM_ARW_FRAME_N;
	clr_frame = ANIM_ARW_CLR_FRAME_N;

	bgn_scrn.x = bgn->x * 2;
	bgn_scrn.y = bgn->y;
	end_scrn.x = end->x * 2;
	end_scrn.y = end->y;

	set_vfx_attr( CURS_ATTR_N_VFX );
	vfx_arw_line( &bgn_scrn, &end_scrn, str,
			len, frame, clr_frame, TRUE );
}

/**/

void	vfx_arw_line(
	pos_t *bgn, pos_t *end, const char *str, long len,
	long frame, long clr_frame, bool_t flg_clr
)
{
	vfx_arw_mul_line( 1, bgn, end, str, len,
			frame, clr_frame, flg_clr );
}

/**/

void	vfx_arw_mul_line(
	long arw_n, pos_t *bgn, pos_t *end, const char *str, long len,
	long frame, long clr_frame, bool_t flg_clr
)
{
	long	i, j, k;
	clock_t	bgn_clock, next_clock;
	static long	n[VFX_ARW_MAX_N], m[VFX_ARW_MAX_N];
	static long	clr_m[VFX_ARW_MAX_N], pre_m[VFX_ARW_MAX_N];
	static long	x[VFX_ARW_MAX_N][ANIM_LINE_LEN + 1];
	static long	y[VFX_ARW_MAX_N][ANIM_LINE_LEN + 1];
	static bool_t	flg_x[VFX_ARW_MAX_N], flg_y[VFX_ARW_MAX_N];
	long	len_clr;

	if( bgn == NULL )
		return;
	if( end == NULL )
		return;

	if( arw_n > VFX_ARW_MAX_N )
		arw_n = VFX_ARW_MAX_N;

	bgn_clock = clock();
	frame = frame * get_vfx_wait() / _100_PERCENT;
	if( frame < 1 )
		frame = 1;

	if( len > ANIM_LINE_LEN )
		len = ANIM_LINE_LEN;

	len_clr = str_len_draw( str ) / 2 + 1;

	for( j = 0; j < arw_n; j++ ){
		m[j] = 0;
		n[j] = 0;

		flg_x[j] = (abs( end[j].x - bgn[j].x )
				>= abs( end[j].y - bgn[j].y ));
		flg_y[j] = (abs( end[j].x - bgn[j].x )
				<= abs( end[j].y - bgn[j].y ));
		x[j][n[j]] = bgn[j].x;
		y[j][n[j]] = bgn[j].y;
	}

	for( i = 0; i <= frame; i++ ){
		for( j = 0; j < arw_n; j++ ){
			long	dx, dy, sx, sy, nx, ny;

			dx = abs( end[j].x - bgn[j].x );
			dy = abs( end[j].y - bgn[j].y );
			sx = sgn( end[j].x - bgn[j].x );
			sy = sgn( end[j].y - bgn[j].y );

			nx = bgn[j].x;
			nx += (dx * i / frame) * sx;
			ny = bgn[j].y;
			ny += (dy * i / frame) * sy;
			do {
				if( flg_x[j] && (nx == x[j][n[j]]) )
					break;
				if( flg_y[j] && (ny == y[j][n[j]]) )
					break;

				m[j]++;
				n[j] = m[j] % (ANIM_LINE_LEN + 1);
				x[j][n[j]] = nx;
				y[j][n[j]] = ny;
			} while( 0 );

			do {
				long	xx, yy;

				if( x[j][n[j]] - (map_draw_pos.x * 2)
						< WIN_MAP_DRAW_MIN_X )
					break;
				if( y[j][n[j]] - map_draw_pos.y
						< WIN_MAP_DRAW_MIN_Y )
					break;
				if( x[j][n[j]] - (map_draw_pos.x * 2)
						> WIN_MAP_DRAW_MAX_X )
					break;
				if( y[j][n[j]] - map_draw_pos.y
						> WIN_MAP_DRAW_MAX_Y )
					break;

				xx = x[j][n[j]] - (map_draw_pos.x * 2);
				yy = y[j][n[j]] - map_draw_pos.y;
				print_str_attr( xx, yy, &g_vfx_attr,
						MSG_S, str );
			} while( 0 );

			if( flg_clr ){
				/* lenĹʤäָä */
				if( (m[j] - len) >= 0 ){
					long	n2;

					n2 = m[j] - len;
					n2 %= ANIM_LINE_LEN + 1;
					draw_map( x[j][n2] / 2, y[j][n2],
							len_clr, 1 );
				}
			}
		}
		next_clock = bgn_clock;
		next_clock += CLK_TCK * i / ANIM_FRAME;
		while( clock() < next_clock )
			;
	}

	if( !flg_clr )
		return;	/* ꥢʤǽλ */

	for( j = 0; j < arw_n; j++ ){
		if( m[j] < len )
			clr_m[j] = m[j];
		else
			clr_m[j] = len;
		pre_m[j] = 0;
	}

	for( ; i <= frame + clr_frame; i++ ){
		for( j = 0; j < arw_n; j++ ){
			long	tmp_m;

			tmp_m = clr_m[j] * i / (frame + clr_frame);
			if( tmp_m > pre_m[j] ){
				pre_m[j]++;
				m[j]++;

				if( (m[j] - len) >= 0 ){
					long	n2;

					n2 = m[j] - len;
					n2 %= ANIM_LINE_LEN + 1;
					draw_map( x[j][n2] / 2, y[j][n2],
							len_clr, 1 );
				}
			}
		}

		next_clock = bgn_clock;
		next_clock += (clock_t)((double)CLK_TCK / ANIM_FRAME * i);
		while( clock() < next_clock )
			;
	}
	for( j = 0; j < arw_n; j++ ){
		for( k = 0; k < len + 1; k++ ){
			draw_map( x[j][k] / 2, y[j][k], len_clr, 1 );
		}
	}
}

/**/

void	vfx_num( chr_t *p, long n )
{
	if( p->kind == CHR_KIND_MBR ){
		if( n <= -1 ){
			if( !chk_flg( get_flg_vfx_mbr(),
					FLG_VFX_MBR_HP_SUB ) ){
				return;
			}
		} else if( n >= +1 ){
			if( !chk_flg( get_flg_vfx_mbr(),
					FLG_VFX_MBR_HP_ADD ) ){
				return;
			}
		} else {
			if( !chk_flg( get_flg_vfx_mbr(),
					FLG_VFX_MBR_HP_ADD ) ){
				return;
			}
		}
		draw_num( p->x, p->y, n, p->kind );
	}
	if( p->kind == CHR_KIND_MNSTR ){
		if( n <= -1 ){
			if( !chk_flg( get_flg_vfx_mnstr(),
					FLG_VFX_MNSTR_HP_SUB ) ){
				return;
			}
		} else if( n >= +1 ){
			if( !chk_flg( get_flg_vfx_mnstr(),
					FLG_VFX_MNSTR_HP_ADD ) ){
				return;
			}
		} else {
			if( !chk_flg( get_flg_vfx_mnstr(),
					FLG_VFX_MNSTR_HP_ADD ) ){
				return;
			}
		}
		draw_num( p->x, p->y, n, p->kind );
	}
}

/**/

void	draw_num( long map_x, long map_y, long n, chr_kind_t kind )
{
	long	scrn_x, scrn_y;
	char	sn[32 + 1], s1[32 + 1], s2[32 + 1];
	long	len;
	clock_t	next_clock;
	long	add_clock;
	long	i, j;
	long	frame;
	curs_attr_n_t	attr;

	attr = CURS_ATTR_N_NORMAL;
	if( kind == CHR_KIND_MBR ){
		if( n < 0 )
			attr = CURS_ATTR_N_FX_MBR_MINUS;
		else
			attr = CURS_ATTR_N_FX_MBR_PLUS;
	} else if( kind == CHR_KIND_MNSTR ){
		if( n < 0 )
			attr = CURS_ATTR_N_FX_MNSTR_MINUS;
		else
			attr = CURS_ATTR_N_FX_MNSTR_PLUS;
	}

	frame = ANIM_NUM_FRAME_N;
	frame = frame * get_vfx_wait() / _100_PERCENT;
	if( frame < 1 )
		frame = 1;

	sprintf( sn, "%-+ld", n );
	len = str_len_draw( sn );

	scrn_x = (map_x - map_draw_pos.x) * 2;
	scrn_y = map_y - map_draw_pos.y;
	if( (scrn_x + len) > (WIN_MAP_DRAW_MAX_X + 1) )
		scrn_x = WIN_MAP_DRAW_MAX_X + 1 - len;
	if( scrn_x < 0 )
		return;
	if( scrn_x > WIN_MAP_DRAW_MAX_X )
		return;
	if( scrn_y < 0 )
		return;
	if( scrn_y > WIN_MAP_DRAW_MAX_Y )
		return;

	for( i = -1; i < len + 1; i++ ){
		next_clock = clock();

		for( j = 0; j < len; j++ ){
			if( j != i ){
				s1[j] = ' ';
				s2[j] = sn[j];
			} else {
				s1[j] = sn[j];
				s2[j] = ' ';
			}
		}
		s1[j] = '\0';
		s2[j] = '\0';

		if( scrn_y >= 2 )
			print_str_n( scrn_x, scrn_y - 2, attr, MSG_S, s1 );
		if( scrn_y >= 1 )
			print_str_n( scrn_x, scrn_y - 1, attr, MSG_S, s2 );
		curs_refresh();

		next_clock = clock();
		add_clock = (double)CLK_TCK / (double)(len + 2);
		add_clock = add_clock * frame / ANIM_FRAME;
		next_clock += add_clock;
		while( clock() < next_clock )
			;
	}

	if( scrn_y >= 2 ){
		draw_map( map_draw_pos.x + (scrn_x / 2),
				map_draw_pos.y + scrn_y - 2,
				(len + 1) / 2, 1 );
	}
	if( scrn_y >= 1 ){
		draw_map( map_draw_pos.x + (scrn_x / 2),
				map_draw_pos.y + scrn_y - 1,
				(len + 1) / 2, 1 );
	}
}

/**/

void	draw_blast( long map_x, long map_y, blast_t *p )
{
	long	xl, yl, xr, yr;
	long	x, y;
	long	draw_x, draw_y;

	if( p == NULL )
		return;

	xl = 1;
	for( yl = 0; yl < BLAST_MAX_Y; yl++ ){
		long	len;

		if( p->ptn[yl][0] == '\0' )
			break;
		len = str_len_draw( p->ptn[yl] );
		xl = max( xl, len );
	}

	xr = xl / 2;
	yr = yl / 2;

	p->xl = xl;
	p->yl = yl;
	p->xr = xr;
	p->yr = yr;

	for( y = 0; y < yl; y++ ){
		for( x = 0; x < xl; x++ ){
			char	c;

			c = p->ptn[y][x];
			if( c == ' ' )
				continue;

			draw_x = (map_x + x - xr) - map_draw_pos.x;
			draw_x *= 2;
			draw_y = (map_y + y - yr) - map_draw_pos.y;

			print_str_attr( draw_x, draw_y, &g_vfx_attr,
					"%c%c", c, c );
		}
	}
}

/**/

void	draw_mbr_data_all( mbr_t *org, mbr_t *mbr, long page_n )
{
	long	i;
	data_n_t	data;

	flg_draw_menu = TRUE;

	wipe_all();

	for( i = 0; i < WIN_MAP_DRAW_MAX_Y + 1; i++ ){
		print_str( WIN_MAP_DRAW_MAX_X + 1, i,
				FLG_NULL, MSG_V_LINE );
	}
	print_str( SCREEN_MIN_X, WIN_MAP_DRAW_MAX_Y + 1,
			FLG_NULL, MSG_H_FRAME );

	for( data = DATA_N_NULL + 1; data < DATA_N_MAX_N; data++ ){
		if( data_page_n_tab[data] != DATA_PAGE_N_ALL )
			if( data_page_n_tab[data] != page_n )
				continue;

		draw_mbr_data( org, mbr, data, FALSE );
	}
}

/**/

void	draw_mbr_data( mbr_t *org, mbr_t *mbr, data_n_t n, bool_t flg_rev )
{
	static char	s[255 + 1];
	abl_kind_t	abl_kind;
	resi_kind_t	resi_kind;
	char	*ttl;
	char	*str_lev_up_left, *str_lev_up_right;
	long	mbr_lev_n, mbr_lev_max;
	long	org_lev_n, org_lev_max;
	static char	str_add_lev[10 + 1];
	rate_t	resi;
	long	x, y;

	abl_kind = ABL_KIND_HP;
	ttl = MSG_MBR_DATA_HP_TTL;
	resi_kind = RESI_KIND_MAX_N;
	x = WIN_MBR_DATA_HP_TTL_DRAW_MIN_X;
	y = WIN_MBR_DATA_HP_TTL_DRAW_MIN_Y;

	switch( n ){
	case DATA_N_NAME:
		sprintf( s, "%s%-*s", MSG_MBR_DATA_NAME_TTL,
				MBR_NAME_MAX_LEN, mbr->name );
		x = WIN_MBR_DATA_NAME_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_NAME_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_FACE:
		sprintf( s, "%s%-1c", MSG_MBR_DATA_FACE_TTL,
				mbr->face_mnr );
		x = WIN_MBR_DATA_FACE_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_FACE_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RACE_STR:
		sprintf( s, "%s%s", MSG_MBR_DATA_RACE_STR_TTL,
				get_race_str( &(mbr->race) ) );
		x = WIN_MBR_DATA_RACE_STR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RACE_STR_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RACE_NAME:
		sprintf( s, "%s%s", MSG_MBR_DATA_RACE_NAME_TTL,
				get_race_name( &(mbr->race) ) );
		x = WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_SEX:
		if( mbr->sex == MALE )
			sprintf( s, "%s%s", MSG_MBR_DATA_SEX_TTL, MSG_MALE );
		else
			sprintf( s, "%s%s", MSG_MBR_DATA_SEX_TTL, MSG_FEMALE );
		x = WIN_MBR_DATA_SEX_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SEX_TTL_DRAW_MIN_Y;
		break;
/**/
	case DATA_N_HP_VAL:
		sprintf( s, "%s%ld/%ld", MSG_MBR_DATA_HP_VAL,
				mbr->abl.hp.n, mbr->abl.hp.max );
		x = WIN_MBR_DATA_HP_VAL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HP_VAL_DRAW_MIN_Y;
		break;
	case DATA_N_MP_VAL:
		sprintf( s, "%s%ld/%ld", MSG_MBR_DATA_MP_VAL,
				mbr->abl.mp.n, mbr->abl.mp.max );
		x = WIN_MBR_DATA_MP_VAL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MP_VAL_DRAW_MIN_Y;
		break;
/**/
	case DATA_N_VAL_TTL:
		strcpy( s, MSG_MBR_DATA_VAL_TTL );
		x = WIN_MBR_DATA_VAL_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_VAL_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_HIT:
		{
			attack_t	attack;
			long	val1, val2;

			if( set_attack_mbr_bash( &attack, mbr, TRUE ) )
				val1 = get_hit( mbr, &attack );
			else
				val1 = get_hit( mbr, NULL );

			if( set_attack_mbr_throw( &attack, mbr, TRUE ) )
				val2 = get_hit( mbr, &attack );
			else
				val2 = get_hit( mbr, NULL );

			sprintf( s, MSG_MBR_DATA_HIT, MSG_MBR_DATA_HIT_TTL,
					val1, val2 );
		}
		x = WIN_MBR_DATA_HIT_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HIT_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_WPN_CRTCL:
		{
			attack_t	attack;
			rate_t	val1, val2;

			if( set_attack_mbr_bash( &attack, mbr, TRUE ) )
				val1 = get_wpn_crtcl( mbr, &attack );
			else
				val1 = get_wpn_crtcl( mbr, NULL );

			if( set_attack_mbr_throw( &attack, mbr, TRUE ) )
				val2 = get_wpn_crtcl( mbr, &attack );
			else
				val2 = get_wpn_crtcl( mbr, NULL );

			sprintf( s, MSG_MBR_DATA_WPN_CRTCL,
					MSG_MBR_DATA_WPN_CRTCL_TTL,
					val1, val2 );
		}
		x = WIN_MBR_DATA_WPN_CRTCL_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_WPN_CRTCL_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_DAM:
		{
			attack_t	attack;
			long	val1, val2;

			if( set_attack_mbr_bash( &attack, mbr, TRUE ) )
				val1 = get_dam( mbr, &attack );
			else
				val1 = get_dam( mbr, NULL );

			if( set_attack_mbr_throw( &attack, mbr, TRUE ) )
				val2 = get_dam( mbr, &attack );
			else
				val2 = get_dam( mbr, NULL );

			sprintf( s, MSG_MBR_DATA_DAM, MSG_MBR_DATA_DAM_TTL,
					val1, val2 );
		}
		x = WIN_MBR_DATA_DAM_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_DAM_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_DEF:
		sprintf( s, MSG_MBR_DATA_DEF, MSG_MBR_DATA_DEF_TTL,
				get_def( mbr ) );
		x = WIN_MBR_DATA_DEF_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_DEF_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_ARMOR_CRTCL:
		sprintf( s, MSG_MBR_DATA_ARMOR_CRTCL,
				MSG_MBR_DATA_ARMOR_CRTCL_TTL,
				get_armor_crtcl( mbr ) );
		x = WIN_MBR_DATA_ARMOR_CRTCL_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_ARMOR_CRTCL_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_AC:
		sprintf( s, MSG_MBR_DATA_AC, MSG_MBR_DATA_AC_TTL,
				get_ac( mbr ) );
		x = WIN_MBR_DATA_AC_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_AC_TTL_DRAW_MIN_Y;
		break;
/**/
	case DATA_N_GOLD:
		sprintf( s, "%s%ld", MSG_MBR_DATA_GOLD_TTL,
				get_chr_gold( mbr ) );
		x = WIN_MBR_DATA_GOLD_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_GOLD_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_TURN:
		{
			long	game_day, turn;
			long	year, month, day, hour, minute;

			game_day = get_game_day();
			turn = get_turn();
			year = (game_day / 360);
			month = (game_day / 30) % 12 + 1;
			day = (game_day) % 30 + 1;
			hour = (turn / TURN_PER_HOUR) % 24;
			minute = (turn / TURN_PER_MINUTE) % 60;
			sprintf( s, MSG_CALENDAR,
					year, month, day, hour, minute );
		}
		x = WIN_MBR_DATA_TURN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_TURN_TTL_DRAW_MIN_Y;
		break;
/**/
	case DATA_N_STAT_TTL:
		strcpy( s, MSG_MBR_DATA_STAT_TTL );
		x = WIN_MBR_DATA_STAT_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_DEAD:
		if( chk_flg( mbr->stat, FLG_STAT_DEAD ) )
			strcpy( s, MSG_MBR_DATA_STAT_DEAD );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_DEAD_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_DEAD_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_STONE:
		if( chk_flg( mbr->stat, FLG_STAT_STONE ) )
			strcpy( s, MSG_MBR_DATA_STAT_STONE );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_STONE_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_STONE_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_PARALYZE:
		if( chk_flg( mbr->stat, FLG_STAT_PARALYZE ) )
			strcpy( s, MSG_MBR_DATA_STAT_PARALYZE );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_PARALYZE_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_PARALYZE_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_POISON:
		if( chk_flg( mbr->stat, FLG_STAT_POISON ) )
			strcpy( s, MSG_MBR_DATA_STAT_POISON );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_POISON_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_POISON_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_CONFUSION:
		if( chk_flg( mbr->stat, FLG_STAT_CONFUSION ) )
			strcpy( s, MSG_MBR_DATA_STAT_CONFUSION );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_CONFUSION_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_CONFUSION_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_BLIND:
		if( chk_flg( mbr->stat, FLG_STAT_BLIND ) )
			strcpy( s, MSG_MBR_DATA_STAT_BLIND );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_BLIND_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_BLIND_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_SLEEP:
		if( chk_flg( mbr->stat, FLG_STAT_SLEEP ) )
			strcpy( s, MSG_MBR_DATA_STAT_SLEEP );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_SLEEP_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_SLEEP_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_SILENCE:
		if( chk_flg( mbr->stat, FLG_STAT_SILENCE ) )
			strcpy( s, MSG_MBR_DATA_STAT_SILENCE );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_SILENCE_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_SILENCE_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_FEAR:
		if( chk_flg( mbr->stat, FLG_STAT_FEAR ) )
			strcpy( s, MSG_MBR_DATA_STAT_FEAR );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_FEAR_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_FEAR_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_HALLUCINATION:
		if( chk_flg( mbr->stat, FLG_STAT_HALLUCINATION ) )
			strcpy( s, MSG_MBR_DATA_STAT_HALLUCINATION );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_HALLUCINATION_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_HALLUCINATION_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_CHARM:
		if( chk_flg( mbr->stat, FLG_STAT_CHARM ) )
			strcpy( s, MSG_MBR_DATA_STAT_CHARM );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_CHARM_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_CHARM_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_FLY:
		if( chk_flg( mbr->stat, FLG_STAT_FLY ) )
			strcpy( s, MSG_MBR_DATA_STAT_FLY );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_FLY_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_FLY_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_HUNGRY:
		if( chk_flg( mbr->stat, FLG_STAT_STARVATION ) )
			strcpy( s, MSG_MBR_DATA_STAT_STARVATION );
		else if( chk_flg( mbr->stat, FLG_STAT_HUNGRY ) )
			strcpy( s, MSG_MBR_DATA_STAT_HUNGRY );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_HUNGRY_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_HUNGRY_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_FAINT:
		if( chk_flg( mbr->stat, FLG_STAT_FAINT ) )
			strcpy( s, MSG_MBR_DATA_STAT_FAINT );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_FAINT_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_FAINT_DRAW_MIN_Y;
		break;
	case DATA_N_STAT_DRUNK:
		if( chk_flg( mbr->stat, FLG_STAT_DRUNK ) )
			strcpy( s, MSG_MBR_DATA_STAT_DRUNK );
		else
			strcpy( s, MSG_MBR_DATA_STAT_NULL );
		x = WIN_MBR_DATA_STAT_DRUNK_DRAW_MIN_X;
		y = WIN_MBR_DATA_STAT_DRUNK_DRAW_MIN_Y;
		break;
/**/
	case DATA_N_LEV_LEFT:
		strcpy( s, MSG_MBR_DATA_LEV_TTL );
		x = WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_X;;
		y = WIN_MBR_DATA_LEV_TTL_LEFT_DRAW_MIN_Y;
		break;
	case DATA_N_EXP_LEFT:
		strcpy( s, MSG_MBR_DATA_EXP_TTL );
		x = WIN_MBR_DATA_EXP_TTL_LEFT_DRAW_MIN_X;
		y = WIN_MBR_DATA_EXP_TTL_LEFT_DRAW_MIN_Y;
		break;
	case DATA_N_NEED_EXP_LEFT:
		strcpy( s, MSG_MBR_DATA_NEED_EXP_TTL );
		x = WIN_MBR_DATA_NEED_EXP_TTL_LEFT_DRAW_MIN_X;
		y = WIN_MBR_DATA_NEED_EXP_TTL_LEFT_DRAW_MIN_Y;
		break;

	case DATA_N_LEV_RIGHT:
		strcpy( s, MSG_MBR_DATA_LEV_TTL );
		x = WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_X;;
		y = WIN_MBR_DATA_LEV_TTL_RIGHT_DRAW_MIN_Y;
		break;
	case DATA_N_EXP_RIGHT:
		strcpy( s, MSG_MBR_DATA_EXP_TTL );
		x = WIN_MBR_DATA_EXP_TTL_RIGHT_DRAW_MIN_X;
		y = WIN_MBR_DATA_EXP_TTL_RIGHT_DRAW_MIN_Y;
		break;
	case DATA_N_NEED_EXP_RIGHT:
		strcpy( s, MSG_MBR_DATA_NEED_EXP_TTL );
		x = WIN_MBR_DATA_NEED_EXP_TTL_RIGHT_DRAW_MIN_X;
		y = WIN_MBR_DATA_NEED_EXP_TTL_RIGHT_DRAW_MIN_Y;
		break;
/* abl 1/2 */
	case DATA_N_HP:
		abl_kind = ABL_KIND_HP;
		ttl = MSG_MBR_DATA_HP_TTL;
		x = WIN_MBR_DATA_HP_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HP_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_MP:
		abl_kind = ABL_KIND_MP,
		ttl = MSG_MBR_DATA_MP_TTL;
		x = WIN_MBR_DATA_MP_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MP_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_DEX:
		abl_kind = ABL_KIND_DEX,
		ttl = MSG_MBR_DATA_DEX_TTL;
		x = WIN_MBR_DATA_DEX_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_DEX_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_STR:
		abl_kind = ABL_KIND_STR,
		ttl = MSG_MBR_DATA_STR_TTL;
		x = WIN_MBR_DATA_STR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_STR_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_AGI:
		abl_kind = ABL_KIND_AGI,
		ttl = MSG_MBR_DATA_AGI_TTL;
		x = WIN_MBR_DATA_AGI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_AGI_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_WIS:
		abl_kind = ABL_KIND_WIS,
		ttl = MSG_MBR_DATA_WIS_TTL;
		x = WIN_MBR_DATA_WIS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_WIS_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_INT:
		abl_kind = ABL_KIND_INT,
		ttl = MSG_MBR_DATA_INT_TTL;
		x = WIN_MBR_DATA_INT_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_INT_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_CHA:
		abl_kind = ABL_KIND_CHA,
		ttl = MSG_MBR_DATA_CHA_TTL;
		x = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_Y;
		break;
/* resi */
	case DATA_N_RESI_TTL:
		strcpy( s, MSG_MBR_DATA_RESI_TTL );
		x = WIN_MBR_DATA_RESI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_KNOC:
		resi_kind = RESI_KIND_KNOC;
		ttl = MSG_MBR_DATA_RESI_KNOC_TTL;
		x = WIN_MBR_DATA_RESI_KNOC_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_KNOC_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_SLAS:
		resi_kind = RESI_KIND_SLAS;
		ttl = MSG_MBR_DATA_RESI_SLAS_TTL;
		x = WIN_MBR_DATA_RESI_SLAS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_SLAS_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_STIN:
		resi_kind = RESI_KIND_STIN;
		ttl = MSG_MBR_DATA_RESI_STIN_TTL;
		x = WIN_MBR_DATA_RESI_STIN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_STIN_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_HEAT:
		resi_kind = RESI_KIND_HEAT;
		ttl = MSG_MBR_DATA_RESI_HEAT_TTL;
		x = WIN_MBR_DATA_RESI_HEAT_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_HEAT_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_COLD:
		resi_kind = RESI_KIND_COLD;
		ttl = MSG_MBR_DATA_RESI_COLD_TTL;
		x = WIN_MBR_DATA_RESI_COLD_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_COLD_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_WIND:
		resi_kind = RESI_KIND_WIND;
		ttl = MSG_MBR_DATA_RESI_WIND_TTL;
		x = WIN_MBR_DATA_RESI_WIND_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_WIND_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_ACID:
		resi_kind = RESI_KIND_ACID;
		ttl = MSG_MBR_DATA_RESI_ACID_TTL;
		x = WIN_MBR_DATA_RESI_ACID_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_ACID_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_ELEC:
		resi_kind = RESI_KIND_ELEC;
		ttl = MSG_MBR_DATA_RESI_ELEC_TTL;
		x = WIN_MBR_DATA_RESI_ELEC_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_ELEC_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_RESI_POIS:
		resi_kind = RESI_KIND_POIS;
		ttl = MSG_MBR_DATA_RESI_POIS_TTL;
		x = WIN_MBR_DATA_RESI_POIS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_RESI_POIS_TTL_DRAW_MIN_Y;
		break;
/* abl 2/2 */
	case DATA_N_FIG:
		abl_kind = ABL_KIND_FIG,
		ttl = MSG_MBR_DATA_FIG_TTL;
		x = WIN_MBR_DATA_FIG_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_FIG_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_MON:
		abl_kind = ABL_KIND_MON,
		ttl = MSG_MBR_DATA_MON_TTL;
		x = WIN_MBR_DATA_MON_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MON_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_HUN:
		abl_kind = ABL_KIND_HUN,
		ttl = MSG_MBR_DATA_HUN_TTL;
		x = WIN_MBR_DATA_HUN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HUN_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_THI:
		abl_kind = ABL_KIND_THI,
		ttl = MSG_MBR_DATA_THI_TTL;
		x = WIN_MBR_DATA_THI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_THI_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_MAG:
		abl_kind = ABL_KIND_MAG,
		ttl = MSG_MBR_DATA_MAG_TTL;
		x = WIN_MBR_DATA_MAG_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MAG_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_SOR:
		abl_kind = ABL_KIND_SOR,
		ttl = MSG_MBR_DATA_SOR_TTL;
		x = WIN_MBR_DATA_SOR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SOR_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_ENC:
		abl_kind = ABL_KIND_ENC,
		ttl = MSG_MBR_DATA_ENC_TTL;
		x = WIN_MBR_DATA_ENC_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_ENC_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_SUM:
		abl_kind = ABL_KIND_SUM,
		ttl = MSG_MBR_DATA_SUM_TTL;
		x = WIN_MBR_DATA_SUM_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SUM_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_PRI:
		abl_kind = ABL_KIND_PRI,
		ttl = MSG_MBR_DATA_PRI_TTL;
		x = WIN_MBR_DATA_PRI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_PRI_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_SHA:
		abl_kind = ABL_KIND_SHA,
		ttl = MSG_MBR_DATA_SHA_TTL;
		x = WIN_MBR_DATA_SHA_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SHA_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_BAR:
		abl_kind = ABL_KIND_BAR,
		ttl = MSG_MBR_DATA_BAR_TTL;
		x = WIN_MBR_DATA_BAR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_BAR_TTL_DRAW_MIN_Y;
		break;
	case DATA_N_NIN:
		abl_kind = ABL_KIND_NIN,
		ttl = MSG_MBR_DATA_NIN_TTL;
		x = WIN_MBR_DATA_NIN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_NIN_TTL_DRAW_MIN_Y;
		break;

	case DATA_N_CLASS:
		sprintf( s, MSG_MBR_DATA_CLASS, MSG_MBR_DATA_CLASS_TTL,
				get_class_tab()[mbr->class_n].name );
		x = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_Y;
		break;

	case DATA_N_NEXT_PAGE:
		strcpy( s, MSG_MBR_DATA_NEXT_PAGE );
		x = WIN_MBR_DATA_NEXT_PAGE_DRAW_MIN_X;
		y = WIN_MBR_DATA_NEXT_PAGE_DRAW_MIN_Y;
		break;

	case DATA_N_MAX_N:
	case DATA_N_NULL:
		break;
	}

/**/

	switch( n ){
	case DATA_N_HP:
	case DATA_N_MP:
	case DATA_N_DEX:
	case DATA_N_STR:
	case DATA_N_AGI:
	case DATA_N_WIS:
	case DATA_N_INT:
	case DATA_N_CHA:
	case DATA_N_FIG:
	case DATA_N_MON:
	case DATA_N_HUN:
	case DATA_N_THI:
	case DATA_N_MAG:
	case DATA_N_SOR:
	case DATA_N_ENC:
	case DATA_N_SUM:
	case DATA_N_PRI:
	case DATA_N_SHA:
	case DATA_N_BAR:
	case DATA_N_NIN:
		str_lev_up_left = MSG_LEV_UP_LEFT_OFF;
		str_lev_up_right = MSG_LEV_UP_RIGHT_OFF;

		mbr_lev_n = mbr->abl.lev[abl_kind].n;
		org_lev_n = org->abl.lev[abl_kind].n;
		mbr_lev_max = mbr->abl.lev[abl_kind].max;
		org_lev_max = org->abl.lev[abl_kind].max;

		if( (mbr_lev_n != org_lev_n)
				|| (mbr_lev_max != org_lev_max) ){
			str_lev_up_left = MSG_LEV_UP_LEFT_ON;
			str_lev_up_right = MSG_LEV_UP_RIGHT_ON;
		}
		if( mbr_lev_n - mbr_lev_max == 0 )
			str_add_lev[0] = '\0';
		else
			sprintf( str_add_lev, MSG_FMT_MBR_DATA_ADD_LEV,
					mbr_lev_n - mbr_lev_max );

		sprintf( s, MSG_FMT_MBR_DATA_ABL,
				ttl, str_lev_up_left,
				mbr_lev_max, str_add_lev,
				mbr->abl.exp[abl_kind].n,
				calc_need_exp( mbr_lev_max + 1, abl_kind ),
				str_lev_up_right );
		break;
	case DATA_N_RESI_KNOC:
	case DATA_N_RESI_SLAS:
	case DATA_N_RESI_STIN:
	case DATA_N_RESI_HEAT:
	case DATA_N_RESI_COLD:
	case DATA_N_RESI_WIND:
	case DATA_N_RESI_ACID:
	case DATA_N_RESI_ELEC:
	case DATA_N_RESI_POIS:
		resi = get_resi( mbr, resi_kind );
		sprintf( s, MSG_FMT_MBR_DATA_RESI, ttl, resi );
		break;
	default:
		break;
	}

	if( flg_rev ){
		print_str_n( x, y, CURS_ATTR_N_MENU_SEL,
				MSG_MBR_DATA_SEL, s );
	} else {
		print_str( x, y, CURS_ATTR_N_NORMAL,
				MSG_MBR_DATA_NOT_SEL, s );
	}
}

/**/

data_n_t	next_mbr_data(
	long page_n, data_n_t n, long d,
	mbr_data_edit_kind_t edit_kind
)
{
	long	i;

	n += d;
	if( d == 0 )
		d = +1;

	for( i = 0; i < 1024; i++, n += d ){
		if( n < DATA_N_NULL + 1 )
			n = DATA_N_MAX_N - 1;
		if( n > DATA_N_MAX_N - 1 )
			n = DATA_N_NULL + 1;

		if( data_page_n_tab[n] != DATA_PAGE_N_ALL )
			if( data_page_n_tab[n] != page_n )
				continue;

		if( flg_sel_data_n[edit_kind][n] )
			return n;
	}

	return DATA_N_NULL;
}

/**/

bool_t	gets_mbr_name( mbr_t *mbr_p )
{
	long	x, y;
	char	name[MBR_NAME_MAX_LEN + 1];

	if( mbr_p == NULL )
		return FALSE;

	/* ̾¸ */
	strncpy( name, mbr_p->name, MBR_NAME_MAX_LEN );

	/* ̾ɽ򥯥ꥢ */
	mbr_p->name[0] = '\0';
	draw_mbr_data( mbr_p, mbr_p, DATA_N_NAME, FALSE );

	/* 򥻥å */
	x = WIN_MBR_DATA_NAME_TTL_DRAW_MIN_X + 1;
	y = WIN_MBR_DATA_NAME_TTL_DRAW_MIN_Y;
	x += str_len_draw( MSG_MBR_DATA_NAME_TTL );
	set_crsr( x, y );

	game_gets( mbr_p->name, MBR_NAME_MAX_LEN );
	pick_cntrl_str( mbr_p->name );

	if( mbr_p->name[0] == '\0' ){
		/* ̾Ϥ򥭥󥻥 */
		strncpy( mbr_p->name, name, MBR_NAME_MAX_LEN );
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	gets_mbr_face( mbr_t *mbr_p )
{
	long	x, y;
	char	buf[1 + 1];

	if( mbr_p == NULL )
		return FALSE;

	/* ¸ */
	buf[0] = mbr_p->face_mnr;

	/* ɽ򥯥ꥢ */
	mbr_p->face_mnr = '\0';
	draw_mbr_data( mbr_p, mbr_p, DATA_N_FACE, FALSE );

	/* 򸵤᤹ */
	mbr_p->face_mnr = buf[0];

	/* 򥻥å */
	x = WIN_MBR_DATA_FACE_TTL_DRAW_MIN_X + 1;
	y = WIN_MBR_DATA_FACE_TTL_DRAW_MIN_Y;
	x += str_len_draw( MSG_MBR_DATA_FACE_TTL );
	set_crsr( x, y );

	/*  */
	game_gets( buf, 1 );
	pick_cntrl_str( buf );

	if( buf[0] != '\0' ){
		/* ѹ */
		mbr_p->face_mnr = buf[0];
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	gets_race_name( mbr_t *mbr )
{
	long	x, y;
	char	name[RACE_NAME_MAX_LEN + 1];

	if( mbr == NULL )
		return FALSE;

	/* ̾¸ */
	strncpy( name, mbr->race.name, RACE_NAME_MAX_LEN );

	/* ̾ɽ򥯥ꥢ */
	mbr->race.name[0] = '\0';
	draw_mbr_data( mbr, mbr, DATA_N_RACE_NAME, FALSE );

	/* 򥻥å */
	x = WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_X + 1;
	y = WIN_MBR_DATA_RACE_NAME_TTL_DRAW_MIN_Y;
	x += str_len_draw( MSG_MBR_DATA_RACE_NAME_TTL );
	set_crsr( x, y );

	game_gets( mbr->race.name, RACE_NAME_MAX_LEN );
	pick_cntrl_str( mbr->race.name );

	if( mbr->race.name[0] == '\0' ){
		/* ̾Ϥ򥭥󥻥 */
		strncpy( mbr->race.name, name, RACE_NAME_MAX_LEN );
		return FALSE;
	}

	return TRUE;
}

/**/

void	draw_edit_class_all(
	class_t *org, class_t *dst,
	edit_class_t sel_n, bool_t flg_sel_add
)
{
	long	i;
	edit_class_t	n;

	wipe_all();

	for( i = 0; i < WIN_MAP_DRAW_MAX_Y + 1; i++ ){
		print_str( WIN_MAP_DRAW_MAX_X + 1, i,
				FLG_NULL, MSG_V_LINE );
	}
	print_str( SCREEN_MIN_X, WIN_MAP_DRAW_MAX_Y + 1,
			FLG_NULL, MSG_H_FRAME );

	for( n = EDIT_CLASS_NULL + 1; n < EDIT_CLASS_MAX_N; n++ ){
		if( n == sel_n )
			draw_edit_class( org, dst, n, TRUE, flg_sel_add );
		else
			draw_edit_class( org, dst, n, FALSE, flg_sel_add );
	}
}

/**/

void	draw_edit_class(
	class_t *org, class_t *dst, edit_class_t n,
	bool_t flg_sel, bool_t flg_sel_add
)
{
	bool_t	flg_add, flg_sub;
	char	*ttl;
	abl_kind_t	abl;
	long	x, y;

	if( (org == NULL) || (dst == NULL) )
		return;

	if( flg_sel ){
		flg_add = flg_sel_add;
		flg_sub = !flg_sel_add;
	} else {
		flg_add = FALSE;
		flg_sub = FALSE;
	}

	ttl = MSG_NULL;
	abl = ABL_KIND_HP;
	x = 0;
	y = 0;

	switch( n ){
	case EDIT_CLASS_NULL:
	case EDIT_CLASS_MAX_N:
		return;
	case EDIT_CLASS_NAME:
		x = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_Y;
		if( flg_sel ){
			print_str_n( x, y, CURS_ATTR_N_MENU_SEL,
					MSG_EDIT_CLASS_NAME,
					MSG_MBR_DATA_CLASS_TTL,
					CLASS_NAME_MAX_LEN,
					dst->name );
		} else {
			print_str_n( x, y, CURS_ATTR_N_NORMAL,
					MSG_EDIT_CLASS_NAME,
					MSG_MBR_DATA_CLASS_TTL,
					CLASS_NAME_MAX_LEN,
					dst->name );
		}
		return;
	case EDIT_CLASS_TOTAL:
		x = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_Y + 2;
		if( flg_sel ){
			print_str_n( x, y, CURS_ATTR_N_MENU_SEL,
					MSG_EDIT_CLASS_TOTAL,
					(long)calc_abl_total( dst ) );
		} else {
			print_str_n( x, y, CURS_ATTR_N_NORMAL,
					MSG_EDIT_CLASS_TOTAL,
					(long)calc_abl_total( dst ) );
		}
		return;
	case EDIT_CLASS_PREV:
		x = WIN_EDIT_CLASS_PREV_DRAW_MIN_X;
		y = WIN_EDIT_CLASS_PREV_DRAW_MIN_Y;
		if( flg_sel ){
			print_str_n( x, y, CURS_ATTR_N_MENU_SEL,
					MSG_MBR_DATA_SEL,
					MSG_EDIT_CLASS_PREV );
		} else {
			print_str_n( x, y, CURS_ATTR_N_NORMAL,
					MSG_MBR_DATA_NOT_SEL,
					MSG_EDIT_CLASS_PREV );
		}
		return;
	case EDIT_CLASS_NEXT:
		x = WIN_EDIT_CLASS_NEXT_DRAW_MIN_X;
		y = WIN_EDIT_CLASS_NEXT_DRAW_MIN_Y;
		if( flg_sel ){
			print_str_n( x, y, CURS_ATTR_N_MENU_SEL,
					MSG_MBR_DATA_SEL,
					MSG_EDIT_CLASS_NEXT );
		} else {
			print_str_n( x, y, CURS_ATTR_N_NORMAL,
					MSG_MBR_DATA_NOT_SEL,
					MSG_EDIT_CLASS_NEXT );
		}
		return;
	case EDIT_CLASS_HP:
		ttl = MSG_MBR_DATA_HP_TTL;
		abl = ABL_KIND_HP;
		x = WIN_MBR_DATA_HP_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HP_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_MP:
		ttl = MSG_MBR_DATA_MP_TTL;
		abl = ABL_KIND_MP;
		x = WIN_MBR_DATA_MP_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MP_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_DEX:
		ttl = MSG_MBR_DATA_DEX_TTL;
		abl = ABL_KIND_DEX;
		x = WIN_MBR_DATA_DEX_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_DEX_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_STR:
		ttl = MSG_MBR_DATA_STR_TTL;
		abl = ABL_KIND_STR;
		x = WIN_MBR_DATA_STR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_STR_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_AGI:
		ttl = MSG_MBR_DATA_AGI_TTL;
		abl = ABL_KIND_AGI;
		x = WIN_MBR_DATA_AGI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_AGI_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_WIS:
		ttl = MSG_MBR_DATA_WIS_TTL;
		abl = ABL_KIND_WIS;
		x = WIN_MBR_DATA_WIS_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_WIS_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_INT:
		ttl = MSG_MBR_DATA_INT_TTL;
		abl = ABL_KIND_INT;
		x = WIN_MBR_DATA_INT_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_INT_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_CHA:
		ttl = MSG_MBR_DATA_CHA_TTL;
		abl = ABL_KIND_CHA;
		x = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_CHA_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_FIG:
		ttl = MSG_MBR_DATA_FIG_TTL;
		abl = ABL_KIND_FIG;
		x = WIN_MBR_DATA_FIG_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_FIG_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_MON:
		ttl = MSG_MBR_DATA_MON_TTL;
		abl = ABL_KIND_MON;
		x = WIN_MBR_DATA_MON_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MON_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_HUN:
		ttl = MSG_MBR_DATA_HUN_TTL;
		abl = ABL_KIND_HUN;
		x = WIN_MBR_DATA_HUN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_HUN_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_THI:
		ttl = MSG_MBR_DATA_THI_TTL;
		abl = ABL_KIND_THI;
		x = WIN_MBR_DATA_THI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_THI_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_NIN:
		ttl = MSG_MBR_DATA_NIN_TTL;
		abl = ABL_KIND_NIN;
		x = WIN_MBR_DATA_NIN_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_NIN_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_PRI:
		ttl = MSG_MBR_DATA_PRI_TTL;
		abl = ABL_KIND_PRI;
		x = WIN_MBR_DATA_PRI_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_PRI_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_SHA:
		ttl = MSG_MBR_DATA_SHA_TTL;
		abl = ABL_KIND_SHA;
		x = WIN_MBR_DATA_SHA_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SHA_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_BAR:
		ttl = MSG_MBR_DATA_BAR_TTL;
		abl = ABL_KIND_BAR;
		x = WIN_MBR_DATA_BAR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_BAR_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_MAG:
		ttl = MSG_MBR_DATA_MAG_TTL;
		abl = ABL_KIND_MAG;
		x = WIN_MBR_DATA_MAG_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_MAG_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_SOR:
		ttl = MSG_MBR_DATA_SOR_TTL;
		abl = ABL_KIND_SOR;
		x = WIN_MBR_DATA_SOR_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SOR_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_ENC:
		ttl = MSG_MBR_DATA_ENC_TTL;
		abl = ABL_KIND_ENC;
		x = WIN_MBR_DATA_ENC_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_ENC_TTL_DRAW_MIN_Y;
		break;
	case EDIT_CLASS_SUM:
		ttl = MSG_MBR_DATA_SUM_TTL;
		abl = ABL_KIND_SUM;
		x = WIN_MBR_DATA_SUM_TTL_DRAW_MIN_X;
		y = WIN_MBR_DATA_SUM_TTL_DRAW_MIN_Y;
		break;
	}

	print_str( x, y, FLG_NULL, MSG_EDIT_CLASS_TTL,
			ttl, (long)dst->abl_rate[abl] );

	if( flg_add ){
		print_str_n( x + 10, y, CURS_ATTR_N_MENU_SEL,
				MSG_EDIT_CLASS_ADD_SEL );
	} else {
		print_str_n( x + 10, y, CURS_ATTR_N_NORMAL,
				MSG_EDIT_CLASS_ADD_NOT_SEL );
	}

	if( flg_sub ){
		print_str_n( x + 10 + 3, y, CURS_ATTR_N_MENU_SEL,
				MSG_EDIT_CLASS_SUB_SEL );
	} else {
		print_str_n( x + 10 + 3, y, CURS_ATTR_N_NORMAL,
				MSG_EDIT_CLASS_SUB_NOT_SEL );
	}
}

/**/

bool_t	gets_class_name( char *name )
{
	long	x, y;
	char	bak[CLASS_NAME_MAX_LEN + 1];

	if( name == NULL )
		return FALSE;

	/* ̾¸ */
	strncpy( bak, name, CLASS_NAME_MAX_LEN );

	/* ̾ɽ򥯥ꥢ */
	name[0] = '\0';

	/* 򥻥å */
	x = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_X;
	y = WIN_MBR_DATA_CLASS_TTL_DRAW_MIN_Y;
	x += str_len_draw( MSG_MBR_DATA_CLASS_TTL );
	set_crsr( x, y );

	game_gets( name, CLASS_NAME_MAX_LEN );
	pick_cntrl_str( name );

	if( name[0] == '\0' ){
		/* ̾Ϥ򥭥󥻥 */
		strncpy( name, bak, CLASS_NAME_MAX_LEN );
		return FALSE;
	}

	return TRUE;
}

/**/

void	game_gets( char *s, long len )
{
	dis_term();
	curs_refresh();
	dis_curs();

	curs_getnstr( s, len );

	ena_curs();
	curs_refresh();
	ena_term();
}

/**/

void	pick_cntrl_str( char *s )
{
	char	*dst;

	for( dst = s; *s != '\0'; s++ ){
		if( !iscntrl( *s ) ){
			*dst = *s;
			dst++;
		}
	}

	*dst = '\0';
}

/**/

void	set_crsr( long x, long y )
{
	curs_move( y, x );
	curs_refresh();
}

/**/

void	reset_crsr( void )
{
	pos_t	*cur, *draw;

	draw = get_map_draw_pos();
	cur = get_crsr();
	set_crsr( (cur->x - draw->x) * 2,
			(cur->y - draw->y) );
}

/**/

pos_t	*get_map_draw_pos( void )
{
	return &map_draw_pos;
}

/**/

long	get_max_line( void )
{
#ifdef	D_USE_CURSES
	return LINES;
#else
	return 24;
#endif
}

/**/

rate_t	get_vfx_wait( void )
{
	return vfx_wait;
}

/**/

rate_t	set_vfx_wait( rate_t n )
{
	if( n < 0 )
		n = 0;

	vfx_wait = n;

	return vfx_wait;
}

/**/

flg_vfx_mbr_t	get_flg_vfx_mbr( void )
{
	return flg_vfx_mbr;
}

/**/

flg_vfx_mbr_t	set_flg_vfx_mbr( flg_vfx_mbr_t flg )
{
	flg_vfx_mbr = flg;

	return flg_vfx_mbr;
}

/**/

flg_vfx_mnstr_t	get_flg_vfx_mnstr( void )
{
	return flg_vfx_mnstr;
}

/**/

flg_vfx_mnstr_t	set_flg_vfx_mnstr( flg_vfx_mnstr_t flg )
{
	flg_vfx_mnstr = flg;

	return flg_vfx_mnstr;
}

/**/

void	wait_clock( long frame )
{
	clock_t	end_clock;
	long	anim_frame;

	frame = frame * get_vfx_wait() / _100_PERCENT;
	if( frame < 1 )
		frame = 1;

	anim_frame = (long)ANIM_FRAME;
#ifdef	D_USE_SLEEP
	if( (frame / anim_frame) > 0 )
		sleep( frame / anim_frame );

	frame %= anim_frame;
#endif	/* D_USE_SLEEP */

	end_clock = clock() + (clock_t)(CLK_TCK * frame / ANIM_FRAME);
	while( clock() < end_clock )
		;
}

/**/

long	read_char( long *p )
{
	randm( 1 );

	*p = curs_getch();

	switch( *p ){
	case '\0':
	case -1:
		return 0;
	case '\033':
		if( !g_flg_use_keypad )
			return read_esc( p );
		break;
	case 0x7f:
		*p = 'H' - '@';
		break;
#ifdef	D_USE_CURSES
	case KEY_BACKSPACE:
		*p = 'H' - '@';
		break;
	case KEY_HOME:
		*p = '/';
		break;
	case KEY_IC:
		*p = '*';
		break;
	case KEY_DC:
		*p = 'H' - '@';
		break;
	case KEY_END:
		*p = '.';
		break;
	case KEY_UP:
		*p = '8';
		break;
	case KEY_DOWN:
		*p = '2';
		break;
	case KEY_RIGHT:
		*p = '6';
		break;
	case KEY_LEFT:
		*p = '4';
		break;
#endif	/* D_USE_CURSES */
	}

	return 1;
}

/**/

long	read_char_wait( long *p )
{
	do {
		*p = curs_getch();
	} while( (*p == '\0') || (*p == -1) );

	return 1;
}

/**/

long	read_esc( long *p )
{
	long	tmp, key;

	key = '\0';

	read_char_wait( &key );
	if( key == '\033' ){
		;
	} else if( (key == '[') || (key == 'O') ){
		read_char_wait( &key );
		if( isdigit( key ) ){
			read_char_wait( &tmp );
		}
	}

	switch( key ){
	default:
		*p = '\0';
		return 0;
	case '\033':
		*p = '\033';
		break;
	case 'A':
		*p = '8';
		break;
	case 'B':
		*p = '2';
		break;
	case 'C':
		*p = '6';
		break;
	case 'D':
		*p = '4';
		break;
	case '1':
		*p = '/';
		break;
	case '2':
		*p = '*';
		break;
	case '3':
		*p = '0';
		break;
	case '4':
		*p = '.';
		break;
	}

	return 1;
}

/**/

long	get_key( bool_t flg_clr_msg )
{
#ifdef	D_X68K

	static long	bc = -1;
	long	c;

	if( !g_flg_clr_key_buf ){
		/* Хåե򥯥ꥢʤ */
		c = K_KEYINP();

		if( flg_clr_msg )
			clr_msg();

		return c;
	}

	c = K_KEYSNS();
	if( c == bc ){
		do {
			K_KEYINP();
			c = K_KEYSNS();
			if( c == '\0' ){
				break;
			}
		} while( c == bc );

		bc = K_KEYINP();

		if( flg_clr_msg )
			clr_msg();

		return bc;
	}

	bc = K_KEYINP();

	if( flg_clr_msg )
		clr_msg();

	return bc;

#elif	defined( D_UNIX )

	static time_t	prev_time = 0;
	static clock_t	prev_clock = 0;
	clock_t	next_clock = 0;
	static long	bc = -1;
	long	c;
	long	n;

	if( prev_clock == 0 )
		prev_clock = clock();
	next_clock = clock();

	do {
		if( g_flg_clr_key_buf ){
			if( difftime( time( NULL ), prev_time ) > 0.5 )
				break;
			if( next_clock < prev_clock )
				break;
			if( (next_clock - prev_clock) > (0.5 * CLK_TCK) )
				break;
		}

		/* Хåե򥯥ꥢʤ */
		do {
			n = read_char( &c );
		} while( n <= 0 );

		if( flg_clr_msg )
			clr_msg();

		bc = c;
		prev_time = time( NULL );
		prev_clock = clock();
		return c;
	} while( 0 );

	prev_time = time( NULL );
	prev_clock = clock();

	n = read_char( &c );
	if( n <= 0 ){
		do {
			n = read_char( &c );
		} while( n <= 0 );

		if( flg_clr_msg )
			clr_msg();

		bc = -1;
		prev_time = time( NULL );
		prev_clock = clock();
		return c;
	}

	if( c == bc ){
		next_clock = prev_clock + (0.2 * CLK_TCK);
		while( c == bc ){
			n = read_char( &c );
			if( difftime( time( NULL ), prev_time ) > 0.2 )
				break;
			if( clock() > next_clock )
				break;
		}
		while( n <= 0 )
			n = read_char( &c );

		if( flg_clr_msg )
			clr_msg();

		bc = c;
		prev_time = time( NULL );
		prev_clock = clock();
		return c;
	}

	if( flg_clr_msg )
		clr_msg();

	bc = c;
	prev_time = time( NULL );
	prev_clock = clock();
	return c;

#else	/* D_UNIX */
	long	c;

	c = getchar();

	if( flg_clr_msg )
		clr_msg();

	return c;

#endif	/* D_X68K */
}

/**/

