/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
/*#include	<string.h>*/
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
#include	"party.h"
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
#include	"msg.h"
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	FX_MAX_N	(LS_MBR_MAX_N * 16)

#define	NATURAL_CURE_HP_TURN	32
#define	NATURAL_CURE_HP_RATE	5
#define	NATURAL_CURE_HP_MAX	16
#define	CURE_HP_LIGHT_N	10
#define	CURE_HP_MODERATE_N	50
#define	CURE_HP_SERIOUS_N	100

#define	POW_UP_RESI_RATE	_100_PERCENT

#define	NATURAL_CURE_MP_TURN	64
#define	NATURAL_CURE_MP_RATE	5
#define	NATURAL_CURE_MP_MAX	16

#define	POISON_DEC_N_POTION	1
#define	SOBER_AVE_TURN	12
#define	SOBER_SUB_RATE	1
#define	HUNGRY_FEEL_RATE	10
#define	STARVATION_FEEL_RATE	10
#define	FAINT_FEEL_RATE	20

#define	SMOKING_PER_A_DAY	20
#define	TOBACCO_ABSTAIN_AVE_TURN	\
		(TURN_DAYTIME / SMOKING_PER_A_DAY / 10)
#define	TOBACCO_ABSTAIN_SUB_RATE	2
#define	TOBACCO_POISONING_AVE_TURN	1
#define	TOBACCO_POISONING_ADD_RATE	1
#define	TOBACCO_CURE_POISONING_AVE_TURN	(1 * TURN_PER_HOUR)
#define	TOBACCO_CURE_POISONING_SUB_RATE	1
#define	TOBACCO_FEEL_AVE_TURN	10
#define	TOBACCO_FEEL_MAX_RATE	50
#define	ADD_NICOTINE_RATE_PER_TURN	\
		(_100_PERCENT / (5 * TURN_PER_MINUTE) + 1)

#define	FX_DETECT_ITEM_R	(MAP_MAX_X / 3)

#define	FX_ABL_LEV_POW_UP_N	(+2)
#define	FX_ABL_LEV_POW_DOWN_N	(-1)
#define	FX_HP_LEV_POW_UP_N	(+2)

#define	FX_REMOVE_CURSE_DIFFICULTY	4

#define	MOVE_MIN_N	4
#define	MOVE_MAX_N	4

#define	FACE_MJR_ZAP	'*'
#define	ANIM_ZAP_LEN	(ANIM_FRAME_N / 4)

/**/

short	liquor_proof[LIQUOR_KIND_MAX_N] = {
	20,	/* LIQUOR_KIND_RED_WINE, */
	20,	/* LIQUOR_KIND WHITE_WINE, */
	20,	/* LIQUOR_KIND_ROSE_WINE, */
	30,	/* LIQUOR_KIND_ALE, */
	30,	/* LIQUOR_KIND_BRANDY, */
	30,	/* LIQUOR_KIND_RUM, */
};

n_msg_t	drink_n_msg_ls[] = {
	N_MSG_FX_DRINK_A00,
	N_MSG_FX_DRINK_A01,
	N_MSG_FX_DRINK_A02,
	N_MSG_FX_DRINK_A03,
	N_MSG_FX_DRINK_A04,
	N_MSG_FX_DRINK_A05,
	N_MSG_FX_DRINK_B00,
	N_MSG_NULL,
};

n_msg_t	eat_food_n_msg_ls[] = {
	N_MSG_FX_EAT_FOOD_A00,
	N_MSG_FX_EAT_FOOD_A01,
	N_MSG_FX_EAT_FOOD_A02,
	N_MSG_FX_EAT_FOOD_A03,
	N_MSG_FX_EAT_FOOD_A04,
	N_MSG_FX_EAT_FOOD_A05,
	N_MSG_FX_EAT_FOOD_A06,
	N_MSG_FX_EAT_FOOD_A07,
	N_MSG_FX_EAT_FOOD_A08,
	N_MSG_FX_EAT_FOOD_B00,
	N_MSG_FX_EAT_FOOD_B01,
	N_MSG_FX_EAT_FOOD_B02,
	N_MSG_NULL,
};

fx_t	fx_buf[FX_MAX_N];
fx_t	fx_free;

blast_t	blast = {
	0, 0, 0, 0,
	{
		"  *  ",
		" *** ",
		"*****",
		" *** ",
		"  *  ",
	},
};

/**/

void	init_fx( void )
{
	long	i;

	fx_free.next = &fx_buf[0];
	fx_buf[0].prev = &fx_free;
	fx_buf[0].next = &fx_buf[1];
	for( i = 1; i < FX_MAX_N - 1; i++ ){
		fx_buf[i].prev = &fx_buf[i - 1];
		fx_buf[i].next = &fx_buf[i + 1];
	}
	fx_buf[i].prev = &fx_buf[i - 1];
	fx_buf[i].next = &fx_free;
	fx_free.prev = &fx_buf[i];
}

/**/

void	inc_turn_all_fx( void )
{
	long	i;
	mnstr_t	*mns, *mns_u;
	party_t	*pty;

	/* ƥСΥեȤμ¹ */

	pty = get_party();
	dec_turn_fx_all_mbr( 1 );
	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*mbr;

		mbr = pty->mbr[i];

		if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST
				| FLG_STAT_DEAD ) ){
			continue;
		}

		/* HP μ */
		natural_cure_hp_mbr( mbr );

		/* MP μ */
		natural_cure_mp_mbr( mbr );

		/* äν */
		sober( mbr );

		/* ʪò */
		digest( mbr );

		/* ХζǾɾ */
		abstain( mbr );

		/* ɤʤ */
		fraternize( mbr );

		/* Żǽϸ */
		dec_infra_vision( mbr );

		inc_turn_smoke( mbr );

		exec_all_fx( mbr );
	}

	/* ƥ󥹥ΥեȤμ¹ */

	dec_turn_fx_all_mnstr( 1 );
	mns_u = get_mnstr_used();
	for( mns = mns_u->next; mns != mns_u; mns = mns->next ){
		/* äν */
		sober( mns );

		/* ʪò */
		digest( mns );

		/* ХζǾɾ */
		abstain( mns );

		/* ɤʤ */
		fraternize( mns );

		/* Żǽϸ */
		dec_infra_vision( mns );

		exec_all_fx( mns );
	}
}

/**/

void	natural_cure_hp_mbr( mbr_t *mbr )
{
	fx_t	*fx;
	long	n, max;

	if( (get_turn() % NATURAL_CURE_HP_TURN) != 0 )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	/* ǤˤƤϲʤ */
	fx = srch_fx( &(mbr->fx), FX_KIND_POISON );
	if( fx != NULL )
		return;

	max = mbr->abl.hp.max;
	n = (max * NATURAL_CURE_HP_RATE) / _100_PERCENT;
	if( n < 1 )
		n = 1;
	if( n > NATURAL_CURE_HP_MAX )
		n = NATURAL_CURE_HP_MAX;

	mbr->abl.hp.n += n;
	if( mbr->abl.hp.n > max ){
		mbr->abl.hp.n = max;
	}

	draw_mbr_stat( mbr );
}

/**/

void	natural_cure_mp_mbr( mbr_t *mbr )
{
	long	n, max;

	if( (get_turn() % NATURAL_CURE_MP_TURN) != 0 )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	max = mbr->abl.mp.max;
	n = (max * NATURAL_CURE_MP_RATE) / _100_PERCENT;
	if( n < 1 )
		n = 1;
	if( n > NATURAL_CURE_MP_MAX )
		n = NATURAL_CURE_MP_MAX;

	mbr->abl.mp.n += n;
	if( mbr->abl.mp.n > max )
		mbr->abl.mp.n = max;

	draw_mbr_stat( mbr );
}

/**/

void	sober( chr_t *p )
{
	if( !per_randm( SOBER_AVE_TURN ) )
		return;

	p->fx_data.drunk_rate -= SOBER_SUB_RATE;
	if( p->fx_data.drunk_rate < 0 )
		p->fx_data.drunk_rate = 0;
}

/**/

void	dec_turn_fx_all_mbr( long turn )
{
	long	i;
	party_t	*pty;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*mbr;
		fx_t	*fx, *end;

		mbr = pty->mbr[i];

		if( chk_flg_or( mbr->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		end = &(mbr->fx);
		for( fx = end->next->next; fx->prev != end; fx = fx->next ){
			if( fx->prev->kind == FX_KIND_NULL )
				break;
			if( fx->prev->turn == FX_TURN_INFINITE_N )
				continue;
			if( fx->prev->turn > 0 )
				fx->prev->turn -= turn;
			if( fx->prev->turn > 0 )
				continue;

			clr_fx( fx->prev );
		}
	}
}

/**/

void	dec_turn_fx_all_mnstr( long turn )
{
	mnstr_t	*mns, *mns_u;
	fx_t	*fx, *end;

	mns_u = get_mnstr_used();
	for( mns = mns_u->next; mns != mns_u; mns = mns->next ){
		end = &mns->fx;
		for( fx = end->next->next; fx->prev != end; fx = fx->next ){
			if( fx->prev->turn == FX_TURN_INFINITE_N )
				continue;
			if( fx->prev->turn > 0 )
				fx->prev->turn -= turn;
			if( fx->prev->turn > 0 )
				continue;

			clr_fx( fx->prev );
		}
	}
}

/**/

abl_kind_t	get_fx_to_abl( fx_kind_t kind )
{
	switch( kind ){
	default:
		return ABL_KIND_MAX_N;
	case FX_KIND_SHARPNESS:
	case FX_KIND_DULLNESS:
		return ABL_KIND_DEX;
	case FX_KIND_STRENGTH:
	case FX_KIND_WEAKNESS:
		return ABL_KIND_STR;
	case FX_KIND_QUICKNESS:
	case FX_KIND_SLOWNESS:
		return ABL_KIND_AGI;
	case FX_KIND_WISE:
	case FX_KIND_FOOLISH:
		return ABL_KIND_WIS;
	case FX_KIND_BRAINY:
	case FX_KIND_BRAINLESS:
		return ABL_KIND_INT;
	case FX_KIND_ATTRACTIVE:
	case FX_KIND_UNATTRACTIVE:
		return ABL_KIND_CHA;
	}

	return ABL_KIND_MAX_N;
}

/**/

long	get_fx_to_abl_add( fx_kind_t kind )
{
	switch( kind ){
	default:
		return 0;
	case FX_KIND_SHARPNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_QUICKNESS:
	case FX_KIND_WISE:
	case FX_KIND_BRAINY:
	case FX_KIND_ATTRACTIVE:
		return FX_ABL_LEV_POW_UP_N;
	case FX_KIND_DULLNESS:
	case FX_KIND_WEAKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINLESS:
	case FX_KIND_UNATTRACTIVE:
		return FX_ABL_LEV_POW_DOWN_N;
	}

	return 0;
}

/**/

void	exec_all_fx( mbr_t *mbr )
{
	fx_t	*fx, *end;

	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	end = &mbr->fx;
	for( fx = end->next->next; fx->prev != end; fx = fx->next )
		exec_fx( fx->prev );
}

/**/

fx_t	*set_fx( mbr_t *mbr, fx_kind_t kind, long turn )
{
	fx_t	*fx;

	/* Ǥ˥եȤ뤫 */
	fx = srch_fx( &(mbr->fx), kind );
	if( fx == NULL ){
		fx = asgn_fx( mbr->fx.next );
		/* եȤäѤ */
		if( fx == NULL )
			return NULL;

		fx->kind = kind;
		fx->turn = 0;
		fx->n = 0;
		fx->chr = mbr;
	}

	if( turn == FX_TURN_INFINITE_N )
		fx->turn = FX_TURN_INFINITE_N;
	else
		fx->turn = roll_dice( turn );

	/**/

	switch( fx->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		return fx;
	case FX_KIND_STONE:
		set_fx_stat( fx, FLG_STAT_STONE );
		break;
	case FX_KIND_PARALYZE:
		set_fx_stat( fx, FLG_STAT_PARALYZE );
		break;
	case FX_KIND_POISON:
		set_fx_stat( fx, FLG_STAT_POISON );
		break;
	case FX_KIND_CONFUSION:
		set_fx_stat( fx, FLG_STAT_CONFUSION );
		break;
	case FX_KIND_BLIND:
		set_fx_stat( fx, FLG_STAT_BLIND );
		break;
	case FX_KIND_SLEEP:
		set_fx_stat( fx, FLG_STAT_SLEEP );
		break;
	case FX_KIND_SILENCE:
		set_fx_stat( fx, FLG_STAT_SILENCE );
		break;
	case FX_KIND_FEAR:
		set_fx_stat( fx, FLG_STAT_FEAR );
		break;
	case FX_KIND_HALLUCINATION:
		set_fx_stat( fx, FLG_STAT_HALLUCINATION );
		break;
	case FX_KIND_CHARM:
		set_fx_stat( fx, FLG_STAT_CHARM );
		break;
	case FX_KIND_FLY:
		set_fx_stat( fx, FLG_STAT_FLY );
		break;
	case FX_KIND_FAINT:
		set_fx_stat( fx, FLG_STAT_FAINT );
		break;
	case FX_KIND_DRUNK:
		set_fx_stat( fx, FLG_STAT_DRUNK );
		break;
	case FX_KIND_VANISH:
		break;
	case FX_KIND_RESI_KNOC:
	case FX_KIND_RESI_SLAS:
	case FX_KIND_RESI_STIN:
	case FX_KIND_RESI_HEAT:
	case FX_KIND_RESI_COLD:
	case FX_KIND_RESI_WIND:
	case FX_KIND_RESI_ACID:
	case FX_KIND_RESI_ELEC:
	case FX_KIND_RESI_POIS:
		set_fx_resi( fx );
		break;
	case FX_KIND_SHARPNESS:
	case FX_KIND_DULLNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_WEAKNESS:
	case FX_KIND_QUICKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_WISE:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINY:
	case FX_KIND_BRAINLESS:
	case FX_KIND_ATTRACTIVE:
	case FX_KIND_UNATTRACTIVE:
		set_fx_abl( fx );
		break;
	case FX_KIND_SENSE_INVISIBLE:
		break;
	case FX_KIND_POW_UP_HP:
		set_fx_pow_up_hp( fx );
		break;
	case FX_KIND_SPEED:
		break;
	}

	draw_mbr_stat( fx->chr );

	return fx;
}

/**/

void	exec_fx( fx_t *p )
{
	if( p == NULL )
		return;

	switch( p->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		return;
	case FX_KIND_STONE:
	case FX_KIND_PARALYZE:
		break;
	case FX_KIND_POISON:
		exec_fx_poison( p );
		break;
	case FX_KIND_CONFUSION:
	case FX_KIND_BLIND:
	case FX_KIND_SLEEP:
	case FX_KIND_SILENCE:
	case FX_KIND_FEAR:
	case FX_KIND_HALLUCINATION:
	case FX_KIND_CHARM:
	case FX_KIND_FLY:
	case FX_KIND_FAINT:
	case FX_KIND_DRUNK:
	case FX_KIND_VANISH:
		break;
	case FX_KIND_RESI_KNOC:
	case FX_KIND_RESI_SLAS:
	case FX_KIND_RESI_STIN:
	case FX_KIND_RESI_HEAT:
	case FX_KIND_RESI_COLD:
	case FX_KIND_RESI_WIND:
	case FX_KIND_RESI_ACID:
	case FX_KIND_RESI_ELEC:
	case FX_KIND_RESI_POIS:
		break;
	case FX_KIND_SHARPNESS:
	case FX_KIND_DULLNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_WEAKNESS:
	case FX_KIND_QUICKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_WISE:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINY:
	case FX_KIND_BRAINLESS:
	case FX_KIND_ATTRACTIVE:
	case FX_KIND_UNATTRACTIVE:
		break;
	case FX_KIND_SENSE_INVISIBLE:
	case FX_KIND_POW_UP_HP:
		break;
	case FX_KIND_SPEED:
		break;
	}
}

/**/

void	clr_fx( fx_t *fx )
{
	char	*s;

	if( fx == NULL )
		return;

	if( fx->chr == NULL )
		s = MSG_MNSTR_UNKNOWN;
	else
		s = fx->chr->name;

	switch( fx->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		break;
	case FX_KIND_STONE:
		clr_fx_stat( fx, FLG_STAT_STONE );
		print_msg( FLG_NULL, MSG_CLR_FX_STONE, s );
		break;
	case FX_KIND_PARALYZE:
		clr_fx_stat( fx, FLG_STAT_PARALYZE );
		print_msg( FLG_NULL, MSG_CLR_FX_PARALYZE, s );
		break;
	case FX_KIND_POISON:
		clr_fx_stat( fx, FLG_STAT_POISON );
		print_msg( FLG_NULL, MSG_CLR_FX_POISON, s );
		break;
	case FX_KIND_CONFUSION:
		clr_fx_stat( fx, FLG_STAT_CONFUSION );
		print_msg( FLG_NULL, MSG_CLR_FX_CONFUSION, s );
		break;
	case FX_KIND_BLIND:
		clr_fx_stat( fx, FLG_STAT_BLIND );
		print_msg( FLG_NULL, MSG_CLR_FX_BLIND, s );
		break;
	case FX_KIND_SLEEP:
		clr_fx_stat( fx, FLG_STAT_SLEEP );
		print_msg( FLG_NULL, MSG_CLR_FX_SLEEP, s );
		break;
	case FX_KIND_SILENCE:
		clr_fx_stat( fx, FLG_STAT_SILENCE );
		print_msg( FLG_NULL, MSG_CLR_FX_SILENCE, s );
		break;
	case FX_KIND_FEAR:
		clr_fx_stat( fx, FLG_STAT_FEAR );
		print_msg( FLG_NULL, MSG_CLR_FX_FEAR, s );
		break;
	case FX_KIND_HALLUCINATION:
		clr_fx_stat( fx, FLG_STAT_HALLUCINATION );
		print_msg( FLG_NULL, MSG_CLR_FX_HALLUCINATION, s );
		break;
	case FX_KIND_CHARM:
		clr_fx_stat( fx, FLG_STAT_CHARM );
		print_msg( FLG_NULL, MSG_CLR_FX_CHARM, s );
		break;
	case FX_KIND_FLY:
		clr_fx_stat( fx, FLG_STAT_FLY );
		print_msg( FLG_NULL, MSG_CLR_FX_FLY, s );
		break;
	case FX_KIND_FAINT:
		clr_fx_stat( fx, FLG_STAT_FAINT );
		break;
	case FX_KIND_DRUNK:
		clr_fx_stat( fx, FLG_STAT_DRUNK );
		print_msg( FLG_NULL, MSG_CLR_FX_DRUNK, s );
		break;
	case FX_KIND_VANISH:
		print_msg( FLG_NULL, MSG_CLR_FX_VANISH, s );
		break;
	case FX_KIND_RESI_KNOC:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_KNOC, s );
		break;
	case FX_KIND_RESI_SLAS:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_SLAS, s );
		break;
	case FX_KIND_RESI_STIN:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_STIN, s );
		break;
	case FX_KIND_RESI_HEAT:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_HEAT, s );
		break;
	case FX_KIND_RESI_COLD:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_COLD, s );
		break;
	case FX_KIND_RESI_WIND:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_WIND, s );
		break;
	case FX_KIND_RESI_ACID:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_ACID, s );
		break;
	case FX_KIND_RESI_ELEC:
		clr_fx_resi( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_ELEC, s );
		break;
	case FX_KIND_RESI_POIS:
		clr_fx_resi( fx ); 
		print_msg( FLG_NULL, MSG_CLR_FX_RESI_POIS, s );
		break;
	case FX_KIND_SHARPNESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_SHARPNESS, s );
		break;
	case FX_KIND_DULLNESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_DULLNESS, s );
		break;
	case FX_KIND_STRENGTH:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_STRENGTH, s );
		break;
	case FX_KIND_WEAKNESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_WEAKNESS, s );
		break;
	case FX_KIND_QUICKNESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_QUICKNESS, s );
		break;
	case FX_KIND_SLOWNESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_SLOWNESS, s );
		break;
	case FX_KIND_WISE:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_WISE, s );
		break;
	case FX_KIND_FOOLISH:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_FOOLISH, s );
		break;
	case FX_KIND_BRAINY:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_BRAINY, s );
		break;
	case FX_KIND_BRAINLESS:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_BRAINLESS, s );
		break;
	case FX_KIND_ATTRACTIVE:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_ATTRACTIVE, s );
		break;
	case FX_KIND_UNATTRACTIVE:
		clr_fx_abl( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_UNATTRACTIVE, s );
		break;
	case FX_KIND_SENSE_INVISIBLE:
		print_msg( FLG_NULL, MSG_CLR_FX_SENSE_INVISIBLE, s );
		break;
	case FX_KIND_POW_UP_HP:
		clr_fx_pow_up_hp( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_POW_UP_HP, s );
		break;
	case FX_KIND_SPEED:
		clr_fx_speed( fx );
		print_msg( FLG_NULL, MSG_CLR_FX_SPEED, s );
		break;
	}

	draw_mbr_stat( fx->chr );

	free_fx( fx );
}

/**/

void	set_fx_stat( fx_t *fx, flg_stat_t flg )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	fx->chr->stat |= flg;
}

/**/

void	clr_fx_stat( fx_t *fx, flg_stat_t flg )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	fx->chr->stat &= ~(flg);
}

/**/

void	set_fx_abl( fx_t *fx )
{
	abl_kind_t	abl;
	long	n;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	abl = get_fx_to_abl( fx->kind );
	if( abl == ABL_KIND_MAX_N )
		return;

	n = get_fx_to_abl_add( fx->kind );

	fx->chr->abl.lev[abl].n += n;
}

/**/

void	clr_fx_abl( fx_t *fx )
{
	abl_kind_t	abl;
	long	n;
	abl_lev_t	*lev;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	abl = get_fx_to_abl( fx->kind );
	if( abl == ABL_KIND_MAX_N )
		return;

	n = get_fx_to_abl_add( fx->kind );

	lev = &(fx->chr->abl.lev[abl]);
	if( n > 0 ){
		if( lev->n > (lev->max + n) )
			lev->n -= n;
		else if( lev->n > lev->max )
			lev->n = lev->max;
	} else {
		if( lev->n < (lev->max + n) )
			lev->n -= n;
		else if( lev->n < lev->max )
			lev->n = lev->max;
	}
}

/**/

void	set_fx_resi( fx_t *fx )
{
	resi_kind_t	resi;

	switch( fx->kind ){
	default:
		return;
	case FX_KIND_RESI_KNOC:
		resi = RESI_KIND_KNOC;
		break;
	case FX_KIND_RESI_SLAS:
		resi = RESI_KIND_SLAS;
		break;
	case FX_KIND_RESI_STIN:
		resi = RESI_KIND_STIN;
		break;
	case FX_KIND_RESI_HEAT:
		resi = RESI_KIND_HEAT;
		break;
	case FX_KIND_RESI_COLD:
		resi = RESI_KIND_COLD;
		break;
	case FX_KIND_RESI_WIND:
		resi = RESI_KIND_WIND;
		break;
	case FX_KIND_RESI_ACID:
		resi = RESI_KIND_ACID;
		break;
	case FX_KIND_RESI_ELEC:
		resi = RESI_KIND_ELEC;
		break;
	case FX_KIND_RESI_POIS:
		resi = RESI_KIND_POIS;
		break;
	}

	pow_up_resi( fx->chr, resi );
}

/**/

void	clr_fx_resi( fx_t *fx )
{
	resi_kind_t	resi;

	switch( fx->kind ){
	default:
		return;
	case FX_KIND_RESI_KNOC:
		resi = RESI_KIND_KNOC;
		break;
	case FX_KIND_RESI_SLAS:
		resi = RESI_KIND_SLAS;
		break;
	case FX_KIND_RESI_STIN:
		resi = RESI_KIND_STIN;
		break;
	case FX_KIND_RESI_HEAT:
		resi = RESI_KIND_HEAT;
		break;
	case FX_KIND_RESI_COLD:
		resi = RESI_KIND_COLD;
		break;
	case FX_KIND_RESI_WIND:
		resi = RESI_KIND_WIND;
		break;
	case FX_KIND_RESI_ACID:
		resi = RESI_KIND_ACID;
		break;
	case FX_KIND_RESI_ELEC:
		resi = RESI_KIND_ELEC;
		break;
	case FX_KIND_RESI_POIS:
		resi = RESI_KIND_POIS;
		break;
	}

	pow_down_resi( fx->chr, resi );
}

/**/

void	set_fx_pow_up_hp( fx_t *fx )
{
	pow_up_hp( fx, +FX_HP_LEV_POW_UP_N );
}

/**/

void	clr_fx_pow_up_hp( fx_t *fx )
{
	pow_up_hp( fx, -FX_HP_LEV_POW_UP_N );
}

/**/

void	clr_fx_speed( fx_t *fx )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	if( fx->kind == CHR_KIND_MNSTR ){
		if( fx->chr->mnstr_tab == NULL )
			return;
		fx->chr->move_rate = fx->chr->mnstr_tab->move_rate;
	} else {
		fx->chr->move_rate = _100_PERCENT;
	}
}

/**/

void	exec_fx_poison( fx_t *fx )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	if( fx->chr->kind == CHR_KIND_MNSTR )
		return;

	if( per_randm( FX_AVE_TURN_POISON_DEC ) )
		add_hp( fx->chr, fx->n );
}

/**/

void	quaff_potion( mbr_t *mbr, item_t *item, bool_t flg_dec )
{
	item_t	tmp;
	char	*s;
	long	i, n;
	char	*str_drink, *str_name;

	if( mbr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_POTION )
		return;

	print_msg( FLG_NULL, MSG_FX_QUAFF_POTION, mbr->name, item->name );

	identify_potion( item );

	copy_item( &tmp, item );
	if( flg_dec )
		inc_item( item, -1 );

	s = mbr->name;

	n = 0;
	for( i = 0; i < 1024; i++ ){
		if( drink_n_msg_ls[i] == N_MSG_NULL )
			break;
		if( randm( i + 1 ) == 0 )
			n = i;
	}
	str_drink = MSG( drink_n_msg_ls[n] );

	if( tmp.tab.potion == NULL )
		return;
	str_name = tmp.tab.potion->name;

	switch( tmp.dat.potion.kind ){
	case POTION_KIND_NULL:
	case POTION_KIND_MAX_N:
		break;
	case POTION_KIND_WATER:
		print_msg( FLG_NULL, MSG_FX_WATER, s );
		break;
	case POTION_KIND_RED_WINE:
		if( drink_liquor( mbr, LIQUOR_KIND_RED_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_WHITE_WINE:
		if( drink_liquor( mbr, LIQUOR_KIND_WHITE_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_ROSE_WINE:
		if( drink_liquor( mbr, LIQUOR_KIND_ROSE_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_ALE:
		if( drink_liquor( mbr, LIQUOR_KIND_ALE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_BRANDY:
		if( drink_liquor( mbr, LIQUOR_KIND_BRANDY ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_RUM:
		if( drink_liquor( mbr, LIQUOR_KIND_RUM ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		else
			print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_MILK:
	case POTION_KIND_COFFE:
	case POTION_KIND_ICE_COFFE:
	case POTION_KIND_TEA:
	case POTION_KIND_MILK_TEA:
	case POTION_KIND_LEMON_TEA:
	case POTION_KIND_ICE_TEA:
	case POTION_KIND_ICE_MILK_TEA:
	case POTION_KIND_ICE_LEMON_TEA:
	case POTION_KIND_APPLE_JUICE:
	case POTION_KIND_GRAPE_JUICE:
	case POTION_KIND_ORANGE_JUICE:
	case POTION_KIND_BLACK_BERRY_JUICE:
	case POTION_KIND_CRAN_BERRY_JUICE:
	case POTION_KIND_RASP_BERRY_JUICE:
	case POTION_KIND_STRAW_BERRY_JUICE:
		print_msg( FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_OIL:
		print_msg( FLG_NULL, MSG_S, MSG_FX_OIL );
		break;
	case POTION_KIND_STONE:
		quaff_potion_std( mbr, FX_KIND_STONE );
		break;
	case POTION_KIND_PARALYZE:
		quaff_potion_std( mbr, FX_KIND_PARALYZE );
		break;
	case POTION_KIND_POISON:
		quaff_potion_poison( mbr );
		break;
	case POTION_KIND_CONFUSION:
		quaff_potion_std( mbr, FX_KIND_CONFUSION );
		break;
	case POTION_KIND_BLIND:
		quaff_potion_std( mbr, FX_KIND_BLIND );
		break;
	case POTION_KIND_SLEEP:
		quaff_potion_std( mbr, FX_KIND_SLEEP );
		break;
	case POTION_KIND_SILENCE:
		quaff_potion_std( mbr, FX_KIND_SILENCE );
		break;
	case POTION_KIND_FEAR:
		quaff_potion_std( mbr, FX_KIND_FEAR );
		break;
	case POTION_KIND_HALLUCINATION:
		quaff_potion_std( mbr, FX_KIND_HALLUCINATION );
		break;
	case POTION_KIND_CHARM:
		quaff_potion_std( mbr, FX_KIND_CHARM );
		break;
	case POTION_KIND_FLY:
		quaff_potion_std( mbr, FX_KIND_FLY );
		break;
	case POTION_KIND_VANISH:
		/*@@@*/
		print_msg( FLG_NULL, MSG_FX_VANISH, s );
		break;
	case POTION_KIND_RESI_PHYS:
		quaff_potion_resi( mbr, FX_KIND_RESI_KNOC );
		quaff_potion_resi( mbr, FX_KIND_RESI_SLAS );
		quaff_potion_resi( mbr, FX_KIND_RESI_STIN );
		break;
	case POTION_KIND_RESI_HEAT:
		quaff_potion_resi( mbr, FX_KIND_RESI_HEAT );
		break;
	case POTION_KIND_RESI_COLD:
		quaff_potion_resi( mbr, FX_KIND_RESI_COLD );
		break;
	case POTION_KIND_RESI_WIND:
		quaff_potion_resi( mbr, FX_KIND_RESI_WIND );
		break;
	case POTION_KIND_RESI_ACID:
		quaff_potion_resi( mbr, FX_KIND_RESI_ACID );
		break;
	case POTION_KIND_RESI_ELEC:
		quaff_potion_resi( mbr, FX_KIND_RESI_ELEC );
		break;
	case POTION_KIND_RESI_POIS:
		quaff_potion_resi( mbr, FX_KIND_RESI_POIS );
		break;
	case POTION_KIND_SHARPNESS:
		quaff_potion_abl( mbr, FX_KIND_SHARPNESS );
		break;
	case POTION_KIND_DULLNESS:
		quaff_potion_abl( mbr, FX_KIND_DULLNESS );
		break;
	case POTION_KIND_STRENGTH:
		quaff_potion_abl( mbr, FX_KIND_STRENGTH );
		break;
	case POTION_KIND_WEAKNESS:
		quaff_potion_abl( mbr, FX_KIND_WEAKNESS );
		break;
	case POTION_KIND_QUICKNESS:
		quaff_potion_abl( mbr, FX_KIND_QUICKNESS );
		break;
	case POTION_KIND_SLOWNESS:
		quaff_potion_abl( mbr, FX_KIND_SLOWNESS );
		break;
	case POTION_KIND_WISE:
		quaff_potion_abl( mbr, FX_KIND_WISE );
		break;
	case POTION_KIND_FOOLISH:
		quaff_potion_abl( mbr, FX_KIND_FOOLISH );
		break;
	case POTION_KIND_BRAINY:
		quaff_potion_abl( mbr, FX_KIND_BRAINY );
		break;
	case POTION_KIND_BRAINLESS:
		quaff_potion_abl( mbr, FX_KIND_BRAINLESS );
		break;
	case POTION_KIND_ATTRACTIVE:
		quaff_potion_abl( mbr, FX_KIND_ATTRACTIVE );
		break;
	case POTION_KIND_UNATTRACTIVE:
		quaff_potion_abl( mbr, FX_KIND_UNATTRACTIVE );
		break;
	case POTION_KIND_SENSE_INVISIBLE:
		/*@@@*/
		print_msg( FLG_NULL, MSG_FX_SENSE_INVISIBLE, s );
		break;
	case POTION_KIND_POW_UP_HP:
		quaff_potion_pow_up_hp( mbr );
		break;
	case POTION_KIND_SPEED_UP:
		quaff_potion_speed( mbr, +1 );
		break;
	case POTION_KIND_SPEED_DOWN:
		quaff_potion_speed( mbr, -1 );
		break;
	case POTION_KIND_CURE_LEV:
		if( quaff_potion_cure_lev( mbr ) )
			print_msg( FLG_NULL, MSG_FX_CURE_LEV, s );
		break;
	case POTION_KIND_CURE_HP_LIGHT:
		quaff_potion_cure_hp_light( mbr );
		break;
	case POTION_KIND_CURE_HP_MODERATE:
		quaff_potion_cure_hp_moderate( mbr );
		break;
	case POTION_KIND_CURE_HP_SERIOUS:
		quaff_potion_cure_hp_serious( mbr );
		break;
	case POTION_KIND_CURE_HP_MAX:
		quaff_potion_cure_hp_max( mbr );
		break;
	case POTION_KIND_CURE_POISON:
		if( quaff_potion_cure_poison( mbr ) )
			print_msg( FLG_NULL, MSG_FX_CURE_POISON, s );
		break;
	case POTION_KIND_CURE_STATUS:
		if( quaff_potion_cure_status( mbr ) )
			print_msg( FLG_NULL, MSG_FX_CURE_STATUS, s );
		break;
	case POTION_KIND_DETECT_MNSTR:
		quaff_potion_detect_mnstr( mbr );
		break;
	}

	draw_mbr_stat( mbr );
}

/**/

void	quaff_potion_mnstr( mnstr_t *mnstr, item_t *item, bool_t flg_dec )
{
	item_t	tmp;
	char	*s;

	if( mnstr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_POTION )
		return;

	copy_item( &tmp, item );
	if( flg_dec )
		inc_item( item, -1 );

	s = mnstr->name;

	switch( tmp.dat.potion.kind ){
	case POTION_KIND_NULL:
	case POTION_KIND_MAX_N:
		break;
	case POTION_KIND_WATER:
	case POTION_KIND_MILK:
		break;
	case POTION_KIND_RED_WINE:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_RED_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_WHITE_WINE:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_WHITE_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_ROSE_WINE:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_ROSE_WINE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_ALE:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_ALE ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_BRANDY:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_BRANDY ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_RUM:
		if( drink_liquor( mnstr,
				LIQUOR_KIND_RUM ) )
			print_msg( FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case POTION_KIND_COFFE:
	case POTION_KIND_ICE_COFFE:
	case POTION_KIND_TEA:
	case POTION_KIND_MILK_TEA:
	case POTION_KIND_LEMON_TEA:
	case POTION_KIND_ICE_TEA:
	case POTION_KIND_ICE_MILK_TEA:
	case POTION_KIND_ICE_LEMON_TEA:
	case POTION_KIND_APPLE_JUICE:
	case POTION_KIND_GRAPE_JUICE:
	case POTION_KIND_ORANGE_JUICE:
	case POTION_KIND_BLACK_BERRY_JUICE:
	case POTION_KIND_CRAN_BERRY_JUICE:
	case POTION_KIND_RASP_BERRY_JUICE:
	case POTION_KIND_STRAW_BERRY_JUICE:
	case POTION_KIND_OIL:
		break;
	case POTION_KIND_STONE:
		quaff_potion_std( mnstr,
				FX_KIND_STONE );
		break;
	case POTION_KIND_PARALYZE:
		quaff_potion_std( mnstr,
				FX_KIND_PARALYZE );
		break;
	case POTION_KIND_POISON:
		quaff_potion_poison( mnstr );
		break;
	case POTION_KIND_CONFUSION:
		quaff_potion_std( mnstr,
				FX_KIND_CONFUSION );
		break;
	case POTION_KIND_BLIND:
		quaff_potion_std( mnstr,
				FX_KIND_BLIND );
		break;
	case POTION_KIND_SLEEP:
		quaff_potion_std( mnstr,
				FX_KIND_SLEEP );
		break;
	case POTION_KIND_SILENCE:
		quaff_potion_std( mnstr,
				FX_KIND_SILENCE );
		break;
	case POTION_KIND_FEAR:
		quaff_potion_std( mnstr,
				FX_KIND_FEAR );
		break;
	case POTION_KIND_HALLUCINATION:
		quaff_potion_std( mnstr,
				FX_KIND_HALLUCINATION );
		break;
	case POTION_KIND_CHARM:
		quaff_potion_std( mnstr,
				FX_KIND_CHARM );
		break;
	case POTION_KIND_FLY:
		quaff_potion_std( mnstr,
				FX_KIND_FLY );
		break;
	case POTION_KIND_VANISH:
		/*@@@*/
		print_msg( FLG_NULL, MSG_FX_VANISH, s );
		break;
	case POTION_KIND_RESI_PHYS:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_KNOC );
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_SLAS );
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_STIN );
		break;
	case POTION_KIND_RESI_HEAT:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_HEAT );
		break;
	case POTION_KIND_RESI_COLD:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_COLD );
		break;
	case POTION_KIND_RESI_WIND:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_WIND );
		break;
	case POTION_KIND_RESI_ACID:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_ACID );
		break;
	case POTION_KIND_RESI_ELEC:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_ELEC );
		break;
	case POTION_KIND_RESI_POIS:
		quaff_potion_resi( mnstr,
				FX_KIND_RESI_POIS );
		break;
	case POTION_KIND_SHARPNESS:
		quaff_potion_abl( mnstr,
				FX_KIND_SHARPNESS );
		break;
	case POTION_KIND_DULLNESS:
		quaff_potion_abl( mnstr,
				FX_KIND_DULLNESS );
		break;
	case POTION_KIND_STRENGTH:
		quaff_potion_abl( mnstr,
				FX_KIND_STRENGTH );
		break;
	case POTION_KIND_WEAKNESS:
		quaff_potion_abl( mnstr,
				FX_KIND_WEAKNESS );
		break;
	case POTION_KIND_QUICKNESS:
		quaff_potion_abl( mnstr,
				FX_KIND_QUICKNESS );
		break;
	case POTION_KIND_SLOWNESS:
		quaff_potion_abl( mnstr,
				FX_KIND_SLOWNESS );
		break;
	case POTION_KIND_WISE:
		quaff_potion_abl( mnstr,
				FX_KIND_WISE );
		break;
	case POTION_KIND_FOOLISH:
		quaff_potion_abl( mnstr,
				FX_KIND_FOOLISH );
		break;
	case POTION_KIND_BRAINY:
		quaff_potion_abl( mnstr,
				FX_KIND_BRAINY );
		break;
	case POTION_KIND_BRAINLESS:
		quaff_potion_abl( mnstr,
				FX_KIND_BRAINLESS );
		break;
	case POTION_KIND_ATTRACTIVE:
		quaff_potion_abl( mnstr,
				FX_KIND_ATTRACTIVE );
		break;
	case POTION_KIND_UNATTRACTIVE:
		quaff_potion_abl( mnstr,
				FX_KIND_UNATTRACTIVE );
		break;
	case POTION_KIND_SENSE_INVISIBLE:
		/*@@@*/
		print_msg( FLG_NULL, MSG_FX_SENSE_INVISIBLE, s );
		break;
	case POTION_KIND_POW_UP_HP:
		quaff_potion_pow_up_hp( mnstr );
		break;
	case POTION_KIND_SPEED_UP:
		quaff_potion_speed( mnstr, +1 );
		break;
	case POTION_KIND_SPEED_DOWN:
		quaff_potion_speed( mnstr, -1 );
		break;
	case POTION_KIND_CURE_LEV:
		quaff_potion_cure_lev( mnstr );
		break;
	case POTION_KIND_CURE_HP_LIGHT:
		quaff_potion_cure_hp_light( mnstr );
		break;
	case POTION_KIND_CURE_HP_MODERATE:
		quaff_potion_cure_hp_moderate( mnstr );
		break;
	case POTION_KIND_CURE_HP_SERIOUS:
		quaff_potion_cure_hp_serious( mnstr );
		break;
	case POTION_KIND_CURE_HP_MAX:
		quaff_potion_cure_hp_max( mnstr );
		break;
	case POTION_KIND_CURE_POISON:
		if( quaff_potion_cure_poison( mnstr ) )
			print_msg( FLG_NULL, MSG_FX_CURE_POISON, s );
		break;
	case POTION_KIND_CURE_STATUS:
		if( quaff_potion_cure_status( mnstr ) )
			print_msg( FLG_NULL, MSG_FX_CURE_STATUS, s );
		break;
	case POTION_KIND_DETECT_MNSTR:
		quaff_potion_detect_mnstr( mnstr );
		break;
	}
}

/**/

bool_t	quaff_potion_std( chr_t *p, fx_kind_t fx_k )
{
	return set_fx_std( p, fx_k );
}

/**/

bool_t	quaff_potion_abl( chr_t *p, fx_kind_t fx_k )
{
	long	turn;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_SHARPNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_QUICKNESS:
	case FX_KIND_WISE:
	case FX_KIND_BRAINY:
	case FX_KIND_ATTRACTIVE:
		turn = FX_AVE_TURN_POW_UP_ABL;
		break;
	case FX_KIND_DULLNESS:
	case FX_KIND_WEAKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINLESS:
	case FX_KIND_UNATTRACTIVE:
		turn = FX_AVE_TURN_POW_DOWN_ABL;
		break;
	}

	return fx_abl( p, fx_k, turn );
}

/**/

bool_t	quaff_potion_resi( chr_t *p, fx_kind_t fx_k )
{
	return fx_resi( p, fx_k, FX_AVE_TURN_POW_UP_RESI );
}

/**/

bool_t	quaff_potion_cure_lev( chr_t *p )
{
	long	i;

	if( p == NULL )
		return FALSE;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		p->abl.lev[i].n = p->abl.lev[i].max;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_CURE_LEV, p->name );

	return TRUE;
}

/**/

bool_t	quaff_potion_cure_hp_light( chr_t *p )
{
	return fx_cure_hp_light( p );
}

/**/

bool_t	quaff_potion_cure_hp_moderate( chr_t *p )
{
	return fx_cure_hp_moderate( p );
}

/**/

bool_t	quaff_potion_cure_hp_serious( chr_t *p )
{
	return fx_cure_hp_serious( p );
}

/**/

bool_t	quaff_potion_cure_hp_max( chr_t *p )
{
	return fx_cure_hp_max( p );
}

/**/

bool_t	quaff_potion_cure_poison( chr_t *p )
{
	fx_t	*fx;

	if( p == NULL )
		return FALSE;

	fx = &(p->fx);

	fx = srch_fx( fx, FX_KIND_POISON );
	if( fx == NULL )
		return FALSE;

	clr_fx( fx );

	return TRUE;
}

/**/

bool_t	quaff_potion_cure_status( chr_t *p )
{
	return fx_cure_all_status( p );
}

/**/

bool_t	quaff_potion_detect_mnstr( chr_t *p )
{
	return fx_detect_mnstr( p );
}

/**/

bool_t	quaff_potion_poison( chr_t *p )
{
	return fx_poison( p );
}

/**/

bool_t	quaff_potion_pow_up_hp( chr_t *p )
{
	return fx_pow_up_hp( p, FX_AVE_TURN_POW_UP_HP );
}

/**/

bool_t	quaff_potion_speed( chr_t *p, long sgn_n )
{
	long	turn;

	if( sgn_n >= +1 )
		turn = FX_AVE_TURN_SPEED_UP;
	else
		turn = FX_AVE_TURN_SPEED_DOWN;

	return fx_speed_up( p, p, sgn_n, turn );
}

/**/

void	fill_potion( mbr_t *mbr, item_t *potion )
{
	item_t	*lamp;
	light_tab_t	*tab;

	if( potion == NULL )
		return;
	if( potion->kind != ITEM_KIND_POTION )
		return;

	lamp = &(get_mbr_item_asgn_equip( mbr )[EQUIP_KIND_LIGHT_SOURCE]);
	tab = lamp->tab.light;
	if( (lamp->kind != ITEM_KIND_LIGHT)
			|| (!tab->flg_fill) ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_FILL_LAMP );
		return;
	}

	if( potion->dat.potion.kind == POTION_KIND_OIL ){
		lamp->dat.light.turn = tab->max_turn + ADJUST_TURN;
		identify_potion( potion );
	} else {
		print_msg( FLG_NULL, MSG_S, MSG_ERR_FILL_LAMP_NON_OIL );
		lamp->dat.light.turn = 0;
	}

	inc_item( potion, -1 );
}

/**/

bool_t	drink_liquor( chr_t *p, liquor_kind_t kind )
{
	fx_t	*fx;
	long	add;

	if( p == NULL )
		return FALSE;

	add = liquor_proof[kind];
	add = calc_resi( p->resi[RESI_KIND_POIS].n, add );
	p->fx_data.drunk_rate += add;
	if( p->fx_data.drunk_rate < _100_PERCENT )
		return FALSE;

	fx = set_fx( p, FX_KIND_DRUNK, FX_TURN_DRUNK );

	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

void	read_scroll( mbr_t *mbr, item_t *item )
{
	dun_t	*dun = get_dun();

	if( mbr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_SCROLL )
		return;

	if( dun->map.light_depth[mbr->y][mbr->x] <= 0 ){
		print_msg( FLG_NULL, MSG_READ_SCROLL_FAILURE, mbr->name );
		return;
	}

	print_msg( FLG_NULL, MSG_FX_READ_SCROLL, mbr->name, item->name );

	identify_scroll( item );

	switch( item->dat.scroll.kind ){
	case SCROLL_KIND_NULL:
	case SCROLL_KIND_MAX_N:
		break;
	case SCROLL_KIND_SLEEP:
		read_scroll_sleep( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_IDENTIFY_ITEM:
		if( read_scroll_identify_item( mbr ) )
			inc_item( item, -1 );
		else
			print_msg( FLG_NULL, MSG_CANCEL );
		redraw_all();
		break;
	case SCROLL_KIND_DETECT_ITEM:
		read_scroll_detect_item( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_TELEPORT:
		read_scroll_teleport( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_POW_UP_WPN_HIT:
		read_scroll_pow_up_wpn_hit( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_POW_UP_WPN_DAM:
		read_scroll_pow_up_wpn_dam( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_REMOVE_CURSE:
		read_scroll_remove_curse( mbr );
		inc_item( item, -1 );
		break;
	case SCROLL_KIND_RECALL:
		if( read_scroll_recall() )
			inc_item( item, -1 );
		break;
	}

	draw_mbr_stat( mbr );
}

/**/

bool_t	read_scroll_sleep( mbr_t *mbr )
{
	long	dx, dy;
	long	turn;
	fx_kind_t	kind;
	mnstr_t	*mnstr;
	bool_t	ret;

	if( mbr == NULL )
		return FALSE;

	ret = FALSE;

	for( dy = -1; dy <= +1; dy++ ){
		for( dx = -1; dx <= +1; dx++ ){
			mnstr = get_mnstr(
					mbr->x + dx,
					mbr->y + dy );
			if( mnstr == NULL )
				continue;

			kind = FX_KIND_SLEEP;
			turn = FX_AVE_TURN_SLEEP;
			if( set_fx( mnstr, kind, turn )
					!= NULL ){
				ret = TRUE;
			}
		}
	}

	if( ret )
		print_msg( FLG_NULL, MSG_FX_SLEEP_SUCCESS, mbr->name );
	else
		print_msg( FLG_NULL, MSG_FX_SLEEP_FAILURE, mbr->name );

	return ret;
}

/**/

bool_t	read_scroll_identify_item( mbr_t *mbr )
{
	return exec_menu_identify_item( mbr );
}

/**/

bool_t	read_scroll_detect_item( mbr_t *mbr )
{
	return fx_detect_mnstr( mbr );
}

/**/

bool_t	read_scroll_teleport( mbr_t *mbr )
{
	teleport_party();

	return TRUE;
}

/**/

bool_t	read_scroll_pow_up_wpn_hit( mbr_t *mbr )
{
	return fx_pow_up_wpn_hit( mbr );
}

/**/

bool_t	read_scroll_pow_up_wpn_wpn_crtcl( mbr_t *mbr )
{
	return fx_pow_up_wpn_wpn_crtcl( mbr );
}

/**/

bool_t	read_scroll_pow_up_wpn_dam( mbr_t *mbr )
{
	return fx_pow_up_wpn_dam( mbr );
}

/**/

bool_t	read_scroll_remove_curse( mbr_t *mbr )
{
	return remove_curse( NULL, mbr, 0 );
}

/**/

bool_t	read_scroll_recall( void )
{
	return recall();
}

/**/

bool_t	zap_stick( chr_t *chr, item_t *item )
{
	spell_tab_t	*spell;

	if( chr == NULL )
		return FALSE;
	if( chr->trgt.p == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_STICK )
		return FALSE;

	item->dat.stick.n--;
	if( item->dat.stick.n < 0 ){
		item->dat.stick.n = 0;
		print_msg( FLG_NULL, MSG_S, MSG_STICK_FAILURE );
		return FALSE;
	}
	set_item_name( item );

	print_msg( FLG_NULL, MSG_FX_ZAP_STICK, chr->name, item->name );

	spell = get_spell_tab( item->dat.stick.spell_kind );
	if( spell == NULL )
		return FALSE;

	switch( item->dat.stick.kind ){
	case STICK_KIND_NULL:
	case STICK_KIND_MAX_N:
		return FALSE;
	case STICK_KIND_WAND:
		chr_cast_spell_normal( chr, spell, _100_PERCENT );
		break;
	case STICK_KIND_ROD:
		chr_cast_spell_spread( chr, spell, _100_PERCENT );
		break;
	case STICK_KIND_STAFF:
		chr_cast_spell_mass( chr, spell, _100_PERCENT );
		break;
	}

	return TRUE;
}

/**/

bool_t	fx_std( chr_t *p, fx_kind_t fx_k )
{
	return set_fx_std( p, fx_k );
}

/**/

bool_t	set_fx_std( chr_t *p, fx_kind_t fx_k )
{
	long	turn;
	char	*msg;

	if( p == NULL )
		return FALSE;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_STONE:
		turn = FX_AVE_TURN_STONE;
		msg = MSG_FX_STONE;
		break;
	case FX_KIND_PARALYZE:
		turn = FX_AVE_TURN_PARALYZE;
		msg = MSG_FX_PARALYZE;
		break;
	case FX_KIND_POISON:
		return fx_poison( p );
	case FX_KIND_CONFUSION:
		turn = FX_AVE_TURN_CONFUSION;
		msg = MSG_FX_CONFUSION;
		break;
	case FX_KIND_BLIND:
		clr_chr_trgt_act( (mbr_t *)p, FALSE );
		turn = FX_AVE_TURN_BLIND;
		msg = MSG_FX_BLIND;
		break;
	case FX_KIND_SLEEP:
		turn = FX_AVE_TURN_SLEEP;
		msg = MSG_FX_SLEEP;
		break;
	case FX_KIND_SILENCE:
		turn = FX_AVE_TURN_SILENCE;
		msg = MSG_FX_SILENCE;
		break;
	case FX_KIND_FEAR:
		turn = FX_AVE_TURN_FEAR;
		msg = MSG_FX_FEAR;
		break;
	case FX_KIND_HALLUCINATION:
		turn = FX_AVE_TURN_HALLUCINATION;
		msg = MSG_FX_HALLUCINATION;
		break;
	case FX_KIND_CHARM:
		turn = FX_AVE_TURN_CHARM;
		msg = MSG_FX_CHARM;
		break;
	case FX_KIND_FLY:
		turn = FX_AVE_TURN_FLY;
		msg = MSG_FX_FLY;
		break;
	}

	if( set_fx( p, fx_k, turn ) == NULL )
		return FALSE;

	print_msg( FLG_NULL, msg, p->name );

	return TRUE;
}

/**/

bool_t	fx_light( long x, long y )
{
	on_light_area( x, y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return TRUE;
}

/**/

bool_t	fx_darkness( long x, long y )
{
	off_light_area( x, y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return TRUE;
}

/**/

bool_t	fx_knock( door_t *p )
{
	if( p == NULL )
		return FALSE;

	return disarm_door( p->n );
}

/**/

bool_t	fx_lock( door_t *p )
{
	if( p == NULL )
		return FALSE;

	return jam_door( p->n );
}

/**/

bool_t	fx_disarm_trap( trap_t *p, chr_t *chr )
{
	if( p == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	if( chr_roll( chr, ABL_KIND_MAG, ABL_KIND_INT, p->difficulty ) ){
		disarm_trap( p );
		print_msg( FLG_NULL, MSG_TRAP_DISARM,
				chr->name, p->tab->name );
		return TRUE;
	}

	if( !rate_randm( TRAP_DISARM_FAILURE_RATE ) ){
		print_msg( FLG_NULL, MSG_ERR_TRAP_DISARM_LEV );
		return FALSE;
	}

	caught_trap( p, chr );
	return TRUE;
}

/**/

bool_t	fx_teleport( trgt_kind_t trgt_kind, chr_t *p )
{
	switch( trgt_kind ){
	case TRGT_KIND_NULL:
		return FALSE;
	case TRGT_KIND_MBR:
		teleport_mbr( (mbr_t *)p );
		return TRUE;
	case TRGT_KIND_MNSTR:
		teleport_mnstr( (mnstr_t *)p );
		return TRUE;
	case TRGT_KIND_MNSTR_NULL:
		return TRUE;
	case TRGT_KIND_ITEM:
		teleport_item( (item_t *)p );
		return TRUE;
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_POS:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return FALSE;
	}

	return FALSE;
}

/**/

bool_t	teleport_party( void )
{
	party_t	*pty;
	long	i;

	print_msg( FLG_NULL, MSG_FX_TELEPORT_PARTY );

	appear_party( TRUE );

	pty = get_party();
	for( i = 0; i < MBR_MAX_N; i++ )
		clr_chr_trgt_act( pty->mbr[i], FALSE );

	next_pos_square( 0 );

	redraw_all();

	return TRUE;
}

/**/

bool_t	teleport_mbr( mbr_t *mbr )
{
	long	i;
	long	nx, ny;

	if( mbr == NULL )
		return FALSE;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	print_msg( FLG_NULL, MSG_FX_TELEPORT, mbr->name );

	clr_map_chr( mbr );

	for( i = 1024; i > 0; i-- ){
		nx = 1 + randm( MAP_MAX_X - 2);
		ny = 1 + randm( MAP_MAX_Y - 2);
		mbr->x = nx;
		mbr->y = ny;
		mbr->pre_x = nx;
		mbr->pre_y = ny;

		if( can_move_chr( mbr, nx, ny ) )
			break;	/* ֤˰ư褿 */
	}
	if( i <= 0 )
		return FALSE;

	clr_chr_trgt_act( mbr, FALSE );

	set_map_chr( mbr );

	redraw_all();

	return TRUE;
}

/**/

bool_t	recall( void )
{
	long	i;
	party_t	*pty;
	dun_t	*dun;
	long	n, max_floor, max_base;
	char	*ret;

	pty = get_party();
	dun = get_dun();
	max_floor = 0;
	max_base = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( pty->mbr[i]->max_dun_lev_floor > max_floor )
			max_floor = pty->mbr[i]->max_dun_lev_floor;
		if( pty->mbr[i]->max_dun_lev_base > max_base )
			max_base = pty->mbr[i]->max_dun_lev_base;
	}

	if( dun->lev == 0 )
		n = -max_base;
	else
		n = 0;

	print_msg( FLG_NULL, MSG_FX_RECALL_ASK );
	ret = exec_menu_sel_num( -max_base, max_floor, &n );
	redraw_all();
	if( ret != NULL )
		return FALSE;

	pty->act.kind = ACT_KIND_RECALL;
	pty->act.n = n;
	pty->act.n2 = FX_AVE_TURN_RECALL;

	print_msg( FLG_MSG_NO_MORE_PREV, MSG_FX_RECALL );

	return TRUE;
}

/**/

bool_t	chk_recall( void )
{
	party_t	*pty;
	dun_t *dun;

	pty = get_party();

	if( pty->act.kind != ACT_KIND_RECALL )
		return FALSE;

	pty->act.n2--;

	if( pty->act.n2 > 0 )
		return FALSE;

	dun = get_dun();
	up_dun( pty->act.n - dun->lev );

	clr_party_act();

	return TRUE;
}

/**/

bool_t	fx_create_food( chr_t *p )
{
	item_t	*food, dmy;

	if( p == NULL )
		return FALSE;

	food = alloc_item( &dmy );
	if( food == NULL )
		return FALSE;

	if( !make_item_food( 10, food, FOOD_KIND_PRESERVED ) ){
		free_item( food );
		return FALSE;
	}

	if( p->kind == CHR_KIND_MBR ){
		if( !give_mbr_item( p, food ) ){
			if( !put_item( p->x, p->y, PUT_ITEM_R,
					food, TRUE ) ){
				free_item( food );
				return FALSE;
			}
		}
	} else {
		if( !put_item( p->x, p->y, PUT_ITEM_R, food, TRUE ) ){
			free_item( food );
			return FALSE;
		}
	}

	if( food->tab.food != NULL ){
		print_msg( FLG_NULL, MSG_FX_CREATE_FOOD,
				p->name, food->tab.food->name );
	}

	return TRUE;
}

/**/

bool_t	fx_detect_item( chr_t *chr )
{
	long	x, y, r;

	x = chr->x;
	y = chr->y;
	r = FX_DETECT_ITEM_R;
	detect_item( x, y, r );

	return TRUE;
}

/**/

bool_t	fx_detect_mnstr( chr_t *p )
{
	if( p == NULL )
		return FALSE;

	if( p->kind == CHR_KIND_MBR ){
		set_find_all_mnstr();
		redraw_all();
		wait_key();
		set_flg_find_all_mnstr();

		print_msg( FLG_NULL, MSG_FX_DETECT_MNSTR,
				((mbr_t *)p)->name );
	}

	return TRUE;
}

/**/

bool_t	fx_darkvision( chr_t *p )
{
	const long	turn = FX_AVE_TURN_DARKVISION;

	if( p == NULL )
		return FALSE;

	if( p->kind == CHR_KIND_MBR )
		clr_map_chr( p );

	p->fx_data.infra_vision += roll_dice( turn );

	if( p->kind == CHR_KIND_MBR )
		set_map_chr( p );

	return TRUE;
}

/**/

bool_t	fx_magic_missile(
	chr_t *o_p, trgt_kind_t trgt_kind, chr_t *d_p, rate_t rate
)
{
	resi_kind_t	resi;

	switch( randm( 3 ) ){
	case 0:
		resi = RESI_KIND_KNOC;
		break;
	case 1:
		resi = RESI_KIND_SLAS;
		break;
	case 2:
		resi = RESI_KIND_STIN;
		break;
	default:
		return FALSE;
	}

	return fx_spell_attack( o_p, trgt_kind, d_p,
			resi, ABL_KIND_SOR, rate );
}

/**/

bool_t	fx_spell_attack(
	chr_t *o_p, trgt_kind_t trgt_kind, void *d_p,
	resi_kind_t resi, abl_kind_t abl, rate_t rate
)
{
	switch( trgt_kind ){
	case TRGT_KIND_MBR:
	case TRGT_KIND_MNSTR:
		return spell_attack( o_p, (chr_t *)d_p,
				resi, FALSE, abl, rate );
	case TRGT_KIND_ITEM:
/*@@@@@@*/
		return FALSE;
	default:
		return FALSE;
	}
}

/**/

bool_t	fx_abl( chr_t *p, fx_kind_t fx_k, long turn )
{
	fx_t	*fx;
	fx_kind_t	deny_kind;
	char	*msg;

	if( p == NULL )
		return FALSE;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_SHARPNESS:
		deny_kind = FX_KIND_DULLNESS;
		msg = MSG_FX_SHARPNESS;
		break;
	case FX_KIND_DULLNESS:
		deny_kind = FX_KIND_SHARPNESS;
		msg = MSG_FX_DULLNESS;
		break;
	case FX_KIND_STRENGTH:
		deny_kind = FX_KIND_WEAKNESS;
		msg = MSG_FX_STRENGTH;
		break;
	case FX_KIND_WEAKNESS:
		deny_kind = FX_KIND_STRENGTH;
		msg = MSG_FX_WEAKNESS;
		break;
	case FX_KIND_QUICKNESS:
		deny_kind = FX_KIND_SLOWNESS;
		msg = MSG_FX_QUICKNESS;
		break;
	case FX_KIND_SLOWNESS:
		deny_kind = FX_KIND_QUICKNESS;
		msg = MSG_FX_SLOWNESS;
		break;
	case FX_KIND_WISE:
		deny_kind = FX_KIND_FOOLISH;
		msg = MSG_FX_WISE;
		break;
	case FX_KIND_FOOLISH:
		deny_kind = FX_KIND_WISE;
		msg = MSG_FX_FOOLISH;
		break;
	case FX_KIND_BRAINY:
		deny_kind = FX_KIND_BRAINLESS;
		msg = MSG_FX_BRAINY;
		break;
	case FX_KIND_BRAINLESS:
		deny_kind = FX_KIND_BRAINY;
		msg = MSG_FX_BRAINLESS;
		break;
	case FX_KIND_ATTRACTIVE:
		deny_kind = FX_KIND_UNATTRACTIVE;
		msg = MSG_FX_ATTRACTIVE;
		break;
	case FX_KIND_UNATTRACTIVE:
		deny_kind = FX_KIND_ATTRACTIVE;
		msg = MSG_FX_UNATTRACTIVE;
		break;
	}

	fx = srch_fx( &(p->fx), deny_kind );
	if( fx != NULL ){
		clr_fx( fx );
		return FALSE;
	}

	if( set_fx( p, fx_k, turn ) == NULL )
		return FALSE;

	print_msg( FLG_NULL, msg, p->name );

	return TRUE;
}

/**/

bool_t	fx_poison( chr_t *p )
{
	fx_kind_t	kind;
	long	turn;
	fx_t	*fx;

	if( p == NULL )
		return FALSE;

	kind = FX_KIND_POISON;
	turn = FX_AVE_TURN_POISON;

	fx = set_fx( p, kind, turn );
	if( fx == NULL )
		return FALSE;

	if( fx->n < POISON_DEC_N_POTION )
		fx->n = POISON_DEC_N_POTION;

	print_msg( FLG_NULL, MSG_FX_POISON, p->name );

	return TRUE;
}

/**/

bool_t	fx_pow_up_hp( chr_t *p, long turn )
{
	fx_t	*fx;

	if( p == NULL )
		return FALSE;

	fx = set_fx( p, FX_KIND_POW_UP_HP, turn );
	if( fx == NULL )
		return FALSE;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_POW_UP_HP, p->name );

	return TRUE;
}

/**/

void	pow_up_hp( fx_t *fx, long add_lev )
{
	long	*hp;
	long	add_hp;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	hp = &(fx->chr->abl.lev[ABL_KIND_HP].n);

	add_hp = calc_lev_to_val( *hp, ABL_KIND_HP );
	*hp += add_lev;
	add_hp = calc_lev_to_val( *hp, ABL_KIND_HP ) - add_hp;

	fx->chr->abl.hp.max += add_hp;
	fx->chr->abl.hp.n += add_hp;
}

/**/

bool_t	fx_speed_up( chr_t *p1, chr_t *p2, long sgn_n, long turn )
{
	abl_kind_t	max_abl2;
	fx_t	*fx, *fx_head;
	rate_t	*rate_p, org_rate, rate;
	char	*msg;

	if( p1->kind != p2->kind ){
		max_abl2 = get_max_abl( p2 );
		if( !roll( p1, ABL_KIND_ENC, ABL_KIND_INT,
				p2, max_abl2, max_abl2 ) ){
			return FALSE;
		}
	}

	fx_head = &(p2->fx);
	rate_p = &(p2->move_rate);
	if( p2->kind == CHR_KIND_MNSTR ){
		if( p2->mnstr_tab == NULL )
			return FALSE;
		org_rate = p2->mnstr_tab->move_rate;
	} else {
		org_rate = _100_PERCENT;
	}

	fx = srch_fx( fx_head, FX_KIND_SPEED );
	if( fx == NULL ){
		fx = asgn_fx( fx_head->next );
		/* եȤäѤ */
		if( fx == NULL )
			return FALSE;

		fx->kind = FX_KIND_SPEED;
		fx->turn = 0;
		fx->n = 0;
		fx->chr = p2;
	}
	if( turn == FX_TURN_INFINITE_N )
		fx->turn = FX_TURN_INFINITE_N;
	else
		fx->turn = roll_dice( turn );

	if( sgn_n >= +1 ){
		if( fx->n >= MOVE_MAX_N )
			return FALSE;
		fx->n++;
		msg = MSG_FX_SPEED_UP;
	} else if( sgn_n <= -1 ){
		if( fx->n <= MOVE_MIN_N )
			return FALSE;
		fx->n--;
		msg = MSG_FX_SPEED_DOWN;
	} else {
		return FALSE;
	}

	if( fx->n > 0 )
		rate = _100_PERCENT * (fx->n + 1);
	else if( fx->n < 0 )
		rate = _100_PERCENT / (abs( fx->n ) + 1);
	else
		rate = _100_PERCENT;

	*rate_p = org_rate * rate / _100_PERCENT;

	print_msg( FLG_NULL, msg, p2->name );

	return TRUE;
}

/**/

bool_t	fx_resi( chr_t *p, fx_kind_t fx_k, long turn )
{
	fx_t	*fx;

	if( p == NULL )
		return FALSE;

	fx = set_fx( p, fx_k, turn );
	if( fx == NULL )
		return FALSE;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_RESI_KNOC:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_PHYS, p->name );
		break;
	case FX_KIND_RESI_SLAS:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_PHYS, p->name );
		break;
	case FX_KIND_RESI_STIN:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_PHYS, p->name );
		break;
	case FX_KIND_RESI_HEAT:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_HEAT, p->name );
		break;
	case FX_KIND_RESI_COLD:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_COLD, p->name );
		break;
	case FX_KIND_RESI_WIND:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_WIND, p->name );
		break;
	case FX_KIND_RESI_ACID:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_ACID, p->name );
		break;
	case FX_KIND_RESI_ELEC:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_ELEC, p->name );
		break;
	case FX_KIND_RESI_POIS:
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_RESI_POIS, p->name );
		break;
	}

	return TRUE;
}

/**/

bool_t	pow_up_resi( chr_t *p, resi_kind_t resi )
{
	return pow_up_down_resi( p, resi, +POW_UP_RESI_RATE );
}

/**/

bool_t	pow_down_resi( chr_t *p, resi_kind_t resi )
{
	return pow_up_down_resi( p, resi, -POW_UP_RESI_RATE );
}

/**/

bool_t	pow_up_down_resi( chr_t *p, resi_kind_t resi, rate_t rate )
{
	if( p == NULL )
		return FALSE;

	p->resi[resi].n += rate;

	return TRUE;
}

/**/

bool_t	fx_cure_hp_light( chr_t *p )
{
	if( p == NULL )
		return FALSE;

	if( !fx_cure_hp( p, CURE_HP_LIGHT_N ) )
		return FALSE;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_CURE_HP_LIGHT, p->name );

	return TRUE;
}

/**/

bool_t	fx_cure_hp_moderate( chr_t *p )
{
	if( p == NULL )
		return FALSE;

	if( !fx_cure_hp( p, CURE_HP_MODERATE_N ) )
		return FALSE;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_CURE_HP_MODERATE, p->name );

	return TRUE;
}

/**/

bool_t	fx_cure_hp_serious( chr_t *p )
{
	if( p == NULL )
		return FALSE;

	if( !fx_cure_hp( p, CURE_HP_SERIOUS_N ) )
		return FALSE;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_CURE_HP_SERIOUS, p->name );

	return TRUE;
}

/**/

bool_t	fx_cure_hp_max( chr_t *p )
{
	long	n;

	if( p == NULL )
		return FALSE;

	n = p->abl.hp.max - p->abl.hp.n;
	if( n <= 0 )
		return FALSE;

	if( !fx_cure_hp( p, n ) )
		return FALSE;

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_FX_CURE_HP_MAX, p->name );

	return TRUE;
}

/**/

bool_t	fx_cure_hp( chr_t *p, long cure_n )
{
	if( p == NULL )
		return FALSE;
	if( cure_n == 0 )
		return FALSE;
	if( chk_flg_or( p->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	add_hp( (mbr_t *)p, cure_n );

	return TRUE;
}

/**/

bool_t	resurrection( mbr_t *mbr )
{
	party_t	*pty = get_party();

	if( mbr == NULL )
		return FALSE;

	if( !chk_flg( mbr->stat, FLG_STAT_DEAD ) )
		return FALSE;

	mbr->stat &= ~(FLG_STAT_DEAD);
	mbr->abl.hp.n = mbr->abl.hp.max;

	if( mbr->mbr_n != MBR_N_NOT_JOIN ){
		mbr->x = pty->square.x + pty->square.chr_pos[mbr->mbr_n].x;
		mbr->y = pty->square.y + pty->square.chr_pos[mbr->mbr_n].y;
	}

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	fx_heal( chr_t *p )
{
	bool_t	flg;

	flg = FALSE;

	if( fx_cure_hp_max( p ) )
		flg = TRUE;
	if( fx_cure_all_status( p ) )
		flg = TRUE;

	return flg;
}

/**/

bool_t	fx_cure_all_status( chr_t *p )
{
	bool_t	flg;

	flg = FALSE;

	if( fx_cure_status( p, FX_KIND_STONE ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_PARALYZE ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_POISON ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_CONFUSION ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_BLIND ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_SLEEP ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_SILENCE ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_FEAR ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_HALLUCINATION ) )
		flg = TRUE;
	if( fx_cure_status( p, FX_KIND_CHARM ) )
		flg = TRUE;

	if( flg )
		draw_mbr_stat( p );

	return flg;
}

/**/

bool_t	fx_cure_status( chr_t *p, fx_kind_t fx_kind )
{
	fx_t	*fx, *fx_head;

	if( p == NULL )
		return FALSE;

	fx_head = &(p->fx);

	fx = srch_fx( fx_head, fx_kind );
	if( fx == NULL )
		return FALSE;

	clr_fx( fx );
	return TRUE;
}

/**/

bool_t	fx_remove_curse( chr_t *p1, chr_t *p2 )
{
	rate_t	difficulty;

	if( p2 == NULL )
		return FALSE;

	difficulty = FX_REMOVE_CURSE_DIFFICULTY;

	return remove_curse( p1, p2, difficulty );
}

/**/

bool_t	remove_curse( chr_t *p1, mbr_t *mbr, rate_t difficulty )
{
	abl_kind_t	abl_main, abl_sub;
	item_t	*head, *p;
	bool_t	flg;
	long	i;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return TRUE;

	flg = FALSE;

	abl_main = ABL_KIND_PRI;
	abl_sub = ABL_KIND_WIS;

	head = get_mbr_item_asgn( mbr );
	for( p = head->next; p != head; p = p->next ){
		if( chk_flg( p->flg, FLG_ITEM_CURSE ) ){
			if( (p1 != NULL) && (p1->kind == CHR_KIND_MBR) ){
				if( !chr_roll( p1, abl_main, abl_sub,
						difficulty ) ){
					continue;
				}
			}

			flg = TRUE;
			p->flg &= ~(FLG_ITEM_CURSE);
			set_item_name( p );
		}
	}

	p = get_mbr_item_asgn_equip( mbr );
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		if( chk_flg( p[i].flg, FLG_ITEM_CURSE ) ){
			if( (p1 != NULL) && (p1->kind == CHR_KIND_MBR) ){
				if( !chr_roll( p1, abl_main, abl_sub,
						difficulty ) ){
					continue;
				}
			}

			flg = TRUE;
			p[i].flg &= ~(FLG_ITEM_CURSE);
			set_item_name( &(p[i]) );
		}
	}

	if( flg ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_REMOVE_CURSE_SUCCESS, mbr->name );
	} else {
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_REMOVE_CURSE_FAILURE, mbr->name );
	}

	return flg;
}

/**/

bool_t	fx_pow_up_wpn_hit( mbr_t *mbr )
{
	item_t	*eq;
	bool_t	ret;

	if( mbr == NULL )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_FAILURE,
				mbr->name );
		return FALSE;
	}

	ret = FALSE;
	if( pow_up_wpn_hit( &(eq[EQUIP_KIND_WIELDING]) ) )
		ret = TRUE;
	else if( pow_up_wpn_hit( &(eq[EQUIP_KIND_BOW]) ) )
		ret = TRUE;
	else if( pow_up_wpn_hit( &(eq[EQUIP_KIND_ARW]) ) )
		ret = TRUE;

	if( ret ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_SUCCESS,
				mbr->name );
	} else {
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_FAILURE,
				mbr->name );
	}

	return ret;
}

/**/

bool_t	fx_pow_up_wpn_wpn_crtcl( mbr_t *mbr )
{
	item_t	*eq;
	bool_t	ret;

	if( mbr == NULL )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg( FLG_NULL, MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
				mbr->name );
		return FALSE;
	}

	ret = FALSE;
	if( pow_up_wpn_wpn_crtcl( &(eq[EQUIP_KIND_WIELDING]) ) )
		ret = TRUE;
	if( pow_up_wpn_wpn_crtcl( &(eq[EQUIP_KIND_BOW]) ) )
		ret = TRUE;
	if( pow_up_wpn_wpn_crtcl( &(eq[EQUIP_KIND_ARW]) ) )
		ret = TRUE;

	if( ret ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_CRTCL_SUCCESS,
				mbr->name );
	} else {
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
				mbr->name );
	}

	return ret;
}

/**/

bool_t	fx_pow_up_wpn_dam( mbr_t *mbr )
{
	item_t	*eq;
	bool_t	ret;

	if( mbr == NULL )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg( FLG_NULL, MSG_FX_POW_UP_WPN_DAM_FAILURE,
				mbr->name );
		return FALSE;
	}

	ret = FALSE;
	if( pow_up_wpn_dam( &(eq[EQUIP_KIND_WIELDING]) ) )
		ret = TRUE;
	if( pow_up_wpn_dam( &(eq[EQUIP_KIND_BOW]) ) )
		ret = TRUE;
	if( pow_up_wpn_dam( &(eq[EQUIP_KIND_ARW]) ) )
		ret = TRUE;

	if( ret ){
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_DAM_SUCCESS,
				mbr->name );
	} else {
		print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
				MSG_FX_POW_UP_WPN_DAM_FAILURE,
				mbr->name );
	}

	return ret;
}

/**/

bool_t	pow_up_wpn_hit( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_hit;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_hit++;
	set_item_name( wpn );

	return TRUE;
}

/**/

bool_t	pow_up_wpn_wpn_crtcl( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_crtcl;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_crtcl++;
	set_item_name( wpn );

	return TRUE;
}

/**/

bool_t	pow_up_wpn_dam( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_dam;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_dam++;
	set_item_name( wpn );

	return TRUE;
}

/**/

void	eat_food( mbr_t *mbr, item_t *item )
{
	long	n, i;

	if( mbr == NULL )
		return;
	if( item == NULL )
		return;

	n = 0;
	for( i = 0; i < 1024; i++ ){
		if( eat_food_n_msg_ls[i] == N_MSG_NULL )
			break;
		if( randm( i + 1 ) == 0 )
			n = i;
	}
	print_msg( FLG_NULL, MSG( eat_food_n_msg_ls[n] ),
			item->tab.food->name );

	take_meal_mbr( mbr, item->tab.food->fill_rate );

	inc_item( item, -1 );
}

/**/

bool_t	smoke_tobacco( mbr_t *mbr, item_t *item )
{
	item_t	*eq;
	bool_t	flg_use_pipe;

	if( mbr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_TOBACCO )
		return TRUE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;
	eq = &(eq[EQUIP_KIND_HEAD]);

	flg_use_pipe = FALSE;
	if( chk_flg( item->tab.tobacco->flg, FLG_TOBACCO_USE_PIPE ) ){
		if( eq->kind != ITEM_KIND_PIPE ){
			print_msg( FLG_NULL, MSG_SMOKE_FAILURE );
			return FALSE;
		} else if( eq->tab.pipe->tobacco_kind
				!= item->tab.tobacco->kind ){
			print_msg( FLG_NULL, MSG_SMOKE_FAILURE );
			return FALSE;
		}
		flg_use_pipe = TRUE;
	}
	if( chk_flg( item->tab.tobacco->flg, FLG_TOBACCO_CAN_USE_PIPE )
			&& (eq->kind == ITEM_KIND_PIPE)
			&& (eq->dat.pipe.consume_turn > 0)
			&& (eq->tab.pipe->tobacco_kind
			== item->tab.tobacco->kind) ){
		flg_use_pipe = TRUE;
	}

	if( flg_use_pipe ){
		eq->dat.pipe.turn = item->dat.tobacco.turn;
		inc_item( item, -1 );
	}

	print_msg_n( CURS_ATTR_N_FX_MBR_MINUS, FLG_NULL,
			MSG_S, MSG_FX_SMOKE_TOBACCO );

	return !flg_use_pipe;	/* ѥפȤʤʤ */
}

/**/

void	inc_turn_smoke( mbr_t *mbr )
{
	item_t	*eq;
	nicotine_t	*nico;

	if( mbr == NULL )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return;
	eq = &(eq[EQUIP_KIND_HEAD]);

	if( eq->kind == ITEM_KIND_PIPE ){
		if( eq->dat.pipe.consume_turn <= 0 )
			return;
		if( eq->dat.pipe.turn <= 0 )
			return;

		eq->dat.pipe.turn--;
		eq->dat.pipe.consume_turn--;
		set_item_name( eq );
		if( eq->dat.pipe.turn <= 0 ){
			print_msg( FLG_NULL, MSG_FX_SMOKE_END,
					mbr->name );
		}
		if( eq->dat.pipe.consume_turn <= 0 ){
			print_msg( FLG_NULL, MSG_FX_BREAK_PIPE,
					mbr->name, eq->name );
		}
	} else if( eq->kind == ITEM_KIND_TOBACCO ){
		if( eq->dat.tobacco.turn <= 0 )
			return;

		eq->dat.tobacco.turn--;
		set_item_name( eq );
		if( eq->dat.tobacco.turn <= 0 ){
			print_msg( FLG_NULL, MSG_FX_SMOKE_END, mbr->name );
		}
	} else {
		return;
	}

	nico = &(mbr->fx_data.nicotine);

	nico->rate += ADD_NICOTINE_RATE_PER_TURN;
	if( nico->rate > _100_PERCENT )
		nico->rate = _100_PERCENT;

	if( per_randm( TOBACCO_POISONING_AVE_TURN ) ){
		nico->poisoning_rate += TOBACCO_POISONING_ADD_RATE;
		if( nico->poisoning_rate > _100_PERCENT )
			nico->poisoning_rate = _100_PERCENT;
	}
}

/**/

void	contribution( mbr_t *mbr, long gold )
{
}

/**/

void	set_stomach( chr_t *p )
{
	stomach_t	*st;

	if( p == NULL )
		return;

	st = &(p->fx_data.stomach);

	if( chk_flg( p->stat, FLG_STAT_HUNGRY ) ){
		if( st->rate >= st->hungry_rate ){
			p->stat &= ~FLG_STAT_HUNGRY;
			draw_mbr_stat( p );
		}
	} else {
		if( st->rate < st->hungry_rate ){
			if( per_randm( HUNGRY_FEEL_RATE ) ){
				p->stat |= FLG_STAT_HUNGRY;
				draw_mbr_stat( p );
			}
		}
	}

	if( chk_flg( p->stat, FLG_STAT_STARVATION ) ){
		if( st->rate >= st->starvation_rate ){
			p->stat &= ~FLG_STAT_STARVATION;
			draw_mbr_stat( p );
		}
	} else {
		if( st->rate < st->starvation_rate ){
			if( per_randm( STARVATION_FEEL_RATE ) ){
				p->stat |= FLG_STAT_STARVATION;
				draw_mbr_stat( p );
			}
		}
	}

	if( st->rate <= 0.0 ){
		st->rate = 0.0;
		if( per_randm( FAINT_FEEL_RATE ) ){
			faint( p );
		}
	} else {
		fx_t	*fx;

		fx = srch_fx( &(p->fx), FX_KIND_FAINT );
		if( fx != NULL ){
			clr_fx( fx );
			draw_mbr_stat( p );
		}
	}
}

/**/

void	digest( chr_t *p )
{
	if( p == NULL )
		return;

	if( !per_randm( TURN_A_DAY / p->fx_data.stomach.digest_p_day ) )
		return;

	p->fx_data.stomach.rate--;
	set_stomach( p );
}

/**/

void	take_meal_mbr( mbr_t *mbr, short rate )
{
	rate *= _100_PERCENT;
	rate /= mbr->fx_data.stomach.full_rate;

	mbr->fx_data.stomach.rate += rate;
	if( mbr->fx_data.stomach.rate >= _100_PERCENT ){
		mbr->fx_data.stomach.rate = _100_PERCENT;
		print_msg( FLG_NULL, MSG_STOMACH_FULL, mbr->name );
	}

	set_stomach( mbr );
}

/**/

void	take_meal_fill_mbr( mbr_t *mbr )
{
	mbr->fx_data.stomach.rate = _100_PERCENT;
	set_stomach( mbr );
}

/**/

bool_t	faint( mbr_t *mbr )
{
	set_fx( mbr, FX_KIND_FAINT, FX_AVE_TURN_FAINT );

	return TRUE;
}

/**/

void	abstain( chr_t *p )
{
	nicotine_t	*nico;

	if( p == NULL )
		return;

	nico = &(p->fx_data.nicotine);

	if( per_randm( TOBACCO_ABSTAIN_AVE_TURN ) )
		nico->rate -= TOBACCO_ABSTAIN_SUB_RATE;
	if( nico->rate < 0 )
		nico->rate = 0;

	if( chk_flg( p->stat, FLG_STAT_SLEEP ) )
		return;

	if( per_randm( TOBACCO_FEEL_AVE_TURN ) ){
		rate_t	rate;

		rate = _100_PERCENT - nico->rate;
		rate = rate * rate / _100_PERCENT;
		rate = rate * TOBACCO_FEEL_MAX_RATE / _100_PERCENT;
		rate = rate * nico->poisoning_rate / _100_PERCENT;
		if( rate_randm( rate ) ){
			if( p->kind == CHR_KIND_MBR ){
				print_msg( FLG_MSG_MORE,
						MSG_FX_TOBACCO_ABSTAIN,
						p->name );
			}
		}
	}

	if( nico->rate <= 0 ){
		if( per_randm( TOBACCO_CURE_POISONING_AVE_TURN ) ){
			rate_t	rate;

			rate = TOBACCO_CURE_POISONING_SUB_RATE;
			nico->poisoning_rate -= rate;
		}
	}
}

/**/

void	fraternize( chr_t *p )
{
	if( p == NULL )
		return;

	p->fx_data.friend_turn--;
	if( p->fx_data.friend_turn < 0 )
		p->fx_data.friend_turn = 0;
}

/**/

bool_t	dec_infra_vision( chr_t *p )
{
	if( p == NULL )
		return FALSE;

	clr_map_chr( p );

	p->fx_data.infra_vision--;
	if( p->fx_data.infra_vision < 0 )
		p->fx_data.infra_vision = 0;

	set_map_chr( p );

	return( p->fx_data.infra_vision > 0 );
}

/**/

void	catch_mbr( mnstr_t *mnstr, mbr_t *mbr )
{
	if( mnstr == NULL )
		return;
	if( mbr == NULL )
		return;

	mnstr->work.catch_chr = mbr;

	inc_mbr_caught( mbr, +1 );
}

/**/

void	release_mbr( mnstr_t *mnstr )
{
	if( mnstr == NULL )
		return;

	if( mnstr->work.catch_chr == NULL )
		return;

	inc_mbr_caught( mnstr->work.catch_chr, -1 );
}

/**/

void	release_all_mbr( void )
{
	mnstr_t	*mns, *mns_u;
	party_t	*pty;
	long	i;

	mns_u = get_mnstr_used();
	for( mns = mns_u->next; mns != mns_u; mns = mns->next )
		mns->work.catch_chr = NULL;

	pty = get_party();
	for( i = 0; i < MBR_MAX_N; i++ )
		inc_mbr_caught( pty->mbr[i], 0 );
}

/**/

abl_kind_t	get_max_abl( chr_t *p )
{
	abl_kind_t	n, max_n;

	max_n = 0;
	for( n = 0; n < ABL_KIND_MAX_N; n++ )
		if( p->abl.lev[n].n > p->abl.lev[max_n].n )
			max_n = n;

	return max_n;
}

/**/

bool_t	roll(
	chr_t *p1, abl_kind_t abl_m1, abl_kind_t abl_s1,
	chr_t *p2, abl_kind_t abl_m2, abl_kind_t abl_s2
)
{
	rate_t	rate_eq_main1, rate_eq_sub_1, rate_eq1;
	rate_t	rate_eq_main2, rate_eq_sub_2, rate_eq2;
	rate_t	rate1, rate2;
	long	dice1, dice2;

	if( p1->kind == CHR_KIND_MBR ){
		rate_eq_main1 = calc_rate_abl_equip( (mbr_t *)p1, abl_m1 );
		rate_eq_sub_1 = calc_rate_abl_equip( (mbr_t *)p1, abl_s1 );
		rate_eq1 = (rate_eq_main1 + rate_eq_sub_1) / 2;
		if( rate_eq_main1 < _100_PERCENT ){
			print_msg_n( CURS_ATTR_N_FX_MBR_MINUS, FLG_NULL,
					MSG_DONT_EXHIBIT_ABL_EQUIP,
					((mbr_t *)p1)->name,
					get_abl_name( abl_m1 ) );
		}
		if( rate_eq_sub_1 < _100_PERCENT ){
			print_msg_n( CURS_ATTR_N_FX_MBR_MINUS, FLG_NULL,
					MSG_DONT_EXHIBIT_ABL_EQUIP,
					((mbr_t *)p1)->name,
					get_abl_name( abl_s1 ) );
		}

		rate1 = ((mbr_t *)p1)->abl.lev[abl_m1].n;
		rate1 += ((mbr_t *)p1)->abl.lev[abl_s1].n;
	} else {
		rate_eq1 = _100_PERCENT;

		rate1 = ((mnstr_t *)p1)->abl.lev[abl_m1].n;
		rate1 += ((mnstr_t *)p1)->abl.lev[abl_s1].n;
	}
	if( p2->kind == CHR_KIND_MBR ){
		rate_eq_main2 = calc_rate_abl_equip( (mbr_t *)p2, abl_m2 );
		rate_eq_sub_2 = calc_rate_abl_equip( (mbr_t *)p2, abl_s2 );
		rate_eq2 = (rate_eq_main2 + rate_eq_sub_2) / 2;
		if( rate_eq_main2 < _100_PERCENT ){
			print_msg_n( CURS_ATTR_N_FX_MBR_MINUS, FLG_NULL,
					MSG_DONT_EXHIBIT_ABL_EQUIP,
					((mbr_t *)p2)->name,
					get_abl_name( abl_m2 ) );
		}
		if( rate_eq_sub_2 < _100_PERCENT ){
			print_msg_n( CURS_ATTR_N_FX_MBR_MINUS, FLG_NULL,
					MSG_DONT_EXHIBIT_ABL_EQUIP,
					((mbr_t *)p2)->name,
					get_abl_name( abl_s2 ) );
		}

		rate2 = ((mbr_t *)p2)->abl.lev[abl_m2].n;
		rate2 += ((mbr_t *)p2)->abl.lev[abl_s2].n;
	} else {
		rate_eq2 = _100_PERCENT;

		rate2 = ((mnstr_t *)p1)->abl.lev[abl_m2].n;
		rate2 += ((mnstr_t *)p1)->abl.lev[abl_s2].n;
	}

	rate1 = rate1 * rate_eq1 / _100_PERCENT;
	if( rate1 < 1 )
		rate1 = 1;

	rate2 = rate2 * rate_eq2 / _100_PERCENT;
	if( rate2 < 1 )
		rate2 = 1;

	rate1 += ROLL_BASE * 2;
	rate2 += ROLL_BASE * 2;

	dice1 = roll_dice( rate1 );
	dice2 = roll_dice( rate2 );

	return( dice1 >= dice2 );
}

/**/

void	inc_mbr_caught( mbr_t *mbr, long n )
{
	if( mbr == NULL )
		return;

	if( n == 0 )
		mbr->work.caught = 0;
	else
		mbr->work.caught += n;

	if( mbr->work.caught > 0 )
		mbr->stat |= FLG_STAT_CAUGHT;
	else
		mbr->stat &= ~FLG_STAT_CAUGHT;
}

/**/

fx_t	*asgn_fx( fx_t *p )
{
	fx_t	*fx;

	fx = fx_free.next;
	if( fx == &fx_free )
		return NULL;

	fx->kind = FX_KIND_NULL;

	ins_ls_fx( p->next, fx );

	return fx;
}

/**/

void	free_fx( fx_t *p )
{
	if( p != NULL )
		ins_ls_fx( &fx_free, p );
}

/**/

void	free_fx_all( fx_t *p )
{
	fx_t	*fx;

	if( p == NULL )
		return;

	for( fx = p->next->next; fx->prev != p; fx = fx->next )
		ins_ls_fx( &fx_free, fx->prev );
}

/**/

void	ins_ls_fx( fx_t *ls, fx_t *p )
{
	p->next->prev = p->prev;
	p->prev->next = p->next;

	p->prev = ls->prev;
	p->next = ls;

	ls->prev->next = p;
	ls->prev = p;
}

/**/

fx_t	*srch_fx( fx_t *ls, fx_kind_t kind )
{
	fx_t	*p;

	for( p = ls->next; p != ls; p = p->next ){
		if( p->kind == kind )
			return p;
	}

	return NULL;
}

/**/

blast_t	*get_blast( void )
{
	return &blast;
}

/**/
