/*****************************************************************
* $BK\%W%m%0%i%`$O%U%j!<!&%=%U%H%&%'%"$G$9!#(B
* $B$"$J$?$O!"(B Free Software Foundation $B$,8xI=$7$?(B
*  GNU $B0lHL8xM-;HMQ5vBz$N!V%P!<%8%g%s#2!W(B
* $B0?$O$=$l0J9_$N3F%P!<%8%g%s$NCf$+$i$$$:$l$+$rA*Br$7!"(B
* $B$=$N%P!<%8%g%s$,Dj$a$k>r9`$K=>$C$FK\%W%m%0%i%`$r(B
* $B:FHRI[$^$?$OJQ99$9$k$3$H$,$G$-$^$9!#(B
* 
* $BK\%W%m%0%i%`$OM-MQ$H$O;W$$$^$9$,!"HRI[$K$"$?$C$F$O!"(B
* $B;T>l@-5Z$SFCDjL\E*E,9g@-$K$D$$$F$N0EL[$NJ]>Z$r4^$a$F(B,
* $B$$$+$J$kJ]>Z$b9T$J$$$^$;$s!#(B
* $B>\:Y$K$D$$$F$O(B GNU $B0lHL8xM-;HMQ5vBz=q$r$*FI$_$/$@$5$$!#(B
* 
* $B$"$J$?$O!"K\%W%m%0%i%`$H0l=o$K(B GNU $B0lHL8xM-;HMQ5vBz=q(B
* $B$N<L$7$r<u$1<h$C$F$$$k$O$:$G$9!#$=$&$G$J$$>l9g$O!"(B
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* $B$X<j;f$r=q$$$F$/$@$5$$!#(B
*****************************************************************/

/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
/*#include	<sys/stat.h>*/

#ifndef	D_X68K
# include	<getopt.h>
#endif

#ifdef	D_UNIX
# ifdef	D_USE_TERMIOS
#  include	<termios.h>
# else
#  include	<termio.h>
# endif
#endif

#include	"gmain.h"
#include	"menu.h"
#include	"town.h"
#include	"spell.h"
#include	"draw.h"
#include	"curs.h"
#include	"chr.h"
#include	"party.h"
#include	"item.h"
#include	"mnstr.h"
#include	"fight.h"
#include	"fx.h"
#include	"trap.h"
#include	"msg.h"
#include	"ver.h"
#include	"gmain_prot.h"
#include	"dun_prot.h"
#include	"menu_prot.h"
#include	"town_prot.h"
#include	"tmenu_prot.h"
#include	"amenu_prot.h"
#include	"spell_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"item_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"gfile_prot.h"
#include	"msg_prot.h"

/**/

#define	KEY_WAIT_VMIN	0
#define	KEY_WAIT_VTIME	1

#define	OPT_ARG_MAX_LEN	128
#define	STR_OPT	"c:p:vh"

#ifndef	D_X68K
static struct option	long_opt[] = {
	{ "clear-key-buf", required_argument, NULL, 'c' },
	{ "use-keypad",    required_argument, NULL, 'p' },
	{ "version",       no_argument,       NULL, 'v' },
	{ "help",          no_argument,       NULL, 'h' },
	{ 0, 0, 0, 0 }
};
#endif

#define	STR_USAGE	\
	"Usage: %s [OPTION]...\n" \
	"OPTION:\n" \
	"  -c, --clear-key-buf=FLAG clear key buffer:\n" \
	"                             ON, OFF\n" \
	"  -p, --use-keypad=FLAG    use cursor key (call keypad):\n" \
	"                             ON, OFF\n" \
	"  -v, --version            display version and exit\n" \
	"  -h, --help               display this help and exit\n"

#define	STR_ENV_SHELL	"SHELL"

#ifdef	D_UNIX
# define	STR_DFLT_SHELL	"sh"
#else
# define	STR_DFLT_SHELL	"command"
#endif

/**/

long	flg_term;
long	rand_seed = 1;
long	g_day, g_turn;

/**/

int	main( int argc, char **argv )
{
	dun_t	*dun;

	chk_arg( argc, argv );

	init_scrn();

	srandm( time( NULL ) );
	set_game_day( 999, 4, 1 );
	set_turn( randm( TURN_A_DAY ) );

	init_msg();
	init_draw();

	ena_scrn( TRUE );
	ena_curs_draw();
	wipe_all();

	init_game_file();

	init_dun();
	init_item();
	init_trap();
	init_fx();
	init_chr();
	init_spell();
	init_town();
	init_menu();
	init_tmenu();
	init_auto_menu();

	dun = get_dun();
	dun->lev = 0;
	up_dun( 0 );

	while( 1 ){
		chk_key( TRUE );
	}

	return EXIT_FAILURE;
}

/**/

void	chk_arg( int argc, char **argv )
{
	long	c;

	g_flg_clr_key_buf = TRUE;
	g_flg_use_keypad = FALSE;

	while( 1 ){
#ifndef	D_X68K
		int	opt_idx;

		c = getopt_long( argc, argv, STR_OPT, long_opt, &opt_idx );
#else
		c = getopt( argc, argv, STR_OPT );
#endif
		if( c <= -1 )
			break;
		switch( c ){
		case 'c':
			g_flg_clr_key_buf = chk_opt_flg( optarg );
			break;
		case 'p':
			g_flg_use_keypad = chk_opt_flg( optarg );
			break;
		case 'v':
			version( stdout );
			exit( EXIT_SUCCESS );
			break;
		case 'h':
			usage( stdout );
			exit( EXIT_SUCCESS );
			break;
		case '\0':
			break;
		case '?':
		case ':':
		default:
			usage( stderr );
			exit( EXIT_FAILURE );
			break;
		}
	}

	if( (argc - optind) > 0 ){
		usage( stderr );
		exit( EXIT_FAILURE );
	}
}

/**/

bool_t	chk_opt_flg( const char *optarg )
{
	static char	str[OPT_ARG_MAX_LEN + 1];
	long	i;

	if( optarg == NULL )
		return FALSE;

	for( i = 0; i < OPT_ARG_MAX_LEN; i++ ){
		if( optarg[i] == '\0' )
			break;
		str[i] = toupper( optarg[i] );
	}
	str[i] = '\0';

	if( strcmp( str, "ON" ) == 0 )
		return TRUE;
	if( strcmp( str, "TRUE" ) == 0 )
		return TRUE;
	if( strcmp( str, "T" ) == 0 )
		return TRUE;
	if( strcmp( str, "YES" ) == 0 )
		return TRUE;
	if( strcmp( str, "1" ) == 0 )
		return TRUE;

	if( strcmp( str, "OFF" ) == 0 )
		return FALSE;
	if( strcmp( str, "FALSE" ) == 0 )
		return FALSE;
	if( strcmp( str, "NIL" ) == 0 )
		return FALSE;
	if( strcmp( str, "NO" ) == 0 )
		return FALSE;
	if( strcmp( str, "0" ) == 0 )
		return FALSE;

	return FALSE;
}

/**/

void	usage( FILE *fp )
{
	fprintf( fp, STR_USAGE, STR_FILE_NAME_GAME );
	fflush( fp );
}

/**/

void	version( FILE *fp )
{
	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );
}

/**/

void	init_term( void )
{
	flg_term = 0;
}

/**/

bool_t	chk_term( void )
{
	return( flg_term > 0 );
}

/**/

#ifdef	D_UNIX
# ifdef	D_USE_TERMIOS
struct termios	pre_tbuf;
# else
struct termio	pre_tbuf;
# endif
#endif

void	ena_term( void )
{
	flg_term++;

	if( flg_term == 1 ){
#ifdef	D_UNIX

		/* $B9=B$BN$N@k8@(B */
# ifdef	D_USE_TERMIOS
		struct termios	tbuf;
# else
		struct termio	tbuf;
# endif

		/* $B>pJs$N%2%C%H(B */
# ifdef	D_USE_TC_ATTR
		tcgetattr( fileno( stdin ), &tbuf );
# elif	defined( D_USE_IOCTL )
		ioctl( 0, TCGETA, &tbuf );
# endif

		/* $B>pJs$NJT=8(B */
		pre_tbuf = tbuf;
		tbuf.c_iflag &= ~(INLCR | ICRNL | IUCLC | ISTRIP
				| IXON | BRKINT);
		tbuf.c_oflag &= ~(OPOST);
		if( g_flg_clr_key_buf ){
			tbuf.c_lflag &= ~(ICANON);
			tbuf.c_cc[VMIN] = KEY_WAIT_VMIN;
			tbuf.c_cc[VTIME] = KEY_WAIT_VTIME;
		}
		tbuf.c_lflag &= ~(ISIG | ECHO);

		/* ^C $B$rM-8z$K$9$k(B */
# ifndef	NDEBUG
		tbuf.c_iflag |= BRKINT;
		tbuf.c_lflag |= ISIG;
# endif

		/* $B>pJs$N%;%C%H(B */
# ifdef	D_USE_TC_ATTR
		if( tcsetattr( fileno( stdin ), TCSANOW, &tbuf ) != 0 ){
			print_err( MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# elif	defined( D_USE_IOCTL )
		if( ioctl( 0, TCSETAF, &tbuf ) != 0 ){
			print_err( MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# endif

#endif	/* D_UNIX */
	}
}

/**/

void	dis_term( void )
{
	if( flg_term == 1 ){
#ifdef	D_UNIX
# ifdef	D_USE_TC_ATTR
		tcsetattr( fileno( stdin ), TCSANOW, &pre_tbuf );
# elif	defined( D_USE_IOCTL )
		ioctl( 0, TCSETAF, &pre_tbuf );
# endif
#endif
	}

	flg_term--;
}

/**/

void	init_scrn( void )
{
	init_curs();
	init_term();
}

/**/

void	reset_scrn( void )
{
	while( chk_term() )
		dis_term();

	curs_refresh();
	while( chk_curs() ){
		curs_endwin();
	}
}

/**/

void	ena_scrn( bool_t flg_initscr )
{
	if( flg_initscr ){
		curs_initscr();
		curs_keypad( stdscr, TRUE );
	} else {
		curs_clearok( stdscr, TRUE );
		curs_refresh();
	}

	ena_term();
}

/**/

void	dis_scrn( void )
{
	dis_term();

	curs_refresh();
	curs_endwin();
}

/**/

void	exit_game( long code )
{
	FILE	*fp;

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	reset_scrn();

	if( code == 0 )
		fp = stdout;
	else
		fp = stderr;

	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );

	exit( code );
}

/**/

void	child_ps( void )
{
	char	*shell;

	dis_scrn();

	shell = getenv( STR_ENV_SHELL );
	if( shell == NULL )
		shell = STR_DFLT_SHELL;

	fprintf( stdout, MSG_CHILD_PS, shell );
	fflush( stdout );
	system( shell );

	ena_scrn( FALSE );
}

/**/

void	about_game( void )
{
	static char	tmp[1023 + 1];

	dis_scrn();

	fprintf( OUT_FP, MSG_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	fprintf( OUT_FP, MSG_S, MSG_ABOUT_GAME );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	ena_scrn( FALSE );
}

/**/

void	srandm( long n )
{
	rand_seed = n;
}

/**/

long	randm( long n )
{
	long	a;

	rand_seed += 15349;
	rand_seed *= 37;
	rand_seed += 598393;
	a = (rand_seed & 0xffff0000) >> 16;
	rand_seed = ((rand_seed & 0x0000ffff) << 16) + a;
	rand_seed = abs( rand_seed );
	rand_seed += 379;

	if( n > 0 )
		return( rand_seed % n );
	else
		return 0;
}

/**/

bool_t	rate_randm( rate_t rate )
{
	return( randm( _100_PERCENT ) < rate );
}

/**/

bool_t	per_randm( rate_t rate )
{
	return( randm( rate ) == 0 );
}

/**/

long	roll_dice( long n )
{
#if	0
/*@@@*/
	n = randm( n + 1 ) + randm( n + 1 );
#else
	n += randm( n + 1 );
#endif
	if( n <= 0 )
		n = 1;

	return n;
}

/**/

size_t	str_len_draw( const char *s )
{
#ifdef	D_UNIX
	size_t	len;

	for( len = 0; *s; len++, s++ ){
		unsigned char	c;

		c = (unsigned char)*s;
		if( (0x80 <= c) && (c <= 0x9f) )
			len--;
	}

	return len;
#else
	return strlen( s );
#endif
}

/**/

size_t	str_len_std( const char *s )
{
	return strlen( s );
}

/**/

char	*str_max_n_cat( char *dst, char *src, int len )
{
	return strncat( dst, src, len - strlen( dst ) );
}

/**/

bool_t	chk_flg( unsigned long var, unsigned long flg )
{
	return( (var & flg) == flg );
}

/**/

bool_t	chk_flg_or( unsigned long var, unsigned long flg )
{
	return( (var & flg) != 0 );
}

/**/

long	get_game_day( void )
{
	return g_day;
}

/**/

long	set_game_day( long year, long month, long day )
{
	g_day = 0;
	g_day += year * 360;
	g_day += (month - 1) * 30;
	g_day += day - 1;

	return g_day;
}

/**/

long	get_turn( void )
{
	return g_turn;
}

/**/

long	set_turn( long n )
{
	g_turn = n;
	if( g_turn >= TURN_A_DAY ){
		g_day += g_turn / TURN_A_DAY;
		g_turn %= TURN_A_DAY;
	}

	return g_turn;
}

/**/

long	inc_turn( void )
{
	g_turn++;
	if( g_turn >= TURN_A_DAY ){
		g_day += g_turn / TURN_A_DAY;
		g_turn %= TURN_A_DAY;
	}
	chk_morning_glow( g_turn );
	chk_evening_glow( g_turn );

	inc_turn_all_item();
	inc_turn_all_fx();
	inc_turn_all_mnstr();

	return g_turn;
}

/**/

bool_t	chk_morning( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (MORNING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn > ((MORNING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_evening( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (EVENING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn > ((EVENING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_night( void )
{
	long	turn;
	long	morning;
	long	evening;

	turn = get_turn() % TURN_A_DAY;
	morning = MORNING_HOUR * TURN_PER_HOUR;
	evening = EVENING_HOUR * TURN_PER_HOUR;

	if( turn < morning )
		return TRUE;
	if( turn >= evening )
		return TRUE;
	return FALSE;
}

/**/

