/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
#include	<ctype.h>
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
#include	"town.h"
/*#include	"item.h"*/
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
#include	"amenu_prot.h"
#include	"gfile_prot.h"
/*#include	"msg_prot.h"*/

/**/

#define	DRAW_MENU_CLR_N	-1

#define	SCROLL_WIDTH	(WIN_MAP_WIDTH / 2)
#define	SCROLL_HEIGHT	(WIN_MAP_HEIGHT / 2)

#define	LS_CLASS_N_PER_PAGE	16

/**/

typedef char	*menu_call_back_t( menu_t **pp, menu_t **dflt );

pos_t	g_crsr, g_pre_crsr;
next_pos_t	g_next_pos;

ask_t	g_sel_ask;
long	g_sub_sel_mbr_n;
race_t	g_sel_race;
sex_t	g_sel_sex;
long	g_sel_class_n;

trgt_kind_t	g_sel_obj_trgt_kind;
chr_kind_t	g_dist_chr_kind;
dist_t	g_sel_dist;
act_kind_t	g_sel_act_kind;

long	g_ref_mbr_n, g_sel_mbr_n;
item_t	*g_sel_item;
item_t	*g_equip_kind;
equip_kind_t	g_sel_equip_kind;

mbr_t	*g_mark_sel_mbr;
item_t	*g_mark_sel_item;
door_t	*g_mark_sel_door;
trap_t	*g_mark_sel_trap;

bool_t	g_ls_flg_srch[MBR_MAX_N];

curs_attr_t	*g_sel_attr;

typedef struct {
	equip_kind_t	kind;
	n_msg_t	n_msg;
} ls_equip_msg_t;

ls_equip_msg_t	ls_equip_msg[] = {
	{ EQUIP_KIND_WIELDING, N_MSG_MENU_SEL_EQUIP_WIELDING },
	{ EQUIP_KIND_SHIELD, N_MSG_MENU_SEL_EQUIP_SHIELD },
	{ EQUIP_KIND_BOW, N_MSG_MENU_SEL_EQUIP_BOW },
	{ EQUIP_KIND_ARW, N_MSG_MENU_SEL_EQUIP_ARW },
	{ EQUIP_KIND_HEAD, N_MSG_MENU_SEL_EQUIP_HEAD },
	{ EQUIP_KIND_NECK, N_MSG_MENU_SEL_EQUIP_NECK },
	{ EQUIP_KIND_BODY, N_MSG_MENU_SEL_EQUIP_BODY },
	{ EQUIP_KIND_ARM, N_MSG_MENU_SEL_EQUIP_ARM },
	{ EQUIP_KIND_RIGHT_HAND, N_MSG_MENU_SEL_EQUIP_RIGHT_HAND },
	{ EQUIP_KIND_LEFT_HAND, N_MSG_MENU_SEL_EQUIP_LEFT_HAND },
	{ EQUIP_KIND_FEET, N_MSG_MENU_SEL_EQUIP_FEET },
	{ EQUIP_KIND_ABOUT_BODY, N_MSG_MENU_SEL_EQUIP_ABOUT_BODY },
	{ EQUIP_KIND_LIGHT_SOURCE, N_MSG_MENU_SEL_EQUIP_LIGHT_SOURCE },
};

/**/

#include	"menu_tab.h"

/**/

void	init_menu( void )
{
	long	i;

	next_pos_square( +1 );
	g_pre_crsr = g_crsr;

	chk_dup_accel_key();

	for( i = 0; i < MBR_MAX_N; i++ )
		g_ls_flg_srch[i] = TRUE;
}

/**/

char	*exec_menu( menu_t *p, menu_t *dflt, char *str_goto )
{
	bool_t	flg_accel = FALSE;
	bool_t	flg_ret = FALSE;

	if( p == NULL )
		return STR_MENU_ERR;

	if( str_goto != NULL ){
		flg_accel = TRUE;
		if( strcmp( p->path, str_goto ) == 0 )
			str_goto = NULL;
	}

	if( p->call_back != NULL ){
		menu_t	*pre_p = p;
		char	*str_goto_call_back;

		str_goto_call_back = p->call_back( &p, &dflt );

		if( str_goto_call_back != NULL )
			return str_goto_call_back;

		if( pre_p != p ){
			clr_msg();
			return exec_menu( p, dflt, str_goto );
		}
	}

	if( p == NULL )
		return STR_MENU_ERR;

	if( strcmp( p->kind, "<Branch>" ) != 0 )
		return NULL;

	while( 1 ){
		if( str_goto == NULL ){
			dflt = sel_menu( p, dflt );
			if( dflt == NULL )
				return STR_MENU_CANCEL;

			if( strcmp( dflt->kind, "<CheckItem>" ) == 0 ){
				if( !set_menu_check_item( dflt ) )
					return STR_MENU_ERR;
			} else if( strcmp( dflt->kind, "<RadioItem>" ) == 0 ){
				if( !set_menu_radio_item( p, dflt ) )
					return STR_MENU_ERR;
			}
		} else {
			dflt = srch_goto_menu( p, str_goto );
			if( dflt == NULL ){
				if( flg_ret )
					return str_goto;
				else
					return STR_MENU_ERR;
			}
		}

		clr_msg();
		str_goto = exec_menu( dflt, NULL, str_goto );

		if( str_goto == NULL ){
			return NULL;
		} else if( strcmp( str_goto, STR_MENU_ERR ) == 0 ){
			return STR_MENU_ERR;
		} else if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 ){
			if( flg_accel )
				return NULL;
			else
				str_goto = NULL;
		} else {
			flg_ret = TRUE;
		}
	}

	return STR_MENU_ERR;
}

/**/

bool_t	set_menu_check_item( menu_t *p )
{
	if( chk_flg( p->flg, FLG_MENU_CHK_ON ) ){
		p->flg &= ~(FLG_MENU_CHK_ON);
		p->flg |= FLG_MENU_CHK_OFF;
	} else if( chk_flg( p->flg, FLG_MENU_CHK_OFF ) ){
		p->flg |= FLG_MENU_CHK_ON;
		p->flg &= ~(FLG_MENU_CHK_OFF);
	} else {
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	set_menu_radio_item( menu_t *ls, menu_t *p )
{
	long	i;
	const long	max_i = 4096;
	long	sep_begin_n, sep_end_n;

	sep_begin_n = 0;
	sep_end_n = 0;

	/* search begin <Separator> */

	for( i = 0; i < max_i; i++ ){
		if( ls[i].path[0] == '\0' )
			return FALSE;
		if( strcmp( ls[i].kind, "<Separator>" ) == 0 )
			sep_begin_n = i;
		if( &(ls[i]) == p )
			break;
	}
	if( i >= max_i )
		return FALSE;

	/* search end <Separator> */

	for( ; i < max_i; i++ ){
		if( ls[i].path[0] == '\0' )
			break;
		if( strcmp( ls[i].kind, "<Separator>" ) == 0 )
			break;
	}
	if( i >= max_i )
		return FALSE;
	sep_end_n = i;

	/* off other <RadioItem> */

	for( i = sep_begin_n; i <= sep_end_n; i++ ){
		if( strcmp( ls[i].kind, "<RadioItem>" ) == 0 ){
			ls[i].flg &= ~(FLG_MENU_CHK_ON);
			ls[i].flg |= FLG_MENU_CHK_OFF;
		}
	}

	/* on selected <RadioItem> */

	p->flg |= FLG_MENU_CHK_ON;
	p->flg &= ~(FLG_MENU_CHK_OFF);

	return TRUE;
}

/**/

ask_t	exec_menu_ask( char *ttl, ask_t dflt, bool_t can_cancel )
{
	menu_t	*p;
	char	*str_goto;

	g_sel_ask = dflt;

	p = srch_menu( ls_menu_ask, "Title" );
	if( p == NULL )
		return ASK_ERR;

	if( ttl == NULL )
		p->msg[0] = '\0';
	else
		strncpy( p->msg, ttl, MENU_MSG_MAX_LEN );

	while( 1 ){
		str_goto = exec_menu( ls_menu_ask, NULL, NULL );

		if( str_goto != NULL ){
			if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
				g_sel_ask = ASK_CANCEL;
		}

		if( !can_cancel && (g_sel_ask == ASK_CANCEL) )
			continue;

		clr_msg();
		return g_sel_ask;
	}

	return ASK_ERR;
}

/**/

char	*cb_menu_ask_init( menu_t **pp, menu_t **dflt )
{
	char	*sub_path;

	if( g_sel_ask == ASK_YES )
		sub_path = "Yes";
	else
		sub_path = "No";

	*dflt = srch_menu( *pp, sub_path );
	if( *dflt == NULL )
		return STR_MENU_ERR;

	return NULL;
}

/**/

char	*cb_menu_ask_yes( menu_t **pp, menu_t **dflt )
{
	g_sel_ask = ASK_YES;

	return NULL;
}

/**/

char	*cb_menu_ask_no( menu_t **pp, menu_t **dflt )
{
	g_sel_ask = ASK_NO;

	return NULL;
}

/**/

char	*exec_menu_race( race_t *race )
{
	char	*str_goto;

	g_sel_race = *race;

	while( 1 ){
		str_goto = exec_menu( ls_menu_main_race, NULL, NULL );
		if( str_goto != NULL )
			return str_goto;

		str_goto = exec_menu( ls_menu_sub_race, NULL, NULL );
		if( str_goto == NULL )
			break;
		if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
			continue;

		return str_goto;
	}

	*race = g_sel_race;
	return NULL;
}

/**/

char	*cb_menu_main_race( menu_t **pp, menu_t **dflt )
{
	g_sel_race.main = (main_race_t)((*pp)->arg);
	return NULL;
}

/**/

char	*cb_menu_sub_race( menu_t **pp, menu_t **dflt )
{
	g_sel_race.sub = (sub_race_t)((*pp)->arg);
	return NULL;
}

/**/

char	*exec_menu_sex( sex_t *sex )
{
	char	*str_goto;

	g_sel_sex = *sex;

	str_goto = exec_menu( ls_menu_sex, NULL, NULL );
	if( str_goto != NULL )
		return str_goto;

	*sex = g_sel_sex;
	return NULL;
}

/**/

char	*cb_menu_sex( menu_t **pp, menu_t **dflt )
{
	g_sel_sex = (sex_t)((*pp)->arg);
	return NULL;
}

/**/

char	*exec_menu_class( long *class_n )
{
	class_t	*class_tab;
	menu_t	*ls, *dflt;
	long	k;
	char	*str_goto;
	long	i;

	class_tab = get_class_tab();
	ls = ls_menu_class;
	dflt = &(ls[0]);
	k = 0;

	strncpy( ls[k].path, "/Class", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Class/--", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	strncpy( ls[k].msg, MSG_TTL_MENU_CLASS, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < CLASS_MAX_N; i++ ){
		if( class_tab[i].name[0] == '\0' )
			break;

		if( i == *class_n )
			dflt = &(ls[k]);

		sprintf( ls[k].path, "/Class/%ld", i );
		strncpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + (i % LS_CLASS_N_PER_PAGE);
		ls[k].accel_key[0] = '\0';
		strncpy( ls[k].msg, class_tab[i].name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_class;
		ls[k].arg = (void *)i;
		ls[k].flg = FLG_NULL;
		k++;

		if( (i % LS_CLASS_N_PER_PAGE)
				== (LS_CLASS_N_PER_PAGE - 1) ){
			strncpy( ls[k].path, "/Class/--",
					MENU_PATH_MAX_LEN );
			strncpy( ls[k].kind, "<PageSeparator>",
					MENU_KIND_MAX_LEN );
			ls[k].key = '\0';
			ls[k].accel_key[0] = '\0';
			ls[k].n_msg = N_MSG_NULL;
			ls[k].msg[0] = '\0';
			ls[k].call_back = NULL;
			ls[k].arg = NULL;
			ls[k].flg = FLG_NULL;
			k++;
		}
	}
	ls[k].path[0] = '\0';

	g_sel_class_n = *class_n;

	str_goto = exec_menu( ls, dflt, NULL );
	if( str_goto != NULL )
		return str_goto;

	*class_n = g_sel_class_n;
	return NULL;
}

/**/

char	*cb_menu_class( menu_t **pp, menu_t **dflt )
{
	g_sel_class_n = (long)((*pp)->arg);
	return NULL;
}

/**/

char	*exec_menu_sel_obj( trgt_kind_t *trgt_kind, pos_t pos )
{
	char	*str;

	g_sel_obj_trgt_kind = TRGT_KIND_NULL;

	str = exec_menu( ls_menu_sel_obj, NULL, NULL );
	if( str != NULL )
		return str;

	*trgt_kind = g_sel_obj_trgt_kind;

	return NULL;
}

/**/

char	*exec_menu_sel_mbr( mbr_t **mbr, char *ttl, bool_t flg_sel_dead )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	menu_t	*dflt;
	long	i, k;
	char	*ret;

	dflt = NULL;

	ls = ls_menu_mbr;
	k = 0;

	strncpy( ls[k].path, "/Member",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	if( ttl != NULL ){
		strncpy( ls[k].path, "/Member/--",
				MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		strncpy( ls[k].msg, ttl,
				MENU_MSG_MAX_LEN );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;
	}

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;
		if( !flg_sel_dead )
			if( chk_flg( pty->mbr[i]->stat, FLG_STAT_DEAD ) )
				continue;

		if( *mbr == pty->mbr[i] )
			dflt = &(ls[k]);

		sprintf( ls[k].path, "/Member/%ld", i );
		strncpy( ls[k].kind, "<Item>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		strncpy( ls[k].msg,
				pty->mbr[i]->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_sel_mbr;
		ls[k].arg = (void *)i;
		ls[k].flg = FLG_NULL;
		k++;
	}

	ls[k].path[0] = '\0';

	g_sub_sel_mbr_n = -1;
	ret = exec_menu( ls, dflt, NULL );
	if( ret != NULL )
		return ret;

	if( g_sub_sel_mbr_n <= -1 )
		return STR_MENU_ERR;

	*mbr = pty->mbr[g_sub_sel_mbr_n];

	return NULL;
}

/**/

char	*cb_menu_sel_mbr( menu_t **pp, menu_t **dflt )
{
	long	mbr_n;

	g_sub_sel_mbr_n = -1;

	mbr_n = (long)((*pp)->arg);
	if( mbr_n < 0 )
		return STR_MENU_ERR;
	if( mbr_n >= MBR_MAX_N )
		return STR_MENU_ERR;

	g_sub_sel_mbr_n = mbr_n;

	return NULL;
}

/**/

char	*exec_menu_point_crsr( void )
{
	chk_scroll();
	redraw_all();

	print_msg( FLG_MSG_NO_MORE_PREV | FLG_MSG_NO_MORE_NEXT,
			MSG_MENU_POINT_CRSR );

	while( 1 ){
		long	c;

		c = chk_key( FALSE );
		switch( c ){
		case CASE_CANCEL:
			return STR_MENU_CANCEL;
		case CASE_ENTER:
			return NULL;
		}
	}

	return STR_MENU_ERR;
}

/**/

char	*exec_menu_sel_num( long min, long max, long *p )
{
	long	i;
	long	figure;
	long	sel_n;
	char	num[FIGURE_MAX_N];

	figure = 0;
	if( abs( min ) < abs( max ) )
		i = abs( max );
	else
		i = abs( min );
	for( ; i > 0; i /= 10 )
		figure++;

	sprintf( num, "%+0*ld", (int)(figure + 1), *p );

	sel_n = 1 + figure + MENU_NUM_OK;
	while( 1 ){
		long	d;
		bool_t	flg_ret;

		draw_menu_num( figure, sel_n, num );

		d = 0;
		flg_ret = FALSE;

		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			return STR_MENU_CANCEL;
		case CASE_ENTER:
			flg_ret = TRUE;
			d = +1;
			break;
		case CASE_CRSR_UP:
			d = +1;
			break;
		case CASE_CRSR_DOWN:
			d = -1;
			break;
		case CASE_CRSR_LEFT:
			sel_n--;
			if( sel_n < 0 ){
				sel_n = 1 + figure + MENU_NUM_MAX_N - 1;
			}
			break;
		case CASE_CRSR_RIGHT:
			sel_n++;
			if( sel_n > 1 + figure + MENU_NUM_MAX_N - 1 )
				sel_n = 0;
			break;
		default:
			break;
		}
		if( (d != 0) || flg_ret ){
			if( sel_n == 1 + figure
					+ MENU_NUM_OK ){
				if( flg_ret ){
					*p = strtol( num, (char **)NULL, 10 );

					if( *p < min )
						*p = min;
					else if( *p > max )
						*p = max;
					else
						return NULL;

					sprintf( num, "%+0*ld",
							(int)(figure + 1),
							*p );
				}
			} else if( sel_n == 1 + figure
					+ MENU_NUM_MIN ){
				if( flg_ret ){
					*p = min;
					sprintf( num, "%+0*ld",
							(int)(figure + 1),
							*p );
				}
			} else if( sel_n == 1 + figure
					+ MENU_NUM_MAX ){
				if( flg_ret ){
					*p = max;
					sprintf( num, "%+0*ld",
							(int)(figure + 1),
							*p );
				}
			} else if( sel_n == 0 ){
				if( num[0] == '-' )
					num[0] = '+';
				else
					num[0] = '-';
			} else {
				long	n;

				n = num[sel_n] - '0' + d;
				if( n > 9 )
					n = 0;
				if( n < 0 )
					n = 9;
				num[sel_n] = '0' + n;
			}
		}
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_main_init( menu_t **pp, menu_t **dflt )
{
	g_sel_mbr_n = get_mbr_n( g_crsr.x, g_crsr.y );
	g_ref_mbr_n = g_sel_mbr_n;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( g_sel_mbr_n <= -1 ){
		/* СꤷƤʤ */
		set_flg_menu( *pp, "Item", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Equip", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Spell", FLG_MENU_HIDDEN );
	}

	return NULL;
}

/**/

char	*cb_menu_exec( menu_t **pp, menu_t **dflt )
{
	act_party();
	inc_turn();
	act_all_mnstr();

	return NULL;
}

/**/

char	*cb_menu_mark( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	trgt_kind_t	trgt_kind_1, trgt_kind_2;
	pos_t	pos1, pos2;
	bool_t	flg_cont;
	char	*str;
	bool_t	flg_ret;

	trgt_kind_1 = TRGT_KIND_NULL;
	trgt_kind_2 = TRGT_KIND_NULL;

	pos1 = g_crsr;

	flg_cont = TRUE;
	while( flg_cont ){
		str = exec_menu_sel_obj( &trgt_kind_1, pos1 );
		if( str != NULL )
			return str;

		if( trgt_kind_1 == TRGT_KIND_NULL ){
			if( menu_mark_square( g_crsr ) )
				return NULL;
			else
				return STR_MENU_ERR;
		}
		if( trgt_kind_1 == TRGT_KIND_AUTO )
			return NULL;
		if( trgt_kind_1 == TRGT_KIND_MBR ){
			mbr_t	*mbr;

			mbr = get_mbr( pos1.x, pos1.y );
			if( mbr == NULL )
				return STR_MENU_ERR;
			g_sel_mbr_n = mbr->mbr_n;

			/* ΥåȤ˥ư */
			if( pty->mbr[g_sel_mbr_n]->trgt.kind
					!= TRGT_KIND_SQUARE ){
				g_crsr.x = pty->mbr[g_sel_mbr_n]->trgt.true_x;
				g_crsr.y = pty->mbr[g_sel_mbr_n]->trgt.true_y;
			}
		}
		while( 1 ){
			str = exec_menu_point_crsr();
			if( str != NULL ){
				g_crsr = pos1;
				redraw_all();

				if( strcmp( str, STR_MENU_CANCEL ) == 0 )
					break;
				if( strcmp( str, STR_MENU_ERR ) == 0 )
					return str;
			}
			pos2 = g_crsr;

			str = exec_menu_sel_obj( &trgt_kind_2, pos2 );
			if( str != NULL ){
				if( strcmp( str, STR_MENU_CANCEL ) == 0 )
					continue;
				if( strcmp( str, STR_MENU_ERR ) == 0 )
					return str;
			}

			if( trgt_kind_2 == TRGT_KIND_NULL )
				return NULL;
			if( trgt_kind_2 == TRGT_KIND_AUTO )
				return NULL;
			if( trgt_kind_2 == TRGT_KIND_MBR ){
				if( trgt_kind_1 != TRGT_KIND_MBR ){
					mbr_t	*mbr;

					mbr = get_mbr( pos2.x, pos2.y );
					if( mbr == NULL )
						return STR_MENU_ERR;
					g_sel_mbr_n = mbr->mbr_n;
				}
			}

			flg_cont = FALSE;
			break;
		}
	}

	/**/

	flg_ret = FALSE;

	switch( trgt_kind_1 ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return STR_MENU_ERR;
	case TRGT_KIND_MBR:
		flg_ret = menu_switch_mark_mbr(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
		flg_ret = menu_switch_mark_mnstr(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_ITEM:
		flg_ret = menu_switch_mark_item(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_DOOR:
		flg_ret = menu_switch_mark_door(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_TRAP:
		flg_ret = menu_switch_mark_trap(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_SQUARE:
		flg_ret = menu_switch_mark_square(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	case TRGT_KIND_POS:
		flg_ret = menu_switch_mark_pos(
				trgt_kind_1, pos1, trgt_kind_2, pos2 );
		break;
	}

	if( !flg_ret )
		return STR_MENU_ERR;

	return NULL;
}

/**/

char	*cb_menu_sel_obj_init( menu_t **pp, menu_t **dflt )
{
	long	mjr_chr, mjr_obj;
	flg_map_t	flg_chr, flg_obj;
	party_t	*pty = get_party();
	dun_t	*dun = get_dun();

	mjr_chr = dun->map.chr.mjr[g_crsr.y][g_crsr.x];
	flg_chr = dun->map.chr.flg[g_crsr.y][g_crsr.x];
	mjr_obj = dun->map.obj.mjr[g_crsr.y][g_crsr.x];
	flg_obj = dun->map.obj.flg[g_crsr.y][g_crsr.x];

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	/* С */
	if( mjr_chr != FACE_MJR_MBR )
		set_flg_menu( *pp, "Member", FLG_MENU_HIDDEN );

	/* 󥹥 */
	if( (mjr_chr == FACE_MJR_MBR) || (mjr_chr == FACE_MJR_NULL)
			|| !chk_flg( flg_chr, FLG_CHR_FIND ) ){
		set_flg_menu( *pp, "Monster", FLG_MENU_HIDDEN );
	}

	/* ƥ */
	if( !chk_flg( flg_obj, FLG_OBJ_FIND )
			|| !get_item( g_crsr.x, g_crsr.y ) ){
		set_flg_menu( *pp, "Item", FLG_MENU_HIDDEN );
	}

	/* ɥ */
	if( ((mjr_obj != FACE_MJR_DOOR_CLOSE)
			&& (mjr_obj != FACE_MJR_DOOR_OPEN))
			|| !chk_flg( flg_obj, FLG_OBJ_FIND ) ){
		set_flg_menu( *pp, "Door", FLG_MENU_HIDDEN );
	}

	/*  */
	if( (mjr_obj != FACE_MJR_TRAP)
			|| !chk_flg( flg_obj, FLG_OBJ_FIND ) ){
		set_flg_menu( *pp, "Trap", FLG_MENU_HIDDEN );
	}

	/* ۡࡦ */
	if( abs( pty->square.x - g_crsr.x ) > (SQUARE_WIDTH / 2) )
		set_flg_menu( *pp, "Square", FLG_MENU_HIDDEN );
	if( abs( pty->square.y - g_crsr.y ) > (SQUARE_HEIGHT / 2) )
		set_flg_menu( *pp, "Square", FLG_MENU_HIDDEN );

	/* ޡ */
	if( mjr_chr != FACE_MJR_MBR )
		set_flg_menu( *pp, "Clear", FLG_MENU_HIDDEN );

	return NULL;
}

/**/

char	*cb_menu_sel_obj( menu_t **pp, menu_t **dflt )
{
	g_sel_obj_trgt_kind = (trgt_kind_t)((*pp)->arg);

	return NULL;
}

/**/

char	*cb_menu_sel_obj_auto( menu_t **pp, menu_t **dflt )
{
	g_sel_obj_trgt_kind = TRGT_KIND_AUTO;

	return menu_auto_mark( pp, dflt );
}

/**/

bool_t	menu_switch_mark_mbr(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	switch( trgt_kind_2 ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return FALSE;
	case TRGT_KIND_MBR:
		return menu_mark_mbr( pos1, pos2 );
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
		return menu_mark_mnstr( pos1, pos2 );
	case TRGT_KIND_ITEM:
		return menu_mark_item( pos1, pos2 );
	case TRGT_KIND_DOOR:
		return menu_mark_door( pos1, pos2 );
	case TRGT_KIND_TRAP:
		return menu_mark_trap( pos1, pos2 );
	case TRGT_KIND_SQUARE:
		return menu_mark_square( pos1 );
	case TRGT_KIND_POS:
		return menu_mark_pos( pos1, pos2 );
	}

	return FALSE;
}

/**/

bool_t	menu_switch_mark_mnstr(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_MBR ){
		return menu_mark_mnstr( pos2, pos1 );
	} else if( trgt_kind_2 == TRGT_KIND_SQUARE ){
		party_t	*pty = get_party();
		long	i;
		pos_t	pos3;

		for( i = 0; i < MBR_MAX_N; i++ ){
			if( chk_flg_or( pty->mbr[i]->stat,
					FLG_STAT_NOT_EXIST
					| FLG_STAT_DEAD ) ){
				continue;
			}
			pos3.x = pty->mbr[i]->x;
			pos3.y = pty->mbr[i]->y;
			menu_mark_mnstr( pos3, pos1 );
		}
		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	menu_switch_mark_item(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_MBR )
		return menu_mark_item( pos2, pos1 );

	return FALSE;
}

/**/

bool_t	menu_switch_mark_door(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_MBR )
		return menu_mark_door( pos2, pos1 );

	return FALSE;
}

/**/

bool_t	menu_switch_mark_trap(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_MBR )
		return menu_mark_trap( pos2, pos1 );

	return FALSE;
}

/**/

bool_t	menu_switch_mark_square(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_POS ){
		return menu_mark_square_pos( pos2 );
	} else if( trgt_kind_2 == TRGT_KIND_MBR ){
		return menu_mark_square( pos2 );
	} else if( trgt_kind_2 == TRGT_KIND_MNSTR ){
		party_t	*pty = get_party();
		long	i;
		pos_t	pos3;

		for( i = 0; i < MBR_MAX_N; i++ ){
			if( chk_flg_or( pty->mbr[i]->stat,
					FLG_STAT_NOT_EXIST
					| FLG_STAT_DEAD ) ){
				continue;
			}
			pos3.x = pty->mbr[i]->x;
			pos3.y = pty->mbr[i]->y;
			menu_mark_mnstr( pos3, pos2 );
		}
		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	menu_switch_mark_pos(
	trgt_kind_t trgt_kind_1, pos_t pos1,
	trgt_kind_t trgt_kind_2, pos_t pos2
)
{
	if( trgt_kind_2 == TRGT_KIND_POS ){
		return menu_mark_square_pos( pos2 );
	} else if( trgt_kind_2 == TRGT_KIND_SQUARE ){
		return menu_mark_square_pos( pos1 );
	} else if( trgt_kind_2 == TRGT_KIND_MBR ){
		return menu_mark_pos( pos2, pos1 );
	}

	return FALSE;
}

/**/

bool_t	menu_mark_mbr( pos_t pos1, pos_t pos2 )
{
	mbr_t	*mbr, *mbr2;

	menu_dist_mbr();

	if( g_dist_chr_kind != CHR_KIND_MBR )
		return FALSE;

	mbr = get_mbr( pos1.x, pos1.y );
	mbr2 = get_mbr( pos2.x, pos2.y );
	if( mbr == NULL )
		return FALSE;
	if( mbr2 == NULL )
		return FALSE;

	if( !set_chr_act( mbr, g_sel_act_kind, NULL, NULL, 0, 0 ) )
		return FALSE;

	mark_mbr( mbr, mbr2, g_sel_dist );
	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	menu_mark_mnstr( pos_t pos1, pos_t pos2 )
{
	mbr_t	*mbr;
	mnstr_t	*mnstr;

	menu_dist_mnstr();

	if( g_dist_chr_kind != CHR_KIND_MNSTR )
		return FALSE;

	mbr = get_mbr( pos1.x, pos1.y );
	mnstr = get_mnstr( pos2.x, pos2.y );
	if( mbr == NULL )
		return FALSE;
	if( mnstr == NULL )
		return FALSE;

	if( !set_chr_act( mbr, g_sel_act_kind, NULL, NULL, 0, 0 ) )
		return FALSE;

	mbr->act.dflt_kind_mnstr = mbr->act.kind;
	strncpy( mbr->act.dflt_msg_mnstr, mbr->act.msg, ACT_MSG_MAX_LEN );

	mark_mnstr( mbr, mnstr, g_sel_dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	menu_mark_item( pos_t pos1, pos_t pos2 )
{
	g_mark_sel_mbr = get_mbr( pos1.x, pos1.y );
	g_mark_sel_item = get_item( pos2.x, pos2.y );

	if( g_mark_sel_mbr == NULL )
		return FALSE;
	if( g_mark_sel_item == NULL )
		return FALSE;

	exec_menu( ls_menu_mark_item, NULL, NULL );

	return TRUE;
}

/**/

char	*cb_menu_mark_item( menu_t **pp, menu_t **dflt )
{
	act_kind_t	kind;

	kind = (act_kind_t)((*pp)->arg);

	if( !set_chr_act( g_mark_sel_mbr, kind, NULL, NULL, 0, 0 ) )
		return STR_MENU_CANCEL;

	mark_item( g_mark_sel_mbr, g_mark_sel_item, DIST_NEAR );

	draw_mbr_stat( g_mark_sel_mbr );

	return NULL;
}

/**/

bool_t	menu_mark_door( pos_t pos1, pos_t pos2 )
{
	g_mark_sel_mbr = get_mbr( pos1.x, pos1.y );
	g_mark_sel_door = get_door( pos2.x, pos2.y );

	if( g_mark_sel_mbr == NULL )
		return FALSE;
	if( g_mark_sel_door == NULL )
		return FALSE;

	exec_menu( ls_menu_mark_door, NULL, NULL );

	return TRUE;
}

/**/

char	*cb_menu_mark_door( menu_t **pp, menu_t **dflt )
{
	act_kind_t	kind;

	kind = (act_kind_t)((*pp)->arg);

	if( !set_chr_act( g_mark_sel_mbr, kind, NULL, NULL, 0, 0 ) )
		return STR_MENU_CANCEL;

	mark_door( g_mark_sel_mbr, g_mark_sel_door, DIST_NEAR );

	draw_mbr_stat( g_mark_sel_mbr );

	return NULL;
}

/**/

bool_t	menu_mark_trap( pos_t pos1, pos_t pos2 )
{
	g_mark_sel_mbr = get_mbr( pos1.x, pos1.y );
	g_mark_sel_trap = get_trap( pos2.x, pos2.y );

	if( g_mark_sel_mbr == NULL )
		return FALSE;
	if( g_mark_sel_trap == NULL )
		return FALSE;

	exec_menu( ls_menu_mark_trap, NULL, NULL );

	return TRUE;
}

/**/

char	*cb_menu_mark_trap( menu_t **pp, menu_t **dflt )
{
	act_kind_t	kind;

	kind = (act_kind_t)((*pp)->arg);

	if( !set_chr_act( g_mark_sel_mbr, kind, NULL, NULL, 0, 0 ) )
		return STR_MENU_CANCEL;

	mark_trap( g_mark_sel_mbr, g_mark_sel_trap, DIST_NEAR );

	draw_mbr_stat( g_mark_sel_mbr );

	return NULL;
}

/**/

bool_t	menu_mark_square( pos_t pos1 )
{
	mbr_t	*mbr;

	mbr = get_mbr( pos1.x, pos1.y );
	if( mbr == NULL )
		return FALSE;

	mark_square( mbr );
	clr_chr_act( mbr );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	menu_mark_pos( pos_t pos1, pos_t pos2 )
{
	mbr_t	*mbr;

	mbr = get_mbr( pos1.x, pos1.y );
	if( mbr == NULL )
		return FALSE;

	if( !set_chr_act( mbr, ACT_KIND_NULL, NULL, NULL, 0, 0 ) )
		return FALSE;

	strncpy( mbr->act.msg, MSG_TRGT_POS, ACT_MSG_MAX_LEN );
	mark_pos( mbr, pos2.x, pos2.y, DIST_NEAR );

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	menu_mark_square_pos( pos_t pos )
{
	square_t	*sq;
	bool_t	flg_loop;

	print_msg( FLG_NULL, MSG_MENU_MARK_SQUARE_POS );

	sq = get_square_mbr();

	sq->pre_x = sq->x;
	sq->pre_y = sq->y;

	sq->dir_x = 0;
	sq->dir_y = 0;

	flg_loop = TRUE;
	while( flg_loop ){
		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			return FALSE;
			break;
		case CASE_CRSR_UP:
			sq->dir_y = -1;
			flg_loop = FALSE;
			break;
		case CASE_CRSR_DOWN:
			sq->dir_y = +1;
			flg_loop = FALSE;
			break;
		case CASE_CRSR_LEFT:
			sq->dir_x = -1;
			flg_loop = FALSE;
			break;
		case CASE_CRSR_RIGHT:
			sq->dir_x = +1;
			flg_loop = FALSE;
			break;
		}
	}

	sq->x = pos.x;
	sq->y = pos.y;
	set_square_mbr( sq );

	set_mbr_dir();

	clr_msg();
	draw_square();

	return TRUE;
}

/**/

void	menu_dist_mbr( void )
{
	g_dist_chr_kind = CHR_KIND_MBR;
	g_sel_dist = DIST_NEAR;
	g_sel_act_kind = ACT_KIND_NULL;

	exec_menu( ls_menu_dist, NULL, NULL );
}

/**/

void	menu_dist_mnstr( void )
{
	g_dist_chr_kind = CHR_KIND_MNSTR;
	g_sel_dist = DIST_NEAR;
	g_sel_act_kind = ACT_KIND_NULL;

	exec_menu( ls_menu_dist, NULL, NULL );
}

/**/

char	*cb_menu_dist_init( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	char	*dflt_path;

	g_sel_dist = DIST_NEAR;
	g_sel_act_kind = ACT_KIND_NULL;

	dflt_path = "Near";

	if( g_dist_chr_kind == CHR_KIND_MBR ){
		dflt_path = "Near";
	} else if( g_dist_chr_kind == CHR_KIND_MNSTR ){
		switch( pty->mbr[g_sel_mbr_n]->trgt.dist ){
		case DIST_NEAR:
			dflt_path = "Near";
			break;
		case DIST_MEDIUM:
			dflt_path = "Medium";
			break;
		case DIST_FAR:
			dflt_path = "Far";
			break;
		}
	} else {
		return STR_MENU_ERR;
	}

	*dflt = srch_menu( *pp, dflt_path );
	if( *dflt == NULL )
		return STR_MENU_ERR;

	return NULL;
}

/**/

char	*cb_menu_dist( menu_t **pp, menu_t **dflt )
{
	char	*dflt_path;

	dflt_path = "Tail";

	switch( g_dist_chr_kind ){
	case CHR_KIND_MBR:
		if( strcmp( (*pp)->arg, "Near" ) == 0 ){
			g_sel_dist = DIST_NEAR;
		} else if( strcmp( (*pp)->arg, "Medium" ) == 0 ){
			g_sel_dist = DIST_MEDIUM;
		} else if( strcmp( (*pp)->arg, "Far" ) == 0 ){
			g_sel_dist = DIST_FAR;
		} else {
			return STR_MENU_ERR;
		}
		dflt_path = "Tail";
		break;
	case CHR_KIND_MNSTR:
		if( strcmp( (*pp)->arg, "Near" ) == 0 ){
			g_sel_dist = DIST_NEAR;
			dflt_path = "Fight";
		} else if( strcmp( (*pp)->arg, "Medium" ) == 0 ){
			g_sel_dist = DIST_MEDIUM;
			dflt_path = "Throw";
		} else if( strcmp( (*pp)->arg, "Far" ) == 0 ){
			g_sel_dist = DIST_FAR;
			dflt_path = "Tail";
		} else {
			return STR_MENU_ERR;
		}
		break;
	default:
		return STR_MENU_ERR;
	}

	*dflt = srch_menu( *pp, dflt_path );
	if( *dflt == NULL )
		return STR_MENU_ERR;

	return NULL;
}

/**/

char	*cb_menu_dist_act( menu_t **pp, menu_t **dflt )
{
	char	*str_act;

	str_act = (char *)((*pp)->arg);

	if( g_dist_chr_kind == CHR_KIND_MBR ){
		if( strcmp( str_act, "Fight" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MBR_FIGHT;
		} else if( strcmp( str_act, "Throw" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MBR_THROW;
		} else if( strcmp( str_act, "Tail" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MBR_TAIL;
		} else {
			return STR_MENU_ERR;
		}
	} else if( g_dist_chr_kind == CHR_KIND_MNSTR ){
		if( strcmp( str_act, "Fight" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MNSTR_FIGHT;
		} else if( strcmp( str_act, "Throw" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MNSTR_THROW;
		} else if( strcmp( str_act, "Tail" ) == 0 ){
			g_sel_act_kind = ACT_KIND_MNSTR_TAIL;
		} else {
			return STR_MENU_ERR;
		}
	} else {
		return STR_MENU_ERR;
	}

	return NULL;
}

/**/

char	*cb_menu_item( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	mbr_t	*mbr;
	long	i, j, k;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( chk_flg_or( mbr->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		print_msg( FLG_NULL, MSG_ERR_MENU_SEL_ITEM, mbr->name );
		return STR_MENU_CANCEL;
	}

	ls = ls_menu_item;
	k = 0;

	strncpy( ls[k].path, "/Item", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = cb_menu_item_init;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < MBR_MAX_N; i++ ){
		item_t	*item, *p;

		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		strncpy( ls[k].path, "/Item/--", MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, pty->mbr[i]->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		item = get_mbr_item_asgn( pty->mbr[i] );
		p = item->next;
		for( j = 0; j < MBR_ITEM_MAX_N; j++, p = p->next ){
			if( p == item )
				break;

			sprintf( ls[k].path, "/Item/%ld%c",
					i, (char)('A' + j) );
			strncpy( ls[k].kind, "<Branch>",
					MENU_KIND_MAX_LEN );
			ls[k].key = 'A' + j;
			ls[k].accel_key[0] = '\0';
			ls[k].n_msg = N_MSG_NULL;
			strncpy( ls[k].msg, p->name, MENU_MSG_MAX_LEN );
			ls[k].call_back = cb_menu_item_sel;
			ls[k].arg = NULL;
			ls[k].flg = FLG_NULL;
			k++;
		}

		sprintf( ls[k].path, "/Item/%ld%s", i, "Equip" );
		strncpy( ls[k].kind, "<Branch>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'Z';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, MSG_MENU_ITEM_LS_EQUIP,
				MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_goto_equip;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		strncpy( ls[k].path, "/Item/--", MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<PageSeparator>",
				MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		ls[k].msg[0] = '\0';
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_item_init( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	mbr_n, srch_mbr_n;
	menu_t	*p;
	long	i;

	srch_mbr_n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( i == g_ref_mbr_n )
			break;
		if( !chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			srch_mbr_n++;
	}

	mbr_n = 0;
	p = *pp;
	for( i = 1; i < 4096; i++ ){
		if( p[i].path[0] == '\0' )
			return STR_MENU_ERR;

		if( mbr_n == srch_mbr_n ){
			if( strcmp( p[i].kind, "<Branch>" ) == 0 ){
				*dflt = &(p[i]);
				return NULL;
			}
		}

		if( strcmp( p[i].kind, "<PageSeparator>" ) == 0 )
			mbr_n++;
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_item_sel( menu_t **pp, menu_t **dflt )
{
	char	*node;
	party_t	*pty = get_party();
	long	i, item_idx;
	item_t	*item_head, *item;

	node = strrchr( (*pp)->path, '/' );
	if( node == NULL )
		return STR_MENU_ERR;
	node++;

	g_ref_mbr_n = strtol( node, (char **)NULL, 10 );
	g_sel_item = NULL;

	item_idx = node[1] - 'A';
	item_head = get_mbr_item_asgn( pty->mbr[g_ref_mbr_n] );
	item = item_head->next;
	for( i = 0; i < MBR_ITEM_MAX_N; i++ ){
		if( item == item_head )
			return STR_MENU_ERR;
		if( i == item_idx )
			break;
		item = item->next;
	}
	if( i >= MBR_ITEM_MAX_N )
		return STR_MENU_ERR;

	g_sel_item = item;

	if( g_ref_mbr_n == g_sel_mbr_n )
		*pp = ls_menu_item_self;
	else
		*pp = ls_menu_item_other;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_item_self_init( menu_t **pp, menu_t **dflt )
{
	set_flg_menu( *pp, NULL, FLG_MENU_HIDDEN );

	clr_flg_menu( *pp, "Equip", FLG_MENU_HIDDEN );
	clr_flg_menu( *pp, "Ready Throw", FLG_MENU_HIDDEN );
	clr_flg_menu( *pp, "Send", FLG_MENU_HIDDEN );
	clr_flg_menu( *pp, "Drop", FLG_MENU_HIDDEN );
	clr_flg_menu( *pp, "Check", FLG_MENU_HIDDEN );

	switch( g_sel_item->kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		return STR_MENU_ERR;
	case ITEM_KIND_WPN:
	case ITEM_KIND_ARMOR:
		break;
	case ITEM_KIND_POTION:
		clr_flg_menu( *pp, "Quaff", FLG_MENU_HIDDEN );
		clr_flg_menu( *pp, "Fill Lamp", FLG_MENU_HIDDEN );
		break;
	case ITEM_KIND_SCROLL:
		clr_flg_menu( *pp, "Read", FLG_MENU_HIDDEN );
		break;
	case ITEM_KIND_STICK:
		clr_flg_menu( *pp, "Zap", FLG_MENU_HIDDEN );
		break;
	case ITEM_KIND_ACCE:
	case ITEM_KIND_LIGHT:
	case ITEM_KIND_SPIKE:
		break;
	case ITEM_KIND_FOOD:
		clr_flg_menu( *pp, "Eat", FLG_MENU_HIDDEN );
		break;
	case ITEM_KIND_CHEST:
		break;
	case ITEM_KIND_TOBACCO:
		clr_flg_menu( *pp, "Smoke", FLG_MENU_HIDDEN );
		break;
	case ITEM_KIND_PIPE:
	case ITEM_KIND_COIN:
	case ITEM_KIND_JUNK:
		break;
	}

	return NULL;
}

/**/

char	*cb_menu_item_other( menu_t **pp, menu_t **dflt )
{
	return NULL;
}

/**/

char	*cb_menu_item_use( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( set_chr_act( mbr, (act_kind_t)((*pp)->arg),
			g_sel_item, NULL, 0, 0 ) ){
		return NULL;
	}
	return STR_MENU_ERR;
}

/**/

char	*cb_menu_item_zap( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	trgt_kind_t	trgt_kind;
	mbr_t	*mbr, *mbr2;
	mnstr_t	*mnstr;
	item_t	*item;
	door_t	*door;
	trap_t	*trap;
	char	*str;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	move_crsr_mbr_trgt( mbr );

	str = exec_menu_point_crsr();
	if( str != NULL )
		return str;

	str = exec_menu_sel_obj( &trgt_kind, g_crsr );
	if( str != NULL )
		return str;

	switch( trgt_kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return STR_MENU_ERR;
	case TRGT_KIND_MBR:
		mbr2 = get_mbr( g_crsr.x, g_crsr.y );
		if( mbr2 == NULL )
			return STR_MENU_ERR;

		mark_mbr( mbr, mbr2, DIST_FAR );
		break;
	case TRGT_KIND_MNSTR:
		mnstr = get_mnstr( g_crsr.x, g_crsr.y );
		if( mnstr == NULL )
			return STR_MENU_ERR;

		mark_mnstr_no_regist( mbr, mnstr, DIST_FAR );
		break;
	case TRGT_KIND_MNSTR_NULL:
	case TRGT_KIND_POS:
		mark_mnstr_null_no_regist(
				mbr, g_crsr.x, g_crsr.y, DIST_FAR );
		break;
	case TRGT_KIND_ITEM:
		item = get_item( g_crsr.x, g_crsr.y );
		if( item == NULL )
			return STR_MENU_ERR;

		mark_item( mbr, item, DIST_FAR );
		break;
	case TRGT_KIND_DOOR:
		door = get_door( g_crsr.x, g_crsr.y );
		if( door == NULL )
			return STR_MENU_ERR;

		mark_door( mbr, door, DIST_FAR );
		break;
	case TRGT_KIND_TRAP:
		trap = get_trap( g_crsr.x, g_crsr.y );
		if( trap == NULL )
			return STR_MENU_ERR;

		mark_trap( mbr, trap, DIST_FAR );
		break;
	case TRGT_KIND_SQUARE:
		break;
	}

	if( !set_chr_act( mbr, (act_kind_t)((*pp)->arg),
			g_sel_item, NULL, 0, 0 ) ){
		return STR_MENU_ERR;
	}

	return NULL;
}

/**/

char	*cb_menu_item_smoke( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;
	char	*ret;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	ret = cb_menu_item_use( pp, dflt );

	if( ret == NULL ){
		mbr->act.n = EQUIP_KIND_HEAD;

		strncpy( mbr->act.msg, MSG_ACT_TOBACCO_SMOKE,
				ACT_MSG_MAX_LEN );
	}

	return ret;
}

/**/

char	*cb_menu_item_fill_lamp( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;
	item_t	*lamp;
	light_tab_t	*tab;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	lamp = get_mbr_item_asgn_equip( mbr );
	if( lamp == NULL )
		return STR_MENU_ERR;
	lamp = &(lamp[EQUIP_KIND_LIGHT_SOURCE]);

	tab = get_light_tab( lamp->dat.light.kind );

	if( (lamp->kind != ITEM_KIND_LIGHT) || !tab->flg_fill ){
		print_msg( FLG_NULL, MSG_ERR_FILL_LAMP );
		return STR_MENU_ERR;
	}

	if( set_chr_act( mbr, (act_kind_t)((*pp)->arg),
			g_sel_item, NULL, 0, 0 ) ){
		return NULL;
	}
	return STR_MENU_ERR;
}

/**/

char	*cb_menu_item_ready_throw( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;
	char	*ret;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	ret = cb_menu_item_use( pp, dflt );

	if( ret == NULL )
		mbr->act.n = EQUIP_KIND_ARW;

	return ret;
}

/**/

char	*cb_menu_item_send( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;
	mbr_t	*mbr2;
	char	*str;
	long	n;

	if( g_sel_item == NULL )
		return STR_MENU_ERR;
	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;

	mbr = pty->mbr[g_sel_mbr_n];
	mbr2 = mbr;

	/* ï뤫 */
	str = exec_menu_sel_mbr(
			&mbr2, MSG_TTL_MENU_ITEM_SEND, TRUE );
	if( str != NULL )
		return str;

	/* Ŀ */
	n = g_sel_item->n;
	str = exec_menu_sel_num( 1, n, &n );
	if( str != NULL )
		return str;

	if( !set_chr_act( mbr, ACT_KIND_ITEM_SEND,
			g_sel_item, mbr2, n, 0 ) ){
		return STR_MENU_CANCEL;
	}

	mark_mbr( mbr, mbr2, DIST_NEAR );

	return NULL;
}

/**/

char	*cb_menu_item_drop( menu_t **pp, menu_t **dflt )
{
	long	n;
	char	*str, *ret;
	party_t	*pty = get_party();
	mbr_t	*mbr;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( g_sel_item == NULL )
		return STR_MENU_ERR;

	n = g_sel_item->n;
	str = exec_menu_sel_num( 1, g_sel_item->n, &n );
	if( str != NULL )
		return str;

	ret = cb_menu_item_use( pp, dflt );

	if( ret == NULL )
		mbr->act.n = n;

	return ret;
}

/**/

char	*cb_menu_item_srch( menu_t **pp, menu_t **dflt )
{
	if( g_sel_item == NULL )
		return STR_MENU_ERR;

	chk_item_data( g_sel_item );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_item_receive( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;
	mbr_t	*mbr2;
	char	*str;
	long	n;

	if( g_sel_item == NULL )
		return STR_MENU_ERR;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( g_ref_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr2 = pty->mbr[g_ref_mbr_n];

	/* Ŀ */
	n = g_sel_item->n;
	str = exec_menu_sel_num( 1, n, &n );
	if( str != NULL )
		return str;

	if( !set_chr_act( mbr, ACT_KIND_ITEM_RECEIVE,
			g_sel_item, mbr2, n, 0 ) ){
		return STR_MENU_CANCEL;
	}

	mark_mbr( mbr, mbr2, DIST_NEAR );

	return NULL;
}

/**/

char	*cb_menu_goto_equip( menu_t **pp, menu_t **dflt )
{
	return "/Equip";
}

/**/

char	*cb_menu_equip( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	mbr_t	*mbr;
	long	i, j, k;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( chk_flg_or( mbr->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		print_msg( FLG_NULL, MSG_ERR_MENU_SEL_EQUIP, mbr->name );
		return STR_MENU_CANCEL;
	}

	ls = ls_menu_equip;
	k = 0;

	strncpy( ls[k].path, "/Equip",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = cb_menu_equip_init;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < MBR_MAX_N; i++, k++ ){
		item_t	*equip;

		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		strncpy( ls[k].path, "/Equip/--",
				MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg,
				pty->mbr[i]->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		equip = get_mbr_item_asgn_equip( pty->mbr[i] );
		for( j = 0; j < EQUIP_KIND_MAX_N; j++ ){
			equip_kind_t	eq_k;
			char	*msg;

			eq_k = ls_equip_msg[j].kind;

			msg = MSG( ls_equip_msg[j].n_msg );

			sprintf( ls[k].path, "/Equip/%ld%c",
					i, (char)('A' + j) );
			strncpy( ls[k].kind, "<Branch>",
					MENU_KIND_MAX_LEN );
			ls[k].key = 'A' + j;
			ls[k].accel_key[0] = '\0';
			ls[k].n_msg = N_MSG_NULL;
			if( equip[eq_k].kind == ITEM_KIND_NULL ){
				sprintf( ls[k].msg, "%s:", msg );
			} else {
				sprintf( ls[k].msg, "%s:%s", msg,
						equip[eq_k].name );
			}
			ls[k].call_back = cb_menu_equip_sel;
			ls[k].arg = (void *)eq_k;
			ls[k].flg = FLG_NULL;
			k++;
		}

		sprintf( ls[k].path,
				"/Equip/%ld%s", i, "Item" );
		strncpy( ls[k].kind, "<Branch>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'Z';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg,
				MSG_MENU_EQUIP_LS_ITEM,
				MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_goto_item;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		strncpy( ls[k].path, "/Equip/--",
				MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<PageSeparator>",
				MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		ls[k].msg[0] = '\0';
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_equip_init( menu_t **pp, menu_t **dflt )
{
	return cb_menu_item_init( pp, dflt );
}

/**/

char	*cb_menu_equip_sel( menu_t **pp, menu_t **dflt )
{
	char	*node;
	party_t	*pty = get_party();
	item_t	*equip;

	node = strrchr( (*pp)->path, '/' );
	if( node == NULL )
		return STR_MENU_ERR;
	node++;

	g_ref_mbr_n = strtol( node, (char **)NULL, 10 );
	g_sel_item = NULL;
	g_sel_equip_kind = (equip_kind_t)((*pp)->arg);

	equip = get_mbr_item_asgn_equip( pty->mbr[g_ref_mbr_n] );
	if( equip == NULL )
		return STR_MENU_ERR;
	g_sel_item = &(equip[g_sel_equip_kind]);

	if( g_ref_mbr_n == g_sel_mbr_n )
		*pp = ls_menu_equip_self;
	else
		*pp = ls_menu_equip_other;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_equip_self( menu_t **pp, menu_t **dflt )
{
	if( g_sel_item->kind == ITEM_KIND_NULL )
		set_flg_menu( *pp, "Take Off", FLG_MENU_HIDDEN );
	else
		clr_flg_menu( *pp, "Take Off", FLG_MENU_HIDDEN );

	return NULL;
}

/**/

char	*cb_menu_equip_other( menu_t **pp, menu_t **dflt )
{
	if( g_sel_item->kind == ITEM_KIND_NULL )
		set_flg_menu( *pp, "Take Off", FLG_MENU_HIDDEN );
	else
		clr_flg_menu( *pp, "Take Off", FLG_MENU_HIDDEN );

	return NULL;
}

/**/

char	*cb_menu_equip_wear_sel( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	mbr_t	*mbr1, *mbr2;
	item_t	*item, *p;
	long	i, k;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr1 = pty->mbr[g_sel_mbr_n];
	if( g_ref_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr2 = pty->mbr[g_ref_mbr_n];

	ls = ls_menu_equip_wear_sel;
	k = 0;

	strncpy( ls[k].path, "/Wear", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = cb_menu_equip_wear_init;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	item = get_mbr_item_asgn( mbr2 );
	p = item->next;
	for( i = 0; i < MBR_ITEM_MAX_N; i++, p = p->next ){
		if( p == item )
			break;

		sprintf( ls[k].path, "/Wear/%c", (char)('A' + i) );
		strncpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, p->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_equip_wear;
		ls[k].arg = p;
		ls[k].flg = FLG_NULL;
		k++;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_equip_wear_init( menu_t **pp, menu_t **dflt )
{
	long	i;
	long	n;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	n = 0;
	for( i = 0; i < 4096; i++ ){
		item_t	*item;

		if( (*pp)[i].path[0] == '\0' )
			break;

		if( strcmp( (*pp)[i].kind, "<Item>" ) != 0 )
			continue;

		item = (item_t *)((*pp)[i].arg);
		if( chk_equip_kind( item, g_sel_equip_kind ) ){
			n++;
		} else {
#if	0
@@@
			char	*path;

			path = (*pp)[i].path;
			path += str_len_byte( (*pp)[0].path ) + 1;
			set_flg_menu( *pp, path, FLG_MENU_HIDDEN );
#else
			(*pp)->flg |= FLG_MENU_HIDDEN;
#endif
		}
	}
	if( n <= 0 ){
		print_msg( FLG_NULL, MSG_ERR_EQUIP_SEL_ITEM );
		return STR_MENU_CANCEL;
	}

	return NULL;
}

/**/

char	*cb_menu_equip_wear( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr, *mbr2;
	act_kind_t	kind;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( g_ref_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr2 = pty->mbr[g_ref_mbr_n];

	if( mbr == mbr2 )
		kind = ACT_KIND_EQUIP;
	else
		kind = ACT_KIND_EQUIP_MBR;

	if( !set_chr_act( mbr, kind, (item_t *)((*pp)->arg), mbr2,
			g_sel_equip_kind, 0 ) )
		return STR_MENU_CANCEL;

	if( mbr != mbr2 )
		mark_mbr( mbr, mbr2, DIST_NEAR );

	draw_mbr_stat( mbr );

	return NULL;
}

/**/

char	*cb_menu_equip_take_off( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr, *mbr2;
	act_kind_t	kind;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr = pty->mbr[g_sel_mbr_n];

	if( g_ref_mbr_n <= -1 )
		return STR_MENU_ERR;
	mbr2 = pty->mbr[g_ref_mbr_n];

	if( count_mbr_item_n( mbr2 ) >= MBR_ITEM_MAX_N ){
		print_msg( FLG_NULL,
				MSG_ERR_ITEM_FULL,
				mbr2->name );
		return STR_MENU_ERR;
	}

	if( mbr == mbr2 ){
		kind = ACT_KIND_TAKE_OFF;
		strncpy( mbr->act.msg, MSG_ACT_TAKE_OFF,
				ACT_MSG_MAX_LEN );
	} else {
		kind = ACT_KIND_TAKE_OFF_MBR;
		strncpy( mbr->act.msg, MSG_ACT_TAKE_OFF_MBR,
				ACT_MSG_MAX_LEN );
	}

	if( !set_chr_act( mbr, kind, NULL, mbr2, g_sel_equip_kind, 0 ) )
		return STR_MENU_CANCEL;

	if( mbr != mbr2 )
		mark_mbr( mbr, mbr2, DIST_NEAR );

	draw_mbr_stat( mbr );

	return NULL;
}

/**/

char	*cb_menu_goto_item( menu_t **pp, menu_t **dflt )
{
	return "/Item";
}

/**/

char	*cb_menu_move( menu_t **pp, menu_t **dflt )
{
	square_t	*sq;

	sq = get_square_mbr();

	sq->pre_x = sq->x;
	sq->pre_y = sq->y;

	sq->dir_x = 0;
	sq->dir_y = 0;
	if( abs( sq->x - g_crsr.x ) > abs( sq->y - g_crsr.y ) ){
		if( g_crsr.x < sq->x ){
			sq->dir_x = -1;
		} else if( g_crsr.x > sq->x ){
			sq->dir_x = +1;
		}
	} else {
		if( g_crsr.y < sq->y ){
			sq->dir_y = -1;
		} else if( g_crsr.y > sq->y ){
			sq->dir_y = +1;
		}
	}
	if( (sq->dir_x == 0) && (sq->dir_y == 0) ){
		sq->dir_x = 0;
		sq->dir_y = -1;
	}

	sq->x = g_crsr.x;
	sq->y = g_crsr.y;

	set_square_mbr( sq );

	set_mbr_dir();
	draw_square();

	return NULL;
}

/**/

char	*cb_menu_fight( menu_t **pp, menu_t **dflt )
{
	pos_t	pos1, pos2;
	char	*str;
	char	c;

	pos1 = g_crsr;

	str = exec_menu_point_crsr();
	if( str != NULL )
		return str;

	pos2 = g_crsr;
	c = get_chr_mjr_crsr();

	if( c == FACE_MJR_MBR ){
		if( !menu_mark_mbr( pos1, pos2 ) )
			return STR_MENU_ERR;
	} else {
		if( !menu_mark_mnstr( pos1, pos2 ) )
			return STR_MENU_ERR;
	}

	return NULL;
}

/**/

char	*cb_menu_misc( menu_t **pp, menu_t **dflt )
{
	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( get_chr_mjr_crsr() == FACE_MJR_NULL ){
		set_flg_menu( *pp, "Data", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Collect gold", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Monster data", FLG_MENU_HIDDEN );
	} else if( get_chr_mjr_crsr() == FACE_MJR_MBR ){
		set_flg_menu( *pp, "Monster data", FLG_MENU_HIDDEN );
	} else {
		set_flg_menu( *pp, "Data", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Collect gold", FLG_MENU_HIDDEN );
	}

	return NULL;
}

/**/

char	*cb_menu_stairs( menu_t **pp, menu_t **dflt )
{
	bool_t	flg_up, flg_down;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	flg_up = TRUE;
	flg_down = TRUE;
	if( !chk_stairs( FACE_MJR_STAIRS_UP ) ){
		flg_up = FALSE;
		set_flg_menu( *pp, "Up", FLG_MENU_HIDDEN );
	}
	if( !chk_stairs( FACE_MJR_STAIRS_DOWN ) ){
		flg_down = FALSE;
		set_flg_menu( *pp, "Down", FLG_MENU_HIDDEN );
	}
	if( !flg_up && !flg_down ){
		print_msg( FLG_NULL, MSG_ERR_STAIRS );
		return STR_MENU_CANCEL;
	}

	*dflt = srch_menu( *pp, "Down" );

	return NULL;
}

/**/

char	*cb_menu_stairs_up( menu_t **pp, menu_t **dflt )
{
	up_stairs();

	return NULL;
}

/**/

char	*cb_menu_stairs_down( menu_t **pp, menu_t **dflt )
{
	down_stairs();

	return NULL;
}

/**/

char	*cb_menu_srch( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	long	i, k;

	ls = ls_menu_srch;
	k = 0;

	strncpy( ls[k].path, "/Search", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = cb_menu_srch_init;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Search/Title", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	strncpy( ls[k].msg, MSG_TTL_MENU_SRCH, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Search/Exec", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[k].key = 'X';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_SRCH_EXEC, MENU_MSG_MAX_LEN );
	ls[k].call_back = cb_menu_srch_exec;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Search/Exec all", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[k].key = 'Y';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_SRCH_EXEC_ALL, MENU_MSG_MAX_LEN );
	ls[k].call_back = cb_menu_srch_exec_all;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Search/Cancel all", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[k].key = 'Z';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_SRCH_CANCEL_ALL, MENU_MSG_MAX_LEN );
	ls[k].call_back = cb_menu_srch_cancel_all;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < MBR_MAX_N; i++, k++ ){
		sprintf( ls[k].path, "/Search/%ld", i );
		strncpy( ls[k].kind, "<CheckItem>", MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, pty->mbr[i]->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_srch_sel_mbr;
		ls[k].arg = (void *)i;
		ls[k].flg = FLG_NULL;
	}

	strncpy( ls[k].path, "/Search/Auto off", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<CheckItem>", MENU_KIND_MAX_LEN );
	ls[k].key = 'V';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_SRCH_AUTO_OFF, MENU_MSG_MAX_LEN );
	ls[k].call_back = cb_menu_srch_auto_off;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_srch_init( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();

	static char	sub_path[MENU_PATH_MAX_LEN + 1];
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		sprintf( sub_path, "%ld", i );

		if( g_ls_flg_srch[i] )
			set_chk_on_menu( *pp, sub_path );
		else
			set_chk_off_menu( *pp, sub_path );
	}

	if( chk_flg( pty->flg, FLG_PARTY_SRCH_AUTO_OFF ) )
		set_chk_on_menu( *pp, "Auto off" );
	else
		set_chk_off_menu( *pp, "Auto off" );

	return NULL;
}

/**/

char	*cb_menu_srch_exec( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( g_ls_flg_srch[i] )
			chr_srch_begin( pty->mbr[i] );
		else
			chr_srch_end( pty->mbr[i] );
	}

	return NULL;
}

/**/

char	*cb_menu_srch_exec_all( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ )
		chr_srch_begin( pty->mbr[i] );

	return NULL;
}

/**/

char	*cb_menu_srch_cancel_all( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ )
		chr_srch_end( pty->mbr[i] );

	return NULL;
}

/**/

char	*cb_menu_srch_sel_mbr( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		g_ls_flg_srch[(long)((*pp)->arg)] = TRUE;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		g_ls_flg_srch[(long)((*pp)->arg)] = FALSE;
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_srch_auto_off( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		pty->flg |= FLG_PARTY_SRCH_AUTO_OFF;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		pty->flg &= ~(FLG_PARTY_SRCH_AUTO_OFF);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_data( menu_t **pp, menu_t **dflt )
{
	mbr_t	**mbr = get_party()->mbr;
	long	n;
	long	page_n;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;

	n = g_sel_mbr_n;
	page_n = 0;

	while( 1 ){
		long	add;

		add = menu_show_mbr_data( mbr[n], &page_n );
		if( add == 0 )
			break;

		n = next_mbr( n, add );
	}

	return STR_MENU_CANCEL;
}

/**/

long	menu_show_mbr_data( mbr_t *mbr, long *page_n )
{
	return menu_mbr_data( mbr, page_n, MBR_DATA_EDIT_KIND_SHOW );
}

/**/

long	menu_edit_mbr_data( mbr_t *mbr, long *page_n )
{
	return menu_mbr_data( mbr, page_n, MBR_DATA_EDIT_KIND_EDIT );
}

/**/

long	menu_mbr_data(
	mbr_t *org_p, long *page_n,
	mbr_data_edit_kind_t edit_kind
)
{
	mbr_t	dst_mbr, *mbr_p;
	data_n_t	n, prev_n;

	if( org_p == NULL )
		return 0;

	mbr_p = &dst_mbr;
	*mbr_p = *org_p;

	n = next_mbr_data( *page_n, DATA_N_NEXT_PAGE, +-0, edit_kind );
	prev_n = n;

	draw_mbr_data_all( org_p, mbr_p, *page_n );

	while( 1 ){
		draw_mbr_data( org_p, mbr_p, prev_n, FALSE );
		draw_mbr_data( org_p, mbr_p, n, TRUE );
		prev_n = n;

		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			if( exec_menu_ask_edit_mbr_data( org_p, mbr_p ) )
				return 0;
			draw_mbr_data_all( org_p, mbr_p, *page_n );
			break;
		case CASE_ENTER:
			draw_mbr_data( org_p, mbr_p, n, FALSE );
			*page_n += exec_menu_edit_mbr_data( mbr_p, n );
			*page_n %= MBR_DATA_PAGE_MAX_N;
			n = next_mbr_data( *page_n, n,
					+-0, edit_kind );
			prev_n = n;
			if( edit_kind == MBR_DATA_EDIT_KIND_NEW ){
				new_mbr_reset( mbr_p );
				*org_p = *mbr_p;
			}
			draw_mbr_data_all( org_p, mbr_p, *page_n );
			break;
		case CASE_CRSR_LEFT:
			if( exec_menu_ask_edit_mbr_data( org_p, mbr_p ) )
				return -1;
			draw_mbr_data_all( org_p, mbr_p, *page_n );
			break;
		case CASE_CRSR_RIGHT:
			if( exec_menu_ask_edit_mbr_data( org_p, mbr_p ) )
				return +1;
			draw_mbr_data_all( org_p, mbr_p, *page_n );
			break;
		case CASE_CRSR_DOWN:
			n = next_mbr_data( *page_n, n, +1, edit_kind );
			break;
		case CASE_CRSR_UP:
			n = next_mbr_data( *page_n, n, -1, edit_kind );
			break;
		default:
			break;
		}
	}

	return 0;
}

/**/

long	exec_menu_edit_mbr_data( mbr_t *mbr, data_n_t n )
{
	switch( n ){
	case DATA_N_NAME:
		print_msg( FLG_MSG_NO_MORE_NEXT, MSG_GETS_MBR_NAME,
				(long)MBR_NAME_MAX_LEN );
		gets_mbr_name( mbr );
		break;
	case DATA_N_FACE:
		print_msg( FLG_MSG_NO_MORE_NEXT, MSG_GETS_MBR_FACE );
		gets_mbr_face( mbr );
		break;
	case DATA_N_RACE_STR:
		exec_menu_race( &(mbr->race) );
		break;
	case DATA_N_RACE_NAME:
		print_msg( FLG_MSG_NO_MORE_NEXT, MSG_GETS_RACE_NAME,
				(long)RACE_NAME_MAX_LEN );
		gets_race_name( mbr );
		break;
	case DATA_N_SEX:
		exec_menu_sex( &(mbr->sex) );
		break;
	case DATA_N_CLASS:
		exec_menu_class( &(mbr->class_n) );
		break;
	case DATA_N_NEXT_PAGE:
		return +1;
	default:
		break;
	}

	return +-0;
}

/**/

bool_t	exec_menu_ask_edit_mbr_data( mbr_t *org_p, mbr_t *mbr_p )
{
	ask_t	ask;

	if( cmp_chr( org_p, mbr_p ) )
		return TRUE;

	ask = exec_menu_ask( MSG_TTL_MENU_ASK_EDIT_MBR, ASK_NO, TRUE );

	if( ask == ASK_YES ){
		*org_p = *mbr_p;
		return TRUE;
	} else if( ask == ASK_NO ){
		*mbr_p = *org_p;
		return TRUE;
	}

	return FALSE;	/* Cancel */
}

/**/

char	*cb_menu_mnstr_data( menu_t **pp, menu_t **dflt )
{
	mnstr_t	*mnstr;
	long	i;
	long	min_lev, max_lev;

	mnstr = get_mnstr( g_crsr.x, g_crsr.y );
	if( mnstr == NULL )
		return STR_MENU_ERR;

	min_lev = 1024;
	max_lev = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		min_lev = min( min_lev, mnstr->abl.lev[i].n );
		max_lev = max( max_lev, mnstr->abl.lev[i].n );
	}

	print_msg( FLG_NULL, MSG_MNSTR_DATA_NAME,
			mnstr->face_mjr, mnstr->face_mnr,
			mnstr->name );
	print_msg( FLG_NULL, MSG_MNSTR_DATA_MAX_LEV,
			mnstr->face_mjr, mnstr->face_mnr, max_lev );
	print_msg( FLG_MSG_MORE, MSG_MNSTR_DATA_MIN_LEV,
			mnstr->face_mjr, mnstr->face_mnr, min_lev );

	return NULL;
}

/**/

char	*cb_menu_sleep( menu_t **pp, menu_t **dflt )
{
	print_msg( FLG_NULL, MSG_S, MSG_INCOMPLETE );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_collect_gold( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	mbr_t	*mbr;

	if( g_sel_mbr_n <= -1 )
		return STR_MENU_ERR;

	mbr = pty->mbr[g_sel_mbr_n];
	collect_gold( mbr );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_divide_gold( menu_t **pp, menu_t **dflt )
{
	divide_gold();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr( menu_t **pp, menu_t **dflt )
{
	*pp = ls_menu_move_crsr;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_crsr_move(
	menu_t **pp, menu_t **dflt
)
{
	switch( (long)((*pp)->arg) ){
	case 1:
		g_crsr.x--;
		g_crsr.y++;
		break;
	case 2:
		g_crsr.y++;
		break;
	case 3:
		g_crsr.x++;
		g_crsr.y++;
		break;
	case 4:
		g_crsr.x--;
		break;
	case 6:
		g_crsr.x++;
		break;
	case 7:
		g_crsr.x--;
		g_crsr.y--;
		break;
	case 8:
		g_crsr.y--;
		break;
	case 9:
		g_crsr.x++;
		g_crsr.y--;
		break;
	default:
		return STR_MENU_ERR;
	}
	chk_scroll();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_quick_move(
	menu_t **pp, menu_t **dflt
)
{
	switch( (long)((*pp)->arg) ){
	case 1:
		jump_crsr( -1, +1 );
		break;
	case 2:
		jump_crsr( 0, +1 );
		break;
	case 3:
		jump_crsr( +1, +1 );
		break;
	case 4:
		jump_crsr( -1, 0 );
		break;
	case 6:
		jump_crsr( +1, 0 );
		break;
	case 7:
		jump_crsr( -1, -1 );
		break;
	case 8:
		jump_crsr( 0, -1 );
		break;
	case 9:
		jump_crsr( +1, -1 );
		break;
	default:
		return STR_MENU_ERR;
	}
	chk_scroll();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_scroll_center(
	menu_t **pp, menu_t **dflt
)
{
	scroll_center();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_mbr(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_mbr( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_mnstr(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_mnstr( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_item(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_item( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_door(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_door( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_obj(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_obj( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_square(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_square( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_next_pos_all(
	menu_t **pp, menu_t **dflt
)
{
	next_pos_all( +1 );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_prev_pos(
	menu_t **pp, menu_t **dflt
)
{
	prev_pos();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_back_log( menu_t **pp, menu_t **dflt )
{
	long	n, max_n;

	max_n = get_ls_msg_idx();
	n = max_n;

	print_log_back( max_n );

	while( 1 ){
		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			print_log_back( max_n );
			return STR_MENU_CANCEL;
		case CASE_ENTER:
			print_log_back( max_n );
			return NULL;
		case CASE_CRSR_UP:
			if( n <= 0 )
				continue;
			n--;
			break;
		case CASE_CRSR_LEFT:
			if( n <= 0 )
				continue;
			n -= get_ls_msg_page();
		case CASE_CRSR_DOWN:
			if( n >= max_n )
				continue;
			n++;
			break;
		case CASE_CRSR_RIGHT:
			if( n >= max_n )
				continue;
			n += get_ls_msg_page();
			break;
		default:
			continue;
		}

		if( n < 0 )
			n = 0;
		if( n > max_n )
			n = max_n;

		print_log_back( n );
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_msg( menu_t **pp, menu_t **dflt )
{
	long	n, max_n;

	if( chk_msg_mul_line() )
		return cb_menu_back_log( pp, dflt );

	n = 0;
	max_n = get_ls_msg_n();
	draw_ls_msg( n );
	while( 1 ){
		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			return STR_MENU_CANCEL;
		case CASE_ENTER:
			return NULL;
		case CASE_CRSR_UP:
		case CASE_CRSR_LEFT:
			if( n < max_n - LS_MSG_DRAW_N )
				n += LS_MSG_DRAW_N;
			else
				continue;
			break;
		case CASE_CRSR_DOWN:
		case CASE_CRSR_RIGHT:
			n -= LS_MSG_DRAW_N;
			if( n < 0 ){
				n = 0;
				continue;
			}
			break;
		default:
			continue;
		}

		draw_ls_msg( n );
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_out_map_file( menu_t **pp, menu_t **dflt )
{
	if( out_map_file() )
		return NULL;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_shell( menu_t **pp, menu_t **dflt )
{
	child_ps();

	return NULL;
}

/**/

char	*cb_menu_cnf( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	if( chk_flg( get_flg_party(), FLG_PARTY_SCROLL_SMOOTH ) ){
		p = srch_menu( *pp, "Scroll smooth" );
		set_menu_radio_item( *pp, p );
	} else if( chk_flg( get_flg_party(), FLG_PARTY_SCROLL_CENTER ) ){
		p = srch_menu( *pp, "Scroll center" );
		set_menu_radio_item( *pp, p );
	} else {
		p = srch_menu( *pp, "Scroll page" );
		set_menu_radio_item( *pp, p );
	}

	if( chk_msg_mul_line() )
		set_chk_on_menu( *pp, "Multi Message" );
	else
		set_chk_off_menu( *pp, "Multi Message" );

	return NULL;
}

/**/

char	*cb_menu_mbr_flg( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	flg_chr_t	flg;
	char	*ttl;
	menu_call_back_t	*cb;
	long	i;
	long	k;

	flg = (flg_chr_t)((*pp)->arg);
	switch( flg ){
	case FLG_CHR_AUTO_FIGHT:
		ttl = MSG_MENU_AUTO_FIGHT;
		cb = cb_menu_auto_fight;
		break;
	case FLG_CHR_AUTO_DOOR:
		ttl = MSG_MENU_AUTO_DOOR;
		cb = cb_menu_auto_door;
		break;
	case FLG_CHR_AVOID_TRAP:
		ttl = MSG_MENU_AVOID_TRAP;
		cb = cb_menu_avoid_trap;
		break;
	case FLG_CHR_AUTO_RELOAD:
		ttl = MSG_MENU_AUTO_RELOAD;
		cb = cb_menu_auto_reload;
		break;
	default:
		return STR_MENU_ERR;
	}

	ls = ls_menu_mbr_flg;
	k = 0;

	strncpy( ls[k].path, "/Config member flag",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = cb_menu_mbr_flg_init;
	ls[k].arg = (void *)flg;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Config member flag/Title",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, ttl, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		sprintf( ls[k].path, "/Config member flag/%ld", i );
		strncpy( ls[k].kind, "<CheckItem>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, pty->mbr[i]->name,
				MENU_MSG_MAX_LEN );
		ls[k].call_back = cb;
		ls[k].arg = (void *)pty->mbr[i];
		ls[k].flg = FLG_NULL;
		k++;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_mbr_flg_init( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	char	str[4 + 1];
	flg_chr_t	flg;
	long	i;

	flg = (flg_chr_t)((*pp)->arg);

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;

		sprintf( str, "%ld", i );
		if( chk_flg( pty->mbr[i]->flg_chr, flg ) )
			set_chk_on_menu( *pp, str );
		else
			set_chk_off_menu( *pp, str );
	}

	return NULL;
}

/**/

char	*cb_menu_auto_fight( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;

	mbr = (mbr_t *)((*pp)->arg);

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		mbr->flg_chr |= FLG_CHR_AUTO_FIGHT;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		mbr->flg_chr &= ~(FLG_CHR_AUTO_FIGHT);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_auto_door( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;

	mbr = (mbr_t *)((*pp)->arg);

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		mbr->flg_chr |= FLG_CHR_AUTO_DOOR;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		mbr->flg_chr &= ~(FLG_CHR_AUTO_DOOR);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_avoid_trap( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;

	mbr = (mbr_t *)((*pp)->arg);

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		mbr->flg_chr |= FLG_CHR_AVOID_TRAP;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		mbr->flg_chr &= ~(FLG_CHR_AVOID_TRAP);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_auto_reload( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;

	mbr = (mbr_t *)((*pp)->arg);

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		mbr->flg_chr |= FLG_CHR_AUTO_RELOAD;
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		mbr->flg_chr &= ~(FLG_CHR_AUTO_RELOAD);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_scroll_page( menu_t **pp, menu_t **dflt )
{
	flg_party_t	flg;

	flg = get_flg_party();
	flg &= ~(FLG_PARTY_SCROLL_SMOOTH | FLG_PARTY_SCROLL_CENTER);
	set_flg_party( flg );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_scroll_smooth( menu_t **pp, menu_t **dflt )
{
	flg_party_t	flg;

	flg = get_flg_party();
	flg &= ~(FLG_PARTY_SCROLL_CENTER);
	flg |= FLG_PARTY_SCROLL_SMOOTH;
	set_flg_party( flg );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_scroll_center( menu_t **pp, menu_t **dflt )
{
	flg_party_t	flg;

	flg = get_flg_party();
	flg &= ~(FLG_PARTY_SCROLL_SMOOTH);
	flg |= FLG_PARTY_SCROLL_CENTER;
	set_flg_party( flg );

	return STR_MENU_CANCEL;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_mul_msg_line( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		set_msg_mul_line( TRUE );
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		set_msg_mul_line( FALSE );
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_vfx( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	p = srch_menu( *pp, "Wait" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_VFX_WAIT, get_vfx_wait() );

	/* mbr */

	if( chk_flg( get_flg_vfx_mbr(), FLG_VFX_MBR_HP_ADD ) )
		set_chk_on_menu( *pp, "Member HP add" );
	else
		set_chk_off_menu( *pp, "Member HP add" );
	if( chk_flg( get_flg_vfx_mbr(), FLG_VFX_MBR_HP_SUB ) )
		set_chk_on_menu( *pp, "Member HP sub" );
	else
		set_chk_off_menu( *pp, "Member HP sub" );
	if( chk_flg( get_flg_vfx_mbr(), FLG_VFX_MBR_HP_SUB_CRTCL ) )
		set_chk_on_menu( *pp, "Member HP critical" );
	else
		set_chk_off_menu( *pp, "Member HP critical" );
	if( chk_flg( get_flg_vfx_mbr(), FLG_VFX_MBR_ARW ) )
		set_chk_on_menu( *pp, "Member arrow" );
	else
		set_chk_off_menu( *pp, "Member arrow" );

	/* mnstr */

	if( chk_flg( get_flg_vfx_mnstr(), FLG_VFX_MNSTR_HP_ADD ) )
		set_chk_on_menu( *pp, "Monster HP add" );
	else
		set_chk_off_menu( *pp, "Monster HP add" );
	if( chk_flg( get_flg_vfx_mnstr(), FLG_VFX_MNSTR_HP_SUB ) )
		set_chk_on_menu( *pp, "Monster HP sub" );
	else
		set_chk_off_menu( *pp, "Monster HP sub" );
	if( chk_flg( get_flg_vfx_mnstr(), FLG_VFX_MNSTR_HP_SUB_CRTCL ) )
		set_chk_on_menu( *pp, "Monster HP critical" );
	else
		set_chk_off_menu( *pp, "Monster HP critical" );
	if( chk_flg( get_flg_vfx_mnstr(), FLG_VFX_MNSTR_ARW ) )
		set_chk_on_menu( *pp, "Monster arrow" );
	else
		set_chk_off_menu( *pp, "Monster arrow" );

	return NULL;
}

/**/

char	*cb_menu_vfx_wait( menu_t **pp, menu_t **dflt )
{
	long	n;
	char	*ret;

	n = get_vfx_wait();

	ret = exec_menu_sel_num( VFX_WAIT_MIN_N, VFX_WAIT_MAX_N, &n );
	if( ret == NULL ){
		set_vfx_wait( n );
		sprintf( (*pp)->msg, MSG_MENU_VFX_WAIT, n );
		return STR_MENU_CANCEL;
	}

	return ret;
}

/**/

char	*cb_menu_vfx_mbr( menu_t **pp, menu_t **dflt )
{
	flg_vfx_mbr_t	flg;

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		flg = get_flg_vfx_mbr();
		flg |= (flg_vfx_mbr_t)((*pp)->arg);
		set_flg_vfx_mbr( flg );
	} else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) ){
		flg = get_flg_vfx_mbr();
		flg &= ~((flg_vfx_mbr_t)((*pp)->arg));
		set_flg_vfx_mbr( flg );
	} else {
		return STR_MENU_ERR;
	}

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_vfx_mnstr( menu_t **pp, menu_t **dflt )
{
	flg_vfx_mnstr_t	flg;

	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		flg = get_flg_vfx_mnstr();
		flg |= (flg_vfx_mnstr_t)((*pp)->arg);
		set_flg_vfx_mnstr( flg );
	} else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) ){
		flg = get_flg_vfx_mnstr();
		flg &= ~((flg_vfx_mnstr_t)((*pp)->arg));
		set_flg_vfx_mnstr( flg );
	} else {
		return STR_MENU_ERR;
	}

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_color( menu_t **pp, menu_t **dflt )
{
	curs_attr_t	*attr;
	menu_t	*ls;
	curs_attr_n_t	i;
	long	k;

	attr = get_curs_attr();
	ls = ls_menu_color;
	k = 0;

	sprintf( ls[k].path, "/Color" );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	sprintf( ls[k].path, "/Color/Title" );
	strncpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_MENU_COLOR, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < CURS_ATTR_MAX_N; i++ ){
		if( i == CURS_ATTR_N_MBR_1 ){
			strncpy( ls[k].path, "/Color/Page Separator",
					MENU_PATH_MAX_LEN );
			strncpy( ls[k].kind, "<PageSeparator>",
					MENU_KIND_MAX_LEN );
			ls[k].key = '\0';
			ls[k].accel_key[0] = '\0';
			ls[k].n_msg = N_MSG_NULL;
			ls[k].msg[0] = '\0';
			ls[k].call_back = NULL;
			ls[k].arg = NULL;
			ls[k].flg = FLG_NULL;
			k++;
		}
		sprintf( ls[k].path, "/Color/%ld", (long)i );
		strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, MSG( attr[i].name_n ),
				MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_color_sel;
		ls[k].arg = (void *)&(attr[i]);
		ls[k].flg = FLG_NULL;
		k++;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_color_sel( menu_t **pp, menu_t **dflt )
{
	g_sel_attr = (curs_attr_t *)((*pp)->arg);

	*pp = ls_menu_color_sel;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_fg_init( menu_t **pp, menu_t **dflt )
{
	menu_color_init( pp, dflt, g_sel_attr->fg );

	return NULL;
}

/**/

char	*cb_menu_bg_init( menu_t **pp, menu_t **dflt )
{
	menu_color_init( pp, dflt, g_sel_attr->bg );

	return NULL;
}

/**/

void	menu_color_init( menu_t **pp, menu_t **dflt, int color )
{
	menu_t	*p;

	p = NULL;

	switch( color ){
	case COLOR_BLACK:
		p = srch_menu( *pp, "Black" );
		break;
	case COLOR_RED:
		p = srch_menu( *pp, "Red" );
		break;
	case COLOR_GREEN:
		p = srch_menu( *pp, "Green" );
		break;
	case COLOR_YELLOW:
		p = srch_menu( *pp, "Yellow" );
		break;
	case COLOR_BLUE:
		p = srch_menu( *pp, "Blue" );
		break;
	case COLOR_MAGENTA:
		p = srch_menu( *pp, "Magenta" );
		break;
	case COLOR_CYAN:
		p = srch_menu( *pp, "Cyan" );
		break;
	case COLOR_WHITE:
		p = srch_menu( *pp, "White" );
		break;
	}

	*dflt = p;
}

/**/

char	*cb_menu_fg( menu_t **pp, menu_t **dflt )
{
	int	color;

	color = (int)((*pp)->arg);
	if( color == g_sel_attr->bg )
		g_sel_attr->bg = g_sel_attr->fg;
	g_sel_attr->fg = color;

	init_curs_color_pair( g_sel_attr, g_sel_attr->color_pair_n );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_bg( menu_t **pp, menu_t **dflt )
{
	int	color;

	color = (int)((*pp)->arg);
	if( color == g_sel_attr->fg )
		g_sel_attr->fg = g_sel_attr->bg;
	g_sel_attr->bg = color;

	init_curs_color_pair( g_sel_attr, g_sel_attr->color_pair_n );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_attr_init( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( g_sel_attr->attr, A_UNDERLINE ) )
		set_chk_on_menu( *pp, "Underline" );
	else
		set_chk_off_menu( *pp, "Underline" );

	if( chk_flg( g_sel_attr->attr, A_REVERSE ) )
		set_chk_on_menu( *pp, "Reverse" );
	else
		set_chk_off_menu( *pp, "Reverse" );

	if( chk_flg( g_sel_attr->attr, A_BLINK ) )
		set_chk_on_menu( *pp, "Blink" );
	else
		set_chk_off_menu( *pp, "Blink" );

	if( chk_flg( g_sel_attr->attr, A_BOLD ) )
		set_chk_on_menu( *pp, "Bold" );
	else
		set_chk_off_menu( *pp, "Bold" );

	return NULL;
}

/**/

char	*cb_menu_attr( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		g_sel_attr->attr |= (chtype)((*pp)->arg);
	else if( chk_flg( (*pp)->flg, FLG_MENU_CHK_OFF ) )
		g_sel_attr->attr &= ~(chtype)((*pp)->arg);
	else
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_crsr_ptn( menu_t **pp, menu_t **dflt )
{
	long	*p, *max_p, n;
	char	*ret;

	p = get_crsr_ptn_n();
	max_p = get_crsr_ptn_max_n();
	if( (p == NULL) || (max_p == NULL) )
		return STR_MENU_ERR;

	n = *p + 1;

	print_msg( FLG_NULL, MSG_S, MSG_MENU_CRSR_PTN_SEL );
	ret = exec_menu_sel_num( 1, *max_p, &n );
	if( ret != NULL )
		return ret;

	*p = n - 1;
	reset_crsr_ptn();

	return NULL;
}

/**/

char	*cb_menu_wizard_on_light( menu_t **pp, menu_t **dflt )
{
	on_light_area( g_crsr.x, g_crsr.y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return NULL;
}

/**/

char	*cb_menu_wizard_off_light( menu_t **pp, menu_t **dflt )
{
	off_light_area( g_crsr.x, g_crsr.y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return NULL;
}

/**/

char	*cb_menu_about_game( menu_t **pp, menu_t **dflt )
{
	about_game();

	return NULL;
}

/**/

char	*cb_menu_exit( menu_t **pp, menu_t **dflt )
{
	ask_t	ask;

	ask = exec_menu_ask( MSG_TTL_MENU_EXIT, ASK_NO, TRUE );

	if( ask == ASK_YES )
		exit_game( EXIT_SUCCESS );
	if( ask == ASK_ERR )
		return STR_MENU_ERR;

	return STR_MENU_CANCEL;
}

/**/

bool_t	exec_menu_identify_item( mbr_t *mbr )
{
	menu_t	*ls;
	item_t	*item, *p;
	char	*ret;
	long	j, k;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	if( chk_flg_or( mbr->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		print_msg( FLG_NULL, MSG_ERR_MENU_SEL_ITEM, mbr->name );
		return FALSE;
	}

	ls = ls_menu_identify_item;
	k = 0;

	strncpy( ls[k].path, "/Identify item",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Identify item/--",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg,
			mbr->name, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	item = get_mbr_item_asgn( mbr );
	p = item->next;
	for( j = 0; j < MBR_ITEM_MAX_N; j++, k++, p = p->next ){
		if( p == item )
			break;

		sprintf( ls[k].path,
				"/Identify item/%c",
				(char)('A' + j) );
		strncpy( ls[k].kind, "<Item>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + j;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, p->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_identify_item;
		ls[k].arg = (void *)p;
		ls[k].flg = FLG_NULL;
	}
	ls[k].path[0] = '\0';

	print_msg( FLG_NULL, MSG_S, MSG_FX_IDENTIFY_ITEM );

	ret = exec_menu( ls, NULL, NULL );
	if( ret == NULL )
		return TRUE;
	if( strcmp( ret, STR_MENU_ERR ) == 0 )
		return FALSE;
	if( strcmp( ret, STR_MENU_CANCEL ) == 0 )
		return FALSE;

	return FALSE;
}

/**/

char	*cb_menu_identify_item( menu_t **pp, menu_t **dflt )
{
	identify_item( (item_t *)((*pp)->arg) );

	return NULL;
}

/**/

bool_t	exec_menu_resurrection( mbr_t *mbr )
{
	party_t	*pty = get_party();
	menu_t	*ls;
	char	*ret;
	long	dead_mbr_n;
	long	i, k;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	if( chk_flg_or( mbr->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	dead_mbr_n = 0;
	ls = ls_menu_resurrection;
	k = 0;

	strncpy( ls[k].path, "/resurrection",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/resurrection/--",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	strncpy( ls[k].msg, MSG_TTL_MENU_RESURRECTION,
			MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			continue;
		if( !chk_flg( pty->mbr[i]->stat, FLG_STAT_DEAD ) )
			continue;

		sprintf( ls[k].path, "/resurrection/%c",
				(char)('A' + i) );
		strncpy( ls[k].kind, "<Item>",
				MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + i;
		ls[k].accel_key[0] = '\0';
		ls[k].n_msg = N_MSG_NULL;
		strncpy( ls[k].msg, pty->mbr[i]->name, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_resurrection;
		ls[k].arg = pty->mbr[i];
		ls[k].flg = FLG_NULL;
		k++;

		dead_mbr_n++;
	}
	ls[k].path[0] = '\0';

	if( dead_mbr_n <= 0 ){
		print_msg( FLG_NULL, MSG_S,
				MSG_MENU_RESURRECTION_ERR_ALL_MBR );
		return FALSE;
	}

	print_msg( FLG_NULL, MSG_S, MSG_TTL_MENU_RESURRECTION );

	ret = exec_menu( ls, NULL, NULL );
	if( ret == NULL )
		return TRUE;
	if( strcmp( ret, STR_MENU_ERR ) == 0 )
		return FALSE;
	if( strcmp( ret, STR_MENU_CANCEL ) == 0 )
		return FALSE;

	return FALSE;
}

/**/

char	*cb_menu_resurrection( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;
	rate_t	rate;

	mbr = (mbr_t *)((*pp)->arg);
	if( mbr == NULL )
		return STR_MENU_ERR;

	rate = _100_PERCENT - mbr->fx_data.nicotine.poisoning_rate;
	rate *= (RESURRECTION_MAX_RATE - RESURRECTION_MIN_RATE);
	rate /= _100_PERCENT;
	rate += RESURRECTION_MIN_RATE;

	if( !rate_randm( rate ) ){
		print_msg( FLG_NULL, MSG_MENU_RESURRECTION_FAILURE,
				mbr->name );
		return NULL;
	}

	if( !resurrection( mbr ) ){
		print_msg( FLG_NULL, MSG_MENU_RESURRECTION_FAILURE,
				mbr->name );
		return NULL;
	}

	print_msg_n( CURS_ATTR_N_FX_MBR_PLUS, FLG_NULL,
			MSG_MENU_RESURRECTION, mbr->name );

	return NULL;
}

/**/

void	sel_menu_clr( draw_menu_t *data )
{
	long	pre_n;

	pre_n = data->sel_n;
	data->sel_n = DRAW_MENU_CLR_N;

	draw_menu( data );

	data->sel_n = pre_n;
}

/**/

menu_t	*sel_menu( menu_t *p, menu_t *dflt )
{
	static draw_menu_t	data;
	menu_t	*tmp_p;
	long	page_sel_n, page_max_n;
	long	n, sel_n, max_n;
	bool_t	flg_head;
	int	i;

	if( p == NULL )
		return NULL;

	page_sel_n = 0;
	page_max_n = 0;
	sel_n = 0;
	max_n = 0;
	tmp_p = p;
	flg_head = TRUE;
	for( i = 0, n = 0; i < 4096; i++ ){
		tmp_p++;
		tmp_p = srch_next_menu( p, tmp_p, TRUE );
		if( tmp_p == NULL )
			break;

		if( flg_head ){
			flg_head = FALSE;
			page_max_n++;
		}

		if( tmp_p == dflt ){
			page_sel_n = page_max_n - 1;
			sel_n = n;
		}

		if( strcmp( tmp_p->kind, "<Title>" ) == 0 ){
			;
		} else if( strcmp( tmp_p->kind, "<Separator>" ) == 0 ){
			;
		} else if( strcmp( tmp_p->kind, "<PageSeparator>" ) == 0 ){
			n = 0;
			flg_head = TRUE;
		} else {
			n++;
		}
	}

	max_n = set_ls_menu( &data, p, page_sel_n );
	if( max_n <= 0 )
		return NULL;

	while( 1 ){
		long	dx, dy;
		long	key;
		long	i;

		data.sel_n = sel_n;
		data.flg_min_page = (page_sel_n > 0);
		data.flg_max_page = (page_sel_n < page_max_n - 1);

		draw_menu( &data );
		data.flg_redraw = FALSE;

		dx = 0;
		dy = 0;
		key = get_key( FALSE );

		switch( key ){
		case '\0':
			break;
		default:
			for( i = 0; i < max_n; i++ )
				if( data.ls[i]->key == key )
					break;
			if( i >= max_n )
				break;

			sel_n = i;
			sel_menu_clr( &data );
			return( data.ls[sel_n] );
		case CASE_ENTER:
			sel_menu_clr( &data );
			return( data.ls[sel_n] );
		case CASE_CANCEL:
			sel_menu_clr( &data );
			return NULL;
		case CASE_CRSR_UP:
			dy = -1;
			break;
		case CASE_CRSR_DOWN:
			dy = +1;
			break;
		case CASE_CRSR_LEFT:
			dx = -1;
			break;
		case CASE_CRSR_RIGHT:
			dx = +1;
			break;
		case CASE_CRSR_UP_LEFT:
			dx = -1;
			dy = -1;
			break;
		case CASE_CRSR_UP_RIGHT:
			dx = +1;
			dy = -1;
			break;
		case CASE_CRSR_DOWN_LEFT:
			dx = -1;
			dy = +1;
			break;
		case CASE_CRSR_DOWN_RIGHT:
			dx = +1;
			dy = +1;
			break;
		}

		if( dy != +-0 ){
			sel_n += dy;
			sel_n += max_n;
			sel_n %= max_n;
		}
		if( dx != +-0 ){
			page_sel_n += dx;
			page_sel_n += page_max_n;
			page_sel_n %= page_max_n;

			sel_menu_clr( &data );

			max_n = set_ls_menu( &data, p, page_sel_n );

			if( max_n <= 0 )
				return NULL;
			if( sel_n > max_n - 1 )
				sel_n = max_n - 1;
		}
	}

	return NULL;
}

/**/

long	set_ls_menu(
	draw_menu_t *data,
	menu_t *p,
	long page_sel_n
)
{
	long	n;
	long	page_n;
	menu_t	*tmp_p;
	bool_t	key_tab[256];
	long	i;

	if( p == NULL )
		return 0;

	data->ttl = NULL;
	data->ls[0] = NULL;
	data->sel_n = 0;
	data->prev_sel_n = 0;
	data->flg_min_page = FALSE;
	data->flg_max_page = FALSE;
	data->flg_redraw = TRUE;

	for( i = 0; i < 256; i++ )
		key_tab[i] = FALSE;

	n = 0;
	page_n = 0;
	tmp_p = p;
	for( i = 0; i < 4096; i++ ){
		tmp_p++;
		tmp_p = srch_next_menu( p, tmp_p, TRUE );
		if( tmp_p == NULL )
			break;

		if( tmp_p->msg[0] == '\0' )
			strcpy( tmp_p->msg, MSG( tmp_p->n_msg ) );

		if( page_n == page_sel_n ){
			if( strcmp( tmp_p->kind, "<Title>" ) == 0 ){
				data->ttl = tmp_p->msg;
			} else if( strcmp( tmp_p->kind,
					"<Separator>" ) == 0 ){
				;
			} else if( strcmp( tmp_p->kind,
					"<PageSeparator>" ) == 0 ){
				;
			} else {
#ifndef	NDEBUG
				if( key_tab[tmp_p->key] ){
					print_msg( FLG_NULL,
							MSG_ERR_ACCEL_KEY,
							tmp_p->key,
							tmp_p->msg );
				}
				key_tab[tmp_p->key] = TRUE;
#endif
				data->ls[n] = tmp_p;
				n++;
				data->ls[n] = NULL;
			}
		}
		if( page_n > page_sel_n )
			break;
		if( strcmp( tmp_p->kind, "<PageSeparator>" ) == 0 ){
			if( page_n == page_sel_n )
				break;
			page_n++;
		}
	}

	if( data->sel_n > n )
		data->sel_n = n;

	return n;
}

/**/

menu_t	*srch_menu( menu_t *ls, char *sub_path )
{
	long	idx;
	menu_t *p;

	if( ls == NULL )
		return NULL;
	if( ls->path[0] == '\0' )
		return NULL;
	if( sub_path == NULL )
		return NULL;

	idx = str_len_std( ls->path ) + 1;
	for( p = &(ls[1]); p->path[0] != '\0'; p++ ){
		p = srch_next_menu( ls, p, FALSE );
		if( p == NULL )
			return NULL;

		if( strcmp( &(p->path[idx]), sub_path ) == 0 )
			return p;
	}

	return NULL;
}

/**/

menu_t	*srch_next_menu(
	menu_t *ls, menu_t *p, bool_t flg_skip_hidden
)
{
	long	idx;

	if( ls == NULL )
		return NULL;
	if( p == NULL )
		return NULL;
	if( ls->path[0] == '\0' )
		return NULL;
	if( p->path[0] == '\0' )
		return NULL;

	if( strcmp( ls->path, "/" ) == 0 )
		idx = 0;
	else
		idx = str_len_std( ls->path );

	for( ; ; p++ ){
		if( p->path[0] == '\0' )
			return NULL;

		if( idx > 0 )
			if( strncmp( ls->path, p->path, idx ) != 0 )
				return NULL;

		if( flg_skip_hidden )
			if( chk_flg( p->flg, FLG_MENU_HIDDEN ) )
				continue;

		if( strchr( &(p->path[idx + 1]), '/' ) == NULL )
			return p;
	}

	return NULL;
}

/**/

menu_t	*srch_goto_menu( menu_t *p, char *str_goto )
{
	long	len_goto;
	menu_t *tmp_p;

	if( p == NULL )
		return NULL;
	if( p->path[0] == '\0' )
		return NULL;
	if( str_goto == NULL )
		return NULL;
	if( strcmp( p->kind, "<Branch>" ) != 0 )
		return NULL;

	len_goto = str_len_std( str_goto );

	for( tmp_p = &p[1]; tmp_p->path[0] != '\0'; tmp_p++ ){
		long	len;

		len = str_len_std( p->path );
		if( strncmp( tmp_p->path, p->path, len ) != 0 )
			return NULL;

		len = str_len_std( tmp_p->path );
		if( strncmp( tmp_p->path, str_goto, len ) == 0 ){
			if( len == len_goto ){
				return tmp_p;
			} else if( len < len_goto ){
				if( str_goto[len] == '/' )
					return tmp_p;
			} else {
				return NULL;
			}
		}
	}

	return NULL;
}

/**/

void	set_chk_on_menu( menu_t *p, char *sub_path )
{
	set_flg_menu( p, sub_path, FLG_MENU_CHK_ON );
	clr_flg_menu( p, sub_path, FLG_MENU_CHK_OFF );
}

/**/

void	set_chk_off_menu( menu_t *p, char *sub_path )
{
	clr_flg_menu( p, sub_path, FLG_MENU_CHK_ON );
	set_flg_menu( p, sub_path, FLG_MENU_CHK_OFF );
}

/**/

bool_t	set_flg_menu( menu_t *p, char *sub_path, unsigned long flg )
{
	return equ_flg_menu( p, sub_path, flg, TRUE );
}

/**/

bool_t	clr_flg_menu( menu_t *p, char *sub_path, unsigned long flg )
{
	return equ_flg_menu( p, sub_path, flg, FALSE );
}

/**/

bool_t	equ_flg_menu(
	menu_t *p, char *sub_path, unsigned long flg, bool_t flg_set
)
{
	static char	path[255 + 1];
	const long	len = sizeof( path ) - 1;
	menu_t	*tmp_p;
	bool_t	flg_find;

	if( p == NULL )
		return FALSE;

	path[0] = '\0';
	if( sub_path != NULL ){
		if( strcmp( p->path, "/" ) != 0 )
			strncpy( path, p->path, len );
		str_max_n_cat( path, "/", len );
		str_max_n_cat( path, sub_path, len );
	}

	flg_find = FALSE;
	for( tmp_p = &p[1]; tmp_p->path[0] != '\0'; tmp_p++ ){
		tmp_p = srch_next_menu( p, tmp_p, FALSE );
		if( tmp_p == NULL )
			break;

		if( sub_path != NULL )
			if( strcmp( tmp_p->path, path ) != 0 )
				continue;

		if( flg_set )
			tmp_p->flg |= flg;
		else
			tmp_p->flg &= ~flg;

		flg_find = TRUE;
	}

	if( !flg_find && (sub_path != NULL) )
		print_msg( FLG_NULL, MSG_ERR_MENU_SRCH_PATH, path );

	return flg_find;
}

/**/

bool_t	prev_pos( void )
{
	bool_t	flg;

	flg = FALSE;
	switch( g_next_pos.kind ){
	case NEXT_POS_KIND_SQUARE:
		flg = next_pos_square( -1 );
		break;
	case NEXT_POS_KIND_MBR:
		flg = next_pos_mbr( -1 );
		break;
	case NEXT_POS_KIND_DOOR:
		flg = next_pos_door( -1 );
		break;
	case NEXT_POS_KIND_OBJ:
		flg = next_pos_obj( -1 );
		break;
	case NEXT_POS_KIND_MNSTR:
		flg = next_pos_mnstr( -1 );
		break;
	}

	return flg;
}

/**/

bool_t	next_pos_square( long d )
{
	party_t *pty;
	void	*pre_p;

	pty = get_party();
	pre_p = g_next_pos.p;

	g_next_pos.kind = NEXT_POS_KIND_SQUARE;
	g_next_pos.p = &(pty->square);
	g_next_pos.n = 0;
	g_next_pos.x = pty->square.x;
	g_next_pos.y = pty->square.y;

	g_crsr.x = g_next_pos.x;
	g_crsr.y = g_next_pos.y;
	chk_scroll();

	return( pre_p == g_next_pos.p );
}

/**/

bool_t	next_pos_mbr( long d )
{
	party_t *pty;
	bool_t	flg;
	long	n;
	long	i, j;

	pty = get_party();

	flg = FALSE;
	if( g_next_pos.kind == NEXT_POS_KIND_MBR ){
		if( (g_crsr.x == g_next_pos.x)
				&& (g_crsr.y == g_next_pos.y) ){
			n = g_next_pos.n;
			for( i = 0; i < abs( d ); i++ ){
				for( j = 0; j < MBR_MAX_N; j++ ){
					n += sgn( d );
					if( n >= MBR_MAX_N ){
						n = 0;
						flg = TRUE;
					} else if( n < 0 ){
						n = MBR_MAX_N - 1;
						flg = TRUE;
					}
					if( !chk_flg_or( pty->mbr[n]->stat,
							FLG_STAT_NOT_EXIST
							| FLG_STAT_DEAD ) ){
						break;
					}
				}
			}
		} else {
			n = g_next_pos.n;
		}
	} else {
		n = 0;
		for( j = 0; j < MBR_MAX_N; j++ ){
			if( n >= MBR_MAX_N ){
				n = 0;
				flg = TRUE;
			}
			if( !chk_flg( pty->mbr[n]->stat, FLG_STAT_NOT_EXIST )
					&& !chk_flg( pty->mbr[n]->stat,
					FLG_STAT_DEAD ) ){
				break;
			}
			n++;
		}
	}
	g_next_pos.kind = NEXT_POS_KIND_MBR;
	g_next_pos.p = pty->mbr[n];
	g_next_pos.n = n;
	g_next_pos.x = pty->mbr[n]->x;
	g_next_pos.y = pty->mbr[n]->y;

	g_crsr.x = g_next_pos.x;
	g_crsr.y = g_next_pos.y;
	chk_scroll();

	return flg;
}

/**/

bool_t	next_pos_door( long d )
{
	dun_t	*dun;
	pos_t	*draw;
	long	mx, my;
	long	dr_n;
	long	n;
	bool_t	flg, flg_cont, flg_find;
	long	pre_n;

	dun = get_dun();
	draw = get_map_draw_pos();
	mx = g_crsr.x;
	my = g_crsr.y;
	dr_n = dun->door_n;
	flg = FALSE;
	flg_find = FALSE;

	if( dun->door_n <= 0 )
		return TRUE;

	if( g_next_pos.kind == NEXT_POS_KIND_DOOR ){
		pre_n = g_next_pos.n;
		/* ưʤä? */
		if( (mx == g_next_pos.x) && (my == g_next_pos.y) ){
			n = (g_next_pos.n + d + dr_n) % dr_n;
			flg_cont = TRUE;
		} else {
			/* ⤦ƱȤޡ */
			n = g_next_pos.n;
			flg_cont = FALSE;
		}
	} else {
		if( d >= +1 )
			n = 0;
		else
			n = dr_n - 1;
		pre_n = n;

		flg_cont = FALSE;
	}

	do {
		door_t	*dr = &(dun->door[n]);

		/* ꤷ`å */
		if( flg_cont ){
			if( (d >= +1) && (n == 0) )
				flg = TRUE;
			if( (d <= -1) && (n == dr_n - 1) )
				flg = TRUE;
		}

		if( (dr->x + dr->dx - 1) < draw->x )
			continue;
		if( (dr->y + dr->dy - 1) < draw->y )
			continue;
		if( dr->x > (draw->x + WIN_MAP_WIDTH - 1) )
			continue;
		if( dr->y > (draw->y + WIN_MAP_HEIGHT - 1) )
			continue;
		if( chk_flg( dr->flg, FLG_DOOR_SECRET ) )
			continue;

		/* ɥ򸫤Ĥ */
		flg_find = TRUE;
		g_next_pos.kind = NEXT_POS_KIND_DOOR;
		g_next_pos.p = dr;
		g_next_pos.n = dr->n;

		if( mx < dr->x )
			g_next_pos.x = dr->x;
		else if( (dr->x + dr->dx - 1) < mx )
			g_next_pos.x = dr->x + dr->dx - 1;
		else
			g_next_pos.x = mx;

		if( my < dr->y )
			g_next_pos.y = dr->y;
		else if( (dr->y + dr->dy - 1) < my )
			g_next_pos.y = dr->y + dr->dy - 1;
		else
			g_next_pos.y = my;

		g_crsr.x = g_next_pos.x;
		g_crsr.y = g_next_pos.y;
		chk_scroll();

		break;
	} while( n = (n + d + dr_n) % dr_n, n != pre_n );

	if( flg_cont && (n == pre_n) )
		flg = TRUE;
	if( !flg_find )
		flg = TRUE;

	return flg;
}

/**/

bool_t	next_pos_item( long d )
{
	return next_pos_item_obj( d, TRUE );
}

/**/

bool_t	next_pos_obj( long d )
{
	return next_pos_item_obj( d, FALSE );
}

/**/

bool_t	next_pos_item_obj( long d, bool_t flg_item )
{
	dun_t	*dun;
	pos_t	*draw;
	long	dx, dy;
	long	c;
	bool_t	flg_ret, flg_reset;

	dun = get_dun();
	draw = get_map_draw_pos();

	flg_reset = FALSE;

	c = dun->map.obj.mjr[g_crsr.y][g_crsr.x];
	switch( c ){
	case FACE_MJR_NULL:
	case FACE_MJR_WALL:
	case FACE_MJR_FLOOR:
	case FACE_MJR_DOOR_CLOSE:
	case FACE_MJR_DOOR_OPEN:
		flg_reset = TRUE;
		break;
	case FACE_MJR_STAIRS_UP:
	case FACE_MJR_STAIRS_DOWN:
	case FACE_MJR_TRAP:
		if( flg_item )
			flg_reset = TRUE;
		break;
	default:
		flg_reset = FALSE;
		break;
	}
	if( flg_reset ){
		/* ǽ餫 */
		if( d >= +1 ){
			dx = 0;
			dy = 0;
		} else {
			dx = WIN_MAP_WIDTH - 1;
			dy = WIN_MAP_HEIGHT - 1;
		}
	} else {
		/* Ϥ */
		dx = g_crsr.x - draw->x + d;
		dy = g_crsr.y - draw->y;

		if( !chk_flg( dun->map.obj.flg[g_crsr.y][g_crsr.x],
				FLG_OBJ_FIND ) ){
			if( d >= +1 ){
				dx = 0;
				dy = 0;
			} else {
				dx = WIN_MAP_WIDTH - 1;
				dy = WIN_MAP_HEIGHT - 1;
			}
		}
	}

	g_next_pos.kind = NEXT_POS_KIND_OBJ;
	g_next_pos.p = NULL;
	g_next_pos.n = 0;

	flg_ret = FALSE;
	if( next_pos_item_obj_sub( &dx, &dy, d, flg_item ) ){
		flg_ret = FALSE;
	} else {
		if( d >= +1 ){
			dx = 0;
			dy = 0;
		} else {
			dx = WIN_MAP_WIDTH - 1;
			dy = WIN_MAP_HEIGHT - 1;
		}
		if( next_pos_item_obj_sub( &dx, &dy, d, flg_item ) ){
			flg_ret = TRUE;
		} else {
			return TRUE;
		}
	}

	g_next_pos.x = draw->x + dx;
	g_next_pos.y = draw->y + dy;

	g_crsr.x = g_next_pos.x;
	g_crsr.y = g_next_pos.y;
	chk_scroll();

	return flg_ret;
}

/**/

bool_t	next_pos_item_obj_sub( long *dx, long *dy, long d, bool_t flg_item )
{
	dun_t	*dun;
	pos_t	*draw;
	long	c;

	dun = get_dun();
	draw = get_map_draw_pos();

	for( ; *dy < WIN_MAP_HEIGHT; (*dy) += d ){
		if( *dy < 0 )
			break;

		for( ; *dx < WIN_MAP_WIDTH; (*dx) += d ){
			if( *dx < 0 )
				break;

			c = dun->map.obj.mjr[draw->y + *dy]
					[draw->x + *dx];
			switch( c ){
			case FACE_MJR_NULL:
			case FACE_MJR_WALL:
			case FACE_MJR_FLOOR:
			case FACE_MJR_DOOR_CLOSE:
			case FACE_MJR_DOOR_OPEN:
				continue;
			case FACE_MJR_STAIRS_UP:
			case FACE_MJR_STAIRS_DOWN:
			case FACE_MJR_TRAP:
				if( flg_item )
					continue;
				/* break; */
			default:
				if( !chk_flg( dun->map.obj.flg[draw->y + *dy]
						[draw->x + *dx],
						FLG_OBJ_FIND ) ){
					continue;
				}
				return TRUE;
			}
		}
		if( d >= +1 ){
			*dx = 0;
		} else {
			*dx = WIN_MAP_WIDTH - 1;
		}
	}
	return FALSE;
}

/**/

bool_t	next_pos_mnstr( long d )
{
	dun_t	*dun;
	pos_t	*draw;
	long	dx, dy;
	long	c;
	flg_map_t	flg;
	bool_t	flg_find;

	dun = get_dun();
	draw = get_map_draw_pos();

	flg = dun->map.chr.flg[g_crsr.y][g_crsr.x];
	if( chk_flg( flg, FLG_CHR_INVISIBLE ) ){
		/* ʤ󥹥ʤ */
		c = FACE_MJR_NULL;
	} else {
		c = dun->map.chr.mjr[g_crsr.y][g_crsr.x];
	}
	if( (c == FACE_MJR_MBR) || (c == FACE_MJR_NULL) ){
		/* ǽ餫 */
		if( d >= +1 ){
			dx = 0;
			dy = 0;
		} else {
			dx = WIN_MAP_WIDTH - 1;
			dy = WIN_MAP_HEIGHT - 1;
		}
	} else {
		flg_map_t	flg;

		/* Ϥ */
		dx = g_crsr.x - draw->x + d;
		dy = g_crsr.y - draw->y;

		flg = dun->map.chr.flg[g_crsr.y][g_crsr.x];
		if( !chk_flg( flg, FLG_CHR_FIND ) ){
			if( d >= +1 ){
				dx = 0;
				dy = 0;
			} else {
				dx = WIN_MAP_WIDTH - 1;
				dy = WIN_MAP_HEIGHT - 1;
			}
		}
	}

	g_next_pos.kind = NEXT_POS_KIND_MNSTR;
	g_next_pos.p = NULL;
	g_next_pos.n = 0;

	flg_find = FALSE;
	if( next_pos_mnstr_sub( &dx, &dy, d ) ){
		flg_find = FALSE;
	} else {
		if( d >= +1 ){
			dx = 0;
			dy = 0;
		} else {
			dx = WIN_MAP_WIDTH - 1;
			dy = WIN_MAP_HEIGHT - 1;
		}
		if( next_pos_mnstr_sub( &dx, &dy, d ) ){
			flg_find = TRUE;
		} else {
			return TRUE;
		}
	}

	g_next_pos.x = draw->x + dx;
	g_next_pos.y = draw->y + dy;

	g_crsr.x = g_next_pos.x;
	g_crsr.y = g_next_pos.y;
	chk_scroll();

	return flg_find;
}

/**/

bool_t	next_pos_mnstr_sub( long *dx, long *dy, long d )
{
	dun_t	*dun;
	pos_t	*draw;
	long	c;

	dun = get_dun();
	draw = get_map_draw_pos();

	for( ; *dy < WIN_MAP_HEIGHT; (*dy) += d ){
		if( *dy < 0 )
			break;

		for( ; *dx < WIN_MAP_WIDTH; (*dx) += d ){
			if( *dx < 0 )
				break;

			if( chk_flg( dun->map.chr.flg[g_crsr.y][g_crsr.x],
					FLG_CHR_INVISIBLE ) ){
				/* ʤ󥹥ʤ */
				c = FACE_MJR_NULL;
			} else {
				c = dun->map.chr.mjr[draw->y + *dy]
						[draw->x + *dx];
			}
			if( (c == FACE_MJR_MBR) || (c == FACE_MJR_NULL) ){
				continue;
			} else {
				if( !chk_flg( dun->map.chr.flg[draw->y + *dy]
						[draw->x + *dx],
						FLG_OBJ_FIND ) ){
					continue;
				}
				return TRUE;
			}
		}
		if( d >= +1 ){
			*dx = 0;
		} else {
			*dx = WIN_MAP_WIDTH - 1;
		}
	}
	return FALSE;
}

/**/

bool_t	next_pos_all( long d )
{
	bool_t	flg;

	flg = FALSE;
	if( g_next_pos.kind == NEXT_POS_KIND_SQUARE ){
		flg = next_pos_square( +1 );
	}
	if( flg || (g_next_pos.kind == NEXT_POS_KIND_MBR) ){
		flg = next_pos_mbr( +1 );
	}
	if( flg || (g_next_pos.kind == NEXT_POS_KIND_MNSTR) ){
		flg = next_pos_mnstr( +1 );
	}
	if( flg || (g_next_pos.kind == NEXT_POS_KIND_OBJ) ){
		flg = next_pos_obj( +1 );
	}
	if( flg || (g_next_pos.kind == NEXT_POS_KIND_DOOR) ){
		flg = next_pos_door( +1 );
	}
	if( flg ){
		next_pos_square( +1 );
	}

	return flg;
}

/**/

void	wait_key( void )
{
	print_msg( FLG_NULL, MSG_WAIT_KEY );

	wait_key_ex( FALSE );
}

/**/

void	wait_key_ex( bool_t flg_exec_key )
{
	while( 1 ){
		switch( chk_key( FALSE ) ){
		case CASE_CANCEL:
		case CASE_ENTER:
			return;
		case CASE_EXEC:
			if( flg_exec_key )
				return;
			break;
		default:
			break;
		}
	}
}

/**/

long	chk_key( bool_t flg_chk_menu )
{
	long	c;
	crsr_ptn_t	*ptn;
	long	x, y;

	ptn = get_crsr_ptn();

	g_pre_crsr = g_crsr;
	reset_crsr();

	c = get_key( flg_chk_menu );
	switch( c ){
	case ' ':
	case CASE_CANCEL:
		break;
	case CASE_ENTER:
	case 'M':
	case 'm':
		/* ˥塼ɽ */
		if( flg_chk_menu ){
			exec_menu( ls_menu_main, NULL, NULL );
			wipe_menu();
			clr_msg();
		}
		break;
	case CASE_REDRAW:
		redraw_all();
		break;
	default:
		if( chk_accel_key( ls_menu_move_crsr, c ) ){
			wipe_menu();
			break;
		}

		if( flg_chk_menu ){
			if( chk_accel_key( ls_menu_main, c ) ){
				wipe_menu();
				break;
			}
			if( chk_accel_key( ls_menu_sel_obj, c ) ){
				wipe_menu();
				break;
			}
		}

		if( flg_chk_menu ){
			print_msg( FLG_NULL, MSG_ERR_CHK_KEY,
					(char)c, (int)c );
		}
		break;
	}

	x = g_pre_crsr.x + ptn->x;
	y = g_pre_crsr.y + ptn->y;
	draw_map( x, y, ptn->x_len, ptn->y_len );

	x = g_crsr.x + ptn->x;
	y = g_crsr.y + ptn->y;
	draw_map( x, y, ptn->x_len, ptn->y_len );

	reset_crsr();

	return c;
}

/**/

bool_t	g_flg_dup_accel_key[256];

void	chk_dup_accel_key( void )
{
	chk_dup_accel_key_init();
	chk_dup_accel_key_main( ls_menu_move_crsr );
	chk_dup_accel_key_main( ls_menu_main );
	chk_dup_accel_key_main( ls_menu_sel_obj );
}

/**/

void	chk_dup_accel_key_init( void )
{
	long	i;

	for( i = 0; i < 256; i++ ){
		g_flg_dup_accel_key[i] = FALSE;
	}
}

/**/

bool_t	chk_dup_accel_key_main( menu_t *ls )
{
	menu_t	*p;

	for( p = ls; p->path[0] != '\0'; p++ ){
		char	*cp;

		for( cp = p->accel_key; *cp != '\0'; cp++ ){
			if( isspace( *cp ) ){
				continue;
			} else if( *cp == '\\' ){
				cp++;
				if( *cp == '\0' )
					break;
			} else if( *cp == '^' ){
				cp++;
				if( *cp == '\0' )
					break;

				chk_dup_accel_key_sub( *cp - '@', p );
				continue;
			}

			chk_dup_accel_key_sub( *cp, p );
		}
	}

	return TRUE;
}

/**/

bool_t	chk_dup_accel_key_sub( unsigned char c, menu_t *ls )
{
	if( g_flg_dup_accel_key[c] ){
		char	s[8];

		if( ('A' - '@' <= c) && (c <= 'Z' - '@') )
			sprintf( s, "^%c", c + '@' );
		else
			sprintf( s, "%c", c );

		print_err( MSG_MENU_DUP_ACCEL_KEY,
				MSG( ls->n_msg ), s );
		return FALSE;
	}

	g_flg_dup_accel_key[c] = TRUE;

	return TRUE;
}

/**/

bool_t	chk_accel_key( menu_t *ls, long c )
{
	bool_t	flg_find = FALSE;
	menu_t	*p;

	if( ls == NULL )
		return FALSE;

	for( p = ls; p->path[0] != '\0'; p++ ){
		char	*cp;

		for( cp = p->accel_key; *cp != '\0'; cp++ ){
			if( isspace( *cp ) ){
				continue;
			} else if( *cp == '\\' ){
				cp++;
				if( *cp == '\0' )
					return FALSE;
			} else if( *cp == '^' ){
				cp++;
				if( *cp == '\0' )
					return FALSE;

				if( *cp - '@' == c ){
					flg_find = TRUE;
					break;
				}
				continue;
			}

			if( *cp == c ){
				flg_find = TRUE;
				break;
			}
		}
		if( flg_find ){
			exec_menu( ls, NULL, p->path );
			return TRUE;
		}
	}

	return FALSE;
}

/**/

void	jump_crsr( long dx, long dy )
{
	long	i;
	dun_t	*dun;
	long	mx, my, nx, ny;
	long	mc, nc, emc, enc;
	flg_map_t	mf, nf;
	long	x, y;
	long	c;

	dun = get_dun();

	mx = g_crsr.x;
	my = g_crsr.y;
	nx = g_crsr.x + dx;
	ny = g_crsr.y + dy;
	if( nx < 0 )
		return;
	if( nx > MAP_MAX_X - 1 )
		return;
	if( ny < 0 )
		return;
	if( ny > MAP_MAX_Y - 1 )
		return;
	mc = dun->map.obj.mjr[my][mx];
	mf = dun->map.obj.flg[my][mx];
	nc = dun->map.obj.mjr[ny][nx];
	nf = dun->map.obj.flg[ny][nx];

	emc = FACE_MJR_NULL;
	enc = FACE_MJR_NULL;
	if( !chk_flg( mf, FLG_OBJ_FIND ) || !chk_flg( nf, FLG_OBJ_FIND ) ){
		g_crsr.x += dx;
		g_crsr.y += dy;
		return;
	} else if( (mc == FACE_MJR_FLOOR) && (nc == FACE_MJR_FLOOR) ){
		emc = FACE_MJR_NULL;
		enc = FACE_MJR_WALL;
	} else if( (mc == FACE_MJR_FLOOR) && (nc == FACE_MJR_WALL) ){
		g_crsr.x += dx;
		g_crsr.y += dy;
		return;
	} else if( (mc == FACE_MJR_WALL) && (nc == FACE_MJR_FLOOR) ){
		g_crsr.x += dx;
		g_crsr.y += dy;
		return;
	} else if( (mc == FACE_MJR_WALL) && (nc == FACE_MJR_WALL) ){
		emc = FACE_MJR_NULL;
		enc = FACE_MJR_FLOOR;
	}

	for( i = 0; i < 1024; i++ ){
		mx += dx;
		my += dy;
		nx += dx;
		ny += dy;
		mc = dun->map.obj.mjr[my][mx];
		mf = dun->map.obj.flg[my][mx];
		nc = dun->map.obj.mjr[ny][nx];
		nf = dun->map.obj.flg[ny][nx];

		if( !chk_flg( mf, FLG_OBJ_FIND )
				|| !chk_flg( nf, FLG_OBJ_FIND ) ){
			g_crsr.x = mx;
			g_crsr.y = my;
			return;
		}
		if( (emc != FACE_MJR_NULL) && (mc == emc) )
			break;
		if( (enc != FACE_MJR_NULL) && (nc == enc) )
			break;
		if( (emc == FACE_MJR_NULL) && (enc == FACE_MJR_NULL)
				&& (mc != FACE_MJR_NULL) ){
			break;
		}

		for( y = -1; y <= +1; y++ ){
			if( my + y < 0 )
				continue;
			if( my + y > MAP_MAX_Y - 1 )
				continue;

			for( x = -1; x <= +1; x++ ){
				if( mx + x < 0 )
					continue;
				if( mx + x > MAP_MAX_X - 1 )
					continue;

				c = dun->map.obj.mjr[my + y][mx + x];
				if( (c != FACE_MJR_WALL)
						&& (c != FACE_MJR_FLOOR)
						&& (c != FACE_MJR_NULL) ){
					g_crsr.x = mx;
					g_crsr.y = my;
					return;
				}

				c = dun->map.chr.mjr[my + y][mx + x];
				if( (c != FACE_MJR_NULL) ){
					g_crsr.x = mx;
					g_crsr.y = my;
					return;
				}
			}
		}
	}

	g_crsr.x = mx;
	g_crsr.y = my;
}

/**/

void	scroll_smooth( void )
{
	bool_t	flg;
	pos_t	*draw;

	draw = get_map_draw_pos();

	flg = FALSE;

	/* X */
	if( g_crsr.x < 0 )
		g_crsr.x = 0;
	if( g_crsr.x > MAP_MAX_X - 1 )
		g_crsr.x = MAP_MAX_X - 1;

	if( draw->x > g_crsr.x ){
		draw->x = g_crsr.x;
		flg = TRUE;
	}
	if( draw->x < g_crsr.x - (WIN_MAP_WIDTH - 1) ){
		draw->x = g_crsr.x - (WIN_MAP_WIDTH - 1);
		flg = TRUE;
	}

	/* Y */
	if( g_crsr.y < 0 )
		g_crsr.y = 0;
	if( g_crsr.y > MAP_MAX_Y - 1 )
		g_crsr.y = MAP_MAX_Y - 1;

	if( draw->y > g_crsr.y ){
		draw->y = g_crsr.y;
		flg = TRUE;
	}
	if( draw->y < g_crsr.y - (WIN_MAP_HEIGHT - 1) ){
		draw->y = g_crsr.y - (WIN_MAP_HEIGHT - 1);
		flg = TRUE;
	}

	/* ̽񤭴 */
	if( flg )
		redraw_map();
}

/**/

void	scroll_center( void )
{
	pos_t	*draw;

	draw = get_map_draw_pos();

	/* X */
	if( g_crsr.x < 0 )
		g_crsr.x = 0;
	if( g_crsr.x > MAP_MAX_X - 1 )
		g_crsr.x = MAP_MAX_X - 1;

	draw->x = g_crsr.x - (WIN_MAP_WIDTH / 2);
	if( draw->x < 0 )
		draw->x = 0;
	if( draw->x > MAP_MAX_X - WIN_MAP_WIDTH )
		draw->x = MAP_MAX_X - WIN_MAP_WIDTH;

	/* Y */
	if( g_crsr.y < 0 )
		g_crsr.y = 0;
	if( g_crsr.y > MAP_MAX_Y - 1 )
		g_crsr.y = MAP_MAX_Y - 1;

	draw->y = g_crsr.y - (WIN_MAP_HEIGHT / 2);
	if( draw->y < 0 )
		draw->y = 0;
	if( draw->y > MAP_MAX_Y - WIN_MAP_HEIGHT )
		draw->y = MAP_MAX_Y - WIN_MAP_HEIGHT;

	redraw_map();
}

/**/

void	scroll_half_page( void )
{
	bool_t	flg;
	pos_t	*draw;

	draw = get_map_draw_pos();
	flg = FALSE;

	/* X */

	if( g_crsr.x < 0 )
		g_crsr.x = 0;
	if( g_crsr.x > MAP_MAX_X - 1 )
		g_crsr.x = MAP_MAX_X - 1;

	while( g_crsr.x < draw->x ){
		draw->x -= SCROLL_WIDTH;
		flg = TRUE;
		if( draw->x < 0 ){
			draw->x = 0;
			break;
		}
	}

	while( g_crsr.x > draw->x + WIN_MAP_WIDTH - 1 ){
		draw->x += SCROLL_WIDTH;
		flg = TRUE;
		if( draw->x > MAP_MAX_X - WIN_MAP_WIDTH ){
			draw->x = MAP_MAX_X - WIN_MAP_WIDTH;
			break;
		}
	}

	/* Y */

	if( g_crsr.y < 0 )
		g_crsr.y = 0;
	if( g_crsr.y > MAP_MAX_Y - 1 )
		g_crsr.y = MAP_MAX_Y - 1;

	while( g_crsr.y < draw->y ){
		draw->y -= SCROLL_WIDTH;
		flg = TRUE;
		if( draw->y < 0 ){
			draw->y = 0;
			break;
		}
	}

	while( g_crsr.y > draw->y + WIN_MAP_HEIGHT - 1 ){
		draw->y += SCROLL_HEIGHT;
		flg = TRUE;
		if( draw->y > MAP_MAX_Y - WIN_MAP_HEIGHT ){
			draw->y = MAP_MAX_Y - WIN_MAP_HEIGHT;
			break;
		}
	}

	/* end */

	if( flg )
		redraw_map();
}

/**/

void	chk_scroll( void )
{
	flg_party_t	flg;

	flg = get_flg_party();

	if( chk_flg( flg, FLG_PARTY_SCROLL_SMOOTH ) )
		scroll_smooth();
	else if( chk_flg( flg, FLG_PARTY_SCROLL_CENTER ) )
		scroll_center();
	else
		scroll_half_page();
}

/**/

void	move_crsr_mbr_trgt( mbr_t *mbr )
{
	if( mbr == NULL )
		return;

	switch( mbr->trgt.kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return;
	case TRGT_KIND_MNSTR:
		g_crsr.x = ((mnstr_t *)(mbr->trgt.p))->x;
		g_crsr.y = ((mnstr_t *)(mbr->trgt.p))->y;
		break;
	case TRGT_KIND_MNSTR_NULL:
		g_crsr.x = ((mnstr_null_t *)(mbr->trgt.p))->x;
		g_crsr.y = ((mnstr_null_t *)(mbr->trgt.p))->y;
		break;
	case TRGT_KIND_MBR:
		g_crsr.x = ((mbr_t *)(mbr->trgt.p))->x;
		g_crsr.y = ((mbr_t *)(mbr->trgt.p))->y;
		break;
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_ITEM:
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_POS:
		g_crsr.x = mbr->x;
		g_crsr.y = mbr->y;
		break;
	}
}

/**/

pos_t	*get_crsr( void )
{
	return &g_crsr;
}

/**/

