#ifndef	__MENU_H__
#define	__MENU_H__

#include	"msg.h"
#include	"party.h"
#include	"item.h"
#include	"draw.h"
#include	"msg.h"

#define	STR_MENU_ERR	"# Error"
#define	STR_MENU_CANCEL	"# Cancel"

#define	CASE_ENTER	\
		'M' - '@': case 'J' - '@'
#define	CASE_CANCEL	\
		'G' - '@': case 'H' - '@': case '0': case '\033'
#define	CASE_EXEC	\
		'.': case '5'

#define	CASE_CRSR_UP	\
		'8': case 'k': case 'P' - '@'
#define	CASE_CRSR_DOWN	\
		'2': case 'j': case 'N' - '@'
#define	CASE_CRSR_LEFT	\
		'4': case 'h': case 'B' - '@'
#define	CASE_CRSR_RIGHT	\
		'6': case 'l': case 'F' - '@'
#define	CASE_CRSR_UP_LEFT	\
		'7': case 'y'
#define	CASE_CRSR_UP_RIGHT	\
		'9': case 'u'
#define	CASE_CRSR_DOWN_LEFT	\
		'1': case 'b'
#define	CASE_CRSR_DOWN_RIGHT	\
		'3': case 'n'

#define	CASE_REDRAW	0x019a

#define	MENU_MAX_LEN	(SCREEN_WIDTH - 4)
#define	MENU_MAX_N_PER_PAGE	20
#define	MENU_MAX_PAGE	32

#define	FLG_MENU_DIS	(1 << 0)
#define	FLG_MENU_HIDDEN	(1 << 1)
#define	FLG_MENU_CHK_ON	(1 << 4)
#define	FLG_MENU_CHK_OFF	(1 << 5)
#define	FLG_MENU_ALL	\
	(FLG_MENU_DIS | FLG_MENU_HIDDEN \
	| FLG_MENU_CHK_ON | FLG_MENU_CHK_OFF)

#define	MENU_PATH_MAX_LEN	64
#define	MENU_KIND_MAX_LEN	16
#define	MENU_ACCEL_KEY_MAX_LEN	16
#define	MENU_MSG_MAX_LEN	128

#define	MBR_DATA_PAGE_MAX_N	2

typedef enum {
	ASK_NO,
	ASK_YES,
	ASK_CANCEL,
	ASK_ERR,
} ask_t;

typedef enum {
	DEAL_KIND_BUY,
	DEAL_KIND_SALE_ITEM,
	DEAL_KIND_SALE_EQUIP,
} deal_kind_t;

typedef struct menu_t {
	char	path[MENU_PATH_MAX_LEN + 1];
	char	kind[MENU_KIND_MAX_LEN + 1];
	unsigned char	key;
	char	accel_key[MENU_ACCEL_KEY_MAX_LEN + 1];
	n_msg_t	n_msg;
	char	msg[MENU_MSG_MAX_LEN + 1];
	char	*(*call_back)(
			struct menu_t **pp, struct menu_t **dflt );
	void	*arg;
	unsigned long	flg;
} menu_t;

typedef struct {
	char	*ttl;
	menu_t	*ls[MENU_MAX_N_PER_PAGE + 1];
	long	sel_n, prev_sel_n;
	bool_t	flg_min_page, flg_max_page;
	bool_t	flg_redraw;
} draw_menu_t;

typedef enum {
	MENU_NUM_MIN,
	MENU_NUM_MAX,
	MENU_NUM_OK,
	MENU_NUM_MAX_N
} menu_num_t;

typedef enum {
	NEXT_POS_KIND_SQUARE,
	NEXT_POS_KIND_MBR,
	NEXT_POS_KIND_MNSTR,
	NEXT_POS_KIND_DOOR,
	NEXT_POS_KIND_OBJ,
} next_pos_kind_t;

typedef struct {
	next_pos_kind_t	kind;
	void	*p;
	long	n;
	int	x, y;
} next_pos_t;

typedef enum {
	MBR_DATA_EDIT_KIND_SHOW,
	MBR_DATA_EDIT_KIND_EDIT,
	MBR_DATA_EDIT_KIND_NEW,
	MBR_DATA_EDIT_KIND_MAX_N,
} mbr_data_edit_kind_t;

#endif	/* __MENU_H__ */
