/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
#include	"town.h"
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
/*#include	"mnstr_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
#include	"gfile_prot.h"
/*#include	"msg_prot.h"*/

/**/

#define	ARTICLE_MAX_N_PER_PAGE	10
#define	ARTICLE_PAGE_MAX_N	MENU_MAX_PAGE
#define	ARTICLE_MAX_N	\
		(ARTICLE_MAX_N_PER_PAGE * ARTICLE_PAGE_MAX_N)

#define	LS_MENU_SHOP_MAX_N	\
		(MENU_MAX_N_PER_PAGE * ARTICLE_PAGE_MAX_N)

#define	LS_MBR_MAX_N_PER_PAGE	12
#define	LS_MBR_PAGE_MAX_N	\
		((LS_MBR_MAX_N + LS_MBR_MAX_N_PER_PAGE - 1)\
		/ LS_MBR_MAX_N_PER_PAGE)

#define	CHARGE_STAY_INN	10

/**/

#include	"tmenu_tab.h"

/**/

mbr_t	*g_sel_mbr, *g_sel_ls_mbr;
shop_n_t	g_shop_n;
deal_kind_t	g_deal_kind;
item_t	*g_sel_art;

/**/

void	init_tmenu( void )
{
	party_t	*pty = get_party();
	mbr_t	**ls_mbr = get_ls_mbr();

	g_sel_mbr = pty->mbr[0];
	g_sel_ls_mbr = ls_mbr[0];
	g_sel_art = NULL;
}

/**/

char	*menu_shop_sel_mbr( shop_n_t shop_n )
{
	g_shop_n = shop_n;
	g_deal_kind = DEAL_KIND_BUY;

	while( 1 ){
		char	ttl[MENU_MSG_MAX_LEN + 1];
		char	*str_goto;

		sprintf( ttl, MSG_MENU_SHOP_SEL_MBR,
				get_shop_name( g_shop_n ) );

		switch( g_shop_n ){
		case SHOP_N_INN:
		case SHOP_N_BAR:
			break;
		case SHOP_N_TEMPLE:
			str_goto = exec_menu_sel_mbr(
					&g_sel_mbr, ttl, TRUE );
			if( str_goto != NULL )
				return str_goto;

			while( 1 ){
				str_goto = exec_menu( ls_menu_temple,
						NULL, str_goto );

				if( str_goto == NULL )
					continue;
				if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
					break;
				if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
					break;
			}
			break;
		case SHOP_N_WPN:
		case SHOP_N_ARMOR:
		case SHOP_N_MAGIC:
		case SHOP_N_GROCERY:
		case SHOP_N_RESTAURANT:
		case SHOP_N_TEAROOM:
		case SHOP_N_TOBACCO:
			str_goto = exec_menu_sel_mbr(
					&g_sel_mbr, ttl, FALSE );
			if( str_goto != NULL )
				return str_goto;

			g_sel_art = NULL;
			while( 1 ){
				str_goto = menu_shop( g_shop_n, g_sel_mbr,
						str_goto );

				if( str_goto == NULL )
					continue;
				if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
					break;
				if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
					break;
			}
			break;
		}
	}

	return STR_MENU_ERR;
}

/**/

char	*cb_menu_temple_init(
	menu_t **pp, menu_t **dflt
)
{
	long	len;
	menu_t	*p;
	long	price;

	len = 0;
	for( p = *pp; p->path[0] != '\0'; p++ ){
		long	tmp_len;

		tmp_len = str_len_std( MSG( p->n_msg ) );
		len = max( len, tmp_len );
	}

	p = srch_menu( *pp, "Title" );
	sprintf( p->msg, MSG_TTL_MENU_TEMPLE,
			get_shop_name( SHOP_N_TEMPLE ),
			g_sel_mbr->name, g_sel_mbr->gold );

	price = get_price_temple_remove_curse( g_sel_mbr );
	p = srch_menu( *pp, "Remove curse" );
	sprintf( p->msg, MSG_FMT_MENU_TEMPLE,
			len, MSG( p->n_msg ), price );

	price = get_price_temple_cure_status( g_sel_mbr );
	p = srch_menu( *pp, "Cure status" );
	sprintf( p->msg, MSG_FMT_MENU_TEMPLE,
			len, MSG( p->n_msg ), price );

	price = get_price_temple_resurrection( g_sel_mbr );
	p = srch_menu( *pp, "Resurrection" );
	sprintf( p->msg, MSG_FMT_MENU_TEMPLE,
			len, MSG( p->n_msg ), price );

	return NULL;
}

/**/

char	*cb_menu_temple_remove_curse(
	menu_t **pp, menu_t **dflt
)
{
	long	price;
	ask_t	ask;

	price = get_price_temple_remove_curse( g_sel_mbr );
	if( price > 0 )
		if( !chk_pay( price, g_sel_mbr ) )
			return STR_MENU_CANCEL;

	ask = exec_menu_ask( MSG_TTL_MENU_TEMPLE_REMOVE_CURSE,
			ASK_NO, TRUE );

	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
		return STR_MENU_CANCEL;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	if( remove_curse( NULL, g_sel_mbr, 0 ) ){
		add_chr_gold( g_sel_mbr, -price );

		print_msg( FLG_NULL,
				MSG_MENU_REMOVE_CURSE,
				g_sel_mbr->name );
	} else {
		print_msg( FLG_NULL,
				MSG_MENU_REMOVE_CURSE_ERR,
				g_sel_mbr->name );
	}

	return "/Temple";
}

/**/

char	*cb_menu_temple_cure_status(
	menu_t **pp, menu_t **dflt
)
{
	long	price;
	ask_t	ask;

	price = get_price_temple_cure_status( g_sel_mbr );
	if( price > 0 )
		if( !chk_pay( price, g_sel_mbr ) )
			return STR_MENU_CANCEL;

	ask = exec_menu_ask( MSG_TTL_MENU_TEMPLE_CURE_STATUS,
			ASK_NO, TRUE );

	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
		return STR_MENU_CANCEL;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	if( fx_cure_all_status( g_sel_mbr ) ){
		add_chr_gold( g_sel_mbr, -price );

		print_msg( FLG_NULL,
				MSG_MENU_CURE_STATUS,
				g_sel_mbr->name );
	} else {
		print_msg( FLG_NULL,
				MSG_MENU_CURE_STATUS_ERR,
				g_sel_mbr->name );
	}

	return "/Temple";
}

/**/

char	*cb_menu_temple_resurrection(
	menu_t **pp, menu_t **dflt
)
{
	long	price;
	ask_t	ask;

	price = get_price_temple_resurrection( g_sel_mbr );
	if( price > 0 )
		if( !chk_pay( price, g_sel_mbr ) )
			return STR_MENU_CANCEL;

	ask = exec_menu_ask( MSG_TTL_MENU_TEMPLE_RESURRECTION,
			ASK_NO, TRUE );

	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
		return STR_MENU_CANCEL;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	if( resurrection( g_sel_mbr ) ){
		add_chr_gold( g_sel_mbr, -price );

		print_msg( FLG_NULL,
				MSG_MENU_RESURRECTION,
				g_sel_mbr->name );
	} else {
		print_msg( FLG_NULL,
				MSG_MENU_RESURRECTION_ERR,
				g_sel_mbr->name );
	}

	return "/Temple";
}

/**/

char	*cb_menu_temple_contribution(
	menu_t **pp, menu_t **dflt
)
{
	long	price;
	char	*str_goto;
	ask_t	ask;

	if( g_sel_mbr->gold <= 0 )
		return STR_MENU_CANCEL;

	price = g_sel_mbr->gold * 10 / _100_PERCENT;
	str_goto = exec_menu_sel_num( 1, g_sel_mbr->gold, &price );
	if( str_goto != NULL )
		return str_goto;

	if( price > 0 )
		if( !chk_pay( price, g_sel_mbr ) )
			return STR_MENU_CANCEL;

	ask = exec_menu_ask( MSG_TTL_MENU_TEMPLE_CONTRIBUTION,
			ASK_NO, TRUE );

	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
		return STR_MENU_CANCEL;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	add_chr_gold( g_sel_mbr, -price );

	contribution( g_sel_mbr, price );
	print_msg( FLG_NULL, MSG_MENU_CONTRIBUTION,
			g_sel_mbr->name, price );

	return "/Temple";
}

/**/

char	*menu_shop( shop_n_t shop_n, mbr_t *mbr, char *str_goto )
{
	menu_t	*ls, *dflt;
	long	page;
	long	i, j, k;
	long	key_n;
	item_t	*art_head, *art;
	long	ls_art_n, art_n;
	static item_t	*ls_art[ARTICLE_MAX_N];
	char	*buy_sale;
	party_t	*pty;
	long	len, max_len;

	pty = get_party();

	art_head = get_begin_article( mbr, shop_n, g_deal_kind );
	if( art_head == NULL )
		return STR_MENU_ERR;

	if( g_deal_kind == DEAL_KIND_BUY )
		buy_sale = MSG_BUY;
	else if( g_deal_kind == DEAL_KIND_SALE_ITEM )
		buy_sale = MSG_SALE_ITEM;
	else if( g_deal_kind == DEAL_KIND_SALE_EQUIP )
		buy_sale = MSG_SALE_EQUIP;
	else
		buy_sale = MSG_NULL;

	ls = ls_menu_shop;
	dflt = NULL;
	k = 0;

	strncpy( ls[k].path, "/Shop", MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	max_len = 0;
	ls_art_n = 0;
	art_n = 0;
	key_n = 0;
	page = 0;
	for( art = art_head;
			!chk_end_article( art, art_head, g_deal_kind );
			art = get_next_article( art, g_deal_kind ) ){
		if( art == NULL )
			break;
		if( page >= ARTICLE_PAGE_MAX_N )
			break;
		if( art->kind == ITEM_KIND_NULL )
			continue;
		if( !chk_deal_article( art, shop_n, g_deal_kind ) )
			continue;

		if( key_n == 0 ){
			strncpy( ls[k].path, "/Shop/--",
					MENU_PATH_MAX_LEN );
			strncpy( ls[k].kind, "<Title>",
					MENU_KIND_MAX_LEN );
			ls[k].key = '\0';
			ls[k].accel_key[0] = '\0';
			sprintf( ls[k].msg,
					MSG_FMT_MENU_SHOP,
					get_shop_name( shop_n ),
					mbr->name, buy_sale,
					get_chr_gold( mbr ) );
			ls[k].call_back = NULL;
			ls[k].arg = NULL;
			ls[k].flg = FLG_NULL;
			k++;
		}

		set_art_name( mbr, art, g_deal_kind );
		ls_art[ls_art_n] = art;
		ls_art_n++;

		len = str_len_std( art->art_name );
		max_len = max( len, max_len );

		/* menu */

		if( art == g_sel_art )
			dflt = &(ls[k]);

		sprintf( ls[k].path, "/Shop/%ld", key_n );
		strncpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		ls[k].key = 'A' + key_n;
		ls[k].accel_key[0] = '\0';
		ls[k].msg[0] = '\0';
		ls[k].call_back = cb_menu_shop;
		ls[k].arg = (void *)art;
		ls[k].flg = FLG_NULL;
		k++;

		key_n++;

		if( ls_art_n >= ((page + 1) * ARTICLE_MAX_N_PER_PAGE) ){
			set_ls_menu_shop( &k, g_deal_kind );
			page++;
			key_n = 0;
		}
	}

	if( (ls_art_n != (page * ARTICLE_MAX_N_PER_PAGE)) || page == 0 ){
		strncpy( ls[k].path, "/Shop/--",
				MENU_PATH_MAX_LEN );
		strncpy( ls[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		ls[k].key = '\0';
		ls[k].accel_key[0] = '\0';
		sprintf( ls[k].msg,
				MSG_FMT_MENU_SHOP,
				get_shop_name( shop_n ),
				mbr->name, buy_sale,
				get_chr_gold( mbr ) );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		set_ls_menu_shop( &k, g_deal_kind );
	}

	ls[k].path[0] = '\0';

	/* ̾ʤĤ */

	for( i = 0, j = 0; i < k; i++ ){
		if( ls[i].arg == NULL )
			continue;

		sprintf( ls[i].msg,
				MSG_FMT_ART_NAME,
				max_len, ls_art[j]->art_name,
				get_price( ls_art[j], g_deal_kind ) );
		j++;
	}

	return exec_menu( ls, dflt, str_goto );
}

/**/

void	set_ls_menu_shop( long *k, deal_kind_t deal_kind )
{
	menu_t	*ls;

	ls = ls_menu_shop;

	/* Data */

	strncpy( ls[*k].path, "/Shop/Data", MENU_PATH_MAX_LEN );
	strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[*k].key = 'U';
	ls[*k].accel_key[0] = '\0';
	strncpy( ls[*k].msg, MSG_MENU_SHOP_DATA, MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_shop_data;
	ls[*k].arg = NULL;
	ls[*k].flg = FLG_NULL;
	(*k)++;

	/* Collect gold */

	strncpy( ls[*k].path, "/Shop/Collect gold", MENU_PATH_MAX_LEN );
	strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[*k].key = 'V';
	ls[*k].accel_key[0] = '\0';
	strncpy( ls[*k].msg, MSG_MENU_SHOP_COLLECT_GOLD,
			MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_shop_collect_gold;
	ls[*k].arg = NULL;
	ls[*k].flg = FLG_NULL;
	(*k)++;

	/* Divide gold */

	strncpy( ls[*k].path, "/Shop/Divide gold", MENU_PATH_MAX_LEN );
	strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
	ls[*k].key = 'W';
	ls[*k].accel_key[0] = '\0';
	strncpy( ls[*k].msg, MSG_MENU_SHOP_DIVIDE_GOLD,
			MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_shop_divide_gold;
	ls[*k].arg = NULL;
	ls[*k].flg = FLG_NULL;
	(*k)++;

	/* Sale equip */

	if( g_deal_kind != DEAL_KIND_SALE_EQUIP ){
		strncpy( ls[*k].path, "/Shop/Sale equip",
				MENU_PATH_MAX_LEN );
		strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[*k].key = 'X';
		ls[*k].accel_key[0] = '\0';
		strncpy( ls[*k].msg, MSG_MENU_SHOP_SALE_EQUIP,
				MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_shop_sale_equip;
		ls[*k].arg = NULL;
		ls[*k].flg = FLG_NULL;
		(*k)++;
	}

	/* Sale item */

	if( g_deal_kind != DEAL_KIND_SALE_ITEM ){
		strncpy( ls[*k].path, "/Shop/Sale item",
				MENU_PATH_MAX_LEN );
		strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[*k].key = 'Y';
		ls[*k].accel_key[0] = '\0';
		strncpy( ls[*k].msg, MSG_MENU_SHOP_SALE_ITEM,
				MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_shop_sale_item;
		ls[*k].arg = NULL;
		ls[*k].flg = FLG_NULL;
		(*k)++;
	}

	/* Buy */

	if( g_deal_kind != DEAL_KIND_BUY ){
		strncpy( ls[*k].path, "/Shop/Buy", MENU_PATH_MAX_LEN );
		strncpy( ls[*k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[*k].key = 'Z';
		ls[*k].accel_key[0] = '\0';
		strncpy( ls[*k].msg, MSG_MENU_SHOP_BUY, MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_shop_buy;
		ls[*k].arg = NULL;
		ls[*k].flg = FLG_NULL;
		(*k)++;
	}

	/* <PageSeparator> */

	strncpy( ls[*k].path, "/Shop/--", MENU_PATH_MAX_LEN );
	strncpy( ls[*k].kind, "<PageSeparator>", MENU_KIND_MAX_LEN );
	ls[*k].key = '\0';
	ls[*k].accel_key[0] = '\0';
	ls[*k].msg[0] = '\0';
	ls[*k].call_back = NULL;
	ls[*k].arg = NULL;
	ls[*k].flg = FLG_NULL;
	(*k)++;
}

/**/

char	*cb_menu_shop_data( menu_t **pp, menu_t **dflt )
{
	return menu_town_mbr_data( MBR_DATA_EDIT_KIND_SHOW, FALSE );
}

/**/

char	*menu_town_mbr_data(
	mbr_data_edit_kind_t edit_kind,
	bool_t flg_ls_mbr
)
{
	mbr_t	**mbr;
	long	n;
	long	page_n;

	if( flg_ls_mbr ){
		n = g_sel_ls_mbr->ls_mbr_n;
		mbr = get_ls_mbr();
	} else {
		n = g_sel_mbr->mbr_n;
		mbr = get_party()->mbr;
	}

	if( n <= -1 )
		return STR_MENU_ERR;

	page_n = 0;

	while( 1 ){
		long	add;
		long	prev_mbr_n;

		prev_mbr_n = mbr[n]->mbr_n;
		if( flg_ls_mbr )
			not_join_mbr( n, prev_mbr_n );

		add = menu_mbr_data( mbr[n], &page_n, edit_kind );

		if( flg_ls_mbr )
			join_mbr( n, prev_mbr_n );
		if( add == 0 )
			break;

		/* СꥹȤƬФ */
		if( flg_ls_mbr )
			n = next_ls_mbr( n, add );
		else
			n = next_mbr( n, add );
	}

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_shop_collect_gold(
	menu_t **pp, menu_t **dflt
)
{
	collect_gold( g_sel_mbr );

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_shop_divide_gold(
	menu_t **pp, menu_t **dflt
)
{
	divide_gold();

	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_shop( menu_t **pp, menu_t **dflt )
{
	item_t	*art;
	long	price;

	art = (item_t *)((*pp)->arg);
	price = get_price( art, g_deal_kind );

	g_sel_art = art;

	chk_item_data( g_sel_art );

	if( g_deal_kind == DEAL_KIND_BUY ){
		if( !menu_shop_buy( g_shop_n, g_sel_mbr, art ) )
			return STR_MENU_CANCEL;

		add_chr_gold( g_sel_mbr, -price );
	} else if( g_deal_kind == DEAL_KIND_SALE_ITEM ){
		if( !menu_shop_sale_item( g_shop_n, g_sel_mbr, art ) )
			return STR_MENU_CANCEL;

		add_chr_gold( g_sel_mbr, price );
	} else if( g_deal_kind == DEAL_KIND_SALE_EQUIP ){
		if( !menu_shop_sale_equip( g_shop_n, g_sel_mbr, art ) )
			return STR_MENU_CANCEL;

		add_chr_gold( g_sel_mbr, price );
	}

	return "/Shop";
}

/**/

char	*cb_menu_shop_buy( menu_t **pp, menu_t **dflt )
{
	g_deal_kind = DEAL_KIND_BUY;

	return NULL;
}

/**/

char	*cb_menu_shop_sale_item( menu_t **pp, menu_t **dflt )
{
	g_deal_kind = DEAL_KIND_SALE_ITEM;

	return NULL;
}

/**/

char	*cb_menu_shop_sale_equip( menu_t **pp, menu_t **dflt )
{
	g_deal_kind = DEAL_KIND_SALE_EQUIP;

	return NULL;
}

/**/

bool_t	menu_shop_buy(
	shop_n_t g_shop_n, mbr_t *g_sel_mbr, item_t *item
)
{
	ask_t	ask;
	item_t	*tmp, dmy;
	long	price;

	/* ̾ɽ */
	print_msg( FLG_NULL, MSG_MENU_BUY, item->name );

	/* 㤦ǧ */
	ask = exec_menu_ask( MSG_TTL_MENU_BUY, ASK_NO, FALSE );
	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
	case ASK_CANCEL:
	case ASK_ERR:
		return FALSE;
	}

	price = get_price( item, DEAL_KIND_BUY );
	if( !chk_pay( price, g_sel_mbr ) )
		return FALSE;

	tmp = alloc_item( &dmy );
	if( tmp == NULL )
		return FALSE;
	copy_item( tmp, item );

	tmp->stock = 1;
	if( g_shop_n == SHOP_N_RESTAURANT ){
		if( tmp->kind == ITEM_KIND_FOOD )
			eat_food( g_sel_mbr, tmp );
		if( tmp->kind == ITEM_KIND_POTION )
			quaff_potion( g_sel_mbr, tmp, TRUE );
	} else if( !give_mbr_item( g_sel_mbr, tmp ) ){
		print_msg( FLG_NULL, MSG_ERR_ITEM_FULL, g_sel_mbr->name );
		return TRUE;
	}

	item->stock--;
	if( item->stock <= 0 )
		inc_item( item, -item->n );

	if( g_shop_n != SHOP_N_RESTAURANT )
		print_msg( FLG_MSG_NO_MORE_PREV | FLG_MSG_NO_MORE_NEXT,
				MSG_MENU_REACHED_BUY, item->name );

	return TRUE;
}

/**/

bool_t	menu_shop_sale_item(
	shop_n_t shop_n, mbr_t *mbr, item_t *item
)
{
	return menu_shop_sale( shop_n, mbr, item, DEAL_KIND_SALE_ITEM );
}

/**/

bool_t	menu_shop_sale_equip(
	shop_n_t shop_n, mbr_t *mbr, item_t *item
)
{
	return menu_shop_sale( shop_n, mbr, item, DEAL_KIND_SALE_EQUIP );
}

/**/

bool_t	menu_shop_sale(
	shop_n_t shop_n, mbr_t *mbr, item_t *item,
	deal_kind_t deal_kind
)
{
	ask_t	ask;
	item_t	*tmp, dmy;
	item_t	*asgn;

	/* ̾ɽ */
	print_msg( FLG_NULL, MSG_MENU_SALE, item->name );

	/* 뤫ǧ */
	ask = exec_menu_ask( MSG_TTL_MENU_SALE, ASK_NO, FALSE );
	switch( ask ){
	case ASK_YES:
		break;
	case ASK_NO:
	case ASK_CANCEL:
	case ASK_ERR:
		return FALSE;
	}

	lost_trgt( item );

	switch( shop_n ){
	default:
	case SHOP_N_INN:
	case SHOP_N_BAR:
	case SHOP_N_RESTAURANT:
	case SHOP_N_TEAROOM:
	case SHOP_N_TOBACCO:
		return FALSE;
	case SHOP_N_TEMPLE:
		asgn = get_shop_temple_item_asgn();
		break;
	case SHOP_N_WPN:
		asgn = get_shop_wpn_item_asgn();
		break;
	case SHOP_N_ARMOR:
		asgn = get_shop_armor_item_asgn();
		break;
	case SHOP_N_MAGIC:
		asgn = get_shop_magic_item_asgn();
		break;
	case SHOP_N_GROCERY:
		asgn = get_shop_grocery_item_asgn();
		break;
	}

	tmp = alloc_item( &dmy );
	if( tmp == NULL )
		return FALSE;
	copy_item( tmp, item );
	tmp->stock = 1;

	if( chk_package_item( item ) ){
		ins_ls_item( asgn, tmp );
		inc_item( item, -item->n );
	} else {
		tmp->n = 1;
		inc_item( tmp, -(tmp->n - 1) );

		ins_ls_item( asgn, tmp );
		inc_item( item, -1 );
	}

	print_msg( FLG_MSG_NO_MORE_PREV | FLG_MSG_NO_MORE_NEXT,
			MSG_MENU_REACHED_SALE, item->name );

	return TRUE;
}

/**/

item_t	*get_begin_article(
	mbr_t *mbr, shop_n_t shop_n, deal_kind_t kind
)
{
	item_t	*art_head;

	if( kind == DEAL_KIND_BUY ){
		switch( shop_n ){
		case SHOP_N_INN:
		case SHOP_N_BAR:
			return NULL;
		case SHOP_N_TEMPLE:
			art_head = get_shop_temple_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_WPN:
			art_head = get_shop_wpn_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_ARMOR:
			art_head = get_shop_armor_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_MAGIC:
			art_head = get_shop_magic_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_GROCERY:
			art_head = get_shop_grocery_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_RESTAURANT:
			art_head = get_shop_restaurant_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_TEAROOM:
			art_head = get_shop_tearoom_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		case SHOP_N_TOBACCO:
			art_head = get_shop_tobacco_item_asgn();
			if( art_head == NULL )
				return NULL;
			return art_head->next;
			break;
		}
	} else if( kind == DEAL_KIND_SALE_ITEM ){
		art_head = get_mbr_item_asgn( mbr );
		if( art_head == NULL )
			return NULL;
		return art_head->next;
	} else if( kind == DEAL_KIND_SALE_EQUIP ){
		return get_mbr_item_asgn_equip( mbr );
	}

	return NULL;
}

/**/

item_t	*get_next_article( item_t *art, deal_kind_t kind )
{
	if( art == NULL )
		return NULL;

	if( kind == DEAL_KIND_BUY ){
		return art->next;
	} else if( kind == DEAL_KIND_SALE_ITEM ){
		return art->next;
	} else if( kind == DEAL_KIND_SALE_EQUIP ){
		return( art + 1 );
	}

	return NULL;
}

/**/

bool_t	chk_end_article( item_t *art, item_t *art_head, deal_kind_t kind )
{
	if( art == NULL )
		return TRUE;
	if( art_head == NULL )
		return TRUE;

	switch( kind ){
	default:
		return FALSE;
	case DEAL_KIND_BUY:
	case DEAL_KIND_SALE_ITEM:
		return( art->next == art_head );
	case DEAL_KIND_SALE_EQUIP:
		return( art >= (art_head + EQUIP_KIND_MAX_N) );
	}
}

/**/

bool_t	chk_deal_article(
	item_t *art, shop_n_t shop_n, deal_kind_t deal_kind
)
{
	switch( shop_n ){
	case SHOP_N_INN:
	case SHOP_N_BAR:
		return FALSE;
	case SHOP_N_TEMPLE:
		return FALSE;
	case SHOP_N_WPN:
		if( art->kind == ITEM_KIND_WPN )
			return TRUE;
		break;
	case SHOP_N_ARMOR:
		if( art->kind == ITEM_KIND_ARMOR )
			return TRUE;
		break;
	case SHOP_N_MAGIC:
		if( art->kind == ITEM_KIND_POTION )
			return TRUE;
		if( art->kind == ITEM_KIND_SCROLL )
			return TRUE;
		if( art->kind == ITEM_KIND_STICK )
			return TRUE;
		if( art->kind == ITEM_KIND_ACCE )
			return TRUE;
		break;
	case SHOP_N_GROCERY:
		if( art->kind == ITEM_KIND_LIGHT )
			return TRUE;
		if( art->kind == ITEM_KIND_SPIKE )
			return TRUE;
		if( art->kind == ITEM_KIND_FOOD )
			return TRUE;
		if( art->kind == ITEM_KIND_TOBACCO ){
			if( art->dat.tobacco.kind
					== TOBACCO_KIND_ABSTAIN_GUM )
				return TRUE;
		}
		if( art->kind == ITEM_KIND_POTION ){
			if( art->dat.potion.kind == POTION_KIND_WATER )
				return TRUE;
			if( art->dat.potion.kind == POTION_KIND_OIL )
				return TRUE;
		}
		break;
	case SHOP_N_RESTAURANT:
		if( deal_kind != DEAL_KIND_BUY )
			return FALSE;

		if( art->kind == ITEM_KIND_FOOD )
			return TRUE;
		if( art->kind == ITEM_KIND_POTION )
			return TRUE;
		break;
	case SHOP_N_TEAROOM:
		if( deal_kind != DEAL_KIND_BUY )
			return FALSE;

		if( art->kind == ITEM_KIND_POTION )
			return TRUE;
		break;
	case SHOP_N_TOBACCO:
		if( deal_kind != DEAL_KIND_BUY )
			return FALSE;

		if( art->kind == ITEM_KIND_TOBACCO )
			return TRUE;
		if( art->kind == ITEM_KIND_PIPE )
			return TRUE;
		break;
	}

	return FALSE;
}

/**/

char	*menu_bar( void )
{
	g_sel_ls_mbr = get_ls_mbr()[0];

	return exec_menu( ls_menu_bar, NULL, NULL );
}

/**/

char	*cb_menu_bar_form( menu_t **pp, menu_t **dflt )
{
	long	i, j, k;
	long	ls_mbr_n;
	mbr_t	**ls_mbr;
	menu_t	*p;

	ls_mbr = get_ls_mbr();
	ls_mbr_n = 0;
	p = ls_menu_bar_form;

	k = 0;
	strncpy( p[k].path, "/Bar form",
			MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = cb_menu_bar_form_init;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < LS_MBR_PAGE_MAX_N; i++ ){
		if( chk_flg( ls_mbr[ls_mbr_n]->stat, FLG_STAT_NOT_EXIST ) )
			break;

		strncpy( p[k].path, "/Bar form/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_TTL_MENU_BAR_FORM,
				MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		for( j = 0; j < LS_MBR_MAX_N_PER_PAGE; j++ ){
			if( ls_mbr_n > LS_MBR_MAX_N )
				return STR_MENU_ERR;

			if( chk_flg( ls_mbr[ls_mbr_n]->stat,
					FLG_STAT_NOT_EXIST ) ){
				break;
			}

			sprintf( p[k].path, "/Bar form/%ld", ls_mbr_n );
			strncpy( p[k].kind, "<CheckItem>",
					MENU_KIND_MAX_LEN );
			p[k].key = 'A' + j;
			p[k].accel_key[0] = '\0';
			strncpy( p[k].msg, ls_mbr[ls_mbr_n]->name,
					MENU_MSG_MAX_LEN );
			p[k].call_back = cb_menu_bar_form_sub;
			p[k].arg = ls_mbr[ls_mbr_n];
			p[k].flg = FLG_NULL;
			k++;

			ls_mbr_n++;
		}

		strncpy( p[k].path, "/Bar form/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<PageSeparator>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		p[k].msg[0] = '\0';
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';

	*pp = p;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_bar_form_init( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	for( p = *pp + 1; p->path[0] != '\0'; p++ ){
		mbr_t	*mbr;

		if( strcmp( p->kind, "<CheckItem>" ) != 0 )
			continue;

		mbr = (mbr_t *)(p->arg);

		if( mbr == g_sel_ls_mbr )
			*dflt = p;

		if( mbr->mbr_n == MBR_N_NOT_JOIN ){
			p->flg &= ~(FLG_MENU_CHK_ON);
			p->flg |= FLG_MENU_CHK_OFF;
		} else {
			p->flg |= FLG_MENU_CHK_ON;
			p->flg &= ~(FLG_MENU_CHK_OFF);
		}
	}

	return NULL;
}

/**/

char	*cb_menu_bar_form_sub( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	g_sel_ls_mbr = (mbr_t *)((*pp)->arg);
	if( g_sel_ls_mbr == NULL )
		return STR_MENU_ERR;

	*pp = ls_menu_bar_form_sub;
	*dflt = NULL;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	strncpy( p->msg, g_sel_ls_mbr->name, MENU_MSG_MAX_LEN );

	return NULL;
}

/**/

char	*cb_menu_bar_form_sub_init( menu_t **pp, menu_t **dflt )
{
	static char	sub_path[MENU_PATH_MAX_LEN + 1];
	party_t	*pty = get_party();
	long	i;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	sprintf( sub_path, "%ld", g_sel_ls_mbr->ls_mbr_n );

	if( g_sel_ls_mbr->mbr_n == MBR_N_NOT_JOIN ){
		set_chk_off_menu( ls_menu_bar_form, sub_path );
		set_flg_menu( *pp, "Not join", FLG_MENU_HIDDEN );
	} else {
		set_chk_on_menu( ls_menu_bar_form, sub_path );
		set_flg_menu( *pp, "Join", FLG_MENU_HIDDEN );
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			break;
	if( i >= MBR_MAX_N )
		set_flg_menu( *pp, "Join", FLG_MENU_HIDDEN );

	return NULL;
}

/**/

char	*cb_menu_bar_join( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;
	party_t	*pty;
	long	k;
	long	i, n;

	p = ls_menu_bar_join;

	pty = get_party();

	if( chk_flg( g_sel_ls_mbr->stat, FLG_STAT_NOT_EXIST ) )
		return STR_MENU_ERR;
	if( g_sel_ls_mbr->mbr_n != MBR_N_NOT_JOIN )
		return STR_MENU_ERR;

	k = 0;
	strncpy( p[k].path, "/Join",
			MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = cb_menu_bar_join_sub_init;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	n = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		sprintf( p[k].path, "/Join/%ld", i );
		strncpy( p[k].kind, "<Item>",
				MENU_KIND_MAX_LEN );
		p[k].key = 'A' + i;
		p[k].accel_key[0] = '\0';
		sprintf( p[k].msg, "%ld", i + 1 );
		p[k].call_back = cb_menu_bar_join_sub;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		if( !chk_flg( pty->mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			n++;
	}
	p[k].path[0] = '\0';

	if( n >= MBR_MAX_N )
		return STR_MENU_ERR;

	*pp = p;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_bar_join_sub_init( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	i;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	for( i = 0; i < 4096; i++ ){
		long	mbr_n;

		if( (*pp)[i].path[0] == '\0' )
			break;
		if( strcmp( (*pp)[i].kind, "<Item>" ) != 0 )
			continue;

		mbr_n = (long)((*pp)[i].arg);
		if( !chk_flg( pty->mbr[mbr_n]->stat, FLG_STAT_NOT_EXIST ) )
			(*pp)[i].flg |= FLG_MENU_HIDDEN;
	}

	return NULL;
}

/**/

char	*cb_menu_bar_join_sub( menu_t **pp, menu_t **dflt )
{
	static char	sub_path[MENU_PATH_MAX_LEN + 1];
	long	mbr_n;

	if( g_sel_ls_mbr == NULL )
		return STR_MENU_ERR;

	mbr_n = (long)((*pp)->arg);
	join_mbr( g_sel_ls_mbr->ls_mbr_n, mbr_n );

	sprintf( sub_path, "%ld", g_sel_ls_mbr->ls_mbr_n );
	set_chk_off_menu( ls_menu_bar_form, sub_path );

	next_g_sel_ls_mbr();

	return "/Bar/Form";
}

/**/

char	*cb_menu_bar_not_join( menu_t **pp, menu_t **dflt )
{
	static char	sub_path[MENU_PATH_MAX_LEN + 1];

	if( g_sel_ls_mbr == NULL )
		return STR_MENU_ERR;

	not_join_mbr( g_sel_ls_mbr->ls_mbr_n, g_sel_ls_mbr->mbr_n );

	sprintf( sub_path, "%ld", g_sel_ls_mbr->ls_mbr_n );
	set_chk_on_menu( ls_menu_bar_form, sub_path );

	next_g_sel_ls_mbr();

	return "/Bar/Form";
}

/**/

void	next_g_sel_ls_mbr( void )
{
	mbr_t	**head;
	long	n;

	head = get_ls_mbr();
	n = g_sel_ls_mbr->ls_mbr_n;

	n++;
	n %= LS_MBR_MAX_N;

	if( chk_flg( head[n]->stat, FLG_STAT_NOT_EXIST ) )
		n = 0;

	g_sel_ls_mbr = head[n];
}

/**/

char	*cb_menu_bar_edit_mbr( menu_t **pp, menu_t **dflt )
{
	long	i, j, k;
	long	ls_mbr_n;
	mbr_t	**ls_mbr;
	menu_t	*p;

	ls_mbr = get_ls_mbr();
	ls_mbr_n = 0;
	p = ls_menu_bar_sel_mbr;

	k = 0;
	strncpy( p[k].path, "/Bar/Edit member",
			MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = cb_menu_bar_edit_mbr_init;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < LS_MBR_PAGE_MAX_N; i++ ){
		if( chk_flg( ls_mbr[ls_mbr_n]->stat, FLG_STAT_NOT_EXIST ) )
			break;

		strncpy( p[k].path, "/Bar/Edit member/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_TTL_MENU_BAR_EDIT_MBR,
				MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		for( j = 0; j < LS_MBR_MAX_N_PER_PAGE; j++ ){
			if( ls_mbr_n > LS_MBR_MAX_N )
				return STR_MENU_ERR;

			if( chk_flg( ls_mbr[ls_mbr_n]->stat,
					FLG_STAT_NOT_EXIST ) ){
				break;
			}

			sprintf( p[k].path, "/Bar/Edit member/%ld",
					ls_mbr_n );
			strncpy( p[k].kind, "<Branch>",
					MENU_KIND_MAX_LEN );
			p[k].key = 'A' + j;
			p[k].accel_key[0] = '\0';
			strncpy( p[k].msg, ls_mbr[ls_mbr_n]->name,
					MENU_MSG_MAX_LEN );
			p[k].call_back = cb_menu_bar_edit_mbr_sub;
			p[k].arg = ls_mbr[ls_mbr_n];
			p[k].flg = FLG_NULL;
			k++;

			ls_mbr_n++;
		}

		strncpy( p[k].path, "/Bar/Edit member/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<PageSeparator>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		p[k].msg[0] = '\0';
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';

	*pp = p;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_bar_edit_mbr_init( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	for( p = *pp + 1; p->path[0] != '\0'; p++ ){
		mbr_t	*mbr;

		if( strcmp( p->kind, "<Branch>" ) != 0 )
			continue;
		if( p->arg == NULL )
			continue;

		mbr = (mbr_t *)(p->arg);

		if( mbr == g_sel_ls_mbr )
			*dflt = p;
	}

	return NULL;
}

/**/

char	*cb_menu_bar_edit_mbr_sub( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;

	g_sel_ls_mbr = (mbr_t *)((*pp)->arg);
	if( g_sel_ls_mbr == NULL )
		return STR_MENU_ERR;

	*pp = ls_menu_bar_edit_mbr_sub;
	*dflt = NULL;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_BAR_EDIT_MBR_SUB,
			g_sel_ls_mbr->name );

	return NULL;
}

/**/

char	*cb_menu_bar_data_form( menu_t **pp, menu_t **dflt )
{
	menu_town_mbr_data( MBR_DATA_EDIT_KIND_EDIT, TRUE );

	return "/Bar/Form";
}

/**/

char	*cb_menu_bar_data_edit( menu_t **pp, menu_t **dflt )
{
	menu_town_mbr_data( MBR_DATA_EDIT_KIND_EDIT, TRUE );

	return "/Bar/Edit member/Edit member";
}

/**/

char	*cb_menu_bar_arrange( menu_t **pp, menu_t **dflt )
{
	long	trgt_ls_mbr_n;
	mbr_t	**ls_mbr, *tmp_mbr;
	long	i;

	if( g_sel_ls_mbr == NULL )
		return STR_MENU_ERR;

	ls_mbr = get_ls_mbr();
	trgt_ls_mbr_n = g_sel_ls_mbr->ls_mbr_n;

	tmp_mbr = g_sel_ls_mbr;
	for( i = trgt_ls_mbr_n - 1; i >= 0; i-- ){
		ls_mbr[i + 1] = ls_mbr[i];
		ls_mbr[i + 1]->ls_mbr_n++;
	}
	ls_mbr[0] = tmp_mbr;
	ls_mbr[0]->ls_mbr_n = 0;

	g_sel_ls_mbr = ls_mbr[0];

	return "/Bar/Edit member/Edit member";
}

/**/

char	*cb_menu_bar_new_mbr( menu_t **pp, menu_t **dflt )
{
	exec_menu_new_mbr();

	return STR_MENU_CANCEL;
}

/**/

bool_t	exec_menu_new_mbr( void )
{
	mbr_t	**ls_mbr;
	race_t	race;
	long	page_n;
	ask_t	ask;
	long	n;

	ls_mbr = get_ls_mbr();
	for( n = 0; n < LS_MBR_MAX_N; n++ )
		if( chk_flg( ls_mbr[n]->stat, FLG_STAT_NOT_EXIST ) )
			break;
	if( n >= LS_MBR_MAX_N )
		return FALSE;

	race.main = MAIN_RACE_HUMAN;
	race.sub = SUB_RACE_NULL;
	strncpy( race.name, MSG_MAIN_RACE_HUMAN, RACE_NAME_MAX_LEN );
	new_mbr( ls_mbr[n], MSG_MENU_NEW_MBR,
			'@', race, MALE, 0, n );

	page_n = 0;
	while( 1 ){
		menu_mbr_data( ls_mbr[n], &page_n,
				MBR_DATA_EDIT_KIND_NEW );

		ask = exec_menu_ask(
				MSG_TTL_MENU_ASK_NEW_MBR, ASK_NO, TRUE );
		if( (ask == ASK_YES) || (ask == ASK_NO) )
			break;
		if( ask == ASK_ERR )
			return FALSE;
	}
	if( ask != ASK_YES ){
		ls_mbr[n]->stat |= FLG_STAT_NOT_EXIST;
		return FALSE;
	}

	ls_mbr[n]->fx.prev = &(ls_mbr[n]->fx);
	ls_mbr[n]->fx.next = &(ls_mbr[n]->fx);

	return TRUE;
}

/**/

char	*cb_menu_bar_remove_mbr( menu_t **pp, menu_t **dflt )
{
	long	i, j, k;
	long	ls_mbr_n;
	mbr_t	**ls_mbr;
	menu_t	*p;

	ls_mbr = get_ls_mbr();
	ls_mbr_n = 0;
	p = ls_menu_bar_sel_mbr;

	k = 0;
	strncpy( p[k].path, "/Bar remove member",
			MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < LS_MBR_PAGE_MAX_N; i++ ){
		if( chk_flg( ls_mbr[ls_mbr_n]->stat, FLG_STAT_NOT_EXIST ) )
			break;

		strncpy( p[k].path, "/Bar remove member/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<Title>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_TTL_MENU_BAR_REMOVE_MBR,
				MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		for( j = 0; j < LS_MBR_MAX_N_PER_PAGE; j++ ){
			if( ls_mbr_n > LS_MBR_MAX_N )
				return STR_MENU_ERR;

			if( chk_flg( ls_mbr[ls_mbr_n]->stat,
					FLG_STAT_NOT_EXIST ) ){
				break;
			}

			sprintf( p[k].path, "/Bar remove member/%ld",
					ls_mbr_n );
			strncpy( p[k].kind, "<OpenWinItem>",
					MENU_KIND_MAX_LEN );
			p[k].key = 'A' + j;
			p[k].accel_key[0] = '\0';
			strncpy( p[k].msg, ls_mbr[ls_mbr_n]->name,
					MENU_MSG_MAX_LEN );
			p[k].call_back = cb_menu_bar_remove_mbr_sub;
			p[k].arg = ls_mbr[ls_mbr_n];
			p[k].flg = FLG_NULL;
			k++;

			ls_mbr_n++;
		}

		strncpy( p[k].path, "/Bar remove member/--",
				MENU_PATH_MAX_LEN );
		strncpy( p[k].kind, "<PageSeparator>",
				MENU_KIND_MAX_LEN );
		p[k].key = '\0';
		p[k].accel_key[0] = '\0';
		p[k].msg[0] = '\0';
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';

	*pp = p;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_bar_remove_mbr_sub( menu_t **pp, menu_t **dflt )
{
	mbr_t	*mbr;
	long	lev;
	ask_t	ask;

	mbr = (mbr_t *)((*pp)->arg);
	if( mbr == NULL )
		return STR_MENU_CANCEL;

	lev = get_specialist_lev( mbr );
	print_msg( FLG_NULL, MSG_MENU_REMOVE_MBR_NAME, mbr->name );
	print_msg( FLG_NULL, MSG_MENU_REMOVE_MBR_LEV, lev );
	print_msg( FLG_MSG_MORE, MSG_MENU_REMOVE_MBR_GOLD, mbr->gold );

	ask = exec_menu_ask( MSG_TTL_MENU_ASK_REMOVE_MBR, ASK_NO, TRUE );
	switch( ask ){
	case ASK_YES:
		remove_mbr( mbr );
		break;
	case ASK_NO:
		break;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	return "/Bar/Edit member/Remove member";
}

/**/

char	*cb_menu_bar_edit_class( menu_t **pp, menu_t **dflt )
{
	long	class_n;
	char	*str_goto;

	class_n = 0;

	while( 1 ){
		str_goto = exec_menu_class( &class_n );
		if( str_goto != NULL )
			return str_goto;

		str_goto = menu_edit_class( class_n );
		if( str_goto != NULL )
			return str_goto;
	}
}

/**/

char	*menu_edit_class( long n )
{
	class_t	*p;
	long	add;

	p = get_class_tab();
	if( p == NULL )
		return STR_MENU_ERR;

	while( 1 ){
		add = exec_edit_class( &(p[n]), FALSE );
		if( add == 0 )
			break;

		if( add > 0 ){
			n++;
			if( p[n].name[0] == '\0' )
				n = 0;
		} else {
			n--;
			if( n < 0 ){
				for( n = 0; n < CLASS_MAX_N; n++ )
					if( p[n + 1].name[0] == '\0' )
						break;
			}
		}
	}

	return NULL;
}

/**/

char	*cb_menu_bar_new_class( menu_t **pp, menu_t **dflt )
{
	class_t	*p;
	long	n;

	p = get_class_tab();
	if( p == NULL )
		return STR_MENU_ERR;

	for( n = 0; n < CLASS_MAX_N; n++ )
		if( p[n].name[0] == '\0' )
			break;
	if( n >= CLASS_MAX_N ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_MENU_NEW_CLASS );
		return STR_MENU_ERR;
	}

	strncpy( p[n].name, MSG_MENU_NEW_CLASS, CLASS_NAME_MAX_LEN );

	menu_new_class( n );

	return STR_MENU_CANCEL;
}

/**/

char	*menu_new_class( long n )
{
	class_t	*p;
	long	add;

	p = get_class_tab();
	if( p == NULL )
		return STR_MENU_ERR;

	while( 1 ){
		add = exec_edit_class( &(p[n]), TRUE );
		if( add == 0 )
			break;
	}

	return NULL;
}

/**/

long	exec_edit_class( class_t *org, bool_t flg_new )
{
	static edit_class_t	n = EDIT_CLASS_NEXT;
	edit_class_t	prev_n;
	class_t	edit, *work;
	bool_t	flg_sel_add;

	if( org == NULL )
		return 0;

	work = &edit;
	*work = *org;

	prev_n = n;
	flg_sel_add = TRUE;

	draw_edit_class_all( org, work, n, flg_sel_add );

	while( 1 ){
		if( n > EDIT_CLASS_MAX_N - 1 )
			n = EDIT_CLASS_NULL + 1;
		if( n < EDIT_CLASS_NULL + 1 )
			n = EDIT_CLASS_MAX_N - 1;

		draw_edit_class( org, work, prev_n, FALSE, flg_sel_add );
		draw_edit_class( org, work, n, TRUE, flg_sel_add );
		prev_n = n;

		switch( get_key( FALSE ) ){
		case CASE_CANCEL:
			if( exec_menu_ask_edit_class( org, work, flg_new ) )
				return 0;
			draw_edit_class_all( org, work, n, flg_sel_add );
			break;
		case CASE_ENTER:
			if( n == EDIT_CLASS_NEXT ){
				if( exec_menu_ask_edit_class(
						org, work, flg_new ) ){
					return +1;
				}
				draw_edit_class_all( org, work, n,
						flg_sel_add );
				break;
			} else if( n == EDIT_CLASS_PREV ){
				if( exec_menu_ask_edit_class(
						org, work, flg_new ) ){
					return -1;
				}
				draw_edit_class_all( org, work, n,
						flg_sel_add );
				break;
			} else if( n == EDIT_CLASS_NAME ){
				draw_edit_class( org, work, n,
						FALSE, flg_sel_add );
				gets_class_name( work->name );
				break;
			}

			if( flg_sel_add )
				menu_edit_class_inc_abl( work, n, +1 );
			else
				menu_edit_class_inc_abl( work, n, -1 );
			draw_edit_class( org, work, EDIT_CLASS_TOTAL,
					FALSE, flg_sel_add );
			break;
		case CASE_CRSR_LEFT:
			flg_sel_add = TRUE;
			break;
		case CASE_CRSR_RIGHT:
			flg_sel_add = FALSE;
			break;
		case CASE_CRSR_DOWN:
			n++;
			break;
		case CASE_CRSR_UP:
			n--;
			break;
		default:
			break;
		}
	}

	return 0;
}

/**/

char	*cb_menu_bar_remove_class( menu_t **pp, menu_t **dflt )
{
	long	class_n;
	char	*str_goto;
	ask_t	ask;

	class_n = 0;
	str_goto = exec_menu_class( &class_n );
	if( str_goto != NULL )
		return str_goto;

	ask = exec_menu_ask( MSG_TTL_MENU_ASK_REMOVE_CLASS, ASK_NO, TRUE );
	switch( ask ){
	case ASK_YES:
		remove_class( class_n );
		break;
	case ASK_NO:
		break;
	case ASK_CANCEL:
		return STR_MENU_CANCEL;
	case ASK_ERR:
		return STR_MENU_ERR;
	}

	return STR_MENU_CANCEL;
}

/**/

rate_t	calc_abl_total( class_t *p )
{
	rate_t	sum;
	abl_kind_t	abl;

	sum = 0;

	for( abl = 0; abl < ABL_KIND_MAX_N; abl++ )
		sum += p->abl_rate[abl];

	return sum;
}

/**/

bool_t	exec_menu_ask_edit_class(
	class_t *org, class_t *work, bool_t flg_new
)
{
	rate_t	total;
	ask_t	ask;

	total = calc_abl_total( work );

	if( total == _100_PERCENT )
		if( cmp_class( org, work ) )
			return TRUE;

	ask = exec_menu_ask( MSG_TTL_MENU_ASK_EDIT_CLASS, ASK_NO, TRUE );
	switch( ask ){
	case ASK_YES:
	case ASK_NO:
		break;
	case ASK_CANCEL:
	case ASK_ERR:
		return FALSE;	/* Cancel */
	}

	if( ask == ASK_YES ){
		if( total != _100_PERCENT ){
			print_msg( FLG_MSG_MORE, MSG_S,
					MSG_ERR_MENU_EDIT_CLASS );
			return FALSE;	/* Cancel */
		} else {
			*org = *work;
		}
	} else {
		if( flg_new )
			org->name[0] = '\0';
		*work = *org;
	}

	return TRUE;
}

/**/

void	menu_edit_class_inc_abl(
	class_t *p, edit_class_t n, long add
)
{
	rate_t	sum;
	abl_kind_t	abl;

	sum = calc_abl_total( p );
	if( sum + add > _100_PERCENT )
		add = _100_PERCENT - sum;

	abl = ABL_KIND_HP;

	switch( n ){
	case EDIT_CLASS_NULL:
	case EDIT_CLASS_MAX_N:
		return;
	case EDIT_CLASS_TOTAL:
	case EDIT_CLASS_NAME:
	case EDIT_CLASS_PREV:
	case EDIT_CLASS_NEXT:
		return;
/**/
	case EDIT_CLASS_HP:
		abl = ABL_KIND_HP;
		break;
	case EDIT_CLASS_MP:
		abl = ABL_KIND_MP;
		break;
	case EDIT_CLASS_DEX:
		abl = ABL_KIND_DEX;
		break;
	case EDIT_CLASS_STR:
		abl = ABL_KIND_STR;
		break;
	case EDIT_CLASS_AGI:
		abl = ABL_KIND_AGI;
		break;
	case EDIT_CLASS_WIS:
		abl = ABL_KIND_WIS;
		break;
	case EDIT_CLASS_INT:
		abl = ABL_KIND_INT;
		break;
	case EDIT_CLASS_CHA:
		abl = ABL_KIND_CHA;
		break;
	case EDIT_CLASS_FIG:
		abl = ABL_KIND_FIG;
		break;
	case EDIT_CLASS_MON:
		abl = ABL_KIND_MON;
		break;
	case EDIT_CLASS_HUN:
		abl = ABL_KIND_HUN;
		break;
	case EDIT_CLASS_THI:
		abl = ABL_KIND_THI;
		break;
	case EDIT_CLASS_MAG:
		abl = ABL_KIND_MAG;
		break;
	case EDIT_CLASS_SOR:
		abl = ABL_KIND_SOR;
		break;
	case EDIT_CLASS_ENC:
		abl = ABL_KIND_ENC;
		break;
	case EDIT_CLASS_SUM:
		abl = ABL_KIND_SUM;
		break;
	case EDIT_CLASS_PRI:
		abl = ABL_KIND_PRI;
		break;
	case EDIT_CLASS_SHA:
		abl = ABL_KIND_SHA;
		break;
	case EDIT_CLASS_BAR:
		abl = ABL_KIND_BAR;
		break;
	case EDIT_CLASS_NIN:
		abl = ABL_KIND_NIN;
		break;
	}

	p->abl_rate[abl] += add;
	if( p->abl_rate[abl] < ABL_RATE_MIN_N )
		p->abl_rate[abl] = ABL_RATE_MIN_N;
	if( p->abl_rate[abl] > ABL_RATE_MAX_N )
		p->abl_rate[abl] = ABL_RATE_MAX_N;
}

/**/

char	*cb_menu_bar_save( menu_t **pp, menu_t **dflt )
{
	save_dun();
	save_town();

	print_msg( FLG_NULL, MSG_S, MSG_INCOMPLETE );

	return STR_MENU_CANCEL;
}

/**/

char	*menu_inn( void )
{
	menu_t	*p;

	p = srch_menu( ls_menu_inn, "Stay" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_INN_STAY, (long)CHARGE_STAY_INN );

	return exec_menu( ls_menu_inn, NULL, NULL );
}

/**/

char	*cb_menu_inn_stay( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	mbr_n;
	bool_t	flg_pay;

	flg_pay = TRUE;
	for( mbr_n = 0; mbr_n < MBR_MAX_N; mbr_n++ )
		if( !chk_pay( CHARGE_STAY_INN, pty->mbr[mbr_n] ) )
			flg_pay = FALSE;

	if( !flg_pay )
		return STR_MENU_CANCEL;

	for( mbr_n = 0; mbr_n < MBR_MAX_N; mbr_n++ )
		add_chr_gold( pty->mbr[mbr_n], -CHARGE_STAY_INN );

	stay_inn();

	print_msg( FLG_NULL, MSG_S, MSG_MENU_INN_DO_STAY );

	return NULL;
}

/**/
