/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: amenu_tab.h,v 1.2 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#ifndef	AMENU_TAB_H
#define	AMENU_TAB_H

static menu_t	ls_menu_auto_mark[1 + 1 + ((1 + 3) * AUTO_MARK_MAX_N) + 1];

static menu_t	ls_menu_appoint_item
		[1 + 1 + (AUTO_MARK_APPOINT_ITEM_MAX_N * 2) + 1];

static menu_t	ls_menu_auto_mark_edit[] = {
	{
		"/Edit",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_edit_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* Target */
	{
		"/Edit/Target",
		"<Branch>",
		'T',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_trgt_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Target/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Target/Monster",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MNSTR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_MNSTR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Item",
		"<Item>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_ITEM, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_ITEM,
		FLG_NULL,
	},
	{
		"/Edit/Target/Door",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_DOOR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_DOOR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Trap",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_TRAP, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_TRAP,
		FLG_NULL,
	},
	{
		"/Edit/Target/Member",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_MBR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_MBR,
		FLG_NULL,
	},
	{
		"/Edit/Target/Unchange",
		"<Item>",
		'U',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_UNCHANGE, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_UNCHANGE,
		FLG_NULL,
	},
	{
		"/Edit/Target/Clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_TRGT_CLEAR, "",
		cb_menu_auto_mark_trgt, (void *)AUTO_MARK_TRGT_CLEAR,
		FLG_NULL,
	},
/* Dist */
	{
		"/Edit/Dist",
		"<Branch>",
		'D',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_dist_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Near",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_NEAR, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_NEAR,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Medium",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_MEDIUM, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_MEDIUM,
		FLG_NULL,
	},
	{
		"/Edit/Dist/Far",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_DIST_FAR, "",
		cb_menu_auto_mark_dist, (void *)AUTO_MARK_DIST_FAR,
		FLG_NULL,
	},
/* Action */
	{
		"/Edit/Action",
		"<Branch>",
		'A',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_act_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_FIGHT, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_FIGHT,
		FLG_NULL,
	},
	{
		"/Edit/Action/Throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_THROW, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_THROW,
		FLG_NULL,
	},
	{
		"/Edit/Action/Tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_TAIL, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_TAIL,
		FLG_NULL,
	},
	{
		"/Edit/Action/Pick up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PICK_UP, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_PICK_UP,
		FLG_NULL,
	},
	{
		"/Edit/Action/Open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_OPEN, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_OPEN,
		FLG_NULL,
	},
	{
		"/Edit/Action/Close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_CLOSE, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_CLOSE,
		FLG_NULL,
	},
	{
		"/Edit/Action/Jam",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_JAM, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_JAM,
		FLG_NULL,
	},
	{
		"/Edit/Action/Disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_DISARM, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_DISARM,
		FLG_NULL,
	},
	{
		"/Edit/Action/Break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_BREAK, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_BREAK,
		FLG_NULL,
	},
	{
		"/Edit/Action/Peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_PEEP, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_PEEP,
		FLG_NULL,
	},
	{
		"/Edit/Action/Search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_ACT_SRCH, "",
		cb_menu_auto_mark_act, (void *)AUTO_MARK_ACT_SRCH,
		FLG_NULL,
	},
/* Condition */
	{
		"/Edit/Condition",
		"<Branch>",
		'C',
		"",
		N_MSG_NULL, "",
		cb_menu_auto_mark_cond_init, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Nearest",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_AUTO_MARK_COND_NEAREST, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_NEAREST,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Disperse",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_AUTO_MARK_COND_DISPERSE, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_DISPERSE,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Stagger",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_AUTO_MARK_COND_STAGGER, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_STAGGER,
		FLG_NULL,
	},
	{
		"/Edit/Condition/Own",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_COND_OWN, "",
		cb_menu_auto_mark_cond, (void *)AUTO_MARK_COND_OWN,
		FLG_NULL,
	},
/* Appoint Item */
	{
		"/Edit/Appoint item",
		"<Branch>",
		'I',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_APPOINT_ITEM, "",
		cb_menu_auto_mark_appoint_item, NULL,
		FLG_NULL,
	},
/**/
	{
		"/Edit/Continue",
		"<CheckItem>",
		'O',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_CONT, "",
		cb_menu_auto_mark_cont, NULL,
		FLG_NULL,
	},
	{
		"/Edit/Priority",
		"<CheckItem>",
		'P',
		"",
		N_MSG_MENU_AUTO_MARK_EDIT_PRIORITY, "",
		cb_menu_auto_mark_priority, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

#endif	/* AMENU_TAB_H */
