/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: dun.c,v 1.34 2003/11/23 05:13:28 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
#include	"dun.h"
#include	"town.h"
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
/*#include	"turn_prot.h"*/
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
#include	"gfile_prot.h"
/*#include	"msg_prot.h"*/

/**/

#define	PATH_WIDTH	3
#define	AREA_PATH	-1
#define	STAIRS_UP_MAX_N	2
#define	STAIRS_DOWN_MAX_N	2
#define	DOOR_NEAR_R	4

#define	MIMIC_RATE	50

/**/

static dun_t	dun;
static long	room_ptn_max_n;

static crsr_ptn_t	g_crsr_ptn, g_crsr_ptn_usr[CRSR_PTN_MAX_N];
static long	g_crsr_ptn_n, g_crsr_ptn_max_n;

/**/

#include	"dun_tab.h"
#include	"crsr_ptn.h"

/**/

void	init_dun( void )
{
	long	i;

	reset_dun();

	/* cursor */

	g_crsr_ptn_n = 0;

	if( load_crsr_ptn( g_crsr_ptn_usr, &g_crsr_ptn_max_n ) ){
		for( i = 0; i < g_crsr_ptn_max_n; i++ )
			set_crsr_ptn( &(g_crsr_ptn_usr[i]) );
	} else {
		g_crsr_ptn_max_n = sizeof( crsr_ptn_dflt )
				/ sizeof( crsr_ptn_dflt[0] );

		for( i = 0; i < g_crsr_ptn_max_n; i++ ){
			set_crsr_ptn( &(crsr_ptn_dflt[i]) );
			g_crsr_ptn_usr[i] = crsr_ptn_dflt[i];
		}
	}

	set_crsr_ptn( &(g_crsr_ptn_usr[g_crsr_ptn_n]) );
}

/**/

long	get_crsr_ptn_max_n( void )
{
	return g_crsr_ptn_max_n;
}

/**/

long	set_crsr_ptn_max_n( long n )
{
	long	prev;

	prev = g_crsr_ptn_max_n;
	g_crsr_ptn_max_n = n;

	return prev;
}

/**/

long	get_crsr_ptn_n( void )
{
	return g_crsr_ptn_n;
}

/**/

long	set_crsr_ptn_n( long n )
{
	long	prev;

	prev = g_crsr_ptn_n;
	g_crsr_ptn_n = n;

	return prev;
}

/**/

void	reset_crsr_ptn( void )
{
	set_crsr_ptn( &(g_crsr_ptn_usr[g_crsr_ptn_n]) );
}

/**/

void	reset_dun( void )
{
	long	x, y;

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			dun.map.sect[y][x] = 'z';

			dun.map.obj.mjr[y][x] = FACE_MJR_WALL;
			dun.map.obj.mnr[y][x] = FACE_MNR_WALL;
			dun.map.obj.flg[y][x] = FLG_NULL;

			dun.map.chr.mjr[y][x] = FACE_MJR_NULL;
			dun.map.chr.mnr[y][x] = FACE_MNR_NULL;
			dun.map.chr.flg[y][x] = FLG_NULL;

			dun.map.total.mjr[y][x] = FACE_MJR_WALL;
			dun.map.total.mnr[y][x] = FACE_MNR_WALL;
			dun.map.total.flg[y][x] = FLG_NULL;

			dun.map.light_depth_obj[y][x] = 0;
			dun.map.light_depth_chr[y][x] = 0;
		}
	}

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			dun.area[y][x] = AREA_PATH;
		}
	}

	dun.door_n = 0;
}

/**/

crsr_ptn_t	*get_crsr_ptn( void )
{
	return &g_crsr_ptn;
}

/**/

bool_t	set_crsr_ptn( crsr_ptn_t *ptn )
{
	long	max_len;
	long	y;

	if( ptn == NULL )
		return FALSE;

	g_crsr_ptn = *ptn;

	max_len = 0;
	for( y = 0; y < CRSR_PTN_MAX_Y_LEN; y++ ){
		long	len;

		if( g_crsr_ptn.face[y][0] == '\0' )
			break;

		len = str_len_std( g_crsr_ptn.face[y] ) / 2;
		max_len = max( max_len, len );
	}
	g_crsr_ptn.x_len = max_len;
	g_crsr_ptn.y_len = y;
	ptn->x_len = max_len;
	ptn->y_len = y;

	return TRUE;
}

/**/

void	up_dun( long d )
{
	long	i;
	party_t	*pty;

	pty = get_party();

	dun.lev += d;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( sgn( dun.lev ) >= +1 ){
			if( pty->mbr[i]->dun_max_lev_floor
					< abs( dun.lev ) ){
				pty->mbr[i]->dun_max_lev_floor
						= abs( dun.lev );
			}
		}
		if( sgn( dun.lev ) <= -1 ){
			if( pty->mbr[i]->dun_max_lev_base
					< abs( dun.lev ) ){
				pty->mbr[i]->dun_max_lev_base
						= abs( dun.lev );
			}
		}
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		clr_chr_trgt_act( pty->mbr[i], FALSE );

	reset_all( TRUE );
}

/**/

void	reset_all( bool_t flg_appear )
{
	reset_trap();
	clr_dun_item();
	reset_mnstr();
	release_all_mbr();
	if( dun.lev == 0 ){
		make_town();
		if( flg_appear ){
			if( !appear_party_town( FALSE ) )
				appear_party( FALSE );
		}
	} else {
		make_dun();
		if( flg_appear ){
			appear_party( FALSE );
		}
	}
	next_pos_square( 0 );
	set_flg_find_all_mnstr();
	redraw_all();
}

/**/

void	make_dun( void )
{
	long	i, j;
	long	item_n, item_max_n;
	long	mnstr_n, mnstr_max_n;
	long	trap_n, trap_max_n;

	reset_dun();

	room_ptn_max_n = sizeof( room_ptn ) / sizeof( room_ptn_t );

	/* ¤ */
	for( i = 0; i < AREA_MAP_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAP_MAX_X; j++ ){
			make_area( room_ptn, j, i );
		}
	}

	/* ϩ¤ */
	for( i = 0; i < AREA_MAP_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAP_MAX_X; j++ ){
			if( dun.area[i][j] == AREA_PATH ){
				make_path( j, i );
			}
		}
	}

	/* ʿ */
	for( i = 0; i < AREA_MAP_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAP_MAX_X - 1; j++ ){
			if( !chk_room( j, i ) )
				continue;
			if( chk_room( j + 1, i ) )
				connect_room( j, i, +1, 0 );
		}
	}

	/* ľ */
	for( i = 0; i < AREA_MAP_MAX_Y - 1; i++ ){
		for( j = 0; j < AREA_MAP_MAX_X; j++ ){
			if( !chk_room( j, i ) )
				continue;
			if( chk_room( j, i + 1 ) )
				connect_room( j, i, 0, +1 );
		}
	}

	/* ޥåפüɤˤ */
	make_fence();

	/* ʤ¤ */
	/*  */
	for( i = 0; i < STAIRS_UP_MAX_N; i++ ){
		for( j = 0; j < 4096; j++ ){
			long	x, y;

			x = randm( MAP_MAX_X );
			y = randm( MAP_MAX_Y );
			if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR ){
				make_stairs( x, y, FACE_MJR_STAIRS_UP );
				break;
			}
		}
	}
	/*  */
	for( i = 0; i < STAIRS_DOWN_MAX_N; i++ ){
		for( j = 0; j < 4096; j++ ){
			long	x, y;

			x = randm( MAP_MAX_X );
			y = randm( MAP_MAX_Y );
			if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR ){
				make_stairs( x, y, FACE_MJR_STAIRS_DOWN );
				break;
			}
		}
	}

	/* ꥢƥ */

	item_n = 0;

	for( i = 0; i < MAP_MAX_Y; i++ ){
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( dun.map.obj.mjr[i][j] != FACE_ROOM_PTN_ITEM )
				continue;

			dun.map.obj.mjr[i][j] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[i][j] = FACE_MNR_FLOOR;
			dun.map.obj.flg[i][j] = FLG_MAP_OBJ_PASS;
			if( make_item( j, i, dun.lev )
					!= ITEM_KIND_NULL ){
				item_n++;
			}
		}
	}

	/* 󥹥 */

	for( i = 0; i < MAP_MAX_Y; i++ ){
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( dun.map.obj.mjr[i][j] != FACE_ROOM_PTN_MIMIC )
				continue;

			dun.map.obj.mjr[i][j] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[i][j] = FACE_MNR_FLOOR;
			dun.map.obj.flg[i][j] |= FLG_MAP_OBJ_PASS;
			if( rate_randm( MIMIC_RATE ) ){
				make_mnstr( j, i, dun.lev,
						MNSTR_KIND_MIMIC );
			} else {
				item_t	*item;

				item = make_item_chest( dun.lev,
						get_chest_n( dun.lev ) );
				if( item == NULL )
					continue;
				if( !put_item( j, i, 1, item, FALSE ) ){
					del_item( item );
					continue;
				}
			}
		}
	}

	/*  */

	for( i = 0; i < MAP_MAX_Y; i++ ){
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( dun.map.obj.mjr[i][j] != FACE_ROOM_PTN_TRAP )
				continue;

			dun.map.obj.mjr[i][j] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[i][j] = FACE_MNR_FLOOR;
			dun.map.obj.flg[i][j] |= FLG_MAP_OBJ_PASS;

			make_trap( j, i, dun.lev );
		}
	}

	/* ॢƥ */

	item_max_n = roll_dice( DUN_ITEM_AVE_N );

	for( i = 0; i < 10240; i++ ){
		long	x, y;

		if( item_n >= item_max_n )
			break;

		x = 1 + randm( MAP_MAX_X - 2 );
		y = 1 + randm( MAP_MAX_Y - 2 );
		if( make_item( x, y, dun.lev ) != ITEM_KIND_NULL )
			item_n++;
	}
	item_max_n = item_n;

	/* 󥹥 */

	mnstr_max_n = roll_dice( MNSTR_AVE_N );
	if( mnstr_max_n > MNSTR_MAX_N )
		mnstr_max_n = MNSTR_MAX_N;

	mnstr_n = 0;
	for( i = 0; i < 4096; i++ ){
		long	x, y;

		if( mnstr_n >= mnstr_max_n )
			break;

		x = 1 + randm( MAP_MAX_X - 2 );
		y = 1 + randm( MAP_MAX_Y - 2 );
		if( make_mnstr_rand( x, y, dun.lev ) != NULL )
			mnstr_n++;
	}

	/*  */

	trap_max_n = roll_dice( TRAP_AVE_N );
	if( trap_max_n > TRAP_MAX_N )
		trap_max_n = TRAP_MAX_N;

	trap_n = 0;
	for( i = 0; i < 1024; i++ ){
		long	x, y;
		trap_t	*trap;

		x = 0;
		y = 0;
		for( j = 0; j < 128; j++ ){
			x = 1 + randm( MAP_MAX_X - 2 );
			y = 1 + randm( MAP_MAX_Y - 2 );
			if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
				break;
		}

		trap = make_trap( x, y, dun.lev );
		if( trap != NULL )
			trap_n++;
		if( trap_n >= trap_max_n )
			break;
	}

	/* ȥå */

	for( i = 0; i < AREA_MAP_MAX_Y; i++ )
		for( j = 0; j < AREA_MAP_MAX_X; j++ )
			make_trap_room( j, i, dun.lev );
}

/**/

void	make_fence( void )
{
	long	n;

	for( n = 0; n < MAP_MAX_Y; n++ ){
		if( dun.map.obj.mnr[n][0] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[n][0] = FACE_MJR_WALL;
		dun.map.obj.mnr[n][0] = FACE_MNR_WALL;
		dun.map.obj.flg[n][0] &= ~(FLG_MAP_OBJ_PASS);
	}
	for( n = 0; n < MAP_MAX_Y; n++ ){
		if( dun.map.obj.mnr[n][MAP_MAX_X - 1] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[n][MAP_MAX_X - 1] = FACE_MJR_WALL;
		dun.map.obj.mnr[n][MAP_MAX_X - 1] = FACE_MNR_WALL;
		dun.map.obj.flg[n][MAP_MAX_X - 1] &= ~(FLG_MAP_OBJ_PASS);
	}

	for( n = 0; n < MAP_MAX_X; n++ ){
		if( dun.map.obj.mnr[0][n] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[0][n] = FACE_MJR_WALL;
		dun.map.obj.mnr[0][n] = FACE_MNR_WALL;
		dun.map.obj.flg[0][n] &= ~(FLG_MAP_OBJ_PASS);
	}
	for( n = 0; n < MAP_MAX_X; n++ ){
		if( dun.map.obj.mnr[MAP_MAX_Y - 1][n] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[MAP_MAX_Y - 1][n] = FACE_MJR_WALL;
		dun.map.obj.mnr[MAP_MAX_Y - 1][n] = FACE_MNR_WALL;
		dun.map.obj.flg[MAP_MAX_Y - 1][n] &= ~(FLG_MAP_OBJ_PASS);
	}
}

/**/

void	make_area( room_ptn_t *ptn, long x, long y )
{
	long	i;
	long	flg;

	dun.area[y][x] = AREA_PATH;

	if( chk_rate_room() ){
		return;
	}

	for( i = 0; i < (room_ptn_max_n * 64); i++ ){
		long	n;

		n = randm( room_ptn_max_n );
		if( abs( dun.lev ) < ptn[n].min_lev )
			continue;
		if( ptn[n].max_lev < abs( dun.lev ) )
			continue;
		if( sgn( dun.lev ) != ptn[n].sgn_lev )
			continue;

		flg = (randm( 8 ) >> 1);	/* ľʿե饰 */
		set_room( ptn, x, y, n, flg );
		break;
	}
}

/**/

void	set_room( room_ptn_t *room, long x, long y, long n, long flg )
{
	long	i, j, ii, jj;
	long	mx, my;
	char	face;
	sect_t	sect;
	flg_map_t	flg_light;

	dun.area[y][x] = n;
	flg_light = chk_lighted_room();

	for( i = 0; i < AREA_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAX_X; j++ ){
			if( chk_flg( flg, 0x02 ) )
				ii = AREA_MAX_Y - 1 - i;
			else
				ii = i;

			if( chk_flg( flg, 0x01 ) )
				jj = AREA_MAX_X - 1 - j;
			else
				jj = j;

			mx = x * AREA_MAX_X + jj;
			my = y * AREA_MAX_Y + ii;

			face = room[n].ptn[i][j];
			sect = room[n].sect[i][j];
			if( face == FACE_MJR_FLOOR ){
				dun.map.obj.mjr[my][mx] = FACE_MJR_FLOOR;
				dun.map.obj.mnr[my][mx] = FACE_MNR_FLOOR;
				dun.map.obj.flg[my][mx] = FLG_MAP_OBJ_PASS;
				dun.map.sect[my][mx] = sect;
			} else if( face == FACE_MJR_WALL ){
				dun.map.obj.mjr[my][mx] = FACE_MJR_WALL;
				dun.map.obj.mnr[my][mx] = FACE_MNR_WALL;
				dun.map.obj.flg[my][mx] = FLG_NULL;
				dun.map.sect[my][mx] = sect;
			} else {
				dun.map.obj.mjr[my][mx] = face;
				dun.map.obj.mnr[my][mx] = FACE_MNR_NULL;
				dun.map.obj.flg[my][mx] = FLG_MAP_OBJ_PASS;
				dun.map.sect[my][mx] = sect;
			}
			if( flg_light )
				dun.map.light_depth_obj[my][mx] = 1;
			else
				dun.map.light_depth_obj[my][mx] = 0;
		}
	}

	/* Ūʥɥ */

	for( i = 0; i < AREA_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAX_X; j++ ){
			mx = x * AREA_MAX_X + j;
			my = y * AREA_MAX_Y + i;
			if( dun.map.obj.mjr[my][mx]
					== FACE_MJR_DOOR_CLOSE ){
				make_door_room( mx, my );
			}
		}
	}
}

/**/

bool_t	chk_lighted_room( void )
{
	rate_t	rate;

	rate = 80 - (randm( abs( dun.lev ) ) * 2);

	if( rate <= 0 )
		return FALSE;
	return rate_randm( rate );
}

/**/

bool_t	chk_lighted_path( void )
{
	rate_t	rate;

	rate = 40 - (randm( abs( dun.lev ) ) * 2);

	if( rate <= 0 )
		return FALSE;
	return rate_randm( rate );
}

/**/

void	make_path( long area_x, long area_y )
{
	long	bgn_x, bgn_y, end_x, end_y;
	long	bend_x, bend_y;
	long	mx, my;

	mx = area_x * AREA_MAX_X;
	my = area_y * AREA_MAX_Y;


	/* ʿϩĤʤ */

	bgn_y = chk_extend_path_h( area_x, area_y, -1 );
		/* ٤ϩΣٺɸ */
	end_y = chk_extend_path_h( area_x, area_y, +1 );
		/* ٤ϩΣٺɸ */
	bend_x = 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 );
		/* ޤʤغɸ */

	line_path( mx + 0, my + bgn_y, mx + bend_x, my + bgn_y );
	line_path( mx + bend_x, my + bgn_y, mx + bend_x, my + end_y );
	line_path( mx + bend_x, my + end_y,
			mx + AREA_MAX_X - PATH_WIDTH, my + end_y );

	if( chk_room( area_x - 1, area_y ) ){
		finish_path( mx + 0,
				my + bgn_y, -1, 0 );
	}
	if( chk_room( area_x + 1, area_y ) ){
		finish_path( mx + AREA_MAX_Y - PATH_WIDTH,
				my + end_y, +1, 0 );
	}


	/* ľϩĤʤ */

	bgn_x = chk_extend_path_v( area_x, area_y, -1 );
		/* ٤ϩΣغɸ */
	end_x = chk_extend_path_v( area_x, area_y, +1 );
		/* ٤ϩΣغɸ */
	bend_y = 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 );
		/* ޤʤٺɸ */

	line_path( mx + bgn_x, my + 0, mx + bgn_x, my + bend_y );
	line_path( mx + bgn_x, my + bend_y, mx + end_x, my + bend_y );
	line_path( mx + end_x, my + bend_y,
			mx + end_x, my + AREA_MAX_Y - PATH_WIDTH );

	if( chk_room( area_x, area_y - 1 ) ){
		finish_path( mx + bgn_x,
				my + 0, 0, -1 );
	}
	if( chk_room( area_x, area_y + 1 ) ){
		finish_path( mx + end_x,
				my + AREA_MAX_Y - PATH_WIDTH, 0, +1 );
	}

	if( chk_lighted_path() ){
		on_light_area( area_x * AREA_MAX_X,
				area_y * AREA_MAX_Y, FALSE );
	}
}

/**/

long	chk_extend_path_h( long ax, long ay, long d )
/* ٤ΥꥢϩӤƤ뤫 */
{
	long	i;
	long	map_x, map_y;

	if( ((ax + d) < 0) || (AREA_MAP_MAX_X <= (ax + d)) )
			/* Ϥ߽Ф */
		return( 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 ) );

	if( d <= -1 )
		map_x = (ax + d) * AREA_MAX_X + (AREA_MAX_X - 1);
	else
		map_x = (ax + d) * AREA_MAX_X + 0;

	for( i = 0; i < AREA_MAX_Y - PATH_WIDTH + 1; i++ ){
		map_y = ay * AREA_MAX_Y + i;

		if( dun.map.obj.mjr[map_y][map_x] == FACE_MJR_FLOOR ){
			return i;
		}
	}

	return( 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 ) );
		/* ˷᤿ٺɸ */
}

/**/

long	chk_extend_path_v( long ax, long ay, long d )
/* ٤ΥꥢϩӤƤ뤫 */
{
	long	i;
	long	map_x, map_y;

	if( ((ay + d) < 0) || (AREA_MAP_MAX_Y <= (ay + d)) )
			/* Ϥ߽Ф */
		return( 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 ) );

	if( d <= -1 )
		map_y = (ay + d) * AREA_MAX_Y + (AREA_MAX_Y - 1);
	else
		map_y = (ay + d) * AREA_MAX_Y + 0;

	for( i = 0; i < AREA_MAX_X - PATH_WIDTH + 1; i++ ){
		map_x = ax * AREA_MAX_X + i;

		if( dun.map.obj.mjr[map_y][map_x] == FACE_MJR_FLOOR ){
			return i;
		}
	}

	return( 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 ) );
		/* ˷᤿غɸ */
}

/**/

bool_t	chk_room( long ax, long ay )
{
	if( ax < 0 )
		return FALSE;
	if( ax >= AREA_MAP_MAX_X )
		return FALSE;
	if( ay < 0 )
		return FALSE;
	if( ay >= AREA_MAP_MAX_Y )
		return FALSE;

	if( dun.area[ay][ax] == AREA_PATH )
		return FALSE;

	return TRUE;
}

/**/

void	finish_path( long mx, long my, long dx, long dy )
/* ޤϩ򿭤Ф */
{
	long	i;

	if( dx < 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_X; i++ ){
			if( chk_finish_path( mx, my, -1, 0 ) )
				break;
			put_path( mx, my, -1, 0 );	/* ϩ򿭤Ф */
			mx--;
		}
	} else if( dx > 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_X; i++ ){
			if( chk_finish_path( mx, my, +1, 0 ) )
				break;
			put_path( mx, my, +1, 0 );	/* ϩ򿭤Ф */
			mx++;
		}
	} else if( dy < 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_Y; i++ ){
			if( chk_finish_path( mx, my, 0, -1 ) )
				break;
			put_path( mx, my, 0, -1 );	/* ϩ򿭤Ф */
			my--;
		}
	} else if( dy > 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_Y; i++ ){
			if( chk_finish_path( mx, my, 0, +1 ) )
				break;
			put_path( mx, my, 0, +1 );	/* ϩ򿭤Ф */
			my++;
		}
	}
}

/**/

bool_t	chk_finish_path( long mx, long my, long dx, long dy )
{
	long	i;
	bool_t	flg;

	if( dx < 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + dx]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - 1][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + PATH_WIDTH][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}
	} else if( dx > 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + dx + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - 1][mx - i + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + PATH_WIDTH]
					[mx - i + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
 			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}
	} else if( dy < 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + dy][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + PATH_WIDTH]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}
	} else if( dy > 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + dy + PATH_WIDTH - 1][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - i + PATH_WIDTH - 1][mx - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - i + PATH_WIDTH - 1]
					[mx + PATH_WIDTH]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}
	}

	return FALSE;
}

/**/

void	connect_room( long ax, long ay, long dx, long dy )
{
	long	mx, my;

	if( dx < 0 ){	/* λ */
		my = ay * AREA_MAX_Y + 1
				+ randm( AREA_MAX_Y - PATH_WIDTH - 2 );

		mx = ax * AREA_MAX_X - 1;
		finish_path( mx, my, -1, 0 );
		mx = ax * AREA_MAX_X - PATH_WIDTH + 1;
		finish_path( mx, my, +1, 0 );
	} else if( dx > 0 ){	/* λ */
		my = ay * AREA_MAX_Y + 1
				+ randm( AREA_MAX_Y - PATH_WIDTH - 2 );

		mx = ax * AREA_MAX_X + AREA_MAX_X - 1;
		finish_path( mx, my, -1, 0 );
		mx = ax * AREA_MAX_X + AREA_MAX_X - PATH_WIDTH + 1;
		finish_path( mx, my, +1, 0 );
	} else if( dy < 0 ){	/* λ */
		mx = ax * AREA_MAX_X + 1
				+ randm( AREA_MAX_X - PATH_WIDTH - 2 );

		my = ay * AREA_MAX_Y - 1;
		finish_path( mx, my, 0, -1 );
		my = ay * AREA_MAX_Y - PATH_WIDTH + 1;
		finish_path( mx, my, 0, +1 );
	} else if( dy > 0 ){	/* λ */
		mx = ax * AREA_MAX_X + 1
				+ randm( AREA_MAX_X - PATH_WIDTH - 2 );

		my = ay * AREA_MAX_Y + AREA_MAX_Y - 1;
		finish_path( mx, my, 0, -1 );
		my = ay * AREA_MAX_Y + AREA_MAX_Y - PATH_WIDTH + 1;
		finish_path( mx, my, 0, +1 );
	}
}

/**/

void	make_door_path( long mx, long my, long dx, long dy )
{
	if( dx < 0 )
		make_door( mx, my,
				mx + 1, my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
	if( dx > 0 )
		make_door( mx + 1, my,
				mx + PATH_WIDTH - 1, my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
	if( dy < 0 )
		make_door( mx, my,
				mx + PATH_WIDTH - 1, my + 1,
				FACE_MNR_NULL);
	if( dy > 0 )
		make_door( mx, my + 1,
				mx + PATH_WIDTH - 1, my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
}

/**/

void	make_door_room( long mx, long my )
{
	long	dx, dy;
	long	i;

	/* ǤϿߤ */
	if( (mx - 1) >= 0 )
		if( dun.map.obj.mjr[my][mx - 1] == FACE_MJR_DOOR_CLOSE )
			return;
	if( (my - 1) >= 0 )
		if( dun.map.obj.mjr[my - 1][mx] == FACE_MJR_DOOR_CLOSE )
			return;


	for( i = 0; i < AREA_MAX_X; i++ ){
		if( dun.map.obj.mjr[my][mx + i] != FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dx = i - 1;
	if( dx < 0 )
		return;

	for( i = 0; i < AREA_MAX_Y; i++ ){
		if( dun.map.obj.mjr[my + i][mx] != FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dy = i - 1;
	if( dy < 0 )
		return;

	make_door( mx, my, mx + dx, my + dy, FACE_MNR_NULL );
}

/**/

bool_t	make_door( long bx, long by, long ex, long ey, char mnr )
{
	long	i;
	long	tmp;
	long	dx, dy;
	long	n;

	if( dun.door_n >= DOOR_MAX_N )
		return FALSE;
	n = dun.door_n;

	if( bx > ex ){
		tmp = bx;
		bx = ex;
		ex = tmp;
	}
	if( by > ey ){
		tmp = by;
		by = ey;
		ey = tmp;
	}
	if( bx < 0 )
		bx = 0;
	if( ex > MAP_MAX_X - 1 )
		ex = MAP_MAX_X - 1;
	if( by < 0 )
		by = 0;
	if( ey > MAP_MAX_Y - 1 )
		ey = MAP_MAX_Y - 1;

	dx = ex - bx + 1;
	dy = ey - by + 1;
	if( dx <= 0 )
		return FALSE;
	if( dy <= 0 )
		return FALSE;

	/* ΰ֤ˤǤ˥ɥʤ return */
	for( i = 0; i < n; i++ ){
		if( dun.door[i].x != bx )
			continue;
		if( dun.door[i].y != by )
			continue;
		if( dun.door[i].dx != dx )
			continue;
		if( dun.door[i].dy != dy )
			continue;

		return FALSE;
	}

	dun.door[n].n = n;
	dun.door[n].x = bx;
	dun.door[n].y = by;
	dun.door[n].dx = dx;
	dun.door[n].dy = dy;

	dun.door[n].flg = FLG_NULL;

	if( mnr == FACE_MNR_NULL ){
		if( chk_rate_door_open() )
			dun.door[n].flg |= FLG_DOOR_OPEN;

		if( chk_rate_door_jammed() )
			dun.door[n].flg |= FLG_DOOR_JAMMED;

		if( chk_rate_door_broken() )
			dun.door[n].flg |= FLG_DOOR_BROKEN;

		if( chk_rate_door_secret() )
			dun.door[n].flg |= FLG_DOOR_SECRET;

		dun.door[n].flg &= ~(FLG_DOOR_SRCHED);
	} else if( mnr == FACE_MNR_GATE ){
		dun.door[n].flg |= FLG_DOOR_GATE;
		dun.door[n].mnr = FACE_MNR_GATE;
	} else {
		dun.door[n].flg |= FLG_DOOR_SHOP;
		dun.door[n].mnr = mnr;
	}

	dun.door_n++;

	set_face_door( n );

	return TRUE;
}

/**/

void	set_face_door( long dr_n )
{
	long	i, j;
	long	mjr, mnr;
	flg_map_t	flg;

	mjr = FACE_MJR_DOOR_CLOSE;
	mnr = FACE_MNR_DOOR_NORM;
	flg = FLG_NULL;

	/* if ʸν֤ */

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_OPEN ) ){
		mjr = FACE_MJR_DOOR_OPEN;
		flg |= FLG_MAP_OBJ_PASS;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_JAMMED ) )
		mnr = FACE_MNR_DOOR_JAMMED;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SRCHED ) )
		flg |= FLG_MAP_OBJ_FIND;
	else
		mnr = FACE_MNR_DOOR_NORM;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		dun.door[dr_n].flg |= FLG_DOOR_OPEN;
		mjr = FACE_MJR_DOOR_OPEN;
		mnr = FACE_MNR_DOOR_BROKEN;
		flg |= FLG_MAP_OBJ_PASS;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SECRET ) ){
		dun.door[dr_n].flg &= ~(FLG_DOOR_OPEN);
		mjr = FACE_MJR_DOOR_CLOSE;
		mnr = FACE_MNR_DOOR_SECRET;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_LOOK_WALL;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SHOP ) ){
		mjr = FACE_MJR_DOOR_CLOSE;
		/* mnr  make_door() Ѥ */
		mnr = dun.door[dr_n].mnr;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_FIND;
	}

	if( chk_find_door( dr_n ) )
		flg |= FLG_MAP_OBJ_FIND;
	if( dun.lev == 0 )
		flg |= FLG_MAP_OBJ_FIND;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_GATE ) ){
		mjr = FACE_MJR_DOOR_CLOSE;
		mnr = FACE_MNR_GATE;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_FIND;
	}

	/**/

	dun.door[dr_n].mjr = mjr;
	dun.door[dr_n].mnr = mnr;
	for( i = 0; i < dun.door[dr_n].dy; i++ ){
		for( j = 0; j < dun.door[dr_n].dx; j++ ){
			long	x, y;

			x = dun.door[dr_n].x + j;
			y = dun.door[dr_n].y + i;
			dun.map.obj.mjr[y][x] = mjr;
			dun.map.obj.mnr[y][x] = mnr;
			dun.map.obj.flg[y][x] = flg;
		}
	}
}

/**/

bool_t	chk_find_door( long dr_n )
{
	long	i, j;

	for( i = 0; i < dun.door[dr_n].dy; i++ ){
		for( j = 0; j < dun.door[dr_n].dx; j++ ){
			long	x, y;

			x = dun.door[dr_n].x + j;
			y = dun.door[dr_n].y + i;
			if( chk_flg( dun.map.obj.flg[y][x],
					FLG_MAP_OBJ_FIND ) ){
				return TRUE;
			}
		}
	}

	return FALSE;
}

/**/

bool_t	break_door( long dr_n )
{
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SHOP ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_SHOP );
		return FALSE;
	}
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_BROKEN );
		return FALSE;
	}
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_GATE ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_SHOP );
		return FALSE;
	}

	dun.door[dr_n].flg |= FLG_DOOR_BROKEN | FLG_DOOR_OPEN;
	set_face_door( dr_n );
	draw_door( dr_n );

	return TRUE;
}

/**/

void	get_near_pos_door( pos_t *pos, door_t *dr, chr_t *chr )
{
	if( pos == NULL )
		return;
	if( dr == NULL )
		return;
	if( chr == NULL )
		return;

	pos->x = dr->x;
	pos->y = dr->y;

	/* ɥΣ֥åȤʤ */
	if( chr->x < dr->x )
		pos->x = dr->x - 1;
	else if( (dr->x + dr->dx - 1) < chr->x )
		pos->x = (dr->x + dr->dx - 1) + 1;

	if( chr->y < dr->y )
		pos->y = dr->y - 1;
	else if( (dr->y + dr->dy - 1) < chr->y )
		pos->y = (dr->y + dr->dy - 1) + 1;
}

/**/

void	make_stairs( long x, long y, char face )
{
	char	mjr, mnr;

	if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return;

	if( (face == FACE_MJR_STAIRS_DOWN)
			|| (face == FACE_MNR_STAIRS_DOWN) ){
		if( dun.lev <= DUN_MAX_LEV_BASE )
			return;

		mjr = FACE_MJR_STAIRS_DOWN;
		mnr = FACE_MNR_STAIRS_DOWN;
	} else {
		if( dun.lev >= DUN_MAX_LEV_FLOOR )
			return;

		mjr = FACE_MJR_STAIRS_UP;
		mnr = FACE_MNR_STAIRS_UP;
	}

	dun.map.obj.mjr[y][x] = mjr;
	dun.map.obj.mnr[y][x] = mnr;
}

/**/

bool_t	set_statue( long x, long y, long dun_lev, bool_t flg_self )
{
	long	ix, iy;

	if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return FALSE;
	if( !flg_self && (dun.map.chr.mjr[y][x] != FACE_MJR_NULL) )
			return FALSE;

	dun.map.obj.mjr[y][x] = FACE_MJR_WALL;
	dun.map.obj.mnr[y][x] = FACE_MNR_WALL;
	dun.map.obj.flg[y][x] = FLG_NULL;

	ix = x + randm( 3 ) - 1;
	iy = y + randm( 3 ) - 1;
	make_item( ix, iy, dun_lev );

	return TRUE;
}

/**/

void	set_map_total( long x, long y, long dx, long dy )
{
	/* ط */
	set_map_total_bg( x, y, dx, dy );

	/* ° */
	set_map_total_crsr_attr( x, y, dx, dy );

	/* ֥ */
	set_map_total_obj( x, y, dx, dy );

	/* ۡࡦ */
	set_map_total_square( x, y, dx, dy );

	/* 󥹥ȥС */
	set_map_total_chr( x, y, dx, dy );

	/* Υѥ */
	set_map_total_crsr_ptn( x, y, dx, dy );
}

/**/

void	set_map_total_bg( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	long	mjr, mnr;
	flg_map_t	flg;
	long	dep;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_n = CURS_ATTR_N_MAP_NORMAL;
	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < dx; j++ ){
			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			mjr = dun.map.obj.mjr[yy][xx];
			mnr = dun.map.obj.mnr[yy][xx];
			flg = dun.map.obj.flg[yy][xx];
			dep = calc_light_depth( xx, yy );

			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_WALL ) ){
				mjr = FACE_MJR_WALL;
				mnr = FACE_MNR_WALL;
			}
			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_FLOOR ) ){
				mjr = FACE_MJR_FLOOR;
				mnr = FACE_MNR_FLOOR;
			}
			if( (mjr == FACE_MJR_FLOOR) && (dep <= 0) ){
				mjr = FACE_MJR_NULL;
				mnr = FACE_MNR_NULL;
			}
			if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) ){
				mjr = FACE_MJR_NULL;
				mnr = FACE_MNR_NULL;
			}

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = FLG_NULL;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/**/

void	set_map_total_crsr_attr( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;
	pos_t	*csr;

	attr_dflt = get_curs_attr();
	csr = get_crsr();

	attr_n = CURS_ATTR_N_MAP_CRSR;
	for( i = 0; i < g_crsr_ptn.y_len; i++ ){
		yy = csr->y + i + g_crsr_ptn.y;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < g_crsr_ptn.x_len; j++ ){
			long	c;

			xx = csr->x + j + g_crsr_ptn.x;
			if( !clip_x( xx ) )
				continue;

			c = g_crsr_ptn.face[i][j * 2 + 0];
			if( c != g_crsr_ptn.mask_chr )
				dun.map.attr[yy][xx] = attr_dflt[attr_n];

			c = g_crsr_ptn.face[i][j * 2 + 1];
			if( c != g_crsr_ptn.mask_chr )
				dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/**/

void	set_map_total_obj( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	long	mjr, mnr;
	flg_map_t	flg;
	long	dep;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_n = CURS_ATTR_N_MAP_ITEM;
	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < dx; j++ ){
			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			mjr = dun.map.obj.mjr[yy][xx];
			mnr = dun.map.obj.mnr[yy][xx];
			flg = dun.map.obj.flg[yy][xx];
			dep = calc_light_depth( xx, yy );

			if( mjr == FACE_MJR_FLOOR )
				continue;
			if( mjr == FACE_MJR_WALL )
				continue;
			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_WALL ) )
				continue;
			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_FLOOR ) )
				continue;
			if( (mjr == FACE_MJR_FLOOR) && (dep <= 0) )
				continue;
			if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) )
				continue;

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = FLG_NULL;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/**/

void	set_map_total_square( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	curs_attr_t	*attr_dflt;
	party_t	*pty;

	attr_dflt = get_curs_attr();
	pty = get_party();

	for( i = -1; i <= +1; i++ ){
		yy = pty->square.y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = -1; j <= +1; j++ ){
			mbr_t	*mbr;

			xx = pty->square.x + j;
			if( !clip_x( xx ) )
				continue;

			if( pty->square.chr_dir[i + 1][j + 1] == MBR_NO_POS )
				continue;

			dun.map.total.mjr[yy][xx] = FACE_MJR_SQUARE;
			dun.map.attr[yy][xx]
					= attr_dflt[CURS_ATTR_N_MAP_SQUARE];

			mbr = pty->mbr[pty->square.chr_dir[i + 1][j + 1]];
			if( chk_flg( mbr->stat, FLG_STAT_NOT_EXIST ) ){
				continue;
			}

			dun.map.total.mnr[yy][xx] = mbr->face.mnr;
		}
	}
}

/**/

void	set_map_total_chr( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	long	mjr, mnr;
	flg_map_t	flg, flg_total;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;
		for( j = 0; j < dx; j++ ){
			bool_t	flg_rev_rev;

			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			flg_total = dun.map.total.flg[yy][xx];

			mjr = dun.map.chr.mjr[yy][xx];
			mnr = dun.map.chr.mnr[yy][xx];
			flg = dun.map.chr.flg[yy][xx];
			attr_n = CURS_ATTR_N_NORMAL;
			flg_rev_rev = FALSE;

			if( mjr == FACE_MJR_NULL ){
				continue;
			} else if( mjr == FACE_MJR_MBR ){
				mbr_t	*p;

				/* Сä */
				p = get_mbr( xx, yy );
				if( p != NULL ){
					attr_n = CURS_ATTR_N_MBR_1
							+ p->mbr_n;
				}
				if( chk_flg( flg, FLG_MAP_CHR_INVISIBLE ) ){
					/* Ʃʤ */
					flg_rev_rev = TRUE;
				}
			} else {
				/* 󥹥ä */
				if( !chk_flg( flg, FLG_MAP_CHR_FIND ) ){
					/* ĤäƤʤ */
					continue;
				}
				if( chk_flg( flg, FLG_MAP_CHR_INVISIBLE ) ){
					/* Ʃʤ */
					continue;
				}
				if( chk_flg( flg, FLG_MAP_CHR_NPC ) ){
					attr_n = CURS_ATTR_N_MAP_NPC;
				} else {
					attr_n = CURS_ATTR_N_MAP_MNSTR;
				}
			}

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = flg_total;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
			if( flg_rev_rev )
				dun.map.attr[yy][xx].attr ^= A_REVERSE;
		}
	}
}

/**/

void	set_map_total_crsr_ptn( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	pos_t	*csr;
	crsr_ptn_t	*ptn;

	csr = get_crsr();
	ptn = get_crsr_ptn();

	for( i = 0; i < ptn->y_len; i++ ){
		yy = csr->y + i + ptn->y;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < ptn->x_len; j++ ){
			long	c;

			xx = csr->x + j + ptn->x;
			if( !clip_x( xx ) )
				continue;

			/* ͭ륢ȥӥ塼Ȥ褹 */

			c = ptn->face[i][j * 2 + 0];
			if( c == '\0' )
				break;
			if( c != ptn->mask_chr )
				dun.map.total.mjr[yy][xx] = c;

			c = ptn->face[i][j * 2 + 1];
			if( c == '\0' )
				break;
			if( c != ptn->mask_chr )
				dun.map.total.mnr[yy][xx] = c;
		}
	}
}

/**/

void	line_path( long x1, long y1, long x2, long y2 )
{
	long	i;

	if( y1 == y2 ){	/* ʿ */
		if( x1 > x2 ){
			long	xx;

			xx = x1;
			x1 = x2;
			x2 = xx;
		}
		for( i = x1; i <= x2; i++ ){
			put_path( i, y1, 0, 0 );
		}
	} else if( x1 == x2 ){	/* ľ */
		if( y1 > y2 ){
			long	yy;

			yy = y1;
			y1 = y2;
			y2 = yy;
		}
		for( i = y1; i <= y2; i++ ){
			put_path( x1, i, 0, 0 );
		}
	}
}

/**/

void	put_path( long x, long y, long dx, long dy )
{
	long	i, j;
	long	min_i, max_i;
	long	min_j, max_j;
	sect_t	sect;
	long	xx, yy;

	/* (dx == 0) && (dy == 0)λϥǥե */
	min_i = 0;
	max_i = PATH_WIDTH;
	min_j = 0;
	max_j = PATH_WIDTH;
	sect = 'z';

	if( dx < 0 ){
		min_j = 0;
		max_j = PATH_WIDTH - 1;
		sect = 'z';
	} else if( dx > 0 ){
		min_j = 1;
		max_j = PATH_WIDTH;
		sect = 'y';
	} else if( dy < 0 ){
		min_i = 0;
		max_i = PATH_WIDTH - 1;
		sect = 'x';
	} else if( dy > 0 ){
		min_i = 1;
		max_i = PATH_WIDTH;
		sect = 'w';
	}

	for( i = min_i; i < max_i; i++ ){
		yy = y + i;
		for( j = min_j; j < max_j; j++ ){
			xx = x + j;
			dun.map.sect[yy][xx] = sect;

			if( dun.map.obj.mjr[yy][xx] != FACE_MJR_WALL ){
				continue;
			}

			dun.map.obj.mjr[yy][xx] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[yy][xx] = FACE_MNR_FLOOR;
			dun.map.obj.flg[yy][xx] |= FLG_MAP_OBJ_PASS;
		}
	}
}

bool_t	open_door( long n )
{
	flg_door_t	flg;

	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	flg = dun.door[n].flg;

	if( chk_flg_or( flg, FLG_DOOR_SECRET | FLG_DOOR_JAMMED ) )
		return FALSE;
	if( chk_flg( flg, FLG_DOOR_GATE ) )
		return FALSE;

	if( chk_flg( flg, FLG_DOOR_SHOP ) ){
		open_door_shop( n );
		return TRUE;
	}

	dun.door[n].flg |= FLG_DOOR_OPEN;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/**/

bool_t	close_door( long n )
{
	bool_t	flg;
	long	i, j;

	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	flg = dun.door[n].flg;

	if( chk_flg( flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( flg, FLG_DOOR_OPEN ) )
		if( chk_flg_or( flg, FLG_DOOR_JAMMED | FLG_DOOR_BROKEN ) )
			return FALSE;
	if( chk_flg( flg, FLG_DOOR_GATE ) )
		return FALSE;

	/* 饯ɥξˤ뤫 */
	for( i = 0; i < dun.door[n].dy; i++ ){
		for( j = 0; j < dun.door[n].dx; j++ ){
			long	x, y;

			x = dun.door[n].x + j;
			y = dun.door[n].y + i;
			if( dun.map.chr.mjr[y][x] != FACE_MJR_NULL ){
				return FALSE;
			}
		}
	}

	dun.door[n].flg &= ~FLG_DOOR_OPEN;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/**/

bool_t	jam_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	if( chk_flg( dun.door[n].flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( dun.door[n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_JAM_BROKEN );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_JAMMED ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_JAM_JAMMED );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_GATE ) )
		return FALSE;

	dun.door[n].flg |= FLG_DOOR_JAMMED;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/**/

bool_t	disarm_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	if( chk_flg( dun.door[n].flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( dun.door[n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_DISARM_BROKEN );
		return FALSE;
	}
	if( !chk_flg( dun.door[n].flg, FLG_DOOR_JAMMED ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_DISARM_NOT_JAM );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_GATE ) )
		return FALSE;

	dun.door[n].flg &= ~(FLG_DOOR_JAMMED);
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/**/

bool_t	srch_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	dun.door[n].flg |= FLG_DOOR_SRCHED;
	dun.door[n].flg &= ~(FLG_DOOR_SECRET);
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/**/

void	detect_door( long x, long y, long r )
{
	long	n;

	for( n = 0; n < dun.door_n; n++ ){
		if( (dun.door[n].x + dun.door[n].dx - 1) < (x - r) )
			continue;
		if( (x + r) < dun.door[n].x )
			continue;
		if( (dun.door[n].y + dun.door[n].dy - 1) < (y - r) )
			continue;
		if( (y + r) < dun.door[n].y )
			continue;

		srch_door( n );
	}
}

/**/

void	find_obj( long x, long y )
{
	long	i, j;
	long	sx, sy;
	flg_map_t	flg;
	long	dep;
	bool_t	flg_redraw;

	flg_redraw = FALSE;

	for( i = -1; i <= +1; i++ ){
		sy = y + i;
		if( !clip_y( sy ) )
			continue;
		for( j = -1; j <= +1; j++ ){
			sx = x + j;
			if( !clip_x( sx ) )
				continue;

			flg = dun.map.obj.flg[sy][sx];
			dep = dun.map.light_depth_obj[sy][sx];
			if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) && (dep > 0) ){
				find_obj_fill( sx, sy );
				flg_redraw = TRUE;
			}
		}
	}

	if( flg_redraw )
		redraw_map();
}

/**/

void	find_obj_fill( long x, long y )
{
	long	ax, ay;
	long	sx, sy;
	long	dx, dy;
	sect_t	sect;

	ax = x / AREA_MAX_X * AREA_MAX_X;
	ay = y / AREA_MAX_Y * AREA_MAX_Y;
	sect = dun.map.sect[y][x];

	for( dy = 0; dy < AREA_MAX_Y; dy++ ){
		sy = ay + dy;
		for( dx = 0; dx < AREA_MAX_X; dx++ ){
			sx = ax + dx;

			if( dun.map.sect[sy][sx] != sect )
				continue;
			if( !chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_PASS ) )
				continue;

			find_obj_fill_field( sx, sy );
		}
	}
}

/**/

void	find_obj_fill_field( long x, long y )
{
	long	i, j;
	long	sx, sy;

	for( i = -1; i <= +1; i++ ){
		sy = y + i;
		if( !clip_y( sy ) )
			continue;
		for( j = -1; j <= +1; j++ ){
			sx = x + j;
			if( !clip_x( sx ) )
				continue;

			dun.map.obj.flg[sy][sx] |= FLG_MAP_OBJ_FIND;
		}
	}
}

/**/

void	on_light_area( long x, long y, bool_t flg_find )
{
	turn_light_area( x, y, TRUE, flg_find );
}

/**/

void	off_light_area( long x, long y, bool_t flg_find )
{
	turn_light_area( x, y, FALSE, flg_find );
}

/**/

void	turn_light_area( long x, long y, bool_t flg_on, bool_t flg_find )
{
	sect_t	sect;
	long	ax, ay;
	long	dx, dy;

	sect = dun.map.sect[y][x];

	ax = ((int)(x / AREA_MAX_X)) * AREA_MAX_X;
	ay = ((int)(y / AREA_MAX_Y)) * AREA_MAX_Y;
	for( dy = 0; dy < AREA_MAX_Y; dy++ ){
		for( dx = 0; dx < AREA_MAX_X; dx++ ){
			turn_light_field( ax + dx, ay + dy, sect,
					flg_on, flg_find );
		}
	}

	redraw_map();
}

/**/

void	turn_light_field(
	long x, long y, sect_t sect, bool_t flg_on, bool_t flg_find
)
{
	long	dx, dy;
	long	sx, sy;
	bool_t	flg_on_depth;

	sx = 0;
	sy = 0;
	for( dy = -1; dy <= +1; dy++ ){
		sy = y + dy;
		if( !clip_y( sy ) )
			continue;

		for( dx = -1; dx <= +1; dx++ ){
			sx = x + dx;
			if( !clip_x( sx ) )
				continue;

			if( dun.map.sect[sy][sx] != sect )
				continue;

			if( !chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_PASS ) )
				continue;

			if( chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_LOOK_WALL ) )
				continue;

			/**/

			flg_on_depth = turn_light_obj( x, y, flg_on );
			if( flg_on_depth && flg_find )
				dun.map.obj.flg[y][x] |= FLG_MAP_OBJ_FIND;
			return;
		}
	}
}

/**/

void	turn_light_door( door_t *dr, bool_t flg_on, bool_t flg_find )
{
	long	dx, dy;

	for( dy = 0; dy < dr->dy; dy++ ){
		for( dx = 0; dx < dr->dx; dx++ ){
			long	sx, sy;
			bool_t	flg_on_depth;

			sx = dr->x + dx;
			sy = dr->y + dy;

			flg_on_depth = turn_light_obj( sx, sy, flg_on );
			if( flg_on_depth && flg_find )
				dun.map.obj.flg[sy][sx] |= FLG_MAP_OBJ_FIND;
		}
	}

	draw_door( dr->n );
}

/**/

bool_t	turn_light_obj( long x, long y, bool_t flg_on )
{
	if( flg_on )
		dun.map.light_depth_obj[y][x]++;
	else
		dun.map.light_depth_obj[y][x]--;

	return( dun.map.light_depth_obj[y][x] > 0 );
}

/**/

bool_t	turn_light_chr( long x, long y, bool_t flg_on )
{
	if( flg_on )
		dun.map.light_depth_chr[y][x]++;
	else
		dun.map.light_depth_chr[y][x]--;

	return( dun.map.light_depth_chr[y][x] > 0 );
}

/**/

long	calc_light_depth( long x, long y )
{
	long	depth;

	depth = 0;
	depth += dun.map.light_depth_obj[y][x];
	depth += dun.map.light_depth_chr[y][x];

	return depth;
}

/**/

bool_t	chk_find( pos_t *pos1, pos_t *pos2 )
{
	long	x1, y1, x2, y2, e;
	long	dx2, dy2, sgn_y;
	long	x, y;

	if( pos1->x < pos2->x ){
		x1 = pos1->x;
		y1 = pos1->y;
		x2 = pos2->x;
		y2 = pos2->y;
	} else {
		x1 = pos2->x;
		y1 = pos2->y;
		x2 = pos1->x;
		y2 = pos1->y;
	}

	dx2 = 2 * (x2 - x1);
	dy2 = 2 * abs( y2 - y1 );
	if( y1 <= y2 )
		sgn_y = +1;
	else
		sgn_y = -1;
	e = -(x2 - x1);
	x = x1;
	y = y1;

	for( ; x <= x2; x++ ){
		if( e < 0 ){
			if( !chk_flg( dun.map.obj.flg[y][x],
					FLG_MAP_OBJ_PASS ) ){
				return FALSE;
			}
		} else {
			do {
				y += sgn_y;
				if( sgn_y >= +1 ){
					if( y > y2 )
						break;
				} else {
					if( y < y2 )
						break;
				}
				e -= dx2;
				if( !chk_flg( dun.map.obj.flg[y][x],
						FLG_MAP_OBJ_PASS ) ){
					return FALSE;
				}
			} while( e >= 0 );
		}
		e += dy2;
	}

	return TRUE;
}

/**/

dun_t	*get_dun( void )
{
	return &dun;
}

/**/

door_t	*get_door( long x, long y )
{
	long	i;
	door_t	*dr;

	for( i = 0; i < dun.door_n; i++ ){
		dr = &(dun.door[i]);
		if( (dr->x <= x) && (x <= dr->x + dr->dx)
				&& (dr->y <= y) && (y <= dr->y + dr->dy) ){
			return dr;
		}
	}
	return NULL;
}

/**/

door_t	*get_door_nearest( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;

		if( !chk_find_door( dr_n ) )
			continue;

		if( p->x >= x ){
			dx = abs( p->x - x );
			pos1.x = p->x;
		} else {
			dx = abs( x - (p->x + p->dx - 1) );
			pos1.x = p->x + p->dx - 1;
		}
		if( p->y >= y ){
			dy = abs( p->y - y );
			pos1.y = p->y;
		} else {
			dy = abs( y - (p->y + p->dy - 1) );
			pos1.y = p->y + p->dy - 1;
		}
		tmp_r = dx + dy;
		if( tmp_r > min_r )
			continue;

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

door_t	*get_door_near( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;

		if( !chk_find_door( dr_n ) )
			continue;

		if( p->x >= x ){
			dx = abs( p->x - x );
			pos1.x = p->x;
		} else {
			dx = abs( x - (p->x + p->dx - 1) );
			pos1.x = p->x + p->dx - 1;
		}
		if( p->y >= y ){
			dy = abs( p->y - y );
			pos1.y = p->y;
		} else {
			dy = abs( y - (p->y + p->dy - 1) );
			pos1.y = p->y + p->dy - 1;
		}
		tmp_r = dx + dy;
		if( tmp_r > min_r )
			continue;

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( (tmp_r - min_r) <= DOOR_NEAR_R ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

door_t	*get_door_disperse( mbr_t *mbr, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	long	x, y;

	x = mbr->x;
	y = mbr->y;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;

		if( !chk_find_door( dr_n ) )
			continue;

		if( p->x >= x ){
			dx = abs( p->x - x );
			pos1.x = p->x;
		} else {
			dx = abs( x - (p->x + p->dx - 1) );
			pos1.x = p->x + p->dx - 1;
		}
		if( p->y >= y ){
			dy = abs( p->y - y );
			pos1.y = p->y;
		} else {
			dy = abs( y - (p->y + p->dy - 1) );
			pos1.y = p->y + p->dy - 1;
		}
		tmp_r = dx + dy;
		if( tmp_r > min_r )
			continue;

		if( chk_already_mark( p, mbr ) )
			continue;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/**/

door_t	*get_door_randm( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	n;

	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;

		if( !chk_find_door( dr_n ) )
			continue;

		if( p->x >= x ){
			dx = abs( p->x - x );
			pos1.x = p->x;
		} else {
			dx = abs( x - (p->x + p->dx - 1) );
			pos1.x = p->x + p->dx - 1;
		}
		if( p->y >= y ){
			dy = abs( p->y - y );
			pos1.y = p->y;
		} else {
			dy = abs( y - (p->y + p->dy - 1) );
			pos1.y = p->y + p->dy - 1;
		}

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		n++;
		if( randm( n ) == 0 )
			ret_p = p;
	}

	return ret_p;
}

/**/

door_t	*get_door_towner( long x, long y, long r )
{
	door_t	*ret, *dr;
	long	n;
	long	xx, yy;
	long	dx, dy;
	char	mjr;

	ret = NULL;
	n = 0;
	for( dy = -r; dy <= +r; dy++ ){
		yy = y + dy;
		if( !clip_y( yy ) )
			continue;

		for( dx = -r; dx <= +r; dx++ ){
			xx = x + dx;
			if( !clip_x( xx ) )
				continue;

			mjr = dun.map.obj.mjr[yy][xx];
			if( mjr != FACE_MJR_DOOR_OPEN )
				if( mjr != FACE_MJR_DOOR_CLOSE )
					continue;

			dr = get_door( xx, yy );
			if( dr != NULL ){
				n++;
				if( per_randm( n ) ){
					ret = dr;
				}
			}
		}
	}

	return ret;
}

/**/

bool_t	chk_mark_door( door_t *p, act_kind_t act_kind )
{
	switch( act_kind ){
	case ACT_KIND_DOOR_OPEN:
		if( chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_CLOSE:
		if( !chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_JAM:
		if( !chk_flg( p->flg, FLG_DOOR_SRCHED ) )
			break;
		if( chk_flg( p->flg, FLG_DOOR_JAMMED ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_DISARM:
		if( !chk_flg( p->flg, FLG_DOOR_SRCHED ) )
			break;
		if( !chk_flg( p->flg, FLG_DOOR_JAMMED ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_BREAK:
		if( chk_flg( p->flg, FLG_DOOR_BROKEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_PEEP:
		if( chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_SRCH:
		if( chk_flg( p->flg, FLG_DOOR_SRCHED ) )
			return FALSE;
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	up_stairs( void )
{
	if( !chk_stairs( FACE_MJR_STAIRS_UP ) ){
		print_msg( FLG_NULL, MSG_ERR_STAIRS_UP );
		return FALSE;
	}
	print_msg( FLG_NULL, MSG_UP_DUN );
	up_dun( +1 );

	return TRUE;
}

/**/

bool_t	down_stairs( void )
{
	if( !chk_stairs( FACE_MJR_STAIRS_DOWN ) ){
		print_msg( FLG_NULL, MSG_ERR_STAIRS_DOWN );
		return FALSE;
	}
	print_msg( FLG_NULL, MSG_DOWN_DUN );
	up_dun( -1 );

	return TRUE;
}

/**/

bool_t	chk_stairs( long face )
{
	party_t	*pty;
	bool_t	flg;
	long	i;
	long	x, y;

	if( (face == FACE_MJR_STAIRS_DOWN)
			|| (face == FACE_MNR_STAIRS_DOWN) ){
		face = FACE_MJR_STAIRS_DOWN;
	} else {
		face = FACE_MJR_STAIRS_UP;
	}

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		flg = FALSE;
		for( y = -STAIRS_MAX_R; y <= +STAIRS_MAX_R; y++ ){
			for( x = -STAIRS_MAX_R; x <= +STAIRS_MAX_R; x++ ){
				long	mx, my;

				mx = pty->mbr[i]->x + x;
				my = pty->mbr[i]->y + y;
				if( dun.map.obj.mjr[my][mx] == face ){
					flg = TRUE;
				}
			}
		}
		if( !flg )
			return FALSE;
	}

	return TRUE;
}

/**/

bool_t	is_map_wall( long x, long y )
{
	if( !clip_x( x ) )
		return TRUE;
	if( !clip_y( y ) )
		return TRUE;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_WALL )
		return TRUE;
	if( chk_flg( dun.map.obj.flg[y][x], FLG_MAP_OBJ_LOOK_WALL ) )
		return TRUE;

	return FALSE;
}

/**/

bool_t	clip_x( long n )
{
	if( n == MAP_DEL_X )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= MAP_MAX_X )
		return FALSE;

	return TRUE;
}

/**/

bool_t	clip_y( long n )
{
	if( n == MAP_DEL_Y )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= MAP_MAX_Y )
		return FALSE;

	return TRUE;
}

/**/

bool_t	clip_pos( long x, long y )
{
	if( !clip_x( x ) )
		return FALSE;
	if( !clip_y( y ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_rate_room( void )
{
	return rate_randm( 50 );
}

/**/

bool_t	chk_rate_door_open( void )
{
	return rate_randm( 10 );
}

/**/

bool_t	chk_rate_door_jammed( void )
{
	return rate_randm( 5 );
}

/**/

bool_t	chk_rate_door_broken( void )
{
	return rate_randm( 1 );
}

/**/

bool_t	chk_rate_door_secret( void )
{
	return rate_randm( abs( dun.lev ) * 4);
}

/**/

char	get_chr_mjr_crsr( void )
{
	return get_chr_crsr( TRUE );
}

/**/

char	get_chr_mnr_crsr( void )
{
	return get_chr_crsr( FALSE );
}

/**/

char	get_chr_crsr( bool_t flg_mjr )
{
	pos_t	*crsr = get_crsr();

	if( crsr == NULL )
		return FACE_MJR_NULL;

	if( !clip_x( crsr->x ) )
		return FACE_MJR_NULL;
	if( !clip_y( crsr->y ) )
		return FACE_MJR_NULL;

	if( flg_mjr )
		return( dun.map.chr.mjr[crsr->y][crsr->x] );
	else
		return( dun.map.chr.mnr[crsr->y][crsr->x] );
}

/**/

bool_t	save_dun( void )
{
	if( !save_crsr_ptn( g_crsr_ptn_usr, g_crsr_ptn_max_n ) ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_SAVE_CRSR_PTN );
		return FALSE;
	}

	return TRUE;
}

/**/
