/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: fx.h,v 1.19 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#ifndef	FX_H
#define	FX_H

#define	DOOR_DISARM_RATE_MUL_N	4
#define	DOOR_DISARM_RATE_ADD_N	20
#define	TRAP_DISARM_FAILURE_RATE	40
#define	ITEM_DISARM_FAILURE_RATE	40

#define	RESURRECTION_MIN_RATE	30
#define	RESURRECTION_MAX_RATE	90

#define	MAGIC_SHIELD_ADD_DEF_RATE	100
#define	MAGIC_SHIELD_MAX_N	1
#define	MAGE_ARMOR_ADD_AC_RATE	20
#define	MAGE_ARMOR_MAX_N	4

#define	FX_FACE_TRAP	'X'

/* Turn begin */

#define	FX_TURN_INFINITE_N	(-1)

#define	FX_AVE_TURN_POISON_DEC	20

#define	FX_AVE_TURN_STONE	FX_TURN_INFINITE_N
#define	FX_AVE_TURN_PARALYZE	16
#define	FX_AVE_TURN_POISON	1024
#define	FX_AVE_TURN_CONFUSION	16
#define	FX_AVE_TURN_BLIND	512
#define	FX_AVE_TURN_SLEEP	32
#define	FX_AVE_TURN_SILENCE	32
#define	FX_AVE_TURN_FEAR	32
#define	FX_AVE_TURN_HALLUCINATION	32
#define	FX_AVE_TURN_CHARM	32
#define	FX_AVE_TURN_FLY	128
#define	FX_AVE_TURN_VANISH	128

#define	FX_AVE_TURN_MAGIC_SHIELD	64
#define	FX_AVE_TURN_MAGE_ARMOR	64

#define	FX_AVE_TURN_POW_UP_HP	64
#define	FX_AVE_TURN_POW_UP_ABL	64
#define	FX_AVE_TURN_POW_DOWN_ABL	64
#define	FX_AVE_TURN_POW_UP_RESI	64
#define	FX_AVE_TURN_SPEED_UP	256
#define	FX_AVE_TURN_SPEED_DOWN	256

#define	FX_AVE_TURN_DARKVISION	128
#define	FX_AVE_TURN_RECALL	24

#define	FX_AVE_TURN_BLESS	64

#define	FX_AVE_TURN_FAINT	16
#define	FX_TURN_DRUNK	1024

/* Turn end */

typedef enum {
	FX_KIND_NULL,
	FX_KIND_STONE,
	FX_KIND_PARALYZE,
	FX_KIND_POISON,
	FX_KIND_CONFUSION,
	FX_KIND_BLIND,
	FX_KIND_SLEEP,
	FX_KIND_SILENCE,
	FX_KIND_FEAR,
	FX_KIND_HALLUCINATION,
	FX_KIND_CHARM,
	FX_KIND_FLY,
	FX_KIND_FAINT,
	FX_KIND_DRUNK,
	FX_KIND_VANISH,
	FX_KIND_RESI_KNOC,
	FX_KIND_RESI_SLAS,
	FX_KIND_RESI_STIN,
	FX_KIND_RESI_HEAT,
	FX_KIND_RESI_COLD,
	FX_KIND_RESI_ACID,
	FX_KIND_RESI_MIND,
	FX_KIND_RESI_ELEC,
	FX_KIND_RESI_POIS,
	FX_KIND_SHARPNESS,
	FX_KIND_DULLNESS,
	FX_KIND_STRENGTH,
	FX_KIND_WEAKNESS,
	FX_KIND_QUICKNESS,
	FX_KIND_SLOWNESS,
	FX_KIND_WISE,
	FX_KIND_FOOLISH,
	FX_KIND_BRAINY,
	FX_KIND_BRAINLESS,
	FX_KIND_ATTRACTIVE,
	FX_KIND_UNATTRACTIVE,
	FX_KIND_SENSE_INVISIBLE,
	FX_KIND_POW_UP_HP,
	FX_KIND_MAGIC_SHIELD,
	FX_KIND_MAGE_ARMOR,
	FX_KIND_SPEED_UP,
	FX_KIND_SPEED_DOWN,
	FX_KIND_BLESS,
	FX_KIND_MAX_N,
} fx_kind_t;

/* ʢ */

typedef struct {
	rate_t	rate;
	rate_t	full_rate;
	long	digest_p_day;
	long	digest_n;
	rate_t	hungry_rate, starvation_rate;
} stomach_t;

/* ˥¸ */

typedef struct {
	rate_t	rate;
	rate_t	poisoning_rate;
} nicotine_t;

typedef struct fx {
	struct fx	*next, *prev;
	fx_kind_t	kind;
	long	turn;
	long	n;
	struct chr_t	*chr;
} fx_t;

typedef struct fx_data {
	rate_t	armor_def, armor_crtcl, armor_ac;
	long	infra_vision;
	stomach_t	stomach;
	rate_t	drunk_rate;
	nicotine_t	nicotine;
	long	friend_turn;
	rate_t	bless;
} fx_data_t;

typedef enum {
	LIQUOR_KIND_RED_WINE,
	LIQUOR_KIND_WHITE_WINE,
	LIQUOR_KIND_ROSE_WINE,
	LIQUOR_KIND_ALE,
	LIQUOR_KIND_BRANDY,
	LIQUOR_KIND_RUM,
	LIQUOR_KIND_MAX_N
} liquor_kind_t;

#define	BLAST_MAX_X	32
#define	BLAST_MAX_Y	32

typedef struct {
	long	xl, yl;
	long	xr, yr;
	char	ptn[BLAST_MAX_Y][BLAST_MAX_X];
} blast_t;

#endif	/* FX_H */

