/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gfile.c,v 1.18 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
#include	"town.h"
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
/*#include	"turn_prot.h"*/
#include	"dun_prot.h"
#include	"town_prot.h"
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
#include	"gfile_prot.h"
/*#include	"msg_prot.h"*/

/**/

#define	FILE_NAME_MAX_LEN	127
#define	BUF_LINE_LEN	1024

#define	STR_FILE_NAME_TOWN_PTN	"town_ptn.xpm"
#define	STR_FILE_NAME_CRSR_PTN	"crsr_ptn.h"

#define	STR_ENV_HOME	"HOME"
#define	STR_SLASH	"/"
#define	STR_DIR_NAME_CUR	"."
#define	STR_DIR_NAME_GAME	".lnl"
#define	STR_FILE_NAME_TMP	"tmp"

#define	STR_DIR_NAME_USR	"usr"
#define	STR_DIR_NAME_GAME_USR	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_USR

#define	STR_DIR_NAME_BAK	"bak"
#define	STR_EXT_NAME_BAK_1	".%03ld"
#define	STR_EXT_NAME_BAK_2	".bak"
#define	STR_DIR_NAME_GAME_BAK	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_BAK

#define	STR_DIR_NAME_OUT_MAP	"out"
#define	STR_FILE_NAME_OUT_MAP	"map"
#define	STR_EXT_NAME_OUT_MAP	".%03ld"
#define	STR_DIR_NAME_GAME_OUT_MAP	\
		STR_DIR_NAME_GAME STR_SLASH STR_DIR_NAME_OUT_MAP

#define	STR_CRSR_PTN_HEAD	"crsr_ptn_t"

/**/

static char	dir_name_game[FILE_NAME_MAX_LEN + 1];
static char	dir_name_usr[FILE_NAME_MAX_LEN + 1];
static char	path_name_town_ptn[FILE_NAME_MAX_LEN + 1];
static char	path_name_crsr_ptn[FILE_NAME_MAX_LEN + 1];

/**/

void	init_game_file( void )
{
	char	*home, *s, *tmp;
	FILE	*fp;

	/* ۡࡦǥ쥯ȥ */

	home = getenv( STR_ENV_HOME );
	if( (home == NULL) || (home[0] == '\0') ){
		/* ̵Хȥǥ쥯ȥ */
		home = STR_DIR_NAME_CUR;
	}
	if( !chk_exist_dir( home ) ){
		print_err( MSG_ERR_HOME_DIR, home );
		exit_game( EXIT_FAILURE );
	}

	/* ࡦǥ쥯ȥ */

	s = init_dir_game( home, STR_DIR_NAME_GAME, TRUE );
	strncpy( dir_name_game, s, FILE_NAME_MAX_LEN );

	s = init_dir_game( home, STR_DIR_NAME_GAME_USR, FALSE );
	strncpy( dir_name_usr, s, FILE_NAME_MAX_LEN );

	init_dir_game( home, STR_DIR_NAME_GAME_BAK, FALSE );
	init_dir_game( home, STR_DIR_NAME_GAME_OUT_MAP, FALSE );

	/* 񤭹뤫 */

	tmp = cat_path( dir_name_game, STR_FILE_NAME_TMP );
	fp = fopen( tmp, "w" );
	if( fp == NULL ){
		print_err( MSG_ERR_GAME_DIR_SAVE, dir_name_game );
		exit_game( EXIT_FAILURE );
	}
	if( fclose( fp ) == EOF ){
		print_err( MSG_ERR_GAME_DIR_SAVE, dir_name_game );
		exit_game( EXIT_FAILURE );
	}

	strncpy( path_name_town_ptn,
			cat_path( dir_name_usr, STR_FILE_NAME_TOWN_PTN ),
			FILE_NAME_MAX_LEN );

	strncpy( path_name_crsr_ptn,
			cat_path( dir_name_usr, STR_FILE_NAME_CRSR_PTN ),
			FILE_NAME_MAX_LEN );
}

/**/

char	*init_dir_game( char *home, char *dir, bool_t flg_GPL )
{
	char	*name;

	/* ࡦǥ쥯ȥ */
	name = cat_path( home, dir );

	if( chk_exist_dir( name ) )
		return name;

	/* ̵ GPL ɽ */
	if( flg_GPL )
		about_game();

	/* ̵к */
	if( make_dir( name, S_IFDIR | 0755 ) == 0 )
		return name;

	return NULL;
}

/**/

bool_t	load_crsr_ptn( crsr_ptn_t *ptn, long *max_n )
{
	FILE	*fp;
	bool_t	ret;

	*max_n = 0;
	ret = TRUE;

	if( !chk_exist_file( path_name_crsr_ptn ) )
		return FALSE;

	fp = fopen( path_name_crsr_ptn, "r" );
	if( fp == NULL )
		return FALSE;

	do {
		if( !load_crsr_ptn_head( fp, ptn ) ){
			ret = FALSE;
			break;
		}
		for( *max_n = 0; *max_n < CRSR_PTN_MAX_N; (*max_n)++ ){
			if( !load_crsr_ptn_misc( fp, &(ptn[*max_n]) ) )
				break;
			if( !load_crsr_ptn_data( fp, &(ptn[*max_n]) ) ){
				ret = FALSE;
				break;
			}
		}
	} while( 0 );

	if( fclose( fp ) == EOF )
		return FALSE;

	return ret;
}

/**/

bool_t	load_crsr_ptn_head( FILE *fp, crsr_ptn_t *ptn )
{
	const long	len_head = str_len_std( STR_CRSR_PTN_HEAD );
	char	*s;

	while( 1 ){
		s = load_line_skip_spc( fp );
		if( strncmp( s, STR_CRSR_PTN_HEAD, len_head ) == 0 )
			break;
	}

	return TRUE;
}

/**/

bool_t	load_crsr_ptn_misc( FILE *fp, crsr_ptn_t *ptn )
{
	char	*s;

	s = load_line_skip_spc( fp );
	if( strchr( s, '}' ) != NULL )
		return FALSE;

	s = load_line_skip_spc( fp );
	sscanf( s, "%ld, %ld", &(ptn->x), &(ptn->y) );

	s = load_line_skip_spc( fp );	/* "size" */

	s = load_line_skip_spc( fp );
	s = strchr( s, '\'' );
	if( s == NULL )
		return FALSE;
	s++;
	ptn->mask_chr = s[0];

	return TRUE;
}

/**/

bool_t	load_crsr_ptn_data( FILE *fp, crsr_ptn_t *ptn )
{
	char	*s;
	long	x, y, idx;

	while( 1 ){
		s = load_line_skip_spc( fp );
		if( strchr( s, '{' ) != NULL )
			break;
	}

	y = 0;
	while( 1 ){
		if( y >= CRSR_PTN_MAX_Y_LEN )
			break;

		s = load_line_skip_spc( fp );
		if( strchr( s, '}' ) != NULL )
			break;

		s = strchr( s, '\"' );
		if( s == NULL )
			continue;
		s++;

		idx = 0;
		for( x = 0; x < CRSR_PTN_MAX_X_LEN * 2; x++ ){
			if( s[idx] == '\"' )
				break;
			if( s[idx] == '\\' )
				idx++;

			ptn->face[y][x] = s[idx];
			idx++;
		}
		ptn->face[y][x] = '\0';
		y++;
	}

	s = load_line_skip_spc( fp );	/* "}," */

	return TRUE;
}

/**/

bool_t	load_town_ptn( town_ptn_t *ptn )
{
	FILE	*fp;

	if( !chk_exist_file( path_name_town_ptn ) )
		set_town_ptn_dflt( ptn );

	fp = fopen( path_name_town_ptn, "r" );
	if( fp == NULL )
		return FALSE;

	do {
		if( !load_town_ptn_head( ptn, fp ) )
			break;
		if( !load_town_ptn_col( ptn, fp ) )
			break;
		if( !load_town_ptn_map( ptn, fp ) )
			break;

		if( fclose( fp ) == EOF )
			return FALSE;

		return TRUE;
	} while( 0 );

	if( fclose( fp ) == EOF )
		return FALSE;

	set_town_ptn_dflt( ptn );
	back_up_town_ptn();
	save_town_ptn( ptn );
	print_err( MSG_ERR_LOAD_TOWN_PTN, path_name_town_ptn );

	return FALSE;
}

/**/

bool_t	load_town_ptn_head( town_ptn_t *ptn, FILE *fp )
{
	long	c;
	char	*s;

	if( !set_town_ptn_init( ptn ) )
		return FALSE;

	while( 1 ){
		c = load_char( fp );
		if( c == '\"' )
			break;
	}

	s = load_line( fp );
	if( !set_town_ptn_head( ptn, s ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	load_town_ptn_col( town_ptn_t *ptn, FILE *fp )
{
	long	i;
	long	c;
	char	*s;

	for( i = 0; i < ptn->col_n; i++ ){
		while( 1 ){
			c = load_char( fp );
			if( c == '\"' )
				break;
		}

		s = load_line( fp );
		if( !set_town_ptn_col( ptn, s ) )
			return FALSE;
	}

	if( !set_town_ptn_col_count( ptn ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	load_town_ptn_map( town_ptn_t *ptn, FILE *fp )
{
	long	i;
	char	*s, *rchr;
	long	len;

	for( i = 0; i < MAP_MAX_Y; i++ ){
		while( 1 )
			if( load_char( fp ) == '\"' )
				break;

		s = load_line( fp );

		rchr = strrchr( s, '\"' );
		if( rchr == NULL ){
			print_err( MSG_S, MSG_ERR_LOAD_WQUOTE );
			return FALSE;
		}
		len = rchr - s;
		if( len != MAP_MAX_X * ptn->col_str_len ){
			print_err( MSG_ERR_LOAD_LINE_LEN,
					len, MAP_MAX_X * ptn->col_str_len );
			return FALSE;
		}

		if( !set_town_ptn_map( ptn, s, i ) )
			return FALSE;
	}

	return TRUE;
}

/**/

long	load_char( FILE *fp )
{
	if( feof( fp ) ){
		print_err( MSG_S, MSG_ERR_LOAD_EOF );
		exit_game( EXIT_FAILURE );
	}

	return fgetc( fp );
}

/**/

char	*load_line_skip_spc( FILE *fp )
{
	char	*s;

	while( !feof( fp ) ){
		s = load_line( fp );

		if( s[0] == '#' )
			continue;
		if( s[strspn( s, " \t\n\r" )] == '\0' )
			continue;

		return s;
	}

	print_err( MSG_S, MSG_ERR_LOAD_EOF );
	exit_game( EXIT_FAILURE );
	return NULL;
}

/**/

char	*load_line( FILE *fp )
{
	static char	buf[BUF_LINE_LEN + 1];

	if( !feof( fp ) ){
		fgets( buf, BUF_LINE_LEN, fp );
		return buf;
	}

	print_err( MSG_S, MSG_ERR_LOAD_EOF );
	exit_game( EXIT_FAILURE );
	return NULL;
}

/**/

bool_t	save_crsr_ptn( crsr_ptn_t *ptn, long max_n )
{
	FILE	*fp;
	long	x, y;
	long	i;

	fp = fopen( path_name_crsr_ptn, "w" );
	if( fp == NULL )
		return FALSE;

	/* header */

	fputs( "#ifndef\tCRSR_PTN_H\n", fp );
	fputs( "#define\tCRSR_PTN_H\n", fp );
	fputs( "\n", fp );
	fputs( "crsr_ptn_t\tcrsr_ptn_dflt[] = {\n", fp );

	for( i = 0; i < max_n; i++ ){
		/* size */

		fputs( "\t{\n", fp );
		fprintf( fp, "\t\t%ld, %ld,\t/* offset x, y */\n",
				ptn[i].x, ptn[i].y );
		fprintf( fp, "\t\t%ld, %ld,\t/* dummy */\n",
				ptn[i].x_len, ptn[i].y_len );
		fprintf( fp, "\t\t'%c',\t/* mask char */\n",
				(int)ptn[i].mask_chr );

		/* pattern */

		fputs( "\t\t{\n", fp );
		for( y = 0; y < ptn[i].y_len; y++ ){
			fputs( "\t\t\t\"", fp );
			for( x = 0; x < ptn[i].x_len * 2; x++ ){
				long	c;

				c = ptn[i].face[y][x];

				if( c == '\"' )
					fputc( '\\', fp );

				fputc( c, fp );

				if( c == '\\' )
					fputc( '\\', fp );
			}
			fputs( "\",\n", fp );
		}
		fputs( "\t\t},\n", fp );
		fputs( "\t},\n", fp );
	}

	/* footer */

	fputs( "};\n\n", fp );
	fputs( "#endif\t/* CRSR_PTN_H */\n", fp );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/**/

void	back_up_town_ptn( void )
{
	rename_back_up_file( path_name_town_ptn );
}

/**/

bool_t	save_town_ptn( town_ptn_t *ptn )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	FILE	*fp;
	long	col_n;
	long	i, j;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	if( (ptn->col_str_len != 1) && (ptn->col_str_len != 2) )
		return FALSE;

	fp = fopen( path_name_town_ptn, "w" );
	if( fp == NULL )
		return FALSE;

	/* header */

	if( ptn->col_str_len == 1 )
		col_n = ptn->col_n;
	else if( ptn->col_str_len == 2 )
		col_n = col_tab_max_n;
	else
		col_n = 0;

	fputs( "/* XPM */\n", fp );
	fputs( "static char\t*town_ptn_xpm[] = {\n", fp );
	fprintf( fp, "\"%d %d %ld %ld\",\n",
			MAP_MAX_X, MAP_MAX_Y, col_n + 1, ptn->col_str_len );

	/* color */

	if( ptn->col_str_len == 1 ){
		fputs( "\" \tc None\",\n", fp );
		save_town_ptn_col_1byte( fp, ptn );
	} else if( ptn->col_str_len == 2 ){
		fputs( "\"  \tc None\",\n", fp );
		save_town_ptn_col_2byte( fp );
	}

	/* data */

	for( i = 0; i < MAP_MAX_Y; i++ ){
		fputs( "\"", fp );
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( ptn->col_str_len == 1 ){
				fprintf( fp, "%c", ptn->map_mjr[i][j] );
			} else if( ptn->col_str_len == 2 ){
				fprintf( fp, "%c%c",
						ptn->map_mjr[i][j],
						ptn->map_mnr[i][j] );
			}
		}
		fputs( "\",\n", fp );
	}
	fputs( "};\n", fp );

	/* end */

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/**/

void	save_town_ptn_col_1byte( FILE *fp, town_ptn_t *ptn )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	i, j;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	for( i = 0; i < TOWN_PTN_COL_MAX_N; i++){
		if( ptn->col_mjr[i] == '\0' )
			continue;
		if( ptn->col_mnr[i] == '\0' )
			continue;

		for( j = 0; j < col_tab_max_n; j++){
			if( col_tab[j].mjr != ptn->col_mjr[i] )
				continue;
			if( col_tab[j].mnr != ptn->col_mnr[i] )
				continue;

			fprintf( fp, "\"%c\tc #%06lx\",\n", (char)i,
					col_tab[j].col_code );
		}
	}
}

/**/

void	save_town_ptn_col_2byte( FILE *fp )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	i;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	for( i = 0; i < col_tab_max_n; i++){
		fprintf( fp, "\"%c%c\tc #%06lx\",\n",
				col_tab[i].mjr, col_tab[i].mnr,
				col_tab[i].col_code );
	}
}

/**/

bool_t	rename_back_up_file( char *fname )
{
	long	i;
	long	path_len;
	char	str_n[15 + 1];
	static char	bak_fname[FILE_NAME_MAX_LEN + 1];

	path_len = strrchr( fname, '/' ) - fname + 1;
	if( path_len > FILE_NAME_MAX_LEN )
		path_len = FILE_NAME_MAX_LEN;

	for( i = 0; i < 999; i++ ){
		sprintf( str_n, STR_EXT_NAME_BAK_1, i );

		strncpy( bak_fname, fname, path_len );
		bak_fname[path_len] = '\0';
		str_max_n_cat( bak_fname, 
				cat_path( STR_DIR_NAME_BAK,
				&(fname[path_len]) ),
				FILE_NAME_MAX_LEN );
		str_max_n_cat( bak_fname, str_n, FILE_NAME_MAX_LEN );
		str_max_n_cat( bak_fname, STR_EXT_NAME_BAK_2,
				FILE_NAME_MAX_LEN );

		if( chk_exist_file( bak_fname ) )
			continue;

		if( rename( fname, bak_fname ) == 0 ){
			print_wrn( MSG_WRN_RENAME, fname, bak_fname );
			return TRUE;
		}
	}

	return FALSE;
}

/**/

char	*get_out_map_file_name( char *s )
{
	long	i;
	const long	max_i = 999;
	static char	fname[FILE_NAME_MAX_LEN + 1];
	static char	num_s[10 + 1];
	long	y;
	ask_t	ask;

	set_map_total( 0, 0, MAP_MAX_X, MAP_MAX_Y );
	wipe_all();

	/* ǥեȤΥե̾ */
	for( i = 0; i < max_i; i++ ){
		sprintf( num_s, STR_EXT_NAME_OUT_MAP, i );

		strncpy( fname, dir_name_game, FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_DIR_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_FILE_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, num_s,
				FILE_NAME_MAX_LEN );

		if( !chk_exist_file( fname ) )
			break;
	}
	if( i >= max_i )
		return NULL;

	y = 0;
	print_str( 0, y, MSG_OUT_MAP_FILE_1 );
	y++;
	print_str( 0, y, MSG_OUT_MAP_FILE_2, fname );
	y++;

	/* ե̾ */
	game_gets( -1, -1, s, FILE_NAME_MAX_LEN, TRUE );

	print_str( 0, y, MSG_OUT_MAP_FILE_3, s );
	y++;

	/* ˽Ϥ뤫ǧȤ */
	ask = exec_menu_ask( MSG_OUT_MAP_FILE_ASK_OK, FALSE, FALSE );

	redraw_all();

	switch( ask ){
	case ASK_YES:
		return s;
	case ASK_NO:
	case ASK_CANCEL:
	case ASK_ERR:
		break;
	}

	return NULL;
}

/**/

bool_t	out_map_file( void )
{
	static char	fname[FILE_NAME_MAX_LEN + 1];
	long	x, y;
	dun_t	*dun;
	FILE	*fp;

	if( get_out_map_file_name( fname ) == NULL )
		return FALSE;

	fp = fopen( fname, "w" );
	if( fp == NULL )
		return FALSE;

	dun = get_dun();

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			fprintf( fp, "%c%c",
					dun->map.total.mjr[y][x],
					dun->map.total.mnr[y][x] );
		}
		fprintf( fp, "\n" );
	}

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/**/

char	*cat_path( char *path, char *file )
{
	static char	dst[FILE_NAME_MAX_LEN + 1];

	strncpy( dst, path, FILE_NAME_MAX_LEN );
	str_max_n_cat( dst, STR_SLASH, FILE_NAME_MAX_LEN );
	str_max_n_cat( dst, file, FILE_NAME_MAX_LEN );

	return dst;
}

/**/

bool_t	chk_exist_file( char *s )
{
	FILE	*fp;

	fp = fopen( s, "r" );
	if( fp == NULL )
		return FALSE;

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_exist_dir( char *s )
{
	FILE	*fp;

	fp = fopen( s, "r" );
	if( fp == NULL )
		return FALSE;

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}

/**/

long	make_dir( char *path, mode_t mode )
{
#if	HAVE_MKDIR
	return mkdir( path, mode );
#else	/* HAVE_MKDIR */
	return mknod( path, mode, 0 );
#endif	/* HAVE_MKDIR */
}

/**/

