/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: item.h,v 1.25 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#ifndef	ITEM_H
#define	ITEM_H

#include	"spell.h"
#include	"chr.h"
#include	"mnstr.h"
#include	"trap.h"

#define	MBR_ITEM_MAX_N	16
#define	DUN_ITEM_AVE_N	12
#define	ITEM_NAME_MAX_LEN	60
#define	ITEM_ART_NAME_MAX_LEN	(ITEM_NAME_MAX_LEN + 16)

#define	SCROLL_TTL_MAX_LEN	50
#define	SPIKE_AVE_N	10

#define	PUT_ITEM_R	MAP_MAX_X
#define	BUNDLE_MAX_N	12

#define	CURSE_ITEM_RATE	((rate_t)30)

/* Face begin */

#define	FACE_MJR_WEAPON	')'
#define	FACE_MNR_SWORD	's'
#define	FACE_MNR_BOW	'b'
#define	FACE_MNR_ARW	'a'
#define	FACE_MNR_STONE	','
#define	FACE_MNR_DAGGER	'd'

#define	FACE_MJR_ARMOR	']'
#define	FACE_MNR_ARMOR_SHIELD	's'
#define	FACE_MNR_ARMOR_HEAD	'h'
#define	FACE_MNR_ARMOR_BODY	'b'
#define	FACE_MNR_ARMOR_ARM	'a'
#define	FACE_MNR_ARMOR_FEET	'f'
#define	FACE_MNR_ARMOR_ABOUT_BODY	'm'

#define	FACE_MJR_POTION	'!'
#define	FACE_MJR_SCROLL	'?'

#define	FACE_MJR_STICK	'/'
#define	FACE_MNR_WAND	'w'
#define	FACE_MNR_ROD	'r'
#define	FACE_MNR_STAFF	's'

#define	FACE_MJR_ACCESSORY	'='
#define	FACE_MNR_RING	'r'
#define	FACE_MNR_AMULET	'a'
#define	FACE_MNR_NECKLACE	'n'

#define	FACE_MJR_FOOD	':'

#define	FACE_MJR_CHEST	'&'

#define	FACE_MJR_COIN	'$'

#define	FACE_MJR_GEM	'*'

#define	FACE_MJR_MISC	'\"'
#define	FACE_MNR_LIGHT	'l'
#define	FACE_MNR_SPIKE	's'
#define	FACE_MNR_TOBACCO	't'
#define	FACE_MNR_PIPE	'p'
#define	FACE_MNR_DISPOSAL	'd'
#define	FACE_MNR_JUNK	'"'

/* Face end */

#define	WPN_ATTACK_MAX_N	4

/******************************************************************/
/*  */

typedef enum {
	CAN_USE_ITEM_YES,
	CAN_USE_ITEM_REST,
	CAN_USE_ITEM_NO,
} can_use_item_t;

typedef enum {
	ITEM_KIND_NULL,
	ITEM_KIND_WPN,
	ITEM_KIND_ARMOR,
	ITEM_KIND_POTION,
	ITEM_KIND_SCROLL,
	ITEM_KIND_STICK,
	ITEM_KIND_ACCE,
	ITEM_KIND_LIGHT,
	ITEM_KIND_SPIKE,
	ITEM_KIND_FOOD,
	ITEM_KIND_CHEST,
	ITEM_KIND_TOBACCO,
	ITEM_KIND_PIPE,
	ITEM_KIND_DISPOSAL,
	ITEM_KIND_COIN,
	ITEM_KIND_JUNK,
	ITEM_KIND_MAX_N,
} item_kind_t;

typedef enum {
	EQUIP_KIND_WIELDING,
	EQUIP_KIND_SHIELD,
	EQUIP_KIND_BOW,
	EQUIP_KIND_ARW,
	EQUIP_KIND_HEAD,
	EQUIP_KIND_NECK,
	EQUIP_KIND_BODY,
	EQUIP_KIND_ABOUT_BODY,
	EQUIP_KIND_ARM,
	EQUIP_KIND_RIGHT_HAND,
	EQUIP_KIND_LEFT_HAND,
	EQUIP_KIND_FEET,
	EQUIP_KIND_LIGHT_SOURCE,
	EQUIP_KIND_MAX_N,
} equip_kind_t;

typedef enum {
	WPN_KIND_NULL,

	WPN_KIND_KNIFE,
	WPN_KIND_KRIS_KNIFE,
	WPN_KIND_MAIN_GAUCHE,
	WPN_KIND_SWORD_BREAKER,
	WPN_KIND_KATAR,
	WPN_KIND_JAMADHAR,
	WPN_KIND_KUKRI,

	WPN_KIND_SHORT_SWORD,
	WPN_KIND_GLADIUS,

	WPN_KIND_LONG_SWORD,
	WPN_KIND_BROAD_SWORD,
	WPN_KIND_BASTARD_SWORD,
	WPN_KIND_CLAYMORE,
	WPN_KIND_GREAT_SWORD,

	WPN_KIND_SABRE,
	WPN_KIND_SHAMSHIR,
	WPN_KIND_TALWAR,
	WPN_KIND_FALCHION,
	WPN_KIND_CUTLASS,
	WPN_KIND_SHOTEL,
	WPN_KIND_KATANA,

	WPN_KIND_RAPIER,
	WPN_KIND_ESTOC,

	WPN_KIND_HAND_AXE,
	WPN_KIND_FRANCISCA,
	WPN_KIND_BHUJ,

	WPN_KIND_BATTLE_AXE,
	WPN_KIND_BROAD_AXE,
	WPN_KIND_GREAT_AXE,

	WPN_KIND_SPEAR,
	WPN_KIND_PILUM,
	WPN_KIND_PIKE,
	WPN_KIND_JAVELIN,
	WPN_KIND_TRIDENT,

	WPN_KIND_LANCE,

	WPN_KIND_WOODEN_CLUB,
	WPN_KIND_QUARTER_STAFF,
	WPN_KIND_LIGHT_FLAIL,
	WPN_KIND_HEAVY_FLAIL,
	WPN_KIND_MORNINGSTAR,

	WPN_KIND_LIGHT_MACE,
	WPN_KIND_HEAVY_MACE,

	WPN_KIND_WAR_HAMMER,
	WPN_KIND_WAR_PICK,
	WPN_KIND_ZAGHNOL,
	WPN_KIND_BEC_DE_CORBIN,

	WPN_KIND_PARTIZAN,
	WPN_KIND_POLEAXE,
	WPN_KIND_GLAIVE,
	WPN_KIND_HALBERD,
	WPN_KIND_CHAUVE_SOURIS,
	WPN_KIND_CORSESCA,
	WPN_KIND_SCYTHE,
	WPN_KIND_FAUCHARD,
	WPN_KIND_GUISARME,

	WPN_KIND_BRASS_KNUCKLE,
	WPN_KIND_BAGH_NAKH,

	WPN_KIND_SLING,
	WPN_KIND_SHORT_BOW,
	WPN_KIND_LONG_BOW,
	WPN_KIND_COMPOSITE_BOW,
	WPN_KIND_LIGHT_CROSS_BOW,
	WPN_KIND_HEAVY_CROSS_BOW,
	WPN_KIND_BLOW_GUN,

	WPN_KIND_STONE,
	WPN_KIND_BULLET,
	WPN_KIND_ARW,
	WPN_KIND_BOLT,
	WPN_KIND_NEEDLE,

	WPN_KIND_DAGGER,
	WPN_KIND_DARTS,
	WPN_KIND_SHURIKEN,
	WPN_KIND_BOOMERANG,

	WPN_KIND_MAX_N,
} wpn_kind_t;

typedef enum {
	BOW_KIND_NULL,
	BOW_KIND_BOW,
	BOW_KIND_CROSS_BOW,
	BOW_KIND_SLING,
	BOW_KIND_BLOW_GUN,
	BOW_KIND_DAGGER,
	BOW_KIND_MAX_N,
} bow_kind_t;

typedef enum {
	ARMOR_KIND_NULL,

	ARMOR_KIND_LEATHER_CAP,
	ARMOR_KIND_METAL_CAP,
	ARMOR_KIND_SALLET,
	ARMOR_KIND_CLOSE_HELMET,
	ARMOR_KIND_SILVER_CROWN,
	ARMOR_KIND_GOLDEN_CROWN,
	ARMOR_KIND_JEWELED_CROWN,

	ARMOR_KIND_ROBE,
	ARMOR_KIND_SOFT_LEATHER_ARMOR,
	ARMOR_KIND_HARD_LEATHER_ARMOR,
	ARMOR_KIND_RING_MAIL,
	ARMOR_KIND_SCALE_MAIL,
	ARMOR_KIND_DRAGON_SCALE,
	ARMOR_KIND_LAMELLAR_ARMOR,
	ARMOR_KIND_CHAIN_MAIL,
	ARMOR_KIND_MITHRIL_CHAIN,
	ARMOR_KIND_PLATE_ARMOR,

	ARMOR_KIND_CLOAK,

	ARMOR_KIND_LEATHER_GLOVES,
	ARMOR_KIND_GAUNTLETS,

	ARMOR_KIND_LEATHER_BOOTS,
	ARMOR_KIND_GREAVE,
	ARMOR_KIND_SLOW_BOOTS,

	ARMOR_KIND_BUCKLER_SHIELD,
	ARMOR_KIND_ROUND_SHIELD,
	ARMOR_KIND_KITE_SHIELD,
	ARMOR_KIND_HEATER_SHIELD,

	ARMOR_KIND_MAX_N,
} armor_kind_t;

typedef enum {
	POTION_KIND_NULL,
	POTION_KIND_WATER,
	POTION_KIND_MILK,
	POTION_KIND_RED_WINE,
	POTION_KIND_WHITE_WINE,
	POTION_KIND_ROSE_WINE,
	POTION_KIND_ALE,
	POTION_KIND_BRANDY,
	POTION_KIND_RUM,
	POTION_KIND_COFFE,
	POTION_KIND_ICE_COFFE,
	POTION_KIND_TEA,
	POTION_KIND_MILK_TEA,
	POTION_KIND_LEMON_TEA,
	POTION_KIND_ICE_TEA,
	POTION_KIND_ICE_MILK_TEA,
	POTION_KIND_ICE_LEMON_TEA,
	POTION_KIND_APPLE_JUICE,
	POTION_KIND_GRAPE_JUICE,
	POTION_KIND_ORANGE_JUICE,
	POTION_KIND_BLACK_BERRY_JUICE,
	POTION_KIND_CRAN_BERRY_JUICE,
	POTION_KIND_RASP_BERRY_JUICE,
	POTION_KIND_STRAW_BERRY_JUICE,
	POTION_KIND_OIL,
	POTION_KIND_STONE,
	POTION_KIND_PARALYZE,
	POTION_KIND_POISON,
	POTION_KIND_CONFUSION,
	POTION_KIND_BLIND,
	POTION_KIND_SLEEP,
	POTION_KIND_SILENCE,
	POTION_KIND_FEAR,
	POTION_KIND_HALLUCINATION,
	POTION_KIND_CHARM,
	POTION_KIND_FLY,
	POTION_KIND_VANISH,
	POTION_KIND_RESI_PHYS,
	POTION_KIND_RESI_HEAT,
	POTION_KIND_RESI_COLD,
	POTION_KIND_RESI_ACID,
	POTION_KIND_RESI_MIND,
	POTION_KIND_RESI_ELEC,
	POTION_KIND_RESI_POIS,
	POTION_KIND_SHARPNESS,
	POTION_KIND_DULLNESS,
	POTION_KIND_STRENGTH,
	POTION_KIND_WEAKNESS,
	POTION_KIND_QUICKNESS,
	POTION_KIND_SLOWNESS,
	POTION_KIND_WISE,
	POTION_KIND_FOOLISH,
	POTION_KIND_BRAINY,
	POTION_KIND_BRAINLESS,
	POTION_KIND_ATTRACTIVE,
	POTION_KIND_UNATTRACTIVE,
	POTION_KIND_SENSE_INVISIBLE,
	POTION_KIND_POW_UP_HP,
	POTION_KIND_SPEED_UP,
	POTION_KIND_SPEED_DOWN,
	POTION_KIND_CURE_LEV,
	POTION_KIND_CURE_HP_LIGHT,
	POTION_KIND_CURE_HP_MODERATE,
	POTION_KIND_CURE_HP_SERIOUS,
	POTION_KIND_CURE_HP_MAX,
	POTION_KIND_CURE_POISON,
	POTION_KIND_CURE_STATUS,
	POTION_KIND_DETECT_MNSTR,
	POTION_KIND_MAX_N,
} potion_kind_t;

typedef enum {
	SCROLL_KIND_NULL,
	SCROLL_KIND_SLEEP,
	SCROLL_KIND_IDENTIFY_ITEM,
	SCROLL_KIND_DETECT_ITEM,
	SCROLL_KIND_TELEPORT,
	SCROLL_KIND_POW_UP_WPN_HIT,
	SCROLL_KIND_POW_UP_WPN_CRTCL,
	SCROLL_KIND_POW_UP_WPN_DAM,
	SCROLL_KIND_POW_UP_ARMOR_DEF,
	SCROLL_KIND_POW_UP_ARMOR_CRTCL,
	SCROLL_KIND_POW_UP_ARMOR_AC,
	SCROLL_KIND_PROTECT_ARMOR,
	SCROLL_KIND_REMOVE_CURSE,
	SCROLL_KIND_RECALL,
	SCROLL_KIND_MAX_N,
} scroll_kind_t;

typedef enum {
	STICK_KIND_NULL,
	STICK_KIND_WAND,
	STICK_KIND_ROD,
	STICK_KIND_STAFF,
	STICK_KIND_MAX_N,
} stick_kind_t;

typedef enum {
	ACCE_KIND_NULL,
	ACCE_KIND_RING,
	ACCE_KIND_AMULET,
	ACCE_KIND_NECKLACE,
	ACCE_KIND_MAX_N,
} acce_kind_t;

typedef enum {
	RING_KIND_NULL,
	RING_KIND_SLOW_DIGESTION,
	RING_KIND_TELEPORT_PARTY,
	RING_KIND_TELEPORT,
	RING_KIND_SHARPNESS,
	RING_KIND_DULLNESS,
	RING_KIND_STRENGTH,
	RING_KIND_WEAKNESS,
	RING_KIND_QUICKNESS,
	RING_KIND_SLOWNESS,
	RING_KIND_WISE,
	RING_KIND_FOOLISH,
	RING_KIND_BRAINY,
	RING_KIND_BRAINLESS,
	RING_KIND_ATTRACTIVE,
	RING_KIND_UNATTRACTIVE,
	RING_KIND_MAX_N,
} ring_kind_t;

typedef enum {
	AMULET_KIND_NULL,
	AMULET_KIND_RESI_PHYS,
	AMULET_KIND_RESI_HEAT,
	AMULET_KIND_RESI_COLD,
	AMULET_KIND_RESI_ACID,
	AMULET_KIND_RESI_MIND,
	AMULET_KIND_RESI_ELEC,
	AMULET_KIND_RESI_POIS,
	AMULET_KIND_MAX_N,
} amulet_kind_t;

typedef enum {
	NECKLACE_KIND_NULL,
	NECKLACE_KIND_MAX_N,
} necklace_kind_t;

typedef enum {
	LIGHT_KIND_NULL,
	LIGHT_KIND_TORCH,
	LIGHT_KIND_LANTERN,
	LIGHT_KIND_LAMP,
	LIGHT_KIND_MAX_N,
} light_kind_t;

typedef enum {
	FOOD_KIND_NULL,
	FOOD_KIND_PRESERVED,
	FOOD_KIND_SAUSAGE,
	FOOD_KIND_BACON,
	FOOD_KIND_CHIPPED_BEEF,
	FOOD_KIND_CORNED_BEEF,
	FOOD_KIND_BREAD,
	FOOD_KIND_BROWN_BREAD,
	FOOD_KIND_TOAST,
	FOOD_KIND_PANCAKE,
	FOOD_KIND_SALAD,
	FOOD_KIND_POTATO_SALAD,
	FOOD_KIND_SCRAMBLED_EGGS,
	FOOD_KIND_FRIED_EGGS,
	FOOD_KIND_HARD_BOILED_EGGS,
	FOOD_KIND_SOFT_BOILED_EGGS,
	FOOD_KIND_BEEF_STEAK,
	FOOD_KIND_PORK_SAUTE,
	FOOD_KIND_FRIED_CHICKEN,
	FOOD_KIND_FRIED_FISH,
	FOOD_KIND_FRIED_POTATO,
	FOOD_KIND_STEWED_BEEF,
	FOOD_KIND_CONSOMME,
	FOOD_KIND_POTAGE,
	FOOD_KIND_APPLE_PIE,
	FOOD_KIND_APPLE,
	FOOD_KIND_GRAPE,
	FOOD_KIND_ORANGE,
	FOOD_KIND_PEAR,
	FOOD_KIND_GRAPEFRUIT,
	FOOD_KIND_PLUM,
	FOOD_KIND_PEACH,
	FOOD_KIND_APRICOT,
	FOOD_KIND_BLACK_BERRY,
	FOOD_KIND_CRAN_BERRY,
	FOOD_KIND_RASP_BERRY,
	FOOD_KIND_STRAW_BERRY,
	FOOD_KIND_MAX_N,
} food_kind_t;

typedef unsigned long	flg_tobacco_t;
#define	FLG_TOBACCO_USE_PIPE	(1 << 0)
#define	FLG_TOBACCO_CAN_USE_PIPE	(1 << 1)

typedef enum {
	TOBACCO_KIND_NULL,
	TOBACCO_KIND_CIGARET,
	TOBACCO_KIND_CIGAR,
	TOBACCO_KIND_CUT_TOBACCO,
	TOBACCO_KIND_SNUFF_TOBACCO,
	TOBACCO_KIND_CHEWING_TOBACCO,
	TOBACCO_KIND_ABSTAIN_GUM,
	TOBACCO_KIND_MAX_N,
} tobacco_kind_t;

typedef enum {
	TOBACCO_BRAND_NULL,

	/* CIGARET */
	TOBACCO_BRAND_HELLO,
	TOBACCO_BRAND_SUN_SHINE,
	TOBACCO_BRAND_CHERRY_TREE,
	TOBACCO_BRAND_GOLDEN_RAT,
	TOBACCO_BRAND_AIR_SHIT,
	TOBACCO_BRAND_HOP,
	TOBACCO_BRAND_PIECE,
	TOBACCO_BRAND_HARPY,
	TOBACCO_BRAND_HIGH_LIGHT,
	TOBACCO_BRAND_SHOOTING_STARS,
	TOBACCO_BRAND_WILD_NINE,
	TOBACCO_BRAND_WILD_NINE_MENTHOL,
	TOBACCO_BRAND_LODGE,
	TOBACCO_BRAND_LODGE_MENTHOL,
	TOBACCO_BRAND_CANCER,
	TOBACCO_BRAND_CANCER_MENTHOL,
	TOBACCO_BRAND_FRONT_LINE,
	TOBACCO_BRAND_FRONT_LINE_MENTHOL,
	TOBACCO_BRAND_MARCO_POLO,
	TOBACCO_BRAND_CAMELLIA,
	TOBACCO_BRAND_GOOD_LUCK,
	TOBACCO_BRAND_BAD_GUY,

	/* CIGAR */
	TOBACCO_BRAND_ARCADIA,
	TOBACCO_BRAND_GLORIA,
	TOBACCO_BRAND_VULCAN,
	TOBACCO_BRAND_PONY,
	TOBACCO_BRAND_KEITH,
	TOBACCO_BRAND_LUMBERJACK,
	TOBACCO_BRAND_CORONA,
	TOBACCO_BRAND_HALF_CORONA,
	TOBACCO_BRAND_CRYSTAL,

	/* CUT TOBACCO */
	TOBACCO_BRAND_FOREST_BRANDY,
	TOBACCO_BRAND_SILK_ROAD,
	TOBACCO_BRAND_PROMENADE,
	TOBACCO_BRAND_BIG_HORN,
	TOBACCO_BRAND_ROCKING_CHAIR,
	TOBACCO_BRAND_VANILLA,
	TOBACCO_BRAND_WILD_MANGO,
	TOBACCO_BRAND_KENTUCKY_BIRD,
	TOBACCO_BRAND_ORIENT,
	TOBACCO_BRAND_FUJI,

	/* SNUFF TOBACCO */
	TOBACCO_BRAND_DOGGY_APRICOT,
	TOBACCO_BRAND_DOGGY_WHISKY,
	TOBACCO_BRAND_DOGGY_HONEY,
	TOBACCO_BRAND_DOGGY_SPEARMINT,
	TOBACCO_BRAND_DOGGY_PEPPERMINT,
	TOBACCO_BRAND_DOGGY_VANILLA,
	TOBACCO_BRAND_DOGGY_MENTHOL,
	TOBACCO_BRAND_DOGGY_CITRUS,
	TOBACCO_BRAND_DOGGY_SHERRY,

	/* CHEWING TOBACCO */
	TOBACCO_BRAND_ROSE_PREMIUM,
	TOBACCO_BRAND_ROSE_VANILLA,
	TOBACCO_BRAND_ROSE_MENTHOL,

	/* ABSTAIN GUM */
	TOBACCO_BRAND_NICOTIME,

	TOBACCO_BRAND_MAX_N,
} tobacco_brand_t;

typedef unsigned long	flg_pipe_t;
#define	FLG_PIPE_CONSUMPTION	(1 << 0)

typedef enum {
	PIPE_KIND_NULL,
	PIPE_KIND_PIPE,
	PIPE_KIND_KISEL,
	PIPE_KIND_CIGARET_HOLDER,
	PIPE_KIND_MAX_N,
} pipe_kind_t;

typedef enum {
	COIN_KIND_NULL,
	COIN_KIND_GOLD,
	COIN_KIND_SILVER,
	COIN_KIND_COPPER,
	COIN_KIND_MAX_N,
} coin_kind_t;

/******************************************************************/
/* ¤ */

struct not_identified {
	n_msg_t	name_n;
	bool_t	flg_used;
};

typedef struct not_identified	color_tab_t;
typedef struct not_identified	material_tab_t;
typedef struct not_identified	ring_material_tab_t;
typedef struct not_identified	amulet_material_tab_t;
typedef struct not_identified	necklace_material_tab_t;
typedef n_msg_t	ttl_syllable_tab_t;

/* flag weapon begin */

typedef unsigned long	flg_wpn_tab_t;

#define	FLG_WPN_TAB_BOW	(1 << 0)
#define	FLG_WPN_TAB_ARW	(1 << 1)
#define	FLG_WPN_TAB_TWO_HANDED	(1 << 2)
#define	FLG_WPN_TAB_RET	(1 << 4)
#define	FLG_WPN_TAB_BUNDLE	(1 << 5)
#define	FLG_WPN_TAB_NOT_SPEND	(1 << 6)
#define	FLG_WPN_TAB_BOOMERANG	\
		(FLG_WPN_TAB_ARW | FLG_WPN_TAB_RET | FLG_WPN_TAB_BUNDLE)
#define	FLG_WPN_TAB_THROW	\
		(FLG_WPN_TAB_ARW | FLG_WPN_TAB_NOT_SPEND)

/* flag weapon end */

/* flag item ability begin */

typedef unsigned long	flg_item_abl;

#define	FLG_ITEM_ABL_FIG	(1 << 0)
#define	FLG_ITEM_ABL_MON	(1 << 1)
#define	FLG_ITEM_ABL_HUN	(1 << 2)
#define	FLG_ITEM_ABL_THI	(1 << 3)
#define	FLG_ITEM_ABL_MAG	(1 << 4)
#define	FLG_ITEM_ABL_SOR	(1 << 5)
#define	FLG_ITEM_ABL_ENC	(1 << 6)
#define	FLG_ITEM_ABL_SUM	(1 << 7)
#define	FLG_ITEM_ABL_PRI	(1 << 8)
#define	FLG_ITEM_ABL_SHA	(1 << 9)
#define	FLG_ITEM_ABL_BAR	(1 << 10)
#define	FLG_ITEM_ABL_NIN	(1 << 11)

#define	FLG_ITEM_ABL_ALL_MAG	\
		(FLG_ITEM_ABL_MAG | FLG_ITEM_ABL_SOR \
		| FLG_ITEM_ABL_ENC | FLG_ITEM_ABL_SUM)
#define	FLG_ITEM_ABL_MAG_SHA	\
		(FLG_ITEM_ABL_ALL_MAG | FLG_ITEM_ABL_SHA)

/* flag item ability end */

/* flag item begin */

typedef unsigned long	flg_item_t;

#define	FLG_ITEM_DETECTED	(1 << 0)
#define	FLG_ITEM_IDENTIFIED	(1 << 1)
#define	FLG_ITEM_PROTECTED	(1 << 2)
#define	FLG_ITEM_CURSED	(1 << 3)

/* flag item end */

typedef struct {
	wpn_kind_t	kind;
	long	add_hit;
	long	add_crtcl;
	long	add_dam;
	char	slayer;
	flg_wpn_tab_t	flg;
} wpn_t;

typedef struct {
	armor_kind_t	kind;
	rate_t	def;
	rate_t	crtcl;
	rate_t	ac;
	long	add_def;
	long	add_crtcl;
	long	add_ac;
} armor_t;

typedef struct {
	potion_kind_t	kind;
} potion_t;

typedef struct {
	scroll_kind_t	kind;
} scroll_t;

typedef struct {
	stick_kind_t	kind;
	spell_kind_t	spell_kind;
	long	n;
} stick_t;

typedef struct {
	acce_kind_t	kind;
	ring_kind_t	ring_kind;
	amulet_kind_t	amulet_kind;
	necklace_kind_t	necklace_kind;
} acce_t;

typedef struct {
	light_kind_t	kind;
	long	turn;
} light_t;

typedef struct {
	food_kind_t	kind;
} food_t;

typedef struct {
	struct item_t	*contents;
	long	ref;
	trap_t	*trap;
} chest_t;

typedef struct {
	tobacco_kind_t	kind;
	tobacco_brand_t	brand;
	long	turn;
} tobacco_t;

typedef struct {
	pipe_kind_t	kind;
	long	turn;
	long	consume_turn;
} pipe_t;

typedef struct {
	long	n, max_n;
} disposal_t;

typedef struct {
	coin_kind_t	kind;
} coin_t;

/******************************************************************/
/* ơ֥ */

typedef struct {
	char	*name;
	n_msg_t	name_n;
	wpn_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	attack_t	attack[WPN_ATTACK_MAX_N + 1];
	rate_t	rate_price;
	long	add_price;
	char	mnr;
	long	min_lev, max_lev, sgn_lev;
	bow_kind_t	bow_kind;
	flg_wpn_tab_t	flg;
	flg_item_abl	flg_abl;
} wpn_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	armor_kind_t	kind;
	rate_t	rate_price;
	long	add_price;
	char	mnr;
	equip_kind_t	equip_kind;
	rate_t	up_resi[RESI_KIND_MAX_N];
	rate_t	def, crtcl, ac;
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	flg_item_abl	flg_abl;
	rate_t	rate_curse;
	modifier_t	modifier;
} armor_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	potion_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	*color;
	n_msg_t	color_n;
	bool_t	flg_identified;
	bool_t	flg_change_color;
} potion_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	scroll_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	ttl[SCROLL_TTL_MAX_LEN + 1];
	bool_t	flg_identified;
} scroll_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;
	long	use_n;
	stick_kind_t	kind;
	spell_kind_t	spell_kind;
	long	min_lev, max_lev, sgn_lev;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
} stick_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	acce_kind_t	kind;
	ring_kind_t	ring_kind;
	amulet_kind_t	amulet_kind;
	necklace_kind_t	necklace_kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	mnr;
	equip_kind_t	equip_kind;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
	rate_t	rate_curse;
	modifier_t	modifier;
} acce_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	light_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	long	max_turn;
	bool_t	flg_fill;
} light_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	food_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	rate_t	fill_rate;
} food_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	tobacco_kind_t	kind;
	char	*brand_name;
	n_msg_t	brand_name_n;
	tobacco_brand_t	brand;
	rate_t	rate;
	long	ave_n;
	long	turn;
	gold_t	price;
	flg_tobacco_t	flg;
} tobacco_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	pipe_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	long	consume_turn;
	tobacco_kind_t	tobacco_kind;
	gold_t	price;
	flg_pipe_t	flg;
} pipe_tab_t;

typedef struct {
	char	*name;
	n_msg_t	name_n;
	coin_kind_t	kind;
	char	mnr;
	rate_t	rate;
	long	value;
} coin_tab_t;

typedef struct {
	char	mjr, mnr;
	bool_t	flg_ena;
} auto_mark_appoint_item_t;

typedef struct {
	stick_kind_t	kind;
	spell_kind_t	spell_kind;
} item_kind_dat_stick_t;

typedef struct {
	tobacco_kind_t	kind;
	tobacco_brand_t	brand;
} item_kind_dat_tobacco_t;

typedef struct {
	wpn_kind_t	wpn;
	armor_kind_t	armor;
	potion_kind_t	potion;
	scroll_kind_t	scroll;
	item_kind_dat_stick_t	stick;
	ring_kind_t	ring;
	amulet_kind_t	amulet;
	necklace_kind_t	necklace;
	light_kind_t	light;
	food_kind_t	food;
	item_kind_dat_tobacco_t	tobacco;
	pipe_kind_t	pipe;
	coin_kind_t	coin;
} item_kind_dat_t;

/******************************************************************/
/* ƥ */

typedef struct item_t {
	struct item_t	*next, *prev;
	char	name[ITEM_NAME_MAX_LEN + 1];
	char	art_name[ITEM_ART_NAME_MAX_LEN + 1];
	item_kind_t	kind;
	equip_kind_t	equip_kind;
	char	mjr, mnr;
	long	x, y;
	long	n, stock;
	flg_item_t	flg;
	modifier_t	modifier;
	union {
		wpn_tab_t	*wpn;
		armor_tab_t	*armor;
		potion_tab_t	*potion;
		scroll_tab_t	*scroll;
		stick_tab_t	*stick;
		acce_tab_t	*acce;
		light_tab_t	*light;
		food_tab_t	*food;
		tobacco_tab_t	*tobacco;
		pipe_tab_t	*pipe;
		coin_tab_t	*coin;
	} tab;
	union {
		wpn_t	wpn;
		armor_t	armor;
		potion_t	potion;
		scroll_t	scroll;
		stick_t	stick;
		acce_t	acce;
		light_t	light;
		food_t	food;
		chest_t	chest;
		tobacco_t	tobacco;
		pipe_t	pipe;
		disposal_t	disposal;
		coin_t	coin;
	} dat;
} item_t;

#endif	/* ITEM_H */

