/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: item_tab.h,v 1.28 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#ifndef	ITEM_TAB_H
#define	ITEM_TAB_H

#include	"chr.h"

ratio_t	item_ratio_tab[ITEM_KIND_MAX_N] = {
	10,	/* ITEM_KIND_NULL */
	80,	/* ITEM_KIND_WPN */
	60,	/* ITEM_KIND_ARMOR */
	80,	/* ITEM_KIND_POTION */
	80,	/* ITEM_KIND_SCROLL */
	80,	/* ITEM_KIND_STICK */
	80,	/* ITEM_KIND_ACCE */
	30,	/* ITEM_KIND_LIGHT */
	30,	/* ITEM_KIND_SPIKE */
	80,	/* ITEM_KIND_FOOD */
	20,	/* ITEM_KIND_CHEST */
	50,	/* ITEM_KIND_TOBACCO */
	20,	/* ITEM_KIND_PIPE */
	80,	/* ITEM_KIND_COIN */
	20,	/* ITEM_KIND_JUNK */
};

wpn_tab_t	wpn_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	wpn_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	attack_t	attack[WPN_ATTACK_MAX_N + 1];
	rate_t	rate_price;
	long	add_price;
	char	mnr;
	long	min_lev, max_lev, sgn_lev;
	bow_kind_t	bow_kind;
	flg_wpn_tab_t	flg;
	flg_item_abl	flg_abl;
} wpn_tab_t;

typedef struct {
	attack_kind_t	kind;
	ratio_t	ratio;
	bool_t	flg_throw, flg_monk;
	rate_t	hit, wpn_crtcl, dam;
	resi_kind_t	resi_kind;
} attack_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, WPN_KIND_NULL,
		(rate_t)0, 0,
		{
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				0, 0, 0, RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)0, +0, FACE_MNR_NULL,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KNIFE, WPN_KIND_KNIFE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KRIS_KNIFE, WPN_KIND_KRIS_KNIFE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_MAIN_GAUCHE, WPN_KIND_MAIN_GAUCHE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SWORD_BREAKER, WPN_KIND_SWORD_BREAKER,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 100, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KATAR, WPN_KIND_KATAR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_JAMADHAR, WPN_KIND_JAMADHAR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KUKRI, WPN_KIND_KUKRI,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SHORT_SWORD, WPN_KIND_SHORT_SWORD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				40, 40, 40, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GLADIUS, WPN_KIND_GLADIUS,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				40, 40, 40, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LONG_SWORD, WPN_KIND_LONG_SWORD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BROAD_SWORD, WPN_KIND_BROAD_SWORD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 50, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CLAYMORE, WPN_KIND_CLAYMORE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 60, 80, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BASTARD_SWORD, WPN_KIND_BASTARD_SWORD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				90, 70, 90, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GREAT_SWORD, WPN_KIND_GREAT_SWORD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 80, 100, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SABRE, WPN_KIND_SABRE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHAMSHIR, WPN_KIND_SHAMSHIR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				60, 60, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_TALWAR, WPN_KIND_TALWAR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FALCHION, WPN_KIND_FALCHION,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 50, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CUTLASS, WPN_KIND_CUTLASS,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 80, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHOTEL, WPN_KIND_SHOTEL,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 80, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KATANA, WPN_KIND_KATANA,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 100, 80, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_RAPIER, WPN_KIND_RAPIER,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_ESTOC, WPN_KIND_ESTOC,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_HAND_AXE, WPN_KIND_HAND_AXE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 60, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 60, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FRANCISCA, WPN_KIND_FRANCISCA,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 60, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 60, 60, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_BATTLE_AXE, WPN_KIND_BATTLE_AXE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BHUJ, WPN_KIND_BHUJ,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BROAD_AXE, WPN_KIND_BROAD_AXE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				60, 80, 80, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GREAT_AXE, WPN_KIND_GREAT_AXE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 100, 100, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SPEAR, WPN_KIND_SPEAR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_PILUM, WPN_KIND_PILUM,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_PIKE, WPN_KIND_PIKE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_JAVELIN, WPN_KIND_JAVELIN,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_TRIDENT, WPN_KIND_TRIDENT,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LANCE, WPN_KIND_LANCE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_WOODEN_CLUB, WPN_KIND_WOODEN_CLUB,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_LIGHT_FLAIL, WPN_KIND_LIGHT_FLAIL,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_HEAVY_FLAIL, WPN_KIND_HEAVY_FLAIL,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				100, 50, 70, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_MORNINGSTAR, WPN_KIND_MORNINGSTAR,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				100, 50, 60, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				100, 50, 60, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LIGHT_MACE, WPN_KIND_LIGHT_MACE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 40, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_HEAVY_MACE, WPN_KIND_HEAVY_MACE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_WPN_WAR_HAMMER, WPN_KIND_WAR_HAMMER,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_WAR_PICK, WPN_KIND_WAR_PICK,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_ZAGHNOL, WPN_KIND_ZAGHNOL,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_BEC_DE_CORBIN, WPN_KIND_BEC_DE_CORBIN,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_PARTIZAN, WPN_KIND_PARTIZAN,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_POLEAXE, WPN_KIND_POLEAXE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD, 0,
		DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GLAIVE, WPN_KIND_GLAIVE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_HALBERD, WPN_KIND_HALBERD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CHAUVE_SOURIS, WPN_KIND_CHAUVE_SOURIS,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CORSESCA, WPN_KIND_CORSESCA,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SCYTHE, WPN_KIND_SCYTHE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FAUCHARD, WPN_KIND_FAUCHARD,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GUISARME, WPN_KIND_GUISARME,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_BRASS_KNUCKLE, WPN_KIND_BRASS_KNUCKLE,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON,
	},

	{ NULL, N_MSG_WPN_BAGH_NAKH, WPN_KIND_BAGH_NAKH,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON,
	},

	{ NULL, N_MSG_WPN_QUARTER_STAFF, WPN_KIND_QUARTER_STAFF,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_SWORD,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_WPN_SLING, WPN_KIND_SLING,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_BOW,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_SHORT_BOW, WPN_KIND_SHORT_BOW,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				40, 40, 50, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_LONG_BOW, WPN_KIND_LONG_BOW,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				60, 60, 70, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_COMPOSITE_BOW, WPN_KIND_COMPOSITE_BOW,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				80, 80, 90, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_LIGHT_CROSS_BOW, WPN_KIND_LIGHT_CROSS_BOW,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				70, 60, 60, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_HEAVY_CROSS_BOW, WPN_KIND_HEAVY_CROSS_BOW,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				90, 80, 80, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BLOW_GUN, WPN_KIND_BLOW_GUN,
		(rate_t)80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)100, +0, FACE_MNR_BOW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BLOW_GUN, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_STONE, WPN_KIND_STONE,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				+0, +0, +0, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)0, +0, FACE_MNR_STONE,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_BULLET, WPN_KIND_BULLET,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				+5, +0, +5, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)1, +0, FACE_MNR_STONE,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_ARW, WPN_KIND_ARW,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+10, +0, +10, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)1, +0, FACE_MNR_ARW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BOLT, WPN_KIND_BOLT,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+10, +0, +10, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)1, +0, FACE_MNR_ARW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_NEEDLE, WPN_KIND_NEEDLE,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+5, +0, +5, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)1, +0, FACE_MNR_ARW,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_BLOW_GUN, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_DAGGER, WPN_KIND_DAGGER,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)10, +0, FACE_MNR_DAGGER,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_DARTS, WPN_KIND_DARTS,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)10, +0, FACE_MNR_DAGGER,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHURIKEN, WPN_KIND_SHURIKEN,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 40, 40, RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)10, +0, FACE_MNR_DAGGER,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BOOMERANG, WPN_KIND_BOOMERANG,
		(rate_t)80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)10, +0, FACE_MNR_DAGGER,
		0, DUN_MAX_LEV_BASE, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_BOOMERANG,
		FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_NULL, WPN_KIND_NULL,
		(rate_t)0, 0,
		{
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				0, 0, 0, RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL, N_MSG_NULL, },
			{ ATTACK_KIND_NULL, },
		},
		(rate_t)0, +0, FACE_MNR_NULL,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
};

armor_tab_t	armor_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	armor_kind_t	kind;
	rate_t	rate_price;
	long	add_price;
	char	mnr;
	equip_kind_t	equip_kind;
	rate_t	up_resi[RESI_KIND_MAX_N];
	rate_t	def, crtcl, ac;
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	flg_item_abl	flg_abl;
	rate_t	rate_curse;
	modifier_t	modifier;
} armor_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		ARMOR_KIND_NULL,
		(rate_t)100, +0, FACE_MNR_NULL,
		EQUIP_KIND_HEAD,
		{ 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		(rate_t)0, (rate_t)0, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0, (rate_t)0,
		FLG_NULL,
		(rate_t)0,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_LEATHER_CAP,
		ARMOR_KIND_LEATHER_CAP,
		(rate_t)100, +0, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)40, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_METAL_CAP,
		ARMOR_KIND_METAL_CAP,
		(rate_t)100, +0, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)60, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_SALLET,
		ARMOR_KIND_SALLET,
		(rate_t)100, +0, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)80, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_CLOSE_HELMET,
		ARMOR_KIND_CLOSE_HELMET,
		(rate_t)100, +0, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)100, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_SILVER_CROWN,
		ARMOR_KIND_SILVER_CROWN,
		(rate_t)0, +10000, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)10, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_GOLDEN_CROWN,
		ARMOR_KIND_GOLDEN_CROWN,
		(rate_t)0, +20000, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)10, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_JEWELED_CROWN,
		ARMOR_KIND_JEWELED_CROWN,
		(rate_t)0, +30000, FACE_MNR_ARMOR_HEAD,
		EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)10, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_ARMOR_ROBE,
		ARMOR_KIND_ROBE,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)10,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_SOFT_LEATHER_ARMOR,
		ARMOR_KIND_SOFT_LEATHER_ARMOR,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)20,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_HARD_LEATHER_ARMOR,
		ARMOR_KIND_HARD_LEATHER_ARMOR,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)30,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_RING_MAIL,
		ARMOR_KIND_RING_MAIL,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)50,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_SCALE_MAIL,
		ARMOR_KIND_SCALE_MAIL,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)60,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_DRAGON_SCALE,
		ARMOR_KIND_DRAGON_SCALE,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 200, 200, 200, 200, 200, 200 },
		(rate_t)0, (rate_t)0, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_LAMELLAR_ARMOR,
		ARMOR_KIND_LAMELLAR_ARMOR,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)70,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_CHAIN_MAIL,
		ARMOR_KIND_CHAIN_MAIL,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 90, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_MITHRIL_CHAIN,
		ARMOR_KIND_MITHRIL_CHAIN,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 90, 100, 100, 180, 180, 180, 180, 180, 180 },
		(rate_t)0, (rate_t)0, (rate_t)100,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_PLATE_ARMOR,
		ARMOR_KIND_PLATE_ARMOR,
		(rate_t)100, +0, FACE_MNR_ARMOR_BODY,
		EQUIP_KIND_BODY,
		{ 150, 50, 150, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)100,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_ARMOR_CLOAK,
		ARMOR_KIND_CLOAK,
		(rate_t)100, +0, FACE_MNR_ARMOR_ABOUT_BODY,
		EQUIP_KIND_ABOUT_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)10,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_ARMOR_LEATHER_GLOVES,
		ARMOR_KIND_LEATHER_GLOVES,
		(rate_t)100, +0, FACE_MNR_ARMOR_ARM,
		EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)10,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_GAUNTLETS,
		ARMOR_KIND_GAUNTLETS,
		(rate_t)100, +0, FACE_MNR_ARMOR_ARM,
		EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)20,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_BUCKLER_SHIELD,
		ARMOR_KIND_BUCKLER_SHIELD,
		(rate_t)100, +0, FACE_MNR_ARMOR_SHIELD,
		EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)40, (rate_t)0, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_ARMOR_LEATHER_BOOTS,
		ARMOR_KIND_LEATHER_BOOTS,
		(rate_t)100, +0, FACE_MNR_ARMOR_FEET,
		EQUIP_KIND_FEET,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)10,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_GREAVE,
		ARMOR_KIND_GREAVE,
		(rate_t)100, +0, FACE_MNR_ARMOR_FEET,
		EQUIP_KIND_FEET,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)20,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_SLOW_BOOTS,
		ARMOR_KIND_SLOW_BOOTS,
		(rate_t)100, +0, FACE_MNR_ARMOR_FEET,
		EQUIP_KIND_FEET,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)0, (rate_t)0, (rate_t)10,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			| FLG_ITEM_ABL_MON
			| FLG_ITEM_ABL_HUN
			| FLG_ITEM_ABL_THI
			| FLG_ITEM_ABL_MAG
			| FLG_ITEM_ABL_SOR
			| FLG_ITEM_ABL_ENC
			| FLG_ITEM_ABL_SUM
			| FLG_ITEM_ABL_PRI
			| FLG_ITEM_ABL_SHA
			| FLG_ITEM_ABL_BAR
		),
		_100_PERCENT,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			-1, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_ARMOR_ROUND_SHIELD,
		ARMOR_KIND_ROUND_SHIELD,
		(rate_t)100, +0, FACE_MNR_ARMOR_SHIELD,
		EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)40, (rate_t)0, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_KITE_SHIELD,
		ARMOR_KIND_KITE_SHIELD,
		(rate_t)100, +0, FACE_MNR_ARMOR_SHIELD,
		EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)70, (rate_t)0, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},

	{ NULL, N_MSG_ARMOR_HEATER_SHIELD,
		ARMOR_KIND_HEATER_SHIELD,
		(rate_t)100, +0, FACE_MNR_ARMOR_SHIELD,
		EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		(rate_t)100, (rate_t)0, (rate_t)0,
		1, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		(FLG_NULL
			| FLG_ITEM_ABL_FIG
			/* | FLG_ITEM_ABL_MON */
			| FLG_ITEM_ABL_HUN
			/* | FLG_ITEM_ABL_THI */
			/* | FLG_ITEM_ABL_MAG */
			/* | FLG_ITEM_ABL_SOR */
			/* | FLG_ITEM_ABL_ENC */
			/* | FLG_ITEM_ABL_SUM */
			| FLG_ITEM_ABL_PRI
			/* | FLG_ITEM_ABL_SHA */
			| FLG_ITEM_ABL_BAR
		),
		CURSE_ITEM_RATE,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
/**/
	{ NULL, N_MSG_NULL,
		ARMOR_KIND_NULL,
		100, +0, FACE_MNR_NULL,
		EQUIP_KIND_HEAD,
		{ 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		(rate_t)0, (rate_t)0, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0, (rate_t)0,
		FLG_NULL,
		(rate_t)0,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, 0,
		},
	},
};

potion_tab_t	potion_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	potion_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	*color;
	n_msg_t	color_n;
	bool_t	flg_identified;
	bool_t	flg_change_color;
} potion_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		POTION_KIND_NULL, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0, 
		NULL, N_MSG_NULL,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_WATER,
		POTION_KIND_WATER, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_CRYSTAL,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_MILK,
		POTION_KIND_MILK, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_MILK,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RED_WINE,
		POTION_KIND_RED_WINE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_RED_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_WHITE_WINE,
		POTION_KIND_WHITE_WINE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_WHITE_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ROSE_WINE,
		POTION_KIND_ROSE_WINE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ROSE_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ALE,
		POTION_KIND_ALE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ALE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_BRANDY,
		POTION_KIND_BRANDY, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_BRANDY,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RUM,
		POTION_KIND_RUM, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_RUM,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_COFFE,
		POTION_KIND_COFFE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_COFFE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_COFFE,
		POTION_KIND_ICE_COFFE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ICE_COFFE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_TEA,
		POTION_KIND_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_MILK_TEA,
		POTION_KIND_MILK_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_MILK_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_LEMON_TEA,
		POTION_KIND_LEMON_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_LEMON_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_TEA,
		POTION_KIND_ICE_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ICE_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_MILK_TEA,
		POTION_KIND_ICE_MILK_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ICE_MILK_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_LEMON_TEA,
		POTION_KIND_ICE_LEMON_TEA, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ICE_LEMON_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_APPLE_JUICE,
		POTION_KIND_APPLE_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_APPLE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_GRAPE_JUICE,
		POTION_KIND_GRAPE_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_GRAPE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ORANGE_JUICE,
		POTION_KIND_ORANGE_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_ORANGE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_BLACK_BERRY_JUICE,
		POTION_KIND_BLACK_BERRY_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_BLACK_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_CRAN_BERRY_JUICE,
		POTION_KIND_CRAN_BERRY_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_CRAN_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RASP_BERRY_JUICE,
		POTION_KIND_RASP_BERRY_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_RASP_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_STRAW_BERRY_JUICE,
		POTION_KIND_STRAW_BERRY_JUICE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_STRAW_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_OIL,
		POTION_KIND_OIL, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_POTION_COLOR_CRYSTAL_YELLOW,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_STONE,
		POTION_KIND_STONE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_PARALYZE,
		POTION_KIND_PARALYZE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_POISON,
		POTION_KIND_POISON, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CONFUSION,
		POTION_KIND_CONFUSION, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_BLIND,
		POTION_KIND_BLIND, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SLEEP,
		POTION_KIND_SLEEP, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SILENCE,
		POTION_KIND_SILENCE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_FEAR,
		POTION_KIND_FEAR, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_HALLUCINATION,
		POTION_KIND_HALLUCINATION, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CHARM,
		POTION_KIND_CHARM, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_LEV,
		POTION_KIND_CURE_LEV, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_LIGHT,
		POTION_KIND_CURE_HP_LIGHT, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_MODERATE,
		POTION_KIND_CURE_HP_MODERATE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_SERIOUS,
		POTION_KIND_CURE_HP_SERIOUS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_MAX,
		POTION_KIND_CURE_HP_MAX, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_POISON,
		POTION_KIND_CURE_POISON, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_STATUS,
		POTION_KIND_CURE_STATUS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_DETECT_MNSTR,
		POTION_KIND_DETECT_MNSTR, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_DULLNESS,
		POTION_KIND_DULLNESS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_FLY,
		POTION_KIND_FLY, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_POW_UP_HP,
		POTION_KIND_POW_UP_HP, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SPEED_UP,
		POTION_KIND_SPEED_UP, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SPEED_DOWN,
		POTION_KIND_SPEED_DOWN, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_QUICKNESS,
		POTION_KIND_QUICKNESS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_PHYS,
		POTION_KIND_RESI_PHYS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_HEAT,
		POTION_KIND_RESI_HEAT, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_COLD,
		POTION_KIND_RESI_COLD, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_ACID,
		POTION_KIND_RESI_ACID, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_MIND,
		POTION_KIND_RESI_MIND, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_ELEC,
		POTION_KIND_RESI_ELEC, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_POIS,
		POTION_KIND_RESI_POIS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SENSE_INVISIBLE,
		POTION_KIND_SENSE_INVISIBLE, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SHARPNESS,
		POTION_KIND_SHARPNESS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SLOWNESS,
		POTION_KIND_SLOWNESS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_STRENGTH,
		POTION_KIND_STRENGTH, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_VANISH,
		POTION_KIND_VANISH, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_WEAKNESS,
		POTION_KIND_WEAKNESS, (rate_t)80,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_NULL,
		POTION_KIND_NULL, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE,
		0, NULL, N_MSG_NULL,
		FALSE, FALSE },
};

long	color_tab_max_n;
color_tab_t	color_tab[] = {
	{ N_MSG_POTION_COLOR_CRYSTAL, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_PINK, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_RED, FALSE },
	{ N_MSG_POTION_COLOR_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_PINK, FALSE },
	{ N_MSG_POTION_COLOR_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_PINK, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_RED, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_PINK, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_MILK, FALSE },
	{ N_MSG_POTION_COLOR_RED_WINE, FALSE },
	{ N_MSG_POTION_COLOR_WHITE_WINE, FALSE },
	{ N_MSG_POTION_COLOR_ROSE_WINE, FALSE },
	{ N_MSG_POTION_COLOR_ALE, FALSE },
	{ N_MSG_POTION_COLOR_BRANDY, FALSE },
	{ N_MSG_POTION_COLOR_RUM, FALSE },
	{ N_MSG_POTION_COLOR_COFFE, FALSE },
	{ N_MSG_POTION_COLOR_ICE_COFFE, FALSE },
	{ N_MSG_POTION_COLOR_TEA, FALSE },
	{ N_MSG_POTION_COLOR_MILK_TEA, FALSE },
	{ N_MSG_POTION_COLOR_LEMON_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_MILK_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_LEMON_TEA, FALSE },
	{ N_MSG_POTION_COLOR_APPLE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_GRAPE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_ORANGE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_BLACK_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_CRAN_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_RASP_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_STRAW_BERRY_JUICE, FALSE },
	{ N_MSG_NULL, FALSE },
};

scroll_tab_t	scroll_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	scroll_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	ttl[SCROLL_TTL_MAX_LEN + 1];
	bool_t	flg_identified;
} scroll_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		SCROLL_KIND_NULL,
		(rate_t)0, DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_SLEEP,
		SCROLL_KIND_SLEEP,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_IDENTIFY_ITEM,
		SCROLL_KIND_IDENTIFY_ITEM,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_DETECT_ITEM,
		SCROLL_KIND_DETECT_ITEM,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_TELEPORT,
		SCROLL_KIND_TELEPORT,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_WPN_HIT,
		SCROLL_KIND_POW_UP_WPN_HIT,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_WPN_CRTCL,
		SCROLL_KIND_POW_UP_WPN_CRTCL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_WPN_DAM,
		SCROLL_KIND_POW_UP_WPN_DAM,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_ARMOR_DEF,
		SCROLL_KIND_POW_UP_ARMOR_DEF,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_ARMOR_CRTCL,
		SCROLL_KIND_POW_UP_ARMOR_CRTCL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_ARMOR_AC,
		SCROLL_KIND_POW_UP_ARMOR_AC,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_PROTECT_ARMOR,
		SCROLL_KIND_PROTECT_ARMOR,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_REMOVE_CURSE,
		SCROLL_KIND_REMOVE_CURSE,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_SCROLL_RECALL,
		SCROLL_KIND_RECALL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		"", FALSE },

	{ NULL, N_MSG_NULL,
		SCROLL_KIND_NULL,
		(rate_t)0, DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		"", FALSE },
};

long	ttl_syllable_tab_max_n;
ttl_syllable_tab_t	ttl_syllable_tab[] = {
	N_MSG_SCROLL_TTL_SYLLABLE_000,
	N_MSG_SCROLL_TTL_SYLLABLE_001,
	N_MSG_SCROLL_TTL_SYLLABLE_002,
	N_MSG_SCROLL_TTL_SYLLABLE_010,
	N_MSG_SCROLL_TTL_SYLLABLE_011,
	N_MSG_SCROLL_TTL_SYLLABLE_012,
	N_MSG_SCROLL_TTL_SYLLABLE_013,
	N_MSG_SCROLL_TTL_SYLLABLE_020,
	N_MSG_SCROLL_TTL_SYLLABLE_021,
	N_MSG_SCROLL_TTL_SYLLABLE_030,
	N_MSG_SCROLL_TTL_SYLLABLE_031,
	N_MSG_SCROLL_TTL_SYLLABLE_032,
	N_MSG_SCROLL_TTL_SYLLABLE_040,
	N_MSG_SCROLL_TTL_SYLLABLE_041,
	N_MSG_SCROLL_TTL_SYLLABLE_042,
	N_MSG_SCROLL_TTL_SYLLABLE_050,
	N_MSG_SCROLL_TTL_SYLLABLE_051,
	N_MSG_SCROLL_TTL_SYLLABLE_052,
	N_MSG_SCROLL_TTL_SYLLABLE_060,
	N_MSG_SCROLL_TTL_SYLLABLE_061,
	N_MSG_SCROLL_TTL_SYLLABLE_070,
	N_MSG_SCROLL_TTL_SYLLABLE_071,
	N_MSG_SCROLL_TTL_SYLLABLE_072,
	N_MSG_SCROLL_TTL_SYLLABLE_080,
	N_MSG_SCROLL_TTL_SYLLABLE_081,
	N_MSG_SCROLL_TTL_SYLLABLE_082,
	N_MSG_SCROLL_TTL_SYLLABLE_090,
	N_MSG_SCROLL_TTL_SYLLABLE_091,
	N_MSG_SCROLL_TTL_SYLLABLE_092,
	N_MSG_SCROLL_TTL_SYLLABLE_101,
	N_MSG_SCROLL_TTL_SYLLABLE_102,
	N_MSG_SCROLL_TTL_SYLLABLE_103,
	N_MSG_SCROLL_TTL_SYLLABLE_104,
	N_MSG_SCROLL_TTL_SYLLABLE_110,
	N_MSG_SCROLL_TTL_SYLLABLE_111,
	N_MSG_SCROLL_TTL_SYLLABLE_120,
	N_MSG_SCROLL_TTL_SYLLABLE_121,
	N_MSG_SCROLL_TTL_SYLLABLE_130,
	N_MSG_SCROLL_TTL_SYLLABLE_131,
	N_MSG_NULL,
};

stick_tab_t	stick_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;
	long	use_n;
	wand_kind_t	wand_kind;
	staff_kind_t	staff_kind;
	long	min_lev, max_lev, sgn_lev;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
} stick_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, (rate_t)0, 0,
		STICK_KIND_NULL, SPELL_KIND_NULL,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		NULL, N_MSG_NULL, FALSE },
/* wand */
	{ NULL, N_MSG_SPELL_NOTHING, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_STONE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_POISON,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_WISE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, (rate_t)80, 16,
		STICK_KIND_WAND, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },
/* rod */
	{ NULL, N_MSG_SPELL_NOTHING, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_STONE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_POISON,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_WISE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, (rate_t)80, 12,
		STICK_KIND_ROD, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },
/* staff */
	{ NULL, N_MSG_SPELL_NOTHING, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_STONE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_POISON,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_WISE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, (rate_t)80, 8,
		STICK_KIND_STAFF, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV_BASE, -1,
		NULL, N_MSG_NULL, FALSE },
/* end */
	{ NULL, N_MSG_NULL, (rate_t)0, 0,
		STICK_KIND_NULL, SPELL_KIND_NULL,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		NULL, N_MSG_NULL, FALSE },
};

long	wand_material_tab_max_n;
material_tab_t	wand_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	rod_material_tab_max_n;
material_tab_t	rod_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	staff_material_tab_max_n;
material_tab_t	staff_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

acce_tab_t	acce_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	acce_kind_t	kind;
	ring_kind_t	ring_kind;
	amulet_kind_t	amulet_kind;
	necklace_kind_t	necklace_kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	mnr;
	equip_kind_t	equip_kind;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
	rate_t	rate_curse;
	modifier_t	modifier;
} acce_tab_t;

typedef struct {
	char	face_mjr, face_mnr;
	sex_t	sex;
	rate_t	armor_def, armor_crtcl, armor_ac;
	long	add_lev[ABL_KIND_MAX_N];
	long	add_resi_n[RESI_KIND_MAX_N];
	long	add_move_speed;
	long	stomach_digest_n;
	long	teleport_n, teleport_party_n;
	rate_t	bless;
} modifier_t;
#endif

/**/
	{
		NULL, N_MSG_ITEM_UNKNOWN,
		ACCE_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)0, DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		FACE_MNR_NULL,
		EQUIP_KIND_MAX_N, NULL, N_MSG_NULL, FALSE, (rate_t)0,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_SLOW_DIGESTION,
		ACCE_KIND_RING,
		RING_KIND_SLOW_DIGESTION,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, -2, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_TELEPORT_PARTY,
		ACCE_KIND_RING,
		RING_KIND_TELEPORT_PARTY,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, +1, 0, +1, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_TELEPORT,
		ACCE_KIND_RING,
		RING_KIND_TELEPORT,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, +1, +1, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_SHARPNESS,
		ACCE_KIND_RING,
		RING_KIND_SHARPNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				+1, 0, 0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_DULLNESS,
		ACCE_KIND_RING,
		RING_KIND_DULLNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				-1, 0, 0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_STRENGTH,
		ACCE_KIND_RING,
		RING_KIND_STRENGTH,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, +1, 0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_WEAKNESS,
		ACCE_KIND_RING,
		RING_KIND_WEAKNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, -1, 0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_QUICKNESS,
		ACCE_KIND_RING,
		RING_KIND_QUICKNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, +1, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_SLOWNESS,
		ACCE_KIND_RING,
		RING_KIND_SLOWNESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, -1, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_WISE,
		ACCE_KIND_RING,
		RING_KIND_WISE,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, +1, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_FOOLISH,
		ACCE_KIND_RING,
		RING_KIND_FOOLISH,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, -1, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_BRAINY,
		ACCE_KIND_RING,
		RING_KIND_BRAINY,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, 0, +1, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_BRAINLESS,
		ACCE_KIND_RING,
		RING_KIND_BRAINLESS,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, 0, -1, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_ATTRACTIVE,
		ACCE_KIND_RING,
		RING_KIND_ATTRACTIVE,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, 0, 0, +1,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_RING_UNATTRACTIVE,
		ACCE_KIND_RING,
		RING_KIND_UNATTRACTIVE,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, (rate_t)90,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0,
			{
				0, 0,
				0, 0, 0, 0, 0, -1,
				0, 0, 0, 0,
				0, 0, 0, 0,
				0, 0, 0, 0,
			},
			ADD_RESI_N_ALL_0,
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_PHYS,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_PHYS,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ +1, +1, +1, 0, 0, 0, 0, 0, 0, },
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_HEAT,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_HEAT,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, +3, 0, 0, 0, 0, 0, },
			0, +1, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_COLD,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_COLD,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, 0, +3, 0, 0, 0, 0, },
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_ACID,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_ACID,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, 0, 0, 0, +3, 0, 0, },
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_MIND,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_MIND,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, 0, 0, +3, 0, 0, 0, },
			0, +1, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_ELEC,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_ELEC,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, 0, 0, 0, 0, +3, 0, },
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_AMULET_RESI_POIS,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_POIS,
		NECKLACE_KIND_NULL,
		(rate_t)80, 1, DUN_MAX_LEV_BASE, -1,
		FACE_MNR_AMULET,
		EQUIP_KIND_NECK, NULL, N_MSG_NULL, FALSE, (rate_t)10,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0,
			{ 0, 0, 0, 0, 0, 0, 0, 0, +3, },
			0, +1, 0, 0, (rate_t)0,
		},
	},
	{
		NULL, N_MSG_NULL,
		ACCE_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		(rate_t)0, DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		FACE_MNR_NULL,
		EQUIP_KIND_MAX_N, NULL, N_MSG_NULL, FALSE, (rate_t)0,
		{
			FACE_MJR_NULL, FACE_MNR_NULL, SEX_NULL,
			ARMOR_ALL_0, ADD_LEV_ALL_0, ADD_RESI_N_ALL_0,
			0, 0, 0, 0, (rate_t)0,
		},
	},
};

long	ring_material_tab_max_n;
ring_material_tab_t	ring_material_tab[] = {
	{ N_MSG_ACCE_MATERIAL_BONE, FALSE },
	{ N_MSG_ACCE_MATERIAL_GOLD, FALSE },
	{ N_MSG_ACCE_MATERIAL_SILVER, FALSE },
	{ N_MSG_ACCE_GEM_AMBER, FALSE },
	{ N_MSG_ACCE_GEM_AGATE, FALSE },
	{ N_MSG_ACCE_GEM_ALEXANDRITE, FALSE },
	{ N_MSG_ACCE_GEM_AMETHYST, FALSE },
	{ N_MSG_ACCE_GEM_ANTLERITE, FALSE },
	{ N_MSG_ACCE_GEM_AQUAMARINE, FALSE },
	{ N_MSG_ACCE_GEM_ARGENTITE, FALSE },
	{ N_MSG_ACCE_GEM_AZURITE, FALSE },
	{ N_MSG_ACCE_GEM_BERYL, FALSE },
	{ N_MSG_ACCE_GEM_BLOODSTONE, FALSE },
	{ N_MSG_ACCE_GEM_CALCITE, FALSE },
	{ N_MSG_ACCE_GEM_CARNELIAN, FALSE },
	{ N_MSG_ACCE_GEM_CORAL, FALSE },
	{ N_MSG_ACCE_GEM_CORUNDUM, FALSE },
	{ N_MSG_ACCE_GEM_CRYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_DIAMOND, FALSE },
	{ N_MSG_ACCE_GEM_DIORITE, FALSE },
	{ N_MSG_ACCE_GEM_EMERALD, FALSE },
	{ N_MSG_ACCE_GEM_FLINT, FALSE },
	{ N_MSG_ACCE_GEM_FLUORITE, FALSE },
	{ N_MSG_ACCE_GEM_GABBRO, FALSE },
	{ N_MSG_ACCE_GEM_GARNET, FALSE },
	{ N_MSG_ACCE_GEM_GRANITE, FALSE },
	{ N_MSG_ACCE_GEM_GYPSUM, FALSE },
	{ N_MSG_ACCE_GEM_HEMATITE, FALSE },
	{ N_MSG_ACCE_GEM_JADE, FALSE },
	{ N_MSG_ACCE_GEM_JASPER, FALSE },
	{ N_MSG_ACCE_GEM_KRYPTONITE, FALSE },
	{ N_MSG_ACCE_GEM_LAPIS_LAZULI, FALSE },
	{ N_MSG_ACCE_GEM_LIMESTONE, FALSE },
	{ N_MSG_ACCE_GEM_MALACHITE, FALSE },
	{ N_MSG_ACCE_GEM_MANGANITE, FALSE },
	{ N_MSG_ACCE_GEM_MARBLE, FALSE },
	{ N_MSG_ACCE_GEM_MOONSTONE, FALSE },
	{ N_MSG_ACCE_GEM_NEPTUNITE, FALSE },
	{ N_MSG_ACCE_GEM_OBSIDIAN, FALSE },
	{ N_MSG_ACCE_GEM_ONYX, FALSE },
	{ N_MSG_ACCE_GEM_OPAL, FALSE },
	{ N_MSG_ACCE_GEM_PEARL, FALSE },
	{ N_MSG_ACCE_GEM_PYRITES, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZ, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZITE, FALSE },
	{ N_MSG_ACCE_GEM_RHODONITE, FALSE },
	{ N_MSG_ACCE_GEM_RHYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_RUBY, FALSE },
	{ N_MSG_ACCE_GEM_SAPPHIRE, FALSE },
	{ N_MSG_ACCE_GEM_SPHALERITE, FALSE },
	{ N_MSG_ACCE_GEM_STAUROLITE, FALSE },
	{ N_MSG_ACCE_GEM_TIGER_EYE, FALSE },
	{ N_MSG_ACCE_GEM_TOPAZ, FALSE },
	{ N_MSG_ACCE_GEM_TURQUOISE, FALSE },
	{ N_MSG_ACCE_GEM_ZIRCON, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	amulet_material_tab_max_n;
amulet_material_tab_t	amulet_material_tab[] = {
	{ N_MSG_ACCE_MATERIAL_BONE, FALSE },
	{ N_MSG_ACCE_MATERIAL_GOLD, FALSE },
	{ N_MSG_ACCE_MATERIAL_SILVER, FALSE },
	{ N_MSG_ACCE_GEM_AMBER, FALSE },
	{ N_MSG_ACCE_GEM_AGATE, FALSE },
	{ N_MSG_ACCE_GEM_ALEXANDRITE, FALSE },
	{ N_MSG_ACCE_GEM_AMETHYST, FALSE },
	{ N_MSG_ACCE_GEM_ANTLERITE, FALSE },
	{ N_MSG_ACCE_GEM_AQUAMARINE, FALSE },
	{ N_MSG_ACCE_GEM_ARGENTITE, FALSE },
	{ N_MSG_ACCE_GEM_AZURITE, FALSE },
	{ N_MSG_ACCE_GEM_BERYL, FALSE },
	{ N_MSG_ACCE_GEM_BLOODSTONE, FALSE },
	{ N_MSG_ACCE_GEM_CALCITE, FALSE },
	{ N_MSG_ACCE_GEM_CARNELIAN, FALSE },
	{ N_MSG_ACCE_GEM_CORAL, FALSE },
	{ N_MSG_ACCE_GEM_CORUNDUM, FALSE },
	{ N_MSG_ACCE_GEM_CRYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_DIAMOND, FALSE },
	{ N_MSG_ACCE_GEM_DIORITE, FALSE },
	{ N_MSG_ACCE_GEM_EMERALD, FALSE },
	{ N_MSG_ACCE_GEM_FLINT, FALSE },
	{ N_MSG_ACCE_GEM_FLUORITE, FALSE },
	{ N_MSG_ACCE_GEM_GABBRO, FALSE },
	{ N_MSG_ACCE_GEM_GARNET, FALSE },
	{ N_MSG_ACCE_GEM_GRANITE, FALSE },
	{ N_MSG_ACCE_GEM_GYPSUM, FALSE },
	{ N_MSG_ACCE_GEM_HEMATITE, FALSE },
	{ N_MSG_ACCE_GEM_JADE, FALSE },
	{ N_MSG_ACCE_GEM_JASPER, FALSE },
	{ N_MSG_ACCE_GEM_KRYPTONITE, FALSE },
	{ N_MSG_ACCE_GEM_LAPIS_LAZULI, FALSE },
	{ N_MSG_ACCE_GEM_LIMESTONE, FALSE },
	{ N_MSG_ACCE_GEM_MALACHITE, FALSE },
	{ N_MSG_ACCE_GEM_MANGANITE, FALSE },
	{ N_MSG_ACCE_GEM_MARBLE, FALSE },
	{ N_MSG_ACCE_GEM_MOONSTONE, FALSE },
	{ N_MSG_ACCE_GEM_NEPTUNITE, FALSE },
	{ N_MSG_ACCE_GEM_OBSIDIAN, FALSE },
	{ N_MSG_ACCE_GEM_ONYX, FALSE },
	{ N_MSG_ACCE_GEM_OPAL, FALSE },
	{ N_MSG_ACCE_GEM_PEARL, FALSE },
	{ N_MSG_ACCE_GEM_PYRITES, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZ, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZITE, FALSE },
	{ N_MSG_ACCE_GEM_RHODONITE, FALSE },
	{ N_MSG_ACCE_GEM_RHYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_RUBY, FALSE },
	{ N_MSG_ACCE_GEM_SAPPHIRE, FALSE },
	{ N_MSG_ACCE_GEM_SPHALERITE, FALSE },
	{ N_MSG_ACCE_GEM_STAUROLITE, FALSE },
	{ N_MSG_ACCE_GEM_TIGER_EYE, FALSE },
	{ N_MSG_ACCE_GEM_TOPAZ, FALSE },
	{ N_MSG_ACCE_GEM_TURQUOISE, FALSE },
	{ N_MSG_ACCE_GEM_ZIRCON, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	necklace_material_tab_max_n;
necklace_material_tab_t	necklace_material_tab[] = {
	{ N_MSG_ACCE_MATERIAL_BONE, FALSE },
	{ N_MSG_ACCE_MATERIAL_GOLD, FALSE },
	{ N_MSG_ACCE_MATERIAL_SILVER, FALSE },
	{ N_MSG_ACCE_GEM_AMBER, FALSE },
	{ N_MSG_ACCE_GEM_AGATE, FALSE },
	{ N_MSG_ACCE_GEM_ALEXANDRITE, FALSE },
	{ N_MSG_ACCE_GEM_AMETHYST, FALSE },
	{ N_MSG_ACCE_GEM_ANTLERITE, FALSE },
	{ N_MSG_ACCE_GEM_AQUAMARINE, FALSE },
	{ N_MSG_ACCE_GEM_ARGENTITE, FALSE },
	{ N_MSG_ACCE_GEM_AZURITE, FALSE },
	{ N_MSG_ACCE_GEM_BERYL, FALSE },
	{ N_MSG_ACCE_GEM_BLOODSTONE, FALSE },
	{ N_MSG_ACCE_GEM_CALCITE, FALSE },
	{ N_MSG_ACCE_GEM_CARNELIAN, FALSE },
	{ N_MSG_ACCE_GEM_CORAL, FALSE },
	{ N_MSG_ACCE_GEM_CORUNDUM, FALSE },
	{ N_MSG_ACCE_GEM_CRYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_DIAMOND, FALSE },
	{ N_MSG_ACCE_GEM_DIORITE, FALSE },
	{ N_MSG_ACCE_GEM_EMERALD, FALSE },
	{ N_MSG_ACCE_GEM_FLINT, FALSE },
	{ N_MSG_ACCE_GEM_FLUORITE, FALSE },
	{ N_MSG_ACCE_GEM_GABBRO, FALSE },
	{ N_MSG_ACCE_GEM_GARNET, FALSE },
	{ N_MSG_ACCE_GEM_GRANITE, FALSE },
	{ N_MSG_ACCE_GEM_GYPSUM, FALSE },
	{ N_MSG_ACCE_GEM_HEMATITE, FALSE },
	{ N_MSG_ACCE_GEM_JADE, FALSE },
	{ N_MSG_ACCE_GEM_JASPER, FALSE },
	{ N_MSG_ACCE_GEM_KRYPTONITE, FALSE },
	{ N_MSG_ACCE_GEM_LAPIS_LAZULI, FALSE },
	{ N_MSG_ACCE_GEM_LIMESTONE, FALSE },
	{ N_MSG_ACCE_GEM_MALACHITE, FALSE },
	{ N_MSG_ACCE_GEM_MANGANITE, FALSE },
	{ N_MSG_ACCE_GEM_MARBLE, FALSE },
	{ N_MSG_ACCE_GEM_MOONSTONE, FALSE },
	{ N_MSG_ACCE_GEM_NEPTUNITE, FALSE },
	{ N_MSG_ACCE_GEM_OBSIDIAN, FALSE },
	{ N_MSG_ACCE_GEM_ONYX, FALSE },
	{ N_MSG_ACCE_GEM_OPAL, FALSE },
	{ N_MSG_ACCE_GEM_PEARL, FALSE },
	{ N_MSG_ACCE_GEM_PYRITES, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZ, FALSE },
	{ N_MSG_ACCE_GEM_QUARTZITE, FALSE },
	{ N_MSG_ACCE_GEM_RHODONITE, FALSE },
	{ N_MSG_ACCE_GEM_RHYOLITE, FALSE },
	{ N_MSG_ACCE_GEM_RUBY, FALSE },
	{ N_MSG_ACCE_GEM_SAPPHIRE, FALSE },
	{ N_MSG_ACCE_GEM_SPHALERITE, FALSE },
	{ N_MSG_ACCE_GEM_STAUROLITE, FALSE },
	{ N_MSG_ACCE_GEM_TIGER_EYE, FALSE },
	{ N_MSG_ACCE_GEM_TOPAZ, FALSE },
	{ N_MSG_ACCE_GEM_TURQUOISE, FALSE },
	{ N_MSG_ACCE_GEM_ZIRCON, FALSE },
	{ N_MSG_NULL, FALSE },
};

light_tab_t	light_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	light_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	long	max_turn;
	bool_t	flg_fill;
} light_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, LIGHT_KIND_NULL, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		0, 0 },

	{ NULL, N_MSG_LIGHT_TORCH, LIGHT_KIND_TORCH, (rate_t)80,
		0, DUN_MAX_LEV_BASE, -1,
		LIGHT_MAX_TURN_TORCH, FALSE },

	{ NULL, N_MSG_LIGHT_LANTERN, LIGHT_KIND_LANTERN, (rate_t)80,
		0, DUN_MAX_LEV_BASE, -1,
		LIGHT_MAX_TURN_LANTERN, TRUE },

	{ NULL, N_MSG_LIGHT_LAMP, LIGHT_KIND_LAMP, (rate_t)80,
		0, DUN_MAX_LEV_BASE, -1,
		LIGHT_MAX_TURN_LAMP, TRUE },

	{ NULL, N_MSG_NULL, LIGHT_KIND_NULL, (rate_t)0,
		DUN_MAX_LEV_BASE, DUN_MAX_LEV_BASE, 0,
		0, 0 },
};

food_tab_t	food_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	food_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	rate_t	fill_rate;
} food_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, FOOD_KIND_NULL,
		(rate_t)0, 0, (rate_t)0 },

	{ NULL, N_MSG_FOOD_PRESERVED, FOOD_KIND_PRESERVED,
		(rate_t)80, 1, (rate_t)50 },

	{ NULL, N_MSG_FOOD_SAUSAGE, FOOD_KIND_SAUSAGE,
		(rate_t)80, 3, (rate_t)20 },

	{ NULL, N_MSG_FOOD_BACON, FOOD_KIND_BACON,
		(rate_t)80, 3, (rate_t)20 },

	{ NULL, N_MSG_FOOD_CHIPPED_BEEF, FOOD_KIND_CHIPPED_BEEF,
		(rate_t)80, 3, (rate_t)20 },

	{ NULL, N_MSG_FOOD_CORNED_BEEF, FOOD_KIND_CORNED_BEEF,
		(rate_t)80, 3, (rate_t)20 },

	{ NULL, N_MSG_FOOD_BREAD, FOOD_KIND_BREAD,
		(rate_t)80, 2, (rate_t)20 },

	{ NULL, N_MSG_FOOD_BROWN_BREAD, FOOD_KIND_BROWN_BREAD,
		(rate_t)80, 2, (rate_t)20 },

	{ NULL, N_MSG_FOOD_TOAST, FOOD_KIND_TOAST,
		(rate_t)10, 2, (rate_t)20 },

	{ NULL, N_MSG_FOOD_PANCAKE, FOOD_KIND_PANCAKE,
		(rate_t)80, 2, (rate_t)30 },

	{ NULL, N_MSG_FOOD_SALAD, FOOD_KIND_SALAD,
		(rate_t)10, 2, (rate_t)20 },

	{ NULL, N_MSG_FOOD_POTATO_SALAD, FOOD_KIND_POTATO_SALAD,
		(rate_t)10, 2, (rate_t)20 },

	{ NULL, N_MSG_FOOD_SCRAMBLED_EGGS, FOOD_KIND_SCRAMBLED_EGGS,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_FRIED_EGGS, FOOD_KIND_FRIED_EGGS,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_HARD_BOILED_EGGS, FOOD_KIND_HARD_BOILED_EGGS,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_SOFT_BOILED_EGGS, FOOD_KIND_SOFT_BOILED_EGGS,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_BEEF_STEAK, FOOD_KIND_BEEF_STEAK,
		(rate_t)10, 2, (rate_t)50 },

	{ NULL, N_MSG_FOOD_PORK_SAUTE, FOOD_KIND_PORK_SAUTE,
		(rate_t)10, 2, (rate_t)50 },

	{ NULL, N_MSG_FOOD_FRIED_CHICKEN, FOOD_KIND_FRIED_CHICKEN,
		(rate_t)10, 2, (rate_t)40 },

	{ NULL, N_MSG_FOOD_FRIED_FISH, FOOD_KIND_FRIED_FISH,
		(rate_t)10, 2, (rate_t)30 },

	{ NULL, N_MSG_FOOD_FRIED_POTATO, FOOD_KIND_FRIED_POTATO,
		(rate_t)10, 2, (rate_t)30 },

	{ NULL, N_MSG_FOOD_STEWED_BEEF, FOOD_KIND_STEWED_BEEF,
		(rate_t)10, 2, (rate_t)50 },

	{ NULL, N_MSG_FOOD_CONSOMME, FOOD_KIND_CONSOMME,
		(rate_t)10, 2, (rate_t)30 },

	{ NULL, N_MSG_FOOD_POTAGE, FOOD_KIND_POTAGE,
		(rate_t)10, 2, (rate_t)40 },

	{ NULL, N_MSG_FOOD_APPLE_PIE, FOOD_KIND_APPLE_PIE,
		(rate_t)10, 2, (rate_t)30 },

	{ NULL, N_MSG_FOOD_APPLE, FOOD_KIND_APPLE,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_GRAPE, FOOD_KIND_GRAPE,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_ORANGE, FOOD_KIND_ORANGE,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_PEAR, FOOD_KIND_PEAR,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_GRAPEFRUIT, FOOD_KIND_GRAPEFRUIT,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_PLUM, FOOD_KIND_PLUM,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_PEACH, FOOD_KIND_PEACH,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_APRICOT, FOOD_KIND_APRICOT,
		(rate_t)10, 2, (rate_t)10 },

	{ NULL, N_MSG_FOOD_BLACK_BERRY, FOOD_KIND_BLACK_BERRY,
		(rate_t)10, 6, (rate_t)10 },

	{ NULL, N_MSG_FOOD_CRAN_BERRY, FOOD_KIND_CRAN_BERRY,
		(rate_t)10, 6, (rate_t)10 },

	{ NULL, N_MSG_FOOD_RASP_BERRY, FOOD_KIND_RASP_BERRY,
		(rate_t)10, 6, (rate_t)10 },

	{ NULL, N_MSG_FOOD_STRAW_BERRY, FOOD_KIND_STRAW_BERRY,
		(rate_t)10, 6, (rate_t)10 },

	{ NULL, N_MSG_NULL, FOOD_KIND_NULL,
		(rate_t)0, 0, (rate_t)0 },
};

#define	TOBACCO_PRICE_CIGARET	((gold_t)2)
#define	TOBACCO_PRICE_CIGAR	((gold_t)10)
#define	TOBACCO_PRICE_CUT_TOBACCO	((gold_t)2)
#define	TOBACCO_PRICE_SNUFF_TOBACCO	((gold_t)3)
#define	TOBACCO_PRICE_CHEWING_TOBACCO	((gold_t)4)
#define	TOBACCO_PRICE_ABSTAIN_GUM	((gold_t)8)

# define	TOBACCO_AVE_TURN_CIGARET	(5 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CIGAR	(10 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CUT_TOBACCO	(5 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_SNUFF_TOBACCO	(10 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CHEWING_TOBACCO	(15 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_ABSTAIN_GUM	(15 * TURN_PER_MINUTE)

#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	tobacco_kind_t	kind;
	char	*brand_name;
	n_msg_t	brand_name_n;
	tobacco_brand_t	brand;
	rate_t	rate;
	long	ave_n;
	long	turn;
	gold_t	price;
	flg_tobacco_t	flg;
} tobacco_tab_t;
#endif

tobacco_tab_t	tobacco_tab[] = {
	{ NULL, N_MSG_ITEM_UNKNOWN, TOBACCO_KIND_NULL,
		NULL, N_MSG_NULL,
		TOBACCO_BRAND_NULL,
		(rate_t)0, 0, 0,
		((gold_t)0), FLG_NULL },
/* CIGARET */
	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HELLO,
		TOBACCO_BRAND_HELLO,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_SUN_SHINE,
		TOBACCO_BRAND_SUN_SHINE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CHERRY_TREE,
		TOBACCO_BRAND_CHERRY_TREE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_GOLDEN_RAT,
		TOBACCO_BRAND_GOLDEN_RAT,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_AIR_SHIT,
		TOBACCO_BRAND_AIR_SHIT,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HOP,
		TOBACCO_BRAND_HOP,
		(rate_t)80, 10, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_PIECE,
		TOBACCO_BRAND_PIECE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HARPY,
		TOBACCO_BRAND_HARPY,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HIGH_LIGHT,
		TOBACCO_BRAND_HIGH_LIGHT,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_SHOOTING_STARS,
		TOBACCO_BRAND_SHOOTING_STARS,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_WILD_NINE,
		TOBACCO_BRAND_WILD_NINE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_WILD_NINE_MENTHOL,
		TOBACCO_BRAND_WILD_NINE_MENTHOL,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_LODGE,
		TOBACCO_BRAND_LODGE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_LODGE_MENTHOL,
		TOBACCO_BRAND_LODGE_MENTHOL,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CANCER,
		TOBACCO_BRAND_CANCER,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CANCER_MENTHOL,
		TOBACCO_BRAND_CANCER_MENTHOL,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_FRONT_LINE,
		TOBACCO_BRAND_FRONT_LINE,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_MARCO_POLO,
		TOBACCO_BRAND_MARCO_POLO,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CAMELLIA,
		TOBACCO_BRAND_CAMELLIA,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_GOOD_LUCK,
		TOBACCO_BRAND_GOOD_LUCK,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_BAD_GUY,
		TOBACCO_BRAND_BAD_GUY,
		(rate_t)80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },
/* CIGAR */
	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_ARCADIA,
		TOBACCO_BRAND_ARCADIA,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_GLORIA,
		TOBACCO_BRAND_GLORIA,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_VULCAN,
		TOBACCO_BRAND_VULCAN,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_PONY,
		TOBACCO_BRAND_PONY,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_KEITH,
		TOBACCO_BRAND_KEITH,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_LUMBERJACK,
		TOBACCO_BRAND_LUMBERJACK,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 4, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_CORONA,
		TOBACCO_BRAND_CORONA,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 2, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_HALF_CORONA,
		TOBACCO_BRAND_HALF_CORONA,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 2, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_CRYSTAL,
		TOBACCO_BRAND_CRYSTAL,
		(rate_t)80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 4, FLG_NULL },
/* CUT TOBACCO */
	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_FOREST_BRANDY,
		TOBACCO_BRAND_FOREST_BRANDY,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_SILK_ROAD,
		TOBACCO_BRAND_SILK_ROAD,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_PROMENADE,
		TOBACCO_BRAND_PROMENADE,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_BIG_HORN,
		TOBACCO_BRAND_BIG_HORN,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROCKING_CHAIR,
		TOBACCO_BRAND_ROCKING_CHAIR,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_VANILLA,
		TOBACCO_BRAND_VANILLA,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_WILD_MANGO,
		TOBACCO_BRAND_WILD_MANGO,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_KENTUCKY_BIRD,
		TOBACCO_BRAND_KENTUCKY_BIRD,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ORIENT,
		TOBACCO_BRAND_ORIENT,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_FUJI,
		TOBACCO_BRAND_FUJI,
		(rate_t)80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },
/* SNUFF TOBACCO */
	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_APRICOT,
		TOBACCO_BRAND_DOGGY_APRICOT,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_WHISKY,
		TOBACCO_BRAND_DOGGY_WHISKY,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_HONEY,
		TOBACCO_BRAND_DOGGY_HONEY,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_SPEARMINT,
		TOBACCO_BRAND_DOGGY_SPEARMINT,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_PEPPERMINT,
		TOBACCO_BRAND_DOGGY_PEPPERMINT,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_VANILLA,
		TOBACCO_BRAND_DOGGY_VANILLA,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_MENTHOL,
		TOBACCO_BRAND_DOGGY_MENTHOL,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_CITRUS,
		TOBACCO_BRAND_DOGGY_CITRUS,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_SHERRY,
		TOBACCO_BRAND_DOGGY_SHERRY,
		(rate_t)50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },
/* CHEWING TOBACCO */
	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_PREMIUM,
		TOBACCO_BRAND_ROSE_PREMIUM,
		(rate_t)50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_VANILLA,
		TOBACCO_BRAND_ROSE_VANILLA,
		(rate_t)50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_MENTHOL,
		TOBACCO_BRAND_ROSE_MENTHOL,
		(rate_t)50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },
/* ABSTAIN GUM */
	{ NULL, N_MSG_TOBACCO_ABSTAIN_GUM, TOBACCO_KIND_ABSTAIN_GUM,
		NULL, N_MSG_TOBACCO_BRAND_NICOTIME,
		TOBACCO_BRAND_NICOTIME,
		(rate_t)50, 20, TOBACCO_AVE_TURN_ABSTAIN_GUM,
		TOBACCO_PRICE_ABSTAIN_GUM, FLG_NULL },
/* null */
	{ NULL, N_MSG_NULL, TOBACCO_KIND_NULL,
		NULL, N_MSG_NULL,
		TOBACCO_BRAND_NULL,
		(rate_t)0, 0, 0,
		((gold_t)0), FLG_NULL },
};

pipe_tab_t	pipe_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	pipe_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	long	consume_turn;
	tobacco_kind_t	tobacco_kind;
	gold_t	price;
	flg_pipe_t	flg;
} pipe_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, PIPE_KIND_NULL,
		(rate_t)0, 0, 0,
		TOBACCO_KIND_NULL,
		0, FLG_NULL },

	{ NULL, N_MSG_PIPE_PIPE, PIPE_KIND_PIPE,
		(rate_t)80, 1, 365 * TURN_A_DAY,
		TOBACCO_KIND_CUT_TOBACCO,
		500, FLG_NULL },

	{ NULL, N_MSG_PIPE_KISEL, PIPE_KIND_KISEL,
		(rate_t)80, 1, 365 * TURN_A_DAY,
		TOBACCO_KIND_CUT_TOBACCO,
		600, FLG_NULL },

	{ NULL, N_MSG_PIPE_CIGARET_HOLDER, PIPE_KIND_CIGARET_HOLDER,
		(rate_t)80, 20, (4 * 5 * TURN_PER_MINUTE),
		TOBACCO_KIND_CIGARET,
		2, FLG_PIPE_CONSUMPTION },

	{ NULL, N_MSG_NULL, PIPE_KIND_NULL,
		(rate_t)0, 0, 0,
		TOBACCO_KIND_NULL,
		0, FLG_NULL },
};

coin_tab_t	coin_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	coin_kind_t	kind;
	char	mnr;
	rate_t	rate;
	long	value;
} coin_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, COIN_KIND_NULL,
		FACE_MNR_NULL,
		(rate_t)0, 0 },
	{ NULL, N_MSG_COIN_GOLD, COIN_KIND_GOLD,
		FACE_MNR_NULL,
		(rate_t)80, 100 },
	{ NULL, N_MSG_COIN_SILVER, COIN_KIND_SILVER,
		FACE_MNR_NULL,
		(rate_t)0, 10 },
	{ NULL, N_MSG_COIN_COPPER, COIN_KIND_COPPER,
		FACE_MNR_NULL,
		(rate_t)0, 1 },
	{ NULL, N_MSG_NULL, COIN_KIND_NULL,
		FACE_MNR_NULL,
		(rate_t)0, 0 },
};

#define	RANGE_MAX_R	20
#define	STICK_RANGE_R	(RANGE_MAX_R)

typedef struct {
	item_kind_t	kind;
	long	r;
} range_tab_t;

range_tab_t	range_tab[] = {
	{ ITEM_KIND_WPN,
		RANGE_MAX_R * 100 / 100, },

	{ ITEM_KIND_ARMOR,
		RANGE_MAX_R * 25 / 100, },

	{ ITEM_KIND_POTION,
		RANGE_MAX_R * 100 / 100, },

	{ ITEM_KIND_SCROLL,
		RANGE_MAX_R * 25 / 100, },

	{ ITEM_KIND_STICK,
		RANGE_MAX_R * 50 / 100, },

	{ ITEM_KIND_ACCE,
		RANGE_MAX_R * 100 / 100, },

	{ ITEM_KIND_LIGHT,
		RANGE_MAX_R * 50 / 100, },

	{ ITEM_KIND_SPIKE,
		RANGE_MAX_R * 100 / 100, },

	{ ITEM_KIND_FOOD,
		RANGE_MAX_R * 25 / 100, },

	{ ITEM_KIND_CHEST,
		RANGE_MAX_R * 1 / 100, },

	{ ITEM_KIND_TOBACCO,
		RANGE_MAX_R * 25 / 100, },

	{ ITEM_KIND_PIPE,
		RANGE_MAX_R * 25 / 100, },

	{ ITEM_KIND_COIN,
		RANGE_MAX_R * 50 / 100, },

	{ ITEM_KIND_JUNK,
		RANGE_MAX_R * 25 / 100, },
};

#endif	/* ITEM_TAB_H */
