/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: main_unix.c,v 1.6 2003/11/20 17:33:49 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"misc.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
#include	"msg.h"
#include	"ver.h"

#include	"gmain_prot.h"
/*#include	"misc_prot.h"*/
/*#include	"turn_prot.h"*/
/*#include	"dun_prot.h"*/
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

#include	"main_unix_prot.h"

/**/

#if	HAVE_GETOPT_H
# include	<getopt.h>
#endif	/* HAVE_GETOPT_H */

#if	HAVE_TERMIOS_H
# include	<termios.h>
#elif	HAVE_TERMIO_H
# include	<termio.h>
#endif

/**/

#define	STR_ENV_SHELL	"SHELL"
#define	STR_DFLT_SHELL	"sh"

#define	KEY_WAIT_VMIN	0
#define	KEY_WAIT_VTIME	1

#define	OPT_ARG_MAX_LEN	128
#define	STR_OPT	"c:p:m:Vh"

#if	HAVE_GETOPT_LONG
static struct option	long_opt[] = {
	{ "clear-key-buf", required_argument, NULL, 'c' },
	{ "use-keypad",    required_argument, NULL, 'p' },
	{ "measure-clock", required_argument, NULL, 'm' },
	{ "version",       no_argument,       NULL, 'V' },
	{ "help",          no_argument,       NULL, 'h' },
	{ 0, 0, 0, 0 }
};
#endif	/* HAVE_GETOPT */

#define	STR_USAGE	\
	"Usage: %s [OPTION]...\n" \
	"OPTION:\n" \
	"  -c, --clear-key-buf=FLAG clear key buffer:\n" \
	"                             ON, OFF\n" \
	"  -p, --use-keypad=FLAG    use cursor key (call keypad):\n" \
	"                             ON, OFF\n" \
	"  -m, --measure-clock=FLAG measure CLK_TCK:\n" \
	"                             ON, OFF\n" \
	"  -V, --version            display version and exit\n" \
	"  -h, --help               display this help and exit\n"

/**/

long	flg_term;

/**/

int	main( int argc, char **argv )
{
	init_arg();
	chk_arg( argc, argv );

	init_game();
	game_main();

	return EXIT_FAILURE;
}

/**/

void	chk_arg( int argc, char **argv )
{
#if	HAVE_GETOPT || HAVE_GETOPT_LONG
	while( 1 ){
		long	c;
# if	HAVE_GETOPT_LONG
		int	opt_idx;

		c = getopt_long( argc, argv, STR_OPT, long_opt, &opt_idx );
# else	/* HAVE_GETOPT_LONG */
		c = getopt( argc, argv, STR_OPT );
# endif	/* HAVE_GETOPT_LONG */

		if( c <= -1 )
			break;
		switch( c ){
		case 'c':
			g_flg_clr_key_buf = chk_opt_flg( optarg );
			break;
		case 'p':
			g_flg_use_keypad = chk_opt_flg( optarg );
			break;
		case 'm':
			g_flg_measure_clk_tck = chk_opt_flg( optarg );
			break;
		case 'V':
			version( stdout );
			exit( EXIT_SUCCESS );
			break;
		case 'h':
			usage( stdout );
			exit( EXIT_SUCCESS );
			break;
		case '\0':
			break;
		case '?':
		case ':':
		default:
			usage( stderr );
			exit( EXIT_FAILURE );
			break;
		}
	}

	if( (argc - optind) > 0 ){
		usage( stderr );
		exit( EXIT_FAILURE );
	}
#endif	/* HAVE_GETOPT || HAVE_GETOPT_LONG */
}

/**/

bool_t	chk_opt_flg( const char *optarg )
{
	static char	str[OPT_ARG_MAX_LEN + 1];
	long	i;

	if( optarg == NULL )
		return FALSE;

	for( i = 0; i < OPT_ARG_MAX_LEN; i++ ){
		if( optarg[i] == '\0' )
			break;
		str[i] = toupper( optarg[i] );
	}
	str[i] = '\0';

	if( strcmp( str, "ON" ) == 0 )
		return TRUE;
	if( strcmp( str, "TRUE" ) == 0 )
		return TRUE;
	if( strcmp( str, "T" ) == 0 )
		return TRUE;
	if( strcmp( str, "YES" ) == 0 )
		return TRUE;
	if( strcmp( str, "1" ) == 0 )
		return TRUE;

	if( strcmp( str, "OFF" ) == 0 )
		return FALSE;
	if( strcmp( str, "FALSE" ) == 0 )
		return FALSE;
	if( strcmp( str, "NIL" ) == 0 )
		return FALSE;
	if( strcmp( str, "NO" ) == 0 )
		return FALSE;
	if( strcmp( str, "0" ) == 0 )
		return FALSE;

	return FALSE;
}

/**/

void	usage( FILE *fp )
{
	fprintf( fp, STR_USAGE, STR_FILE_NAME_GAME );
	fflush( fp );
}

/**/

void	child_ps_unix( void )
{
	char	*shell;

	dis_scrn();

	shell = getenv( STR_ENV_SHELL );
	if( shell == NULL )
		shell = STR_DFLT_SHELL;

	fprintf( stdout, MSG_CHILD_PS, shell );
	fflush( stdout );
	system( shell );

	ena_scrn( FALSE );
}

/**/

void	init_term_unix( void )
{
	flg_term = 0;
}

/**/

bool_t	chk_term_unix( void )
{
	return( flg_term > 0 );
}

/**/

#if	HAVE_TERMIOS_H
struct termios	pre_tbuf;
#elif	HAVE_TERMIO_H
struct termio	pre_tbuf;
#endif

void	ena_term_unix( void )
{
	flg_term++;

#if	(HAVE_TERMIOS_H || HAVE_TERMIO_H)
	if( flg_term == 1 ){
		/* ¤Τ */
# if	HAVE_TERMIOS_H
		struct termios	tbuf;
# elif	HAVE_TERMIO_H
		struct termio	tbuf;
# endif

		/* Υå */
# if	HAVE_TERMIOS_H
		tcgetattr( fileno( stdin ), &tbuf );
# elif	HAVE_TERMIO_H
		ioctl( 0, TCGETA, &tbuf );
# endif

		/* Խ */
		pre_tbuf = tbuf;
		tbuf.c_iflag &= ~(INLCR | ICRNL | ISTRIP | IXON | BRKINT);
		tbuf.c_oflag &= ~(OPOST);
		if( g_flg_clr_key_buf ){
			tbuf.c_lflag &= ~(ICANON);
			tbuf.c_cc[VMIN] = KEY_WAIT_VMIN;
			tbuf.c_cc[VTIME] = KEY_WAIT_VTIME;
		}
		tbuf.c_lflag &= ~(ISIG | ECHO);

		/* ^C ͭˤ */
		if( g_flg_debug ){
			tbuf.c_iflag |= BRKINT;
			tbuf.c_lflag |= ISIG;
		}

		/* Υå */
# if	HAVE_TERMIOS_H
		if( tcsetattr( fileno( stdin ), TCSANOW, &tbuf ) != 0 ){
			print_err( MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# elif	HAVE_TERMIO_H
		if( ioctl( 0, TCSETAF, &tbuf ) != 0 ){
			print_err( MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# endif
	}
#endif	/* (HAVE_TERMIOS_H || HAVE_TERMIO_H) */
}

/**/

void	dis_term_unix( void )
{
	if( flg_term == 1 ){
# if	HAVE_TERMIOS_H
		tcsetattr( fileno( stdin ), TCSANOW, &pre_tbuf );
# elif	HAVE_TERMIO_H
		ioctl( 0, TCSETAF, &pre_tbuf );
# endif
	}

	flg_term--;
}

/**/

