/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: spell.c,v 1.45 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
/*#include	"turn_prot.h"*/
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#include	"spell_tab.h"

/**/

static cast_tab_t	cast_tab[LS_MBR_MAX_N][SPELL_KIND_MAX_N];

static mbr_t	*g_sel_mbr;
static spell_tab_t	*g_sel_spell;

static pos_t	g_vfx_bgn[VFX_ARW_MAX_N], g_vfx_end[VFX_ARW_MAX_N];
static long	g_vfx_n;

/**/

void	init_spell( void )
{
	long	m;
	spell_kind_t	k;

	for( m = 0; m < LS_MBR_MAX_N; m++ ){
		for( k = 0; k < SPELL_KIND_MAX_N; k++ ){
			cast_tab[m][k].kind = k;
			cast_tab[m][k].flg_cast = FALSE;
		}
	}

	for( k = SPELL_KIND_NULL + 1; k < SPELL_KIND_MAX_N; k++ ){
		if( spell_tab[k].kind == SPELL_KIND_NULL )
			break;
		if( spell_tab[k].kind == SPELL_KIND_MAX_N )
			break;

		spell_tab[k].name = MSG( spell_tab[k].n_name );
	}

	init_spell_debug();
}

/**/

void	init_spell_debug( void )
{
	long	m;
	spell_kind_t	k;

	m = 0;
	for( k = SPELL_KIND_NIN_MIN_N + 1; k < SPELL_KIND_NIN_MAX_N; k++ )
		cast_tab[m][k].flg_cast = TRUE;

	m = 3;
	for( k = SPELL_KIND_PRI_MIN_N + 1; k < SPELL_KIND_PRI_MAX_N; k++ )
		cast_tab[m][k].flg_cast = TRUE;

	m = 5;
	for( k = SPELL_KIND_NULL + 1; k < SPELL_KIND_MAX_N; k++ ){
		if( k == SPELL_KIND_CREATE_FOOD )
			continue;
		if( k == SPELL_KIND_CREATE_UNDEAD )
			continue;
		cast_tab[m][k].flg_cast = TRUE;
	}
}

/**/

char	*cb_menu_sel_spell( menu_t **pp, menu_t **dflt )
{
	pos_t	*crsr;
	menu_t	*ls;
	unsigned char	key;
	bool_t	flg;
	long	i;

	crsr = get_crsr();
	g_sel_mbr = get_mbr( crsr->x, crsr->y );
	if( g_sel_mbr == NULL )
		return STR_MENU_ERR;

	ls = ls_menu_spell;
	clr_flg_menu( ls, NULL, FLG_MENU_ALL );

	key = 'A';
	for( i = 0; i < 1024; i++ ){
		spell_kind_t	kind;

		if( ls[i].path[0] == '\0' )
			break;
		if( strcmp( ls[i].kind, "<PageSeparator>" ) == 0 ){
			key = 'A';
			continue;
		}
		if( ls[i].key == 'Z' ){
			if( key == 'A' )
				ls[i].flg &= ~FLG_MENU_HIDDEN;
			else
				ls[i].flg |= FLG_MENU_HIDDEN;
			continue;
		}
		if( ls[i].arg == NULL )
			continue;

		kind = (spell_kind_t)(ls[i].arg);
		if( chk_can_chr_cast( g_sel_mbr, kind ) ){
			ls[i].flg &= ~FLG_MENU_HIDDEN;
			ls[i].key = key;
			key++;
		} else {
			ls[i].flg |= FLG_MENU_HIDDEN;
			ls[i].key = '\0';
		}
	}

	flg = FALSE;

	if( get_lev( g_sel_mbr, ABL_KIND_MAG ) > 0 ){
		clr_flg_menu( ls, "MAG", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "MAG", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_SOR ) > 0 ){
		clr_flg_menu( ls, "SOR", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "SOR", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_ENC ) > 0 ){
		clr_flg_menu( ls, "ENC", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "ENC", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_SUM ) > 0 ){
		clr_flg_menu( ls, "SUM", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "SUM", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_PRI ) > 0 ){
		clr_flg_menu( ls, "PRI", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "PRI", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_SHA ) > 0 ){
		clr_flg_menu( ls, "SHA", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "SHA", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_BAR ) > 0 ){
		clr_flg_menu( ls, "BAR", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "BAR", FLG_MENU_HIDDEN );
	}

	if( get_lev( g_sel_mbr, ABL_KIND_NIN ) > 0 ){
		clr_flg_menu( ls, "NIN", FLG_MENU_HIDDEN );
		flg = TRUE;
	} else {
		set_flg_menu( ls, "NIN", FLG_MENU_HIDDEN );
	}

	*pp = ls;
	*dflt = NULL;

	if( !flg ){
		print_msg( FLG_NULL, MSG_ERR_SPELL, g_sel_mbr->name );
		return STR_MENU_CANCEL;
	}

	return NULL;
}

/**/


char	*cb_menu_spell_no_learn( menu_t **pp, menu_t **dflt )
{
	return STR_MENU_CANCEL;
}

/**/

char	*cb_menu_spell( menu_t **pp, menu_t **dflt )
{
	menu_t	*ls;

	ls = ls_menu_spell_extent;

	g_sel_spell = get_spell_tab( (spell_kind_t)((*pp)->arg) );
	if( g_sel_spell == NULL )
		return STR_MENU_ERR;

	if( chk_flg( g_sel_spell->flg_extent, FLG_EXTENT_NORMAL ) )
		clr_flg_menu( ls, "Normal", FLG_MENU_HIDDEN );
	else
		set_flg_menu( ls, "Normal", FLG_MENU_HIDDEN );

	if( chk_flg( g_sel_spell->flg_extent, FLG_EXTENT_SPREAD ) )
		clr_flg_menu( ls, "Spread", FLG_MENU_HIDDEN );
	else
		set_flg_menu( ls, "Spread", FLG_MENU_HIDDEN );

	if( chk_flg( g_sel_spell->flg_extent, FLG_EXTENT_MASS ) )
		clr_flg_menu( ls, "Mass", FLG_MENU_HIDDEN );
	else
		set_flg_menu( ls, "Mass", FLG_MENU_HIDDEN );

	if( chk_flg( g_sel_spell->flg_extent, FLG_EXTENT_HALF ) )
		clr_flg_menu( ls, "Half", FLG_MENU_HIDDEN );
	else
		set_flg_menu( ls, "Half", FLG_MENU_HIDDEN );

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/**/

char	*cb_menu_spell_extent( menu_t **pp, menu_t **dflt )
{
	char	*str_goto;

	if( g_sel_mbr == NULL )
		return STR_MENU_ERR;
	if( g_sel_spell == NULL )
		return STR_MENU_ERR;

	if( g_sel_spell->flg_trgt ){
		str_goto = menu_spell_trgt( g_sel_mbr );
		if( str_goto != NULL )
			return str_goto;
	}

	/*  */

	set_chr_act( g_sel_mbr, ACT_KIND_SPELL,
			g_sel_spell, NULL,
			(extent_kind_t)((*pp)->arg), 0 );

	return NULL;
}

/**/

char	*menu_spell_trgt( mbr_t *mbr )
{
	pos_t	*crsr;
	trgt_kind_t	trgt_kind;
	char	*str_goto;
	mbr_t	*mbr2;
	mnstr_t	*mnstr;
	item_t	*item;
	door_t	*door;
	trap_t	*trap;

	if( mbr == NULL )
		return STR_MENU_ERR;

	/* ΥåȤ˥ư */

	crsr = get_crsr();
	if( crsr == NULL )
		return STR_MENU_ERR;
	if( mbr->trgt.kind != TRGT_KIND_SQUARE ){
		crsr->x = mbr->trgt.true_x;
		crsr->y = mbr->trgt.true_y;
	}

	/* åȤ˥ư */

	while( 1 ){
		str_goto = exec_menu_point_crsr();
		if( str_goto != NULL )
			return str_goto;

		/* åȤ */

		str_goto = exec_menu_sel_obj( &trgt_kind, *crsr );
		if( str_goto == NULL ){
			if( trgt_kind == TRGT_KIND_AUTO )
				continue;
			break;
		}
		if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
			continue;
		if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
			return str_goto;
	}

	/* åȤޡ */
	switch( trgt_kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return STR_MENU_ERR;
	case TRGT_KIND_MBR:
		mbr2 = get_mbr( crsr->x, crsr->y );
		if( mbr2 == NULL )
			return STR_MENU_ERR;
		mark_mbr( mbr, mbr2, DIST_FAR );
		break;
	case TRGT_KIND_MNSTR:
		mnstr = get_mnstr( crsr->x, crsr->y );
		if( mnstr == NULL )
			return STR_MENU_ERR;
		mark_mnstr( mbr, mnstr, DIST_FAR );
		break;
	case TRGT_KIND_MNSTR_NULL:
	case TRGT_KIND_POS:
		mark_mnstr_null( mbr, crsr->x, crsr->y, DIST_FAR );
		break;
	case TRGT_KIND_ITEM:
		item = get_item( crsr->x, crsr->y );
		if( item == NULL )
			return STR_MENU_ERR;
		mark_item( mbr, item, DIST_FAR );
		break;
	case TRGT_KIND_DOOR:
		door = get_door( crsr->x, crsr->y );
		if( door == NULL )
			return STR_MENU_ERR;
		mark_door( mbr, door, DIST_FAR );
		break;
	case TRGT_KIND_TRAP:
		trap = get_trap( crsr->x, crsr->y );
		if( trap == NULL )
			return STR_MENU_ERR;
		mark_trap( mbr, trap, DIST_FAR );
		break;
	case TRGT_KIND_QUEUE:
		return STR_MENU_ERR;
	case TRGT_KIND_SQUARE:
		mark_square( mbr );
		break;
	}

	return NULL;
}

/**/

void	chr_cast_spell( chr_t *chr, spell_tab_t *tab, const char *fmt )
{
	long	hp, mp;
	curs_attr_t	prev_attr;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	hp = tab->hp;
	mp = tab->mp;

	switch( (extent_kind_t)(chr->act.n) ){
	case EXTENT_KIND_NULL:
	case EXTENT_KIND_MAX_N:
		return;
	case EXTENT_KIND_NORMAL:
		hp *= 1;
		mp *= 1;
		break;
	case EXTENT_KIND_SPREAD:
		hp *= 2;
		mp *= 2;
		break;
	case EXTENT_KIND_MASS:
		hp *= 3;
		mp *= 3;
		break;
	case EXTENT_KIND_HALF:
		hp /= 2;
		mp /= 2;
		break;
	}
	if( (tab->hp > 0) && (hp < 1) )
		hp = 1;
	if( (tab->mp > 0) && (mp < 1) )
		mp = 1;

	if( chr->abl.hp.n < hp ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_HP_SHORT, chr->name,
				hp - chr->abl.hp.n );
		return;
	}
	if( chr->abl.mp.n < mp ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_MP_SHORT, chr->name,
				mp - chr->abl.mp.n );
		return;
	}
	chr->abl.hp.n -= hp;
	chr->abl.mp.n -= mp;

	draw_mbr_stat( chr );

	if( fmt == NULL )
		print_msg( FLG_NULL, MSG_SPELL, chr->name, tab->name );
	else
		print_msg( FLG_NULL, fmt, chr->name );

	get_vfx_attr( &prev_attr );
	set_vfx_attr_n( CURS_ATTR_N_VFX );

	switch( (extent_kind_t)(chr->act.n) ){
	case EXTENT_KIND_NULL:
	case EXTENT_KIND_MAX_N:
		break;
	case EXTENT_KIND_NORMAL:
		chr_cast_spell_normal( chr, FALSE, tab, _100_PERCENT );
		break;
	case EXTENT_KIND_SPREAD:
		chr_cast_spell_spread( chr, FALSE, tab, _100_PERCENT );
		break;
	case EXTENT_KIND_MASS:
		chr_cast_spell_mass( chr, FALSE, tab, _100_PERCENT );
		break;
	case EXTENT_KIND_HALF:
		chr_cast_spell_normal( chr, FALSE, tab, 50 );
		break;
	}

	set_vfx_attr( &prev_attr );
}

/**/

void	chr_cast_spell_normal(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	long	x, y;
	trgt_kind_t	trgt_kind;
	void	*p;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	if( tab->flg_trgt ){
		x = chr->trgt.true_x;
		y = chr->trgt.true_y;
		trgt_kind = chr->trgt.kind;
		p = chr->trgt.p;

		g_vfx_bgn[0].x = chr->x * 2;
		g_vfx_bgn[0].y = chr->y;
		g_vfx_end[0].x = x * 2;
		g_vfx_end[0].y = y;
		vfx_arw_line( g_vfx_bgn, g_vfx_end,
				get_spell_vfx_str( tab->kind ),
				ANIM_SPELL_LEN,
				ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N,
				TRUE );
	} else {
		x = chr->x;
		y = chr->y;
		trgt_kind = TRGT_KIND_NULL;
		p = NULL;
	}

	chr_cast_spell_sub( chr, flg_item, tab, rate, x, y, trgt_kind, p );
}

/**/

void	chr_cast_spell_spread(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	long	x, y;
	trgt_kind_t	trgt_kind;
	void	*p;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	if( tab->flg_trgt ){
		x = chr->trgt.true_x;
		y = chr->trgt.true_y;
		trgt_kind = chr->trgt.kind;
		p = chr->trgt.p;

		g_vfx_bgn[0].x = chr->x * 2;
		g_vfx_bgn[0].y = chr->y;
		g_vfx_end[0].x = x * 2;
		g_vfx_end[0].y = y;
		vfx_arw_line( g_vfx_bgn, g_vfx_end,
				get_spell_vfx_str( tab->kind ),
				ANIM_SPELL_LEN,
				ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N,
				TRUE );

		chr_cast_spell_blast( chr, flg_item, tab, rate,
				x, y, trgt_kind, p );
	} else {
		x = chr->x;
		y = chr->y;
		trgt_kind = TRGT_KIND_NULL;
		p = NULL;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				x, y, trgt_kind, p );
	}
}

/**/

void	chr_cast_spell_blast(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate,
	long x, long y, trgt_kind_t trgt_kind, void *p
)
{
	blast_t	*blast;
	char	*blast_str;
	long	nx, ny;
	long	xx, yy;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	blast = get_blast();
	blast_str = get_spell_vfx_str( tab->kind );
	draw_blast( x, y, blast, blast_str );

	for( ny = 0; ny < blast->yl; ny++ ){
		for( nx = 0; nx < blast->xl; nx++ ){
			if( blast->ptn[ny][nx] == ' ' )
				continue;

			xx = x + nx - blast->xr;
			yy = y + ny - blast->yr;

			switch( trgt_kind ){
			case TRGT_KIND_NULL:
				continue;
			case TRGT_KIND_MBR:
				p = get_mbr( xx, yy );
				break;
			case TRGT_KIND_MNSTR:
			case TRGT_KIND_MNSTR_NULL:
			case TRGT_KIND_POS:
				p = get_mnstr( xx, yy );
				break;
			case TRGT_KIND_ITEM:
				p = get_item( xx, yy );
				break;
			case TRGT_KIND_DOOR:
				p = get_door( xx, yy );
				break;
			case TRGT_KIND_TRAP:
				p = get_trap( xx, yy );
				break;
			case TRGT_KIND_QUEUE:
			case TRGT_KIND_SQUARE:
			case TRGT_KIND_AUTO:
			case TRGT_KIND_MAX_N:
				continue;
			}
			if( p == NULL )
				continue;

			draw_map( xx, yy, 1, 1 );

			chr_cast_spell_sub( chr, flg_item, tab, rate,
					xx, yy, trgt_kind, p );

			draw_blast( x, y, blast, blast_str );
		}
	}

	draw_map( x - blast->xr, y - blast->yr,
			blast->xl + str_len_draw( blast_str ),
			blast->yl );
}

/**/

void	chr_cast_spell_mass(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	if( !tab->flg_trgt ){
		chr_cast_spell_normal( chr, flg_item, tab, rate );
		return;
	}

	switch( chr->trgt.kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		break;
	case TRGT_KIND_MBR:
		chr_cast_spell_mass_mbr( chr, flg_item, tab, rate );
		break;
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
	case TRGT_KIND_POS:
		chr_cast_spell_mass_mnstr( chr, flg_item, tab, rate );
		break;
	case TRGT_KIND_ITEM:
		chr_cast_spell_mass_item( chr, flg_item, tab, rate );
		break;
	case TRGT_KIND_DOOR:
		chr_cast_spell_mass_door( chr, flg_item, tab, rate );
		break;
	case TRGT_KIND_TRAP:
		chr_cast_spell_mass_trap( chr, flg_item, tab, rate );
		break;
	case TRGT_KIND_QUEUE:
		break;
	}
}

/**/

void	chr_cast_spell_mass_mbr(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	party_t	*pty = get_party();
	long	i;
	pos_t	pos1, pos2;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	g_vfx_n = 0;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = pty->mbr[i]->x;
		pos2.y = pty->mbr[i]->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( g_vfx_n < VFX_ARW_MAX_N ){
			g_vfx_bgn[g_vfx_n].x = pos1.x * 2;
			g_vfx_bgn[g_vfx_n].y = pos1.y;
			g_vfx_end[g_vfx_n].x = pos2.x * 2;
			g_vfx_end[g_vfx_n].y = pos2.y;
			g_vfx_n++;
		}
	}

	vfx_arw_mul_line( g_vfx_n, g_vfx_bgn, g_vfx_end,
			get_spell_vfx_str( tab->kind ), ANIM_SPELL_LEN,
			ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N, TRUE );

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = pty->mbr[i]->x;
		pos2.y = pty->mbr[i]->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				pty->mbr[i]->x, pty->mbr[i]->y,
				TRGT_KIND_MBR, pty->mbr[i] );
	}
}

/**/

void	chr_cast_spell_mass_mnstr(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	mnstr_t	*mns_head, *mns_p, *mns_pp;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	g_vfx_n = 0;

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mns_pp = mns_p->prev;
		if( mns_pp == mns_head )
			break;

		if( chk_flg_or( mns_pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( !chk_find_chr( chr, mns_pp ) )
			continue;

		if( g_vfx_n < VFX_ARW_MAX_N ){
			g_vfx_bgn[g_vfx_n].x = chr->x * 2;
			g_vfx_bgn[g_vfx_n].y = chr->y;
			g_vfx_end[g_vfx_n].x = mns_pp->x * 2;
			g_vfx_end[g_vfx_n].y = mns_pp->y;
			g_vfx_n++;
		}
	}

	vfx_arw_mul_line( g_vfx_n, g_vfx_bgn, g_vfx_end,
			get_spell_vfx_str( tab->kind ), ANIM_SPELL_LEN,
			ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N, TRUE );

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mns_pp = mns_p->prev;
		if( mns_pp == mns_head )
			break;

		if( chk_flg_or( mns_pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( !chk_find_chr( chr, mns_pp ) )
			continue;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				mns_pp->x, mns_pp->y,
				TRGT_KIND_MNSTR, mns_pp );
	}
}

/**/

void	chr_cast_spell_mass_item(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	item_t	*item, *head, *p;
	pos_t	pos1, pos2;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	g_vfx_n = 0;

	head = get_dun_item_asgn();
	for( item = head->next->next; item->prev != head;
			item = item->next ){
		p = item->prev;

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = p->x;
		pos2.y = p->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( g_vfx_n < VFX_ARW_MAX_N ){
			g_vfx_bgn[g_vfx_n].x = pos1.x * 2;
			g_vfx_bgn[g_vfx_n].y = pos1.y;
			g_vfx_end[g_vfx_n].x = pos2.x * 2;
			g_vfx_end[g_vfx_n].y = pos2.y;
			g_vfx_n++;
		}
	}

	vfx_arw_mul_line( g_vfx_n, g_vfx_bgn, g_vfx_end,
			get_spell_vfx_str( tab->kind ), ANIM_SPELL_LEN,
			ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N, TRUE );

	for( item = head->next->next; item->prev != head;
			item = item->next ){
		p = item->prev;

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = p->x;
		pos2.y = p->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				p->x, p->y, TRGT_KIND_ITEM, p );
	}
}

/**/

void	chr_cast_spell_mass_door(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	dun_t	*dun = get_dun();
	long	i;
	pos_t	pos1, pos2;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	g_vfx_n = 0;

	for( i = 0; i < dun->door_n; i++ ){
		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = dun->door[i].x;
		pos2.y = dun->door[i].y;
		get_near_pos_door( &pos2, &(dun->door[i]), chr );

		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( g_vfx_n < VFX_ARW_MAX_N ){
			g_vfx_bgn[g_vfx_n].x = pos1.x * 2;
			g_vfx_bgn[g_vfx_n].y = pos1.y;
			g_vfx_end[g_vfx_n].x = pos2.x * 2;
			g_vfx_end[g_vfx_n].y = pos2.y;
			g_vfx_n++;
		}
	}

	vfx_arw_mul_line( g_vfx_n, g_vfx_bgn, g_vfx_end,
			get_spell_vfx_str( tab->kind ), ANIM_SPELL_LEN,
			ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N, TRUE );

	for( i = 0; i < dun->door_n; i++ ){
		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = dun->door[i].x;
		pos2.y = dun->door[i].y;
		get_near_pos_door( &pos2, &(dun->door[i]), chr );

		if( !chk_find( &pos1, &pos2 ) )
			continue;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				dun->door[i].x, dun->door[i].y,
				TRGT_KIND_DOOR, &(dun->door[i]) );
	}
}

/**/

void	chr_cast_spell_mass_trap(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate
)
{
	trap_t	*trap, *head, *p;
	pos_t	pos1, pos2;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;

	g_vfx_n = 0;

	head = get_dun_trap_asgn();
	for( trap = head->next->next; trap->prev != head;
			trap = trap->next ){
		p = trap->prev;

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = p->x;
		pos2.y = p->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( g_vfx_n < VFX_ARW_MAX_N ){
			g_vfx_bgn[g_vfx_n].x = pos1.x * 2;
			g_vfx_bgn[g_vfx_n].y = pos1.y;
			g_vfx_end[g_vfx_n].x = pos2.x * 2;
			g_vfx_end[g_vfx_n].y = pos2.y;
			g_vfx_n++;
		}
	}

	vfx_arw_mul_line( g_vfx_n, g_vfx_bgn, g_vfx_end,
			get_spell_vfx_str( tab->kind ), ANIM_SPELL_LEN,
			ANIM_SPELL_FRAME_N, ANIM_SPELL_CLR_FRAME_N, TRUE );

	for( trap = head->next->next; trap->prev != head;
			trap = trap->next ){
		p = trap->prev;

		pos1.x = chr->x;
		pos1.y = chr->y;
		pos2.x = p->x;
		pos2.y = p->y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		chr_cast_spell_sub( chr, flg_item, tab, rate,
				p->x, p->y, TRGT_KIND_TRAP, p );
	}
}

/**/

void	chr_cast_spell_sub(
	chr_t *chr, bool_t flg_item,
	spell_tab_t *tab, rate_t rate,
	long x, long y, trgt_kind_t trgt_kind, void *p
)
{
	bool_t	flg_chr;
	const long	turn_resi = FX_AVE_TURN_POW_UP_RESI;

	if( chr == NULL )
		return;
	if( tab == NULL )
		return;
	if( !chk_cast_spell_trgt( tab->kind, trgt_kind ) )
		return;

	if( (trgt_kind == TRGT_KIND_MBR)
			|| (trgt_kind == TRGT_KIND_MNSTR) ){
		flg_chr = TRUE;
	} else {
		flg_chr = FALSE;
	}

	if( (trgt_kind == TRGT_KIND_MNSTR_NULL)
			|| (trgt_kind == TRGT_KIND_POS) ){
		mnstr_t	*mnstr;

		mnstr = get_mnstr( x, y );
		if( mnstr == NULL )
			return;
		trgt_kind = TRGT_KIND_MNSTR;
		p = mnstr;
	}

	if( flg_chr ){
		chr_t	*chr2;

		chr2 = (chr_t *)p;
		if( chr2->gold < tab->gold ){
			print_msg_mbr( chr2, FLG_NULL, MSG_ERR_GOLD_SHORT,
					chr2->name, tab->gold - chr2->gold );
			return;
		}
		chr2->gold -= tab->gold;
	}

	/* ʸ뤫å */
	if( flg_chr )
		if( !chk_spell( chr, (chr_t *)p, tab, flg_item ) )
			return;

	switch( tab->kind ){
	case SPELL_KIND_NULL:
		break;
/* MAG */
	case SPELL_KIND_MAG_MIN_N:
		break;
	case SPELL_KIND_LIGHT:
		fx_light( x, y );
		break;
	case SPELL_KIND_DARKNESS:
		fx_darkness( x, y );
		break;
	case SPELL_KIND_TELEPORT_PARTY:
		fx_teleport_party();
		break;
	case SPELL_KIND_TELEPORT:
		fx_teleport( trgt_kind, p );
		break;
	case SPELL_KIND_RECALL:
		fx_recall();
		break;
	case SPELL_KIND_KNOCK:
		fx_knock( get_door( x, y ) );
		break;
	case SPELL_KIND_LOCK:
		fx_lock( get_door( x, y ) );
		break;
	case SPELL_KIND_DISARM_TRAP:
		fx_disarm_trap( get_trap( x, y ), chr );
		break;
	case SPELL_KIND_DISPEL_MAGIC:
		break;
	case SPELL_KIND_MIRROR_IMAGE:
	case SPELL_KIND_ANIMATE_OBJECTS:
	case SPELL_KIND_SHELTER:
		break;
	case SPELL_KIND_CREATE_FOOD:
		fx_create_food( chr );
		break;
	case SPELL_KIND_IDENTIFY_ITEM:
		exec_menu_identify_item( chr );
		break;
	case SPELL_KIND_SEARCHING:
	case SPELL_KIND_ANALYZE_DWEOMER:
	case SPELL_KIND_DETECT_MAGIC:
		break;
	case SPELL_KIND_DETECT_ITEM:
		fx_detect_item( chr );
		break;
	case SPELL_KIND_DETECT_DOORS:
		fx_detect_door( chr );
		break;
	case SPELL_KIND_DETECT_TRAPS:
		fx_detect_trap( chr );
		break;
	case SPELL_KIND_DETECT_MONSTER:
		fx_detect_mnstr( chr );
		break;
	case SPELL_KIND_SENSE_INVISIBLE:
		break;
	case SPELL_KIND_FLY:
		fx_std( p, FX_KIND_FLY );
		break;
	case SPELL_KIND_FEATHER_FALL:
		break;
	case SPELL_KIND_VANISH:
		fx_std( p, FX_KIND_VANISH );
		break;
	case SPELL_KIND_DARKVISION:
		fx_darkvision( p );
		break;
	case SPELL_KIND_PASSWALL:
	case SPELL_KIND_POLYMORPH_OTHER:
	case SPELL_KIND_POLYMORPH_SELF:
	case SPELL_KIND_STEALTH:
		break;
	case SPELL_KIND_MAG_MAX_N:
		break;
/* SOR */
	case SPELL_KIND_SOR_MIN_N:
		break;
	case SPELL_KIND_MAGIC_MISSILE:
		fx_magic_missile( chr, trgt_kind, p, rate );
		break;
	case SPELL_KIND_FIRE_BALL:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_HEAT,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_ICE_BLIZZARD:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_COLD,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_ACID_RAIN:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_ACID,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_MIND_STORM:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_MIND,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_LIGHTNING_BOLT:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_ELEC,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_POISON_CLOUD:
		fx_spell_attack( chr, trgt_kind, p, RESI_KIND_POIS,
				ABL_KIND_SOR, rate );
		break;
	case SPELL_KIND_DEATH_SPELL:
		fx_death_spell( chr, trgt_kind, p );
		break;
	case SPELL_KIND_MAGIC_SHIELD:
		fx_magic_armor( p, FX_KIND_MAGIC_SHIELD );
		break;
	case SPELL_KIND_MAGE_ARMOR:
		fx_magic_armor( p, FX_KIND_MAGE_ARMOR );
		break;
	case SPELL_KIND_STONESKIN:
	case SPELL_KIND_IRON_BODY:
	case SPELL_KIND_SPELL_RESISTANCE:
	case SPELL_KIND_COUNTER_MAGIC:
		break;
	case SPELL_KIND_STONE:
		fx_std( p, FX_KIND_STONE );
		break;
	case SPELL_KIND_PARALYZE:
		fx_std( p, FX_KIND_PARALYZE );
		break;
	case SPELL_KIND_POISON:
		fx_std( p, FX_KIND_POISON );
		break;
	case SPELL_KIND_CONFUSION:
		fx_std( p, FX_KIND_CONFUSION );
		break;
	case SPELL_KIND_BLINDNESS:
		fx_std( p, FX_KIND_BLIND );
		break;
	case SPELL_KIND_SLEEP:
		fx_std( p, FX_KIND_SLEEP );
		break;
	case SPELL_KIND_SILENCE:
		fx_std( p, FX_KIND_SILENCE );
		break;
	case SPELL_KIND_FEAR:
		fx_std( p, FX_KIND_FEAR );
		break;
	case SPELL_KIND_HALLUCINATION:
		fx_std( p, FX_KIND_HALLUCINATION );
		break;
	case SPELL_KIND_CHARM:
		fx_std( p, FX_KIND_CHARM );
		break;
	case SPELL_KIND_SOR_MAX_N:
		break;
/* ENC */
	case SPELL_KIND_ENC_MIN_N:
		break;
	case SPELL_KIND_SHARPNESS:
		fx_abl( p, FX_KIND_SHARPNESS, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_STRENGTH:
		fx_abl( p, FX_KIND_STRENGTH, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_QUICKNESS:
		fx_abl( p, FX_KIND_QUICKNESS, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_WISE:
		fx_abl( p, FX_KIND_WISE, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_BRAINY:
		fx_abl( p, FX_KIND_BRAINY, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_ATTRACTIVE:
		fx_abl( p, FX_KIND_ATTRACTIVE, FX_AVE_TURN_POW_UP_ABL );
		break;
	case SPELL_KIND_POWER_UP_HP:
		fx_pow_up_hp( p, FX_AVE_TURN_POW_UP_HP );
		break;
	case SPELL_KIND_HASTE:
		fx_speed_up( chr, p, +1, FX_AVE_TURN_SPEED_UP );
		break;
	case SPELL_KIND_DULLNESS:
		fx_abl( p, FX_KIND_DULLNESS, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_WEAKNESS:
		fx_abl( p, FX_KIND_WEAKNESS, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_SLOWNESS:
		fx_abl( p, FX_KIND_SLOWNESS, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_FOOLISH:
		fx_abl( p, FX_KIND_FOOLISH, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_BRAINLESS:
		fx_abl( p, FX_KIND_BRAINLESS, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_UNATTRACTIVE:
		fx_abl( p, FX_KIND_UNATTRACTIVE, FX_AVE_TURN_POW_DOWN_ABL );
		break;
	case SPELL_KIND_ENERGY_DRAIN:
		fx_energy_drain( p );
		break;
	case SPELL_KIND_SLOW:
		fx_speed_up( chr, p, -1, FX_AVE_TURN_SPEED_DOWN );
		break;
	case SPELL_KIND_HUNGER:
	case SPELL_KIND_CANCELLATION:
		break;
	case SPELL_KIND_ENC_MAX_N:
		break;
/* SUM */
	case SPELL_KIND_SUM_MIN_N:
		break;
	case SPELL_KIND_CREATE_UNDEAD:
	case SPELL_KIND_SUMMON_MONSTER:
	case SPELL_KIND_DISMISSAL:
		break;
	case SPELL_KIND_SUM_MAX_N:
		break;
/* PRI */
	case SPELL_KIND_PRI_MIN_N:
		break;
	case SPELL_KIND_CURE_HP_LIGHT:
		fx_cure_hp_light( p );
		break;
	case SPELL_KIND_CURE_HP_MODERATE:
		fx_cure_hp_moderate( p );
		break;
	case SPELL_KIND_CURE_HP_SERIOUS:
		fx_cure_hp_serious( p );
		break;
	case SPELL_KIND_CURE_HP_MAX:
		fx_cure_hp_max( p );
		break;
	case SPELL_KIND_CURE_MP:
	case SPELL_KIND_TRANSFER_MP:
	case SPELL_KIND_REGENERATION:
	case SPELL_KIND_RESTORE_EXPERIENCE:
		break;
	case SPELL_KIND_RESURRECTION:
		exec_menu_resurrection( chr );
		break;
	case SPELL_KIND_HEAL:
		fx_heal( p );
		break;
	case SPELL_KIND_CURE_STATUS:
		fx_cure_all_status( p );
		break;
	case SPELL_KIND_CURE_STONE:
		fx_cure_status( p, FX_KIND_STONE );
		break;
	case SPELL_KIND_CURE_PARALYZE:
		fx_cure_status( p, FX_KIND_PARALYZE );
		break;
	case SPELL_KIND_CURE_POISON:
		fx_cure_status( p, FX_KIND_POISON );
		break;
	case SPELL_KIND_CURE_CONFUSION:
		fx_cure_status( p, FX_KIND_CONFUSION );
		break;
	case SPELL_KIND_CURE_BLINDNESS:
		fx_cure_status( p, FX_KIND_BLIND );
		break;
	case SPELL_KIND_CURE_SLEEP:
		fx_cure_status( p, FX_KIND_SLEEP );
		break;
	case SPELL_KIND_CURE_SILENCE:
		fx_cure_status( p, FX_KIND_SILENCE );
		break;
	case SPELL_KIND_CURE_FEAR:
		fx_cure_status( p, FX_KIND_FEAR );
		break;
	case SPELL_KIND_CURE_HALLUCINATION:
		fx_cure_status( p, FX_KIND_HALLUCINATION );
		break;
	case SPELL_KIND_CURE_CHARM:
		fx_cure_status( p, FX_KIND_CHARM );
		break;
	case SPELL_KIND_PROTECTION:
		break;
	case SPELL_KIND_RESIST_PHYSICAL:
		fx_resi( p, FX_KIND_RESI_KNOC, turn_resi );
		fx_resi( p, FX_KIND_RESI_SLAS, turn_resi );
		fx_resi( p, FX_KIND_RESI_STIN, turn_resi );
		break;
	case SPELL_KIND_RESIST_HEAT:
		fx_resi( p, FX_KIND_RESI_HEAT, turn_resi );
		break;
	case SPELL_KIND_RESIST_COLD:
		fx_resi( p, FX_KIND_RESI_COLD, turn_resi );
		break;
	case SPELL_KIND_RESIST_ACID:
		fx_resi( p, FX_KIND_RESI_ACID, turn_resi );
		break;
	case SPELL_KIND_RESIST_MIND:
		fx_resi( p, FX_KIND_RESI_MIND, turn_resi );
		break;
	case SPELL_KIND_RESIST_ELECTRICITY:
		fx_resi( p, FX_KIND_RESI_ELEC, turn_resi );
		break;
	case SPELL_KIND_RESIST_POISON:
		fx_resi( p, FX_KIND_RESI_POIS, turn_resi );
		break;
	case SPELL_KIND_BLESS:
		fx_bless( p );
		break;
	case SPELL_KIND_REMOVE_CURSE:
		fx_remove_curse( chr, p );
		break;
	case SPELL_KIND_DISPEL_UNDEAD:
		fx_dispel_undead( chr, trgt_kind, p, rate );
		break;
	case SPELL_KIND_SANCTUARY:
	case SPELL_KIND_WISH:
		break;
	case SPELL_KIND_PRI_MAX_N:
		break;
/* SHA */
/* BAR */
/* NIN */
	case SPELL_KIND_NIN_MIN_N:
		break;
	case SPELL_KIND_TYPHOON:
	case SPELL_KIND_CONFLAGRATION:
	case SPELL_KIND_EARTHQUAKE:
	case SPELL_KIND_THUNDERCLOUD:
	case SPELL_KIND_INUNDATION:
	case SPELL_KIND_SUBSTITUTE:
	case SPELL_KIND_BURNING_HANDS:
		break;
	case SPELL_KIND_NIN_MAX_N:
		break;
/* ANC */
	case SPELL_KIND_ANC_MIN_N:
		break;
	case SPELL_KIND_NOTHING:
		break;
	case SPELL_KIND_ANC_MAX_N:
		break;
/* end */
	case SPELL_KIND_MAX_N:
		break;
	}
}

/**/

bool_t	chk_spell(
	chr_t *o_p, chr_t *d_p,
	spell_tab_t *tab, bool_t flg_item
)
{
	abl_kind_t	o_abl;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;
	if( tab == NULL )
		return FALSE;

	if( flg_item )
		o_abl = ABL_KIND_MAX_N;
	else
		o_abl = tab->abl;

	return( !resi_roll( o_p, o_abl, d_p, tab->resi ) );
}

/**/

bool_t	chk_cast_spell_trgt( spell_kind_t spell, trgt_kind_t trgt )
{
	switch( spell ){
	case SPELL_KIND_NULL:
		break;
/* MAG */
	case SPELL_KIND_MAG_MIN_N:
	case SPELL_KIND_LIGHT:
	case SPELL_KIND_DARKNESS:
	case SPELL_KIND_TELEPORT_PARTY:
	case SPELL_KIND_TELEPORT:
	case SPELL_KIND_RECALL:
	case SPELL_KIND_KNOCK:
	case SPELL_KIND_LOCK:
	case SPELL_KIND_DISARM_TRAP:
	case SPELL_KIND_DISPEL_MAGIC:
	case SPELL_KIND_MIRROR_IMAGE:
	case SPELL_KIND_ANIMATE_OBJECTS:
	case SPELL_KIND_SHELTER:
	case SPELL_KIND_CREATE_FOOD:
	case SPELL_KIND_IDENTIFY_ITEM:
	case SPELL_KIND_SEARCHING:
	case SPELL_KIND_ANALYZE_DWEOMER:
	case SPELL_KIND_DETECT_MAGIC:
	case SPELL_KIND_DETECT_ITEM:
	case SPELL_KIND_DETECT_DOORS:
	case SPELL_KIND_DETECT_TRAPS:
	case SPELL_KIND_DETECT_MONSTER:
	case SPELL_KIND_SENSE_INVISIBLE:
		break;
	case SPELL_KIND_FLY:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_FEATHER_FALL:
		break;
	case SPELL_KIND_VANISH:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_DARKVISION:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_PASSWALL:
	case SPELL_KIND_POLYMORPH_OTHER:
	case SPELL_KIND_POLYMORPH_SELF:
	case SPELL_KIND_STEALTH:
	case SPELL_KIND_MAG_MAX_N:
/* SOR */
	case SPELL_KIND_SOR_MIN_N:
	case SPELL_KIND_MAGIC_MISSILE:
	case SPELL_KIND_FIRE_BALL:
	case SPELL_KIND_ICE_BLIZZARD:
	case SPELL_KIND_ACID_RAIN:
	case SPELL_KIND_MIND_STORM:
	case SPELL_KIND_LIGHTNING_BOLT:
	case SPELL_KIND_POISON_CLOUD:
	case SPELL_KIND_DEATH_SPELL:
	case SPELL_KIND_MAGIC_SHIELD:
	case SPELL_KIND_MAGE_ARMOR:
	case SPELL_KIND_STONESKIN:
	case SPELL_KIND_IRON_BODY:
	case SPELL_KIND_SPELL_RESISTANCE:
	case SPELL_KIND_COUNTER_MAGIC:
		break;
	case SPELL_KIND_STONE:
	case SPELL_KIND_PARALYZE:
	case SPELL_KIND_POISON:
	case SPELL_KIND_CONFUSION:
	case SPELL_KIND_BLINDNESS:
	case SPELL_KIND_SLEEP:
	case SPELL_KIND_SILENCE:
	case SPELL_KIND_FEAR:
	case SPELL_KIND_HALLUCINATION:
	case SPELL_KIND_CHARM:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_SOR_MAX_N:
/* ENC */
	case SPELL_KIND_ENC_MIN_N:
		break;
	case SPELL_KIND_SHARPNESS:
	case SPELL_KIND_STRENGTH:
	case SPELL_KIND_QUICKNESS:
	case SPELL_KIND_WISE:
	case SPELL_KIND_BRAINY:
	case SPELL_KIND_ATTRACTIVE:
	case SPELL_KIND_POWER_UP_HP:
	case SPELL_KIND_HASTE:
	case SPELL_KIND_DULLNESS:
	case SPELL_KIND_WEAKNESS:
	case SPELL_KIND_SLOWNESS:
	case SPELL_KIND_FOOLISH:
	case SPELL_KIND_BRAINLESS:
	case SPELL_KIND_UNATTRACTIVE:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_ENERGY_DRAIN:
	case SPELL_KIND_SLOW:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_HUNGER:
	case SPELL_KIND_CANCELLATION:
	case SPELL_KIND_ENC_MAX_N:
/* SUM */
	case SPELL_KIND_SUM_MIN_N:
	case SPELL_KIND_CREATE_UNDEAD:
	case SPELL_KIND_SUMMON_MONSTER:
	case SPELL_KIND_DISMISSAL:
	case SPELL_KIND_SUM_MAX_N:
/* PRI */
	case SPELL_KIND_PRI_MIN_N:
		break;
	case SPELL_KIND_CURE_HP_LIGHT:
	case SPELL_KIND_CURE_HP_MODERATE:
	case SPELL_KIND_CURE_HP_SERIOUS:
	case SPELL_KIND_CURE_HP_MAX:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_CURE_MP:
	case SPELL_KIND_TRANSFER_MP:
	case SPELL_KIND_REGENERATION:
	case SPELL_KIND_RESTORE_EXPERIENCE:
	case SPELL_KIND_RESURRECTION:
		break;
	case SPELL_KIND_HEAL:
	case SPELL_KIND_CURE_STATUS:
	case SPELL_KIND_CURE_STONE:
	case SPELL_KIND_CURE_PARALYZE:
	case SPELL_KIND_CURE_POISON:
	case SPELL_KIND_CURE_CONFUSION:
	case SPELL_KIND_CURE_BLINDNESS:
	case SPELL_KIND_CURE_SLEEP:
	case SPELL_KIND_CURE_SILENCE:
	case SPELL_KIND_CURE_FEAR:
	case SPELL_KIND_CURE_HALLUCINATION:
	case SPELL_KIND_CURE_CHARM:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_PROTECTION:
		break;
	case SPELL_KIND_RESIST_PHYSICAL:
	case SPELL_KIND_RESIST_HEAT:
	case SPELL_KIND_RESIST_COLD:
	case SPELL_KIND_RESIST_ACID:
	case SPELL_KIND_RESIST_MIND:
	case SPELL_KIND_RESIST_ELECTRICITY:
	case SPELL_KIND_RESIST_POISON:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_BLESS:
		break;
	case SPELL_KIND_REMOVE_CURSE:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_DISPEL_UNDEAD:
		if( (trgt != TRGT_KIND_MBR) && (trgt != TRGT_KIND_MNSTR) )
			return FALSE;
		break;
	case SPELL_KIND_SANCTUARY:
	case SPELL_KIND_WISH:
	case SPELL_KIND_PRI_MAX_N:
/* SHA */
/* BAR */
/* NIN */
	case SPELL_KIND_NIN_MIN_N:
	case SPELL_KIND_TYPHOON:
	case SPELL_KIND_CONFLAGRATION:
	case SPELL_KIND_EARTHQUAKE:
	case SPELL_KIND_THUNDERCLOUD:
	case SPELL_KIND_INUNDATION:
	case SPELL_KIND_SUBSTITUTE:
	case SPELL_KIND_BURNING_HANDS:
	case SPELL_KIND_NIN_MAX_N:
/* ANC */
	case SPELL_KIND_ANC_MIN_N:
	case SPELL_KIND_NOTHING:
	case SPELL_KIND_ANC_MAX_N:
/* end */
	case SPELL_KIND_MAX_N:
		break;
	}

	return TRUE;
}

/**/

bool_t	chk_can_chr_cast( chr_t *chr, spell_kind_t kind )
{
	cast_tab_t	*tab;

	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	tab = get_cast_tab( chr, kind );
	if( tab == NULL )
		return FALSE;

	return tab->flg_cast;
}

/**/

bool_t	set_can_chr_cast( chr_t *chr, spell_kind_t kind, bool_t flg )
{
	cast_tab_t	*tab;

	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	tab = get_cast_tab( chr, kind );
	if( tab == NULL )
		return FALSE;

	tab->flg_cast = flg;

	if( flg ){
		print_msg( FLG_NULL, MSG_LEARN_SPELL,
				chr->name, get_spell_name( kind ) );
	} else {
		print_msg( FLG_NULL, MSG_FORGET_SPELL,
				chr->name, get_spell_name( kind ) );
	}

	return tab->flg_cast;
}

/**/

char	*get_spell_vfx_str( spell_kind_t spell_kind )
{
	switch( spell_kind ){
	case SPELL_KIND_NULL:
/* MAG */
	case SPELL_KIND_MAG_MIN_N:
	case SPELL_KIND_LIGHT:
	case SPELL_KIND_DARKNESS:
	case SPELL_KIND_TELEPORT_PARTY:
	case SPELL_KIND_TELEPORT:
	case SPELL_KIND_RECALL:
		break;
	case SPELL_KIND_KNOCK:
		return "+'";
	case SPELL_KIND_LOCK:
		return "+^";
	case SPELL_KIND_DISARM_TRAP:
		return "^*";
	case SPELL_KIND_DISPEL_MAGIC:
	case SPELL_KIND_MIRROR_IMAGE:
	case SPELL_KIND_ANIMATE_OBJECTS:
	case SPELL_KIND_SHELTER:
	case SPELL_KIND_CREATE_FOOD:
	case SPELL_KIND_IDENTIFY_ITEM:
	case SPELL_KIND_SEARCHING:
	case SPELL_KIND_ANALYZE_DWEOMER:
	case SPELL_KIND_DETECT_ITEM:
	case SPELL_KIND_DETECT_DOORS:
	case SPELL_KIND_DETECT_TRAPS:
	case SPELL_KIND_DETECT_MAGIC:
	case SPELL_KIND_DETECT_MONSTER:
	case SPELL_KIND_SENSE_INVISIBLE:
	case SPELL_KIND_FLY:
	case SPELL_KIND_FEATHER_FALL:
	case SPELL_KIND_VANISH:
	case SPELL_KIND_DARKVISION:
	case SPELL_KIND_PASSWALL:
	case SPELL_KIND_POLYMORPH_OTHER:
	case SPELL_KIND_POLYMORPH_SELF:
	case SPELL_KIND_STEALTH:
	case SPELL_KIND_MAG_MAX_N:
/* SOR */
	case SPELL_KIND_SOR_MIN_N:
		break;
	case SPELL_KIND_MAGIC_MISSILE:
		return "||";
	case SPELL_KIND_FIRE_BALL:
		return "oo";
	case SPELL_KIND_ICE_BLIZZARD:
		return "~~";
	case SPELL_KIND_ACID_RAIN:
		return "//";
	case SPELL_KIND_MIND_STORM:
		return "@@";
	case SPELL_KIND_LIGHTNING_BOLT:
		return "<<";
	case SPELL_KIND_POISON_CLOUD:
		return "Oo";
	case SPELL_KIND_DEATH_SPELL:
		return "XX";
	case SPELL_KIND_MAGE_ARMOR:
	case SPELL_KIND_MAGIC_SHIELD:
	case SPELL_KIND_STONESKIN:
	case SPELL_KIND_IRON_BODY:
	case SPELL_KIND_SPELL_RESISTANCE:
	case SPELL_KIND_COUNTER_MAGIC:
	case SPELL_KIND_STONE:
	case SPELL_KIND_PARALYZE:
	case SPELL_KIND_POISON:
	case SPELL_KIND_CONFUSION:
	case SPELL_KIND_BLINDNESS:
	case SPELL_KIND_SLEEP:
	case SPELL_KIND_SILENCE:
	case SPELL_KIND_FEAR:
	case SPELL_KIND_HALLUCINATION:
	case SPELL_KIND_CHARM:
	case SPELL_KIND_SOR_MAX_N:
/* ENC */
	case SPELL_KIND_ENC_MIN_N:
		break;
	case SPELL_KIND_SHARPNESS:
	case SPELL_KIND_STRENGTH:
	case SPELL_KIND_QUICKNESS:
	case SPELL_KIND_WISE:
	case SPELL_KIND_BRAINY:
	case SPELL_KIND_ATTRACTIVE:
	case SPELL_KIND_POWER_UP_HP:
	case SPELL_KIND_HASTE:
		return "@+";
	case SPELL_KIND_DULLNESS:
	case SPELL_KIND_WEAKNESS:
	case SPELL_KIND_SLOWNESS:
	case SPELL_KIND_FOOLISH:
	case SPELL_KIND_BRAINLESS:
	case SPELL_KIND_UNATTRACTIVE:
	case SPELL_KIND_ENERGY_DRAIN:
	case SPELL_KIND_SLOW:
		return "@-";
	case SPELL_KIND_HUNGER:
	case SPELL_KIND_CANCELLATION:
	case SPELL_KIND_ENC_MAX_N:
/* SUM */
	case SPELL_KIND_SUM_MIN_N:
	case SPELL_KIND_CREATE_UNDEAD:
	case SPELL_KIND_SUMMON_MONSTER:
	case SPELL_KIND_DISMISSAL:
	case SPELL_KIND_SUM_MAX_N:
/* PRI */
	case SPELL_KIND_PRI_MIN_N:
		break;
	case SPELL_KIND_CURE_HP_LIGHT:
		return "+";
	case SPELL_KIND_CURE_HP_MODERATE:
		return "+!";
	case SPELL_KIND_CURE_HP_SERIOUS:
		return "+!!";
	case SPELL_KIND_CURE_HP_MAX:
		return "+!!!";
	case SPELL_KIND_REGENERATION:
	case SPELL_KIND_CURE_MP:
	case SPELL_KIND_TRANSFER_MP:
	case SPELL_KIND_RESTORE_EXPERIENCE:
		return "+?";
	case SPELL_KIND_RESURRECTION:
		break;
	case SPELL_KIND_HEAL:
	case SPELL_KIND_CURE_STATUS:
	case SPELL_KIND_CURE_STONE:
	case SPELL_KIND_CURE_PARALYZE:
	case SPELL_KIND_CURE_POISON:
	case SPELL_KIND_CURE_CONFUSION:
	case SPELL_KIND_CURE_BLINDNESS:
	case SPELL_KIND_CURE_SLEEP:
	case SPELL_KIND_CURE_SILENCE:
	case SPELL_KIND_CURE_FEAR:
	case SPELL_KIND_CURE_HALLUCINATION:
	case SPELL_KIND_CURE_CHARM:
		return "+%";
	case SPELL_KIND_PROTECTION:
	case SPELL_KIND_RESIST_PHYSICAL:
	case SPELL_KIND_RESIST_HEAT:
	case SPELL_KIND_RESIST_COLD:
	case SPELL_KIND_RESIST_ACID:
	case SPELL_KIND_RESIST_MIND:
	case SPELL_KIND_RESIST_ELECTRICITY:
	case SPELL_KIND_RESIST_POISON:
		return "+[";
	case SPELL_KIND_BLESS:
	case SPELL_KIND_REMOVE_CURSE:
		break;
	case SPELL_KIND_DISPEL_UNDEAD:
		return "+Z";
	case SPELL_KIND_SANCTUARY:
	case SPELL_KIND_WISH:
	case SPELL_KIND_PRI_MAX_N:
/* SHA */
/* BAR */
/* NIN */
	case SPELL_KIND_NIN_MIN_N:
	case SPELL_KIND_TYPHOON:
	case SPELL_KIND_CONFLAGRATION:
	case SPELL_KIND_EARTHQUAKE:
	case SPELL_KIND_THUNDERCLOUD:
	case SPELL_KIND_INUNDATION:
	case SPELL_KIND_SUBSTITUTE:
	case SPELL_KIND_BURNING_HANDS:
	case SPELL_KIND_NIN_MAX_N:
/* ANC */
	case SPELL_KIND_ANC_MIN_N:
	case SPELL_KIND_NOTHING:
	case SPELL_KIND_ANC_MAX_N:
/* end */
	case SPELL_KIND_MAX_N:
		break;
	}

	return "**";
}

/**/

cast_tab_t	*get_cast_tab( chr_t *chr, spell_kind_t kind )
{
	long	m;
	spell_kind_t	k;

	if( chr == NULL )
		return NULL;

	m = chr->ls_mbr_n;
	for( k = SPELL_KIND_NULL + 1; k < SPELL_KIND_MAX_N; k++ ){
		if( cast_tab[m][k].kind == SPELL_KIND_NULL )
			break;
		if( cast_tab[m][k].kind == SPELL_KIND_MAX_N )
			break;

		if( cast_tab[m][k].kind == kind )
			return &(cast_tab[m][k]);
	}

	return NULL;
}

/**/

char	*get_spell_name( spell_kind_t kind )
{
	switch( kind ){
	case SPELL_KIND_NULL:
		return NULL;
/* MAG */
	case SPELL_KIND_MAG_MIN_N:
		return NULL;
	case SPELL_KIND_LIGHT:
		return MSG_SPELL_LIGHT;
	case SPELL_KIND_DARKNESS:
		return MSG_SPELL_DARKNESS;
	case SPELL_KIND_TELEPORT_PARTY:
		return MSG_SPELL_TELEPORT_PARTY;
	case SPELL_KIND_TELEPORT:
		return MSG_SPELL_TELEPORT;
	case SPELL_KIND_RECALL:
		return MSG_SPELL_RECALL;
	case SPELL_KIND_KNOCK:
		return MSG_SPELL_KNOCK;
	case SPELL_KIND_LOCK:
		return MSG_SPELL_LOCK;
	case SPELL_KIND_DISARM_TRAP:
		return MSG_SPELL_DISARM_TRAP;
	case SPELL_KIND_DISPEL_MAGIC:
		return MSG_SPELL_DISPEL_MAGIC;
	case SPELL_KIND_MIRROR_IMAGE:
		return MSG_SPELL_MIRROR_IMAGE;
	case SPELL_KIND_ANIMATE_OBJECTS:
		return MSG_SPELL_ANIMATE_OBJECTS;
	case SPELL_KIND_SHELTER:
		return MSG_SPELL_SHELTER;
	case SPELL_KIND_CREATE_FOOD:
		return MSG_SPELL_CREATE_FOOD;
	case SPELL_KIND_IDENTIFY_ITEM:
		return MSG_SPELL_IDENTIFY_ITEM;
	case SPELL_KIND_SEARCHING:
		return MSG_SPELL_SEARCHING;
	case SPELL_KIND_ANALYZE_DWEOMER:
		return MSG_SPELL_ANALYZE_DWEOMER;
	case SPELL_KIND_DETECT_MAGIC:
		return MSG_SPELL_DETECT_MAGIC;
	case SPELL_KIND_DETECT_ITEM:
		return MSG_SPELL_DETECT_ITEM;
	case SPELL_KIND_DETECT_DOORS:
		return MSG_SPELL_DETECT_DOORS;
	case SPELL_KIND_DETECT_TRAPS:
		return MSG_SPELL_DETECT_TRAPS;
	case SPELL_KIND_DETECT_MONSTER:
		return MSG_SPELL_DETECT_MONSTER;
	case SPELL_KIND_SENSE_INVISIBLE:
		return MSG_SPELL_SENSE_INVISIBLE;
	case SPELL_KIND_FLY:
		return MSG_SPELL_FLY;
	case SPELL_KIND_FEATHER_FALL:
		return MSG_SPELL_FEATHER_FALL;
	case SPELL_KIND_VANISH:
		return MSG_SPELL_VANISH;
	case SPELL_KIND_DARKVISION:
		return MSG_SPELL_DARKVISION;
	case SPELL_KIND_PASSWALL:
		return MSG_SPELL_PASSWALL;
	case SPELL_KIND_POLYMORPH_OTHER:
		return MSG_SPELL_POLYMORPH_OTHER;
	case SPELL_KIND_POLYMORPH_SELF:
		return MSG_SPELL_POLYMORPH_SELF;
	case SPELL_KIND_STEALTH:
		return MSG_SPELL_STEALTH;
	case SPELL_KIND_MAG_MAX_N:
		return NULL;
/* SOR */
	case SPELL_KIND_SOR_MIN_N:
		return NULL;
	case SPELL_KIND_MAGIC_MISSILE:
		return MSG_SPELL_MAGIC_MISSILE;
	case SPELL_KIND_FIRE_BALL:
		return MSG_SPELL_FIRE_BALL;
	case SPELL_KIND_ICE_BLIZZARD:
		return MSG_SPELL_ICE_BLIZZARD;
	case SPELL_KIND_ACID_RAIN:
		return MSG_SPELL_ACID_RAIN;
	case SPELL_KIND_MIND_STORM:
		return MSG_SPELL_MIND_STORM;
	case SPELL_KIND_LIGHTNING_BOLT:
		return MSG_SPELL_LIGHTNING_BOLT;
	case SPELL_KIND_POISON_CLOUD:
		return MSG_SPELL_POISON_CLOUD;
	case SPELL_KIND_DEATH_SPELL:
		return MSG_SPELL_DEATH_SPELL;
	case SPELL_KIND_MAGIC_SHIELD:
		return MSG_SPELL_MAGIC_SHIELD;
	case SPELL_KIND_MAGE_ARMOR:
		return MSG_SPELL_MAGE_ARMOR;
	case SPELL_KIND_STONESKIN:
		return MSG_SPELL_STONESKIN;
	case SPELL_KIND_IRON_BODY:
		return MSG_SPELL_IRON_BODY;
	case SPELL_KIND_SPELL_RESISTANCE:
		return MSG_SPELL_SPELL_RESISTANCE;
	case SPELL_KIND_COUNTER_MAGIC:
		return MSG_SPELL_COUNTER_MAGIC;
	case SPELL_KIND_STONE:
		return MSG_SPELL_STONE;
	case SPELL_KIND_PARALYZE:
		return MSG_SPELL_PARALYZE;
	case SPELL_KIND_BLINDNESS:
		return MSG_SPELL_BLINDNESS;
	case SPELL_KIND_POISON:
		return MSG_SPELL_POISON;
	case SPELL_KIND_CONFUSION:
		return MSG_SPELL_CONFUSION;
	case SPELL_KIND_SILENCE:
		return MSG_SPELL_SILENCE;
	case SPELL_KIND_SLEEP:
		return MSG_SPELL_SLEEP;
	case SPELL_KIND_FEAR:
		return MSG_SPELL_FEAR;
	case SPELL_KIND_HALLUCINATION:
		return MSG_SPELL_HALLUCINATION;
	case SPELL_KIND_CHARM:
		return MSG_SPELL_CHARM;
	case SPELL_KIND_SOR_MAX_N:
		return NULL;
/* ENC */
	case SPELL_KIND_ENC_MIN_N:
		return NULL;
	case SPELL_KIND_SHARPNESS:
		return MSG_SPELL_SHARPNESS;
	case SPELL_KIND_STRENGTH:
		return MSG_SPELL_STRENGTH;
	case SPELL_KIND_QUICKNESS:
		return MSG_SPELL_QUICKNESS;
	case SPELL_KIND_WISE:
		return MSG_SPELL_WISE;
	case SPELL_KIND_BRAINY:
		return MSG_SPELL_BRAINY;
	case SPELL_KIND_ATTRACTIVE:
		return MSG_SPELL_ATTRACTIVE;
	case SPELL_KIND_POWER_UP_HP:
		return MSG_SPELL_POWER_UP_HP;
	case SPELL_KIND_HASTE:
		return MSG_SPELL_HASTE;
	case SPELL_KIND_DULLNESS:
		return MSG_SPELL_DULLNESS;
	case SPELL_KIND_WEAKNESS:
		return MSG_SPELL_WEAKNESS;
	case SPELL_KIND_SLOWNESS:
		return MSG_SPELL_SLOWNESS;
	case SPELL_KIND_FOOLISH:
		return MSG_SPELL_FOOLISH;
	case SPELL_KIND_BRAINLESS:
		return MSG_SPELL_BRAINLESS;
	case SPELL_KIND_UNATTRACTIVE:
		return MSG_SPELL_UNATTRACTIVE;
	case SPELL_KIND_ENERGY_DRAIN:
		return MSG_SPELL_ENERGY_DRAIN;
	case SPELL_KIND_SLOW:
		return MSG_SPELL_SLOW;
	case SPELL_KIND_HUNGER:
		return MSG_SPELL_HUNGER;
	case SPELL_KIND_CANCELLATION:
		return MSG_SPELL_CANCELLATION;
	case SPELL_KIND_ENC_MAX_N:
		return NULL;
/* SUM */
	case SPELL_KIND_SUM_MIN_N:
		return NULL;
	case SPELL_KIND_CREATE_UNDEAD:
		return MSG_SPELL_CREATE_UNDEAD;
	case SPELL_KIND_SUMMON_MONSTER:
		return MSG_SPELL_SUMMON_MONSTER;
	case SPELL_KIND_DISMISSAL:
		return MSG_SPELL_DISMISSAL;
	case SPELL_KIND_SUM_MAX_N:
		return NULL;
/* PRI */
	case SPELL_KIND_PRI_MIN_N:
		return NULL;
	case SPELL_KIND_CURE_HP_LIGHT:
		return MSG_SPELL_CURE_HP_LIGHT;
	case SPELL_KIND_CURE_HP_MODERATE:
		return MSG_SPELL_CURE_HP_MODERATE;
	case SPELL_KIND_CURE_HP_SERIOUS:
		return MSG_SPELL_CURE_HP_SERIOUS;
	case SPELL_KIND_CURE_HP_MAX:
		return MSG_SPELL_CURE_HP_MAX;
	case SPELL_KIND_CURE_MP:
		return MSG_SPELL_CURE_MP;
	case SPELL_KIND_TRANSFER_MP:
		return MSG_SPELL_TRANSFER_MP;
	case SPELL_KIND_REGENERATION:
		return MSG_SPELL_REGENERATION;
	case SPELL_KIND_RESTORE_EXPERIENCE:
		return MSG_SPELL_RESTORE_EXPERIENCE;
	case SPELL_KIND_RESURRECTION:
		return MSG_SPELL_RESURRECTION;
	case SPELL_KIND_HEAL:
		return MSG_SPELL_HEAL;
	case SPELL_KIND_CURE_STATUS:
		return MSG_SPELL_CURE_STATUS;
	case SPELL_KIND_CURE_STONE:
		return MSG_SPELL_CURE_STONE;
	case SPELL_KIND_CURE_PARALYZE:
		return MSG_SPELL_CURE_PARALYZE;
	case SPELL_KIND_CURE_POISON:
		return MSG_SPELL_CURE_POISON;
	case SPELL_KIND_CURE_CONFUSION:
		return MSG_SPELL_CURE_CONFUSION;
	case SPELL_KIND_CURE_BLINDNESS:
		return MSG_SPELL_CURE_BLINDNESS;
	case SPELL_KIND_CURE_SLEEP:
		return MSG_SPELL_CURE_SLEEP;
	case SPELL_KIND_CURE_SILENCE:
		return MSG_SPELL_CURE_SILENCE;
	case SPELL_KIND_CURE_FEAR:
		return MSG_SPELL_CURE_FEAR;
	case SPELL_KIND_CURE_HALLUCINATION:
		return MSG_SPELL_CURE_HALLUCINATION;
	case SPELL_KIND_CURE_CHARM:
		return MSG_SPELL_CURE_CHARM;
	case SPELL_KIND_PROTECTION:
		return MSG_SPELL_PROTECTION;
	case SPELL_KIND_RESIST_PHYSICAL:
		return MSG_SPELL_RESIST_PHYSICAL;
	case SPELL_KIND_RESIST_HEAT:
		return MSG_SPELL_RESIST_HEAT;
	case SPELL_KIND_RESIST_COLD:
		return MSG_SPELL_RESIST_COLD;
	case SPELL_KIND_RESIST_ACID:
		return MSG_SPELL_RESIST_ACID;
	case SPELL_KIND_RESIST_MIND:
		return MSG_SPELL_RESIST_MIND;
	case SPELL_KIND_RESIST_ELECTRICITY:
		return MSG_SPELL_RESIST_ELECTRICITY;
	case SPELL_KIND_RESIST_POISON:
		return MSG_SPELL_RESIST_POISON;
	case SPELL_KIND_BLESS:
		return MSG_SPELL_BLESS;
	case SPELL_KIND_REMOVE_CURSE:
		return MSG_SPELL_REMOVE_CURSE;
	case SPELL_KIND_DISPEL_UNDEAD:
		return MSG_SPELL_DISPEL_UNDEAD;
	case SPELL_KIND_SANCTUARY:
		return MSG_SPELL_SANCTUARY;
	case SPELL_KIND_WISH:
		return MSG_SPELL_WISH;
	case SPELL_KIND_PRI_MAX_N:
		return NULL;
/* SHA */
/* BAR */
/* NIN */
	case SPELL_KIND_NIN_MIN_N:
		return NULL;
	case SPELL_KIND_TYPHOON:
		return MSG_SPELL_TYPHOON;
	case SPELL_KIND_CONFLAGRATION:
		return MSG_SPELL_CONFLAGRATION;
	case SPELL_KIND_EARTHQUAKE:
		return MSG_SPELL_EARTHQUAKE;
	case SPELL_KIND_THUNDERCLOUD:
		return MSG_SPELL_THUNDERCLOUD;
	case SPELL_KIND_INUNDATION:
		return MSG_SPELL_INUNDATION;
	case SPELL_KIND_SUBSTITUTE:
		return MSG_SPELL_SUBSTITUTE;
	case SPELL_KIND_BURNING_HANDS:
		return MSG_SPELL_BURNING_HANDS;
	case SPELL_KIND_NIN_MAX_N:
		return NULL;
/* ANC */
	case SPELL_KIND_ANC_MIN_N:
		return NULL;
	case SPELL_KIND_NOTHING:
		return MSG_SPELL_NOTHING;
	case SPELL_KIND_ANC_MAX_N:
		return NULL;
/* end */
	case SPELL_KIND_MAX_N:
		return NULL;
	}

	return NULL;
}

/**/

spell_tab_t	*get_spell_tab( spell_kind_t kind )
{
	spell_kind_t	n;

	for( n = SPELL_KIND_NULL + 1; n < SPELL_KIND_MAX_N; n++ ){
		if( spell_tab[n].kind == SPELL_KIND_NULL )
			break;
		if( spell_tab[n].kind == SPELL_KIND_MAX_N )
			break;

		if( spell_tab[n].kind == kind )
			return &(spell_tab[n]);
	}

	return NULL;
}

/**/

gold_t	get_price_spell( spell_kind_t kind )
{
	spell_tab_t	*tab;

	tab = get_spell_tab( kind );
	if( tab == NULL )
		return( (gold_t)0 );

	return( (gold_t)tab->price );
}

/**/

