/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: trap.h,v 1.11 2003/11/19 13:19:14 bowkenken Exp $
*****************************************************************/

#ifndef	TRAP_H
#define	TRAP_H

#include	"gmain.h"
#include	"msg.h"

#if	0
# ifndef	D_TEST_TRAP
#  define	D_TEST_TRAP
# endif
#endif

#if	defined( DEBUG ) && defined( D_TEST_TRAP )
# define	TRAP_AVE_N	512
# define	TRAP_MAX_N	1024
#else
# define	TRAP_AVE_N	12
# define	TRAP_MAX_N	128
#endif

typedef enum {
	TRAP_KIND_NULL,
	TRAP_KIND_SLEEP,
	TRAP_KIND_ARW,
	TRAP_KIND_POISON_DARTS,
	TRAP_KIND_BOMB,
	TRAP_KIND_TELEPORT_PARTY,
	TRAP_KIND_TELEPORT,
	TRAP_KIND_MAX_N
} trap_kind_t;

typedef struct {
	trap_kind_t	kind;
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
} trap_tab_t;

typedef struct trap_t {
	struct trap_t	*next, *prev;
	trap_kind_t	kind;
	long	x, y;
	long	lev;
	long	difficulty;
	trap_tab_t	*tab;
} trap_t;

#endif	/* TRAP_H */
