#include <stdio.h>
#include <unistd.h>
#include <X11/StringDefs.h>

#include <X11/Intrinsic.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>

typedef struct  /* XawのWidetを構造体として定義 */
{
	XtAppContext* Context;
	int argc;
	char **argv;
	char* Name;
	XtOrientation Direction;
//	void (*CallbackFunction)( Widget w, XtPointer client, XtPointer called );
} xawWindow;


typedef struct  /* XawのWidetを構造体として定義 */
{
	char* Name;
	WidgetClass Type;
	Widget Parent;
	char* Text;
	int Width;//x
	int Height;//y
	int Left;//x
	int Top;//y
	int Border;
	void (*CallbackFunction)( Widget w, XtPointer client, XtPointer called );
} xawWidet;


/* コールバック関数 */
void Quit( Widget w, XtPointer client, XtPointer called )
{
	exit( 0 );
}

Widget createForm(Widget* form, xawWindow window)
{
	Widget top;

	/* ツールキットの初期化 */
	top = XtVaAppInitialize( window.Context, window.Name, NULL, 0, &window.argc, window.argv, NULL, NULL );
	/*  クラス名       引数のリソース指定を解釈*/
	/* 台紙ウィジットの作成 */            /* ウィジットクラス */
	*form = XtVaCreateManagedWidget( "form", formWidgetClass, top, 
                                   /* ウィジット名 */      /* 親ウィンドウ */
								   /* リソースの指定 */                XtNorientation, window.Direction,
								   /* いくつでもOKなので最後はNULL */  NULL );
	return top;
}

Widget createControl(xawWidet widget)
{
	Widget control;
	control = XtVaCreateManagedWidget( widget.Name, widget.Type, widget.Parent,
								   XtNlabel, widget.Text,
								   XtNwidth, widget.Width, XtNheight, widget.Height,
									/* 縁取り */             XtNborderWidth, widget.Border,
								   /* 配置方法 */           XtNfromHoriz, NULL,
								   /* ウィンドウの左端から */  XtNhorizDistance, widget.Left,
								   /* ウィンドウの上端から */  XtNfromVert, NULL,
														   XtNvertDistance, widget.Top,
								   NULL );
	XtAddCallback( control, XtNcallback, widget.CallbackFunction, NULL );
	return control;
}

int main( int argc, char **argv )
{
	
	XtAppContext app_con;
	Widget this, form, lab;
	
	//Windowのプロパティを設定
	xawWindow window;
	window.Context = &app_con;
	window.argc = argc;
	window.argv = argv;
	window.Name = "Window";
	window.Direction = XtorientVertical;
	//Windowを指定したプロパティを基に作成
	this = createForm(&form,window);

	
	xawWidet myLabel;
	myLabel.Name = "lab";
	myLabel.Type = labelWidgetClass;
	myLabel.Parent = form;
	myLabel.Text = "Athena Widget";
	myLabel.Width = 150;//x
	myLabel.Height = 20;//y
	myLabel.Left = 0;//x
	myLabel.Top = 0;//y
	myLabel.Border = 0;
	
	createControl(myLabel);


	xawWidet quit = {"quit",commandWidgetClass,form,"Quit",50,20,53,105,1,Quit};
    createControl(quit);
	/* 対象ウィンドウ     関数名 */
	
	XtRealizeWidget( this ); /* ウィンドウの具現化。これを呼ばないと表示もしない */
	XtAppMainLoop( app_con ); /* メインループに突入 */
	return 0;
}

