<?php
/**
 * CSS Style Plugin
 *  
 * @author     sonots
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @link       http://lsx.sourceforge.jp/?Plugin%2Fstyle.inc.hp
 * @version    $Id: style.inc.php,v 1.3 2007-06-28 19:02:47Z sonots $
 * @package    plugin
 */

function plugin_style_convert()
{
    $args = func_get_args();
    $end = end($args);
    if (substr($end, -1) == "\r") {
        $body = array_pop($args);
    }
    $options = array(
        'style' => '',
        'class' => '',
        'end'   => FALSE,
    );
    foreach ($args as $arg) {
        list($key, $val) = array_pad(explode('=', $arg, 2), 2, TRUE);
        if (isset($options[$key])) {
            $options[$key] = $val;
        } else {
            $options['style'] = $arg;
        }
    }
    if ($options['end']) return '</div>';
    $options['style'] = htmlspecialchars($options['style']);
    $options['class'] = htmlspecialchars($options['class']);

    $ret = '<div';
    $ret .= ($options['class'] != '') ? ' class="' . $options['class'] . '"' : '';
    $ret .= ($options['style'] != '') ? ' style="' . $options['style'] . '"' : '';
    $ret .= '>';

    if (isset($body)) {
        $body = str_replace("\r", "\n", $body);
        $body = convert_html($body);
        $ret .= "\n" . $body;
        $ret .= '</div>';
    }
    return $ret;
}
?>
