/* Copyright(C) 2004 Brazil

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "senna.h"

#define MAX_BUF_SIZE 0x100000

unsigned char *
get_token(unsigned char *buf)
{
  unsigned char *p;
  for (p = buf; *p && *p != ' ' && *p != '\t' && *p != '\n'; p++);
  while (*p && (*p == ' ' || *p == '\t' || *p == '\n')) { p++; }
  return p;
}

unsigned char *
strip(unsigned char *buf)
{
  unsigned char *p;
  for (p = buf + strlen(buf) - 1; buf < p; p--) {
    if (*p != '\n' && *p != '\t' && *p != ' ') { break; }
    *p = '\0';
  }
  for (p = buf; *p && (*p == ' ' || *p == '\t' || *p == '\n'); p++) ;
  return p;
}

unsigned char *
get_content(unsigned char *fname)
{
  int fd;
  struct stat st;
  unsigned char *buf;
  stat(fname, &st);
  buf = malloc(st.st_size);
  fd = open(fname, O_RDONLY);
  read(fd, buf, st.st_size);
  return buf;
}

int
main(int argc, char **argv)
{
  sen_index *index;
  sen_records *records;
  unsigned char *buf, *p, *q, *content;
  if (argc < 2) {
    fputs("usage: btest indexname\n", stderr);
    return -1;
  }
  sen_init();
  index = sen_index_open(argv[1]);
  if (!index) {
    index = sen_index_create(argv[1], 0, SEN_INDEX_NORMALIZE, 0, sen_enc_default);
  }
  if (!index) {
    fprintf(stderr, "unable to create index '%s'\n",  argv[1]);
    return -1;
  }
  buf = malloc(MAX_BUF_SIZE);
  if (!buf) {
    fputs("unable to allocate memory ", stderr);
    return -1;
  }
  while (!feof(stdin)) {
    fgets(buf, MAX_BUF_SIZE, stdin);
    p = strip(buf);
    switch (*p) {
    case 's' : 
      q = get_token(p);
      records = sen_index_sel(index, q);
      printf("%d hits!!\n", sen_records_nhits(records));
      break;
    case 'l' : 
      q = get_token(p);
      puts("pke");
      content = get_content(q);
      puts("hoge");
      sen_index_upd(index, q, NULL, content);
      puts("iya");
      free(content);
      break;
    case 'd' :
      q = get_token(p);
      content = get_content(q);
      sen_index_upd(index, q, content, NULL);
      free(content);
      break;
    default :
      printf("invalid command '%s'\n", p);
    }
  }
  return 0;
}

