#!/usr/bin/ruby -w
require 'pp'
require 'cgi'

#---------------------------------------------
# Variable
#---------------------------------------------
#HOSTS_FILE="/usr/local/lvs_rrd/hosts"
HOSTS_FILE="/etc/hosts"
RRD_DIR="./rrd"
GRAPH_DIR="./graph"
CGI_NAME=File.basename(__FILE__)

#---------------------------------------------
# Method 
#---------------------------------------------

VS=Dir.glob("#{RRD_DIR}/*.rrd").map {|f| File.basename(f,".rrd") }.sort
@vs_name_title_table=Hash.new

def get_vs_hostname(vs_name)
  if @vs_name_title_table.empty?
    File.open(HOSTS_FILE).each do |line|
      ip_addr , hostname = line.chomp.split(/\s+/).values_at(0,1)
      @vs_name_title_table[ip_addr] = hostname
    end
  end

  %Q!#{@vs_name_title_table[vs_name.split("_")[0]]} #{vs_name.sub("_",":")}!
end

def show_by_type(graph1, graph2=nil)
  if graph2
    puts "<h1>#{graph1} and #{graph2}</h1>"
  else
    puts "<h1>#{graph1}</h1>"
  end

  puts "<table>"
  VS.each do |vs|
    if graph2
      puts %Q!<tr><td><img src="#{GRAPH_DIR}/#{vs}-#{graph1}.png"></td><td><img src="#{GRAPH_DIR}/#{vs}-#{graph2}.png"></td></tr>!
    else
      puts %Q!<img src="#{GRAPH_DIR}/#{vs}-#{graph1}.png">!
    end
  end
  puts "</table>"
end

def show_by_vs
  VS.each do |vs|
    vs_name=get_vs_hostname(vs)
    puts <<"EOS"
<h2>#{vs_name}</h2>
<table>
<tr><td><img src="#{GRAPH_DIR}/#{vs}-conn.png"></td><td><img src="#{GRAPH_DIR}/#{vs}-traffic.png"></td></tr>
<tr><td><img src="#{GRAPH_DIR}/#{vs}-pps.png"></td><td><img src="#{GRAPH_DIR}/#{vs}-pktsize.png"></td></tr>
<tr><td><img src="#{GRAPH_DIR}/#{vs}-bit_per_conn.png"></td><td><img src="#{GRAPH_DIR}/#{vs}-pkt_per_conn.png"></td></tr>
<tr><td><img src="#{GRAPH_DIR}/#{vs}-actconn.png"></td><td><img src="#{GRAPH_DIR}/#{vs}-inactconn.png"></td></tr>
</table>
EOS
  end
end

def show_all_vs(range)
  if range=="d"
    graph_dir = GRAPH_DIR
  else
    graph_dir = "#{GRAPH_DIR}/#{range}"
  end

  puts <<"EOS"
#{gen_link_range("vs_all",range)}</br>
<font size="+2"><b>New Connections per second</b></font></br>
#{gen_img_map("vs_all_conn","#{graph_dir}/vs_all-conn.png")}</br>
<h2>Inbound bps</h2>
#{gen_img_map("vs_all_traffic_recv","#{graph_dir}/vs_all-traffic_recv.png")}</br>
<h2>Outbound bps</h2>
#{gen_img_map("vs_all_traffic_send","#{graph_dir}/vs_all-traffic_send.png")}</br>
<h2>Active Connections</h2>
#{gen_img_map("vs_all_actconn","#{graph_dir}/vs_all-actconn.png")}</br>
<h2>Inactive Connections</h2>
#{gen_img_map("vs_all_inactconn","#{graph_dir}/vs_all-inactconn.png")}</br>
EOS
end

def gen_img_map(query, graph_path)
  %Q!<a href="#{CGI_NAME}?graph_type=#{query}"><img src="#{graph_path}" border="0"></a>!
end

def show_all_vs_fullrange(graph_type)
  #%w( conn traffic_recv traffic_send actconn inactconn )
  puts <<"EOS"
  <h2>day</h2>
  <img src="#{GRAPH_DIR}/vs_all-#{graph_type}.png"></br>
  <h2>week</h2>
  <img src="#{GRAPH_DIR}/w/vs_all-#{graph_type}.png"></br>
  <h2>month</h2>
  <img src="#{GRAPH_DIR}/m/vs_all-#{graph_type}.png"></br>
  <h2>year</h2>
  <img src="#{GRAPH_DIR}/y/vs_all-#{graph_type}.png"></br>
EOS
end

def gen_link_range(graph_type,range)
  str = %Q!&nbsp; [   <a href="#{CGI_NAME}">top</a>!
  str2 =<<"EOS"
  | <a href="#{CGI_NAME}?graph_type=#{graph_type}&range=d">day</a>
  | <a href="#{CGI_NAME}?graph_type=#{graph_type}&range=w">week</a>
  | <a href="#{CGI_NAME}?graph_type=#{graph_type}&range=m">month</a>
  | <a href="#{CGI_NAME}?graph_type=#{graph_type}&range=y">year</a> ]
EOS
  case range
  when "d": str2.sub!("day",  "<b>day</b>")
  when "w": str2.sub!("week", "<b>week</b>")
  when "m": str2.sub!("month","<b>month</b>")
  when "y": str2.sub!("year", "<b>year</b>")
  end

  return str << str2
end

def gen_link(graph_type,str)
  puts %Q!<li><a href="#{CGI_NAME}?graph_type=#{graph_type}">#{str}</a></li>!
end

#---------------------------------------------
# Main
#---------------------------------------------
cgi = CGI.new
print cgi.header("type" => "text/html", "charset" => "UTF-8")

puts <<'END_OF_HEADER'
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css">
<!--
  body { font-family:sans-serif; }
   table, td, th { border: 1px black solid; }
   a:link    { color: #0000cc; text-decoration: none; }
   a:visited { color: #0000cc; text-decoration: none; }
   a:hover   { color: #ff0000; text-decoration: none; }
   a:active  { color: #0000cc; text-decoration: none; }
-->
</style>
<title>LVS Graph</title>
</head>
<body>
END_OF_HEADER

query=cgi.params['graph_type'][0]
range= cgi.params['range'][0] || "d"

case query
when "act-inact_conn"     : show_by_type("actconn","inactconn")
when "conns_traffic"      : show_by_type("conn","traffic")
when "pps_pktsize"        : show_by_type("pps","pktsize")
when "bit_pkt-per_conn"   : show_by_type("bit_per_conn","pkt_per_conn")
when "vs_base"            : show_by_vs
when "vs_all"             : show_all_vs(range)
when "vs_all_conn"        : show_all_vs_fullrange("conn")
when "vs_all_traffic_recv": show_all_vs_fullrange("traffic_recv")
when "vs_all_traffic_send": show_all_vs_fullrange("traffic_send")
when "vs_all_actconn"     : show_all_vs_fullrange("actconn")
when "vs_all_inactconn"   : show_all_vs_fullrange("inactconn")
when "only_conns"         : show_by_type("conn")
when "only_traffic"       : show_by_type("traffic")
when "only_pps"           : show_by_type("pps")
when "only_pktsize"       : show_by_type("pktsize")
when "only_bit-per_conn"  : show_by_type("bit_per_conn")
when "only_pkt-per_conn"  : show_by_type("pkt_per_conn")
when "only_actconn"       : show_by_type("actconn")
when "only_inactconn"     : show_by_type("inactconn")
else
  puts "<h2>#{`hostname`}</h2>"
  puts "<ul>"
  gen_link("vs_all", "All VirtualServer")
  gen_link("vs_base", "Per VirtualServer view")
  puts "</ul>"

  puts "<ul>"
  gen_link("conns_traffic","New Connection per sconds(CPS) and Throughput(BPS)")
  gen_link("act-inact_conn","Concurrent Connections")
  gen_link("pps_pktsize", "Packets per seconds(PPS) and Average packet size")
  gen_link("bit_pkt-per_conn", "Bit/connection and Packet/connection")
  puts "</ul>"

  puts "<ul>"
  gen_link("only_conns","New Connection only")
  gen_link("only_traffic","Throughput only")
  gen_link("only_actconn","Active Connection only")
  gen_link("only_inactconn","Inactive Connection")
  gen_link("only_pps", "PPS only")
  gen_link("only_pktsize", "Packet size only")
  gen_link("only_bit-per_conn", "Bit/connection only")
  gen_link("only_pkt-per_conn", "Packet/connection")
  puts "</ul>"
end
puts "</body></html>"
