unit about;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, JvPcx;

type
  TAboutBox = class(TForm)
    OKButton: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel1: TPanel;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    TabSheet2: TTabSheet;
    Memo1: TMemo;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Panel2: TPanel;
    ProgramIcon: TImage;
    Label1: TLabel;
    Label6: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label2Click(Sender: TObject);
    procedure Label2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Label5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  type lplp = ^Pointer;

function GetFileVersionInfoSize2(lptstrFilename: PAnsiChar; lpdwHandle: LPDWORD): DWORD; stdcall;
function GetFileVersionInfo2(lptstrFilename: PAnsiChar; dwHandle : DWORD; dwLen: DWORD; lpData: Pointer): BOOL; stdcall;
function VerQueryValue2(pBlock: Pointer; lpSubBlock: PAnsiChar; lplpBuffer: lplp; puLen: pUINT): BOOL; stdcall;

var
  AboutBox: TAboutBox;

implementation

uses ShellAPI, ex2explore, Dialogs;

{$R *.DFM}

const
  version   = 'version.dll';

function VerQueryValue2; external version name 'VerQueryValueA';
function GetFileVersionInfoSize2; external version name 'GetFileVersionInfoSizeA';
function GetFileVersionInfo2; external version name 'GetFileVersionInfoA';


procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TAboutBox.Label2Click(Sender: TObject);
begin
   ShellExecute(Handle, 'open', PChar(TLabel(Sender).Caption), nil, nil, SW_SHOWNORMAL)
end;

procedure TAboutBox.Label2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   TLabel(Sender).Font.Color := clRed;
end;

procedure TAboutBox.Label2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   TLabel(Sender).Font.Color := clBlue;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
   Version.Caption := 'Version ' + MetamoSetupVersion;
   Memo1.Text := '';
   Memo1.Lines.Add('MetamoSetup, the Linux Image file utiltiy for Windows 2000 & XP Copyright (C) 2005 Keishi Suenaga');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('This program is origined the explore2fs version 1.00 pre 4 (Copyright (C) 2002  John Newbigin)');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.');

   Memo1.WordWrap := True;

end;
{
    MetamoSetup, the Linux Image file utiltiy for Windows 2000 & XP
    Copyright (C) 2005 Keishi Suenaga.

    This program is origined the explore2fs(Copyright (C) 2002  John Newbigin).

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

procedure TAboutBox.Label5Click(Sender: TObject);
var
   URL : String;
begin
   URL := 'mailto:' + TLabel(Sender).Caption;
   ShellExecute(Handle, 'open', PChar(URL), nil, nil, SW_SHOWNORMAL)
end;



end.

