unit BetterProgressBar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type
  TBetterProgressBar = class(TProgressBar)
  private
    { Private declarations }
    procedure Calculate;
//    property Max;
//    property Min;
  protected
    { Protected declarations }

    fMax : LongInt;
    fPos : LongInt;

    procedure SetRange(R : LongInt);
    function  GetRange : LongInt;

    procedure SetPos(Pos : LongInt);
    function  GetPos : LongInt;

  public
   constructor Create(AOwner: TComponent); override;
   procedure StepIt;
    { Public declarations }
  published
    { Published declarations }
    property Range : LongInt read GetRange write SetRange;
    property LPosition : LongInt read GetPos write SetPos;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TBetterProgressBar]);
end;

constructor TBetterProgressBar.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
   inherited Max := 32768;
   inherited Min := 0;
   fMax := 100;
   fPos := 0;
end;

procedure TBetterProgressBar.SetRange(R : LongInt);
begin
   fMax := R;
   Calculate;
end;

function TBetterProgressBar.GetRange : LongInt;
begin
   Result := fMax;
end;

procedure TBetterProgressBar.SetPos(Pos : LongInt);
begin
   fPos := Pos;
   Calculate;
end;

function TBetterProgressBar.GetPos : LongInt;
begin
   Result := fPos;
end;

procedure TBetterProgressBar.Calculate;
begin
   if fMax > 32768 then
   begin
      inherited Max := 32768;
      inherited Position := Round((fPos * 32768.0) / fMax);
   end
   else
   begin
      inherited Max := fMax;
      inherited Position := fPos;
   end;
end;

procedure TBetterProgressBar.StepIt;
begin
   fPos := fPos + Step;
   Calculate;
//   Refresh;
end;

end.
