;Metamo Linux installer
;Written by NEBOR Regis
;Modified by Dan Aloni (c) 2004
;Midified by Keishi Suenaga (c) 2005

;-------------------------------------
;Good look
  !include "MUI.nsh"
  !include Sections.nsh
  !include "MetamoLinux_def.inc"
  !define PUBLISHER "Metamo Linux project"

  ;General
  Name "Metamo Linux ${VERSION}"
  OutFile "..\MetamoLinux${VERSION}.exe"

  ShowInstDetails show
  ShowUninstDetails show

  ;Folder selection page
  InstallDir "$PROGRAMFILES\MetamoLinux"
  
  ;Get install folder from registry if available
  InstallDirRegKey HKCU "Software\MetamoLinux" ""

  BrandingText "${PUBLISHER}"

  VIAddVersionKey ProductName "Metamo Linux"
  VIAddVersionKey CompanyName "${PUBLISHER}"
  VIAddVersionKey ProductVersion "${VERSION}"
  VIAddVersionKey FileVersion "${VERSION}"
  VIAddVersionKey FileDescription "An optimized virtual Linux system for Windows"
  VIAddVersionKey LegalCopyright "Copyright @ 2005 ${PUBLISHER}"
  VIProductVersion "${LONGVERSION}"

  XPStyle on

; For priority Unpack
  ReserveFile "iDl.ini"
  ReserveFile "WinpcapRedir.ini"
  !insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
 
;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

;--------------------------------
;Pages

  
  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP "header.bmp"
  !define MUI_SPECIALBITMAP "startlogo.bmp"

  !define MUI_COMPONENTSPAGE_SMALLDESC
  
  !define LANG_ENGLISH 1033
  !define LANG_JAPANESE 1041
  LangString METAMO_WELCOMEPAGE_TITLE ${LANG_ENGLISH} "Welcome to the MetamoLinux ${VERSION} Setup Wizard"
  LangString METAMO_WELCOMEPAGE_TITLE ${LANG_JAPANESE} "MetamoLinux ${VERSION} CXg[ւ悤"
  LangString METAMO_WELCOMEPAGE_TEXT ${LANG_ENGLISH} "This wizard will guide you through the installation of Metamo Linux ${VERSION}\r\n\r\n$_CLICK"
  LangString METAMO_WELCOMEPAGE_TEXT ${LANG_JAPANESE} "̃CXg[[Metamo Linux ${VERSION}CXg[܂B\r\n\r\n$_CLICK"
  !define MUI_WELCOMEPAGE_TITLE "$(METAMO_WELCOMEPAGE_TITLE)"
  !define MUI_WELCOMEPAGE_TEXT "$(METAMO_WELCOMEPAGE_TEXT)"
  
  !insertmacro MUI_PAGE_WELCOME

  !insertmacro MUI_PAGE_LICENSE "COPYING"
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
  Page custom WinpcapRedir WinpcapRedirLeave
  !insertmacro MUI_PAGE_INSTFILES

  !define MUI_FINISHPAGE_LINK "Visit the Metamo Linux website"
  !define MUI_FINISHPAGE_LINK_LOCATION "https://sourceforge.jp/projects/m-install/"
  
  !insertmacro MUI_PAGE_FINISH
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  

;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  
;------------------------------------------------------------------------
;------------------------------------------------------------------------
;Custom Setup for image download


Function WinpcapRedirLeave
	
FunctionEnd

Function .onInit

FunctionEnd

;------------------------------------------------------------------------
;------------------------------------------------------------------------
;Installer Sections


Section "MetamoLinux" SecMetamoLinux
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MetamoLinux" "DisplayName" "MetamoLinux"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MetamoLinux" "UninstallString" '"$INSTDIR\Uninstall.exe"'


  ;---------------------------------------------------------------FILES--
  ;----------------------------------------------------------------------
  ; Our Files . If you adds something here, Remember to delete it in 
  ; the uninstall section

  SetOutPath "$INSTDIR"
  File "..\coLinux-console-fltk.exe"
  File "..\coLinux-console-nt.exe"
  File "..\coLinux-net-daemon.exe"
  File "..\colinux-slirp-net-daemon.exe"
  File "..\coLinux-daemon.exe"
  File "..\colinux-debug-daemon.exe"
;  File "..\coLinux-serial-daemon.exe"
  File "..\linux.sys"
  File "..\vmlinux"
  File "..\initrd.gz"
  File "..\vmlinux-modules.tar.gz"
  File "..\README.colinux.txt"
  File "..\cofs.txt"
  File "..\colinux-daemon.txt"
  File "..\news.txt"
  File "..\colinux.bat"
  File "..\metamolinux.bat"
  File "..\esd.exe"
  File "..\esd.bat"
  File "..\bzip2.dll"
  File "..\bzip2.exe"
  File "..\metamolaunch.exe"
  File "..\metamosetup.exe"
  File "..\metamosetup.INI"
  File "..\sakura.exe"
  File /r "..\netdriver"
  File /r "..\shared_disk"
  File /r "..\Xming"
  File /r "..\sakura"
  File /r "..\etc"
  File /r "..\bin"
  File /r "..\tmp"
  CopyFiles /SILENT "$EXEDIR\swap_device.bz2" "$INSTDIR\swap_device.bz2"
  ;Backup config file if present
  IfFileExists "$INSTDIR\default.colinux.xml" XMLEXIST XMLNOTEXIST
XMLEXIST:
  CopyFiles /SILENT "$INSTDIR\default.colinux.xml" "$INSTDIR\default.colinux.xml.old"
XMLNOTEXIST:
  File "..\default.colinux.xml"

  ; Remove kludge from older installations	
  Delete "$INSTDIR\packet.dll"
  Delete "$INSTDIR\wpcap.dll"

  ;--------------------------------------------------------------/FILES--
  ;----------------------------------------------------------------------

  ;Store install folder
  WriteRegStr HKCU "Software\MetamoLinux" "" $INSTDIR
  
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

LangString MSG_DISK_UNCOMP ${LANG_ENGLISH} "Uncompressing Disk Image(Need long time!!)."
LangString MSG_DISK_UNCOMP ${LANG_JAPANESE} "fBXNC[W𓀒iԂ܂j"
Section "Metamo Linux Disk Image" SecDiskImage

  ;---------------------------------------------------------------FILES--
  ;----------------------------------------------------------------------
  ; Our Files . If you adds something here, Remember to delete it in 
  ; the uninstall section
    IfFileExists "$INSTDIR\Debian.ext3.2gb" DISKIMAGEEXIST DISKIMAGENOTEXIST
DISKIMAGENOTEXIST:
    IfFileExists "$EXEDIR\Debian.ext3.2gb.bz2" BZDISKIMAGEEXIST BZDISKIMAGENOTEXIST
BZDISKIMAGEEXIST:
    DetailPrint "$(MSG_DISK_UNCOMP)"
    nsExec::ExecToLog '"$INSTDIR\bzip2" -d -k "$EXEDIR\Debian.ext3.2gb.bz2"'
    Pop $R0 # return value/error/timeout
    DetailPrint "bzip2 returned: $R0"
    Rename $EXEDIR\Debian.ext3.2gb $INSTDIR\Debian.ext3.2gb
BZDISKIMAGENOTEXIST:
DISKIMAGEEXIST:

  ;--------------------------------------------------------------/FILES--
  ;----------------------------------------------------------------------

SectionEnd

Section "coLinux Virtual Ethernet Driver (TAP-Win32)" SeccoLinuxNet
  ;---------------------------------------------------------------FILES--
  ;----------------------------------------------------------------------
  ; Our Files . If you adds something here, Remember to delete it in 
  ; the uninstall section

  SetOutPath "$INSTDIR\netdriver"
  File "..\netdriver\OemWin2k.inf"
  File "..\netdriver\tap0801co.sys"
  File "..\netdriver\tapcontrol.exe"

  ;--------------------------------------------------------------/FILES--
  ;----------------------------------------------------------------------
SectionEnd

Section "coLinux Bridged Ethernet (WinPcap)" SeccoLinuxBridgedNet
  ;---------------------------------------------------------------FILES--
  ;----------------------------------------------------------------------
  ; Our Files . If you adds something here, Remember to delete it in 
  ; the uninstall section

  SetOutPath "$INSTDIR"
  File "..\coLinux-bridged-net-daemon.exe"

  ;--------------------------------------------------------------/FILES--
  ;----------------------------------------------------------------------
SectionEnd

Function WinpcapRedir
  SectionGetFlags ${SeccoLinuxBridgedNet} $R0
  IntOp $R0 $R0 & ${SF_SELECTED}
  IntCmp $R0 ${SF_SELECTED} "" WinpcapEnd WinpcapEnd
  !insertmacro MUI_HEADER_TEXT "Get WinPCAP" "Install Bridged Ethernet WinPCAP dependency"
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "WinpcapRedir.ini"
  WinpcapEnd:
FunctionEnd

;--------------------
;Post-install section

Section -post

;---- Directly from OpenVPN install script , some minor mods

  SectionGetFlags ${SeccoLinuxNet} $R0
  IntOp $R0 $R0 & ${SF_SELECTED}
  IntCmp $R0 ${SF_SELECTED} "" notap notap
    ; TAP install/update was selected.
    ; Should we install or update?
    ; If tapcontrol error occurred, $5 will
    ; be nonzero.
    IntOp $5 0 & 0
    nsExec::ExecToStack '"$INSTDIR\netdriver\tapcontrol.exe" hwids TAP0801co'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "tapcontrol hwids returned: $R0"

    ; If tapcontrol output string contains "TAP" we assume
    ; that TAP device has been previously installed,
    ; therefore we will update, not install.
    Push "TAP"
    Call StrStr
    Pop $R0

    IntCmp $5 0 +1 tapcontrol_check_error tapcontrol_check_error
    IntCmp $R0 -1 tapinstall

 ;tapupdate:
    DetailPrint "TAP-Win32 UPDATE"
    nsExec::ExecToLog '"$INSTDIR\netdriver\tapcontrol.exe" update "$INSTDIR\netdriver\OemWin2k.inf" TAP0801co'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "tapcontrol update returned: $R0"
    Goto tapcontrol_check_error

 tapinstall:
    DetailPrint "TAP-Win32 INSTALL"
    nsExec::ExecToLog '"$INSTDIR\netdriver\tapcontrol.exe" install "$INSTDIR\netdriver\OemWin2k.inf" TAP0801co'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "tapcontrol install returned: $R0"

 tapcontrol_check_error:
    IntCmp $5 +1 notap
    MessageBox MB_OK "An error occurred installing the TAP-Win32 device driver."

 notap:

SectionEnd

;--------------------
;Post-install section

Section -post
    nsExec::ExecToStack '"$INSTDIR\colinux-daemon.exe" --remove-driver'
    Pop $R0 # return value/error/timeout
    nsExec::ExecToStack '"$INSTDIR\colinux-daemon.exe" --install-driver'
    Pop $R0 # return value/error/timeout
SectionEnd

;--------------------
;Post-install section

Section -post
; compleate default.colinux.xml
FileOpen $0 "$INSTDIR\default.colinux.xml" "a"
FileSeek $0 0 END
FileWrite $0 '<block_device index="0" path="\DosDevices\$INSTDIR\Debian.ext3.2gb" enabled="true" /> $\r$\n'
FileWrite $0 '<block_device index="1" path="\DosDevices\$INSTDIR\swap_device" enabled="true" /> $\r$\n'
FileWrite $0 '<cofs_device index="0" path="\DosDevices\$INSTDIR\shared_disk" type="flat" enabled="true" /> $\r$\n'
FileWrite $0 '</colinux> $\r$\n'
FileClose $0
SectionEnd

;--------------------
;Post-install section

Section -post
; uncompress Swap Image File
    IfFileExists "$INSTDIR\swap_device.bz2" SWAPIMAGEEXIST SWAPIMAGENOTEXIST
SWAPIMAGEEXIST:
    DetailPrint "Uncompressing Swap Image."
    nsExec::ExecToLog '"$INSTDIR\bzip2" -d "$INSTDIR\swap_device.bz2"'
    Pop $R0 # return value/error/timeout
    DetailPrint "bzip2 returned: $R0"
SWAPIMAGENOTEXIST:
SectionEnd

;--------------------
;Post-install section

Section -post
; setup INI files
	WriteINIStr "$INSTDIR\metamosetup.INI" "metamosetup" "PasswdFile" "$INSTDIR\etc\passwd"
	WriteINIStr "$INSTDIR\metamosetup.INI" "metamosetup" "GroupFile" "$INSTDIR\etc\group"
SectionEnd

;--------------------
;Post-install section

  LangString MSG_RebootMetamoLinux ${LANG_ENGLISH} "Metamo Linux has been installed succesfully, do you want to reboot now ?"
  LangString MSG_RebootMetamoLinux ${LANG_JAPANESE} "MetamoLinux̃CXg[I, WindowsċN܂H"
  
Section -post
	MessageBox MB_YESNO "$(MSG_RebootMetamoLinux)" IDNO NoReboot
	Reboot
NoReboot:
SectionEnd

;--------------------------------
;Descriptions

  LangString DESC_SecMetamoLinux ${LANG_ENGLISH} "Install MetamoLinux"
  LangString DESC_SecMetamoLinux ${LANG_JAPANESE} "MetamoLinux̃CXg["
  LangString DESC_SecDiskImage ${LANG_ENGLISH} "Install MetamoLinux Disk Image"
  LangString DESC_SecDiskImage ${LANG_JAPANESE} "fBXNC[Wt@C̃CXg["
  LangString DESC_SeccoLinuxNet ${LANG_ENGLISH} "Install coLinux Virtual Ethernet Driver, which allows to create a network link between Linux and Windows"
  LangString DESC_SeccoLinuxNet ${LANG_JAPANESE} "o[`C[TlbghCo[iMetamoLinuxWindowsԂ̃lbg[Nڑ\ɂj"
  LangString DESC_SeccoLinuxBridgedNet ${LANG_ENGLISH} "Install coLinux Bridge Ethernet support, which allows to join the coLinux machine to an existing network"
  LangString DESC_SeccoLinuxBridgedNet ${LANG_Japanese} "ubWC[TlbgT|[gilbg[NMetamLinux}VQ邱Ƃłj"

  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecMetamoLinux} $(DESC_SecMetamoLinux)
    !insertmacro MUI_DESCRIPTION_TEXT ${SecDiskImage} $(DESC_SecDiskImage)    
    !insertmacro MUI_DESCRIPTION_TEXT ${SeccoLinuxNet} $(DESC_SeccoLinuxNet)
    !insertmacro MUI_DESCRIPTION_TEXT ${SeccoLinuxBridgedNet} $(DESC_SeccoLinuxBridgedNet)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section
;--------------------------------


Section "Uninstall"
  DeleteRegValue HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MetamoLinux" "DisplayName"
  DeleteRegValue HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MetamoLinux" "UninstallString"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\MetamoLinux"

  DetailPrint "TAP-Win32 REMOVE"
  nsExec::ExecToLog '"$INSTDIR\netdriver\tapcontrol.exe" remove TAP0801co'
  Pop $R0 # return value/error/timeout
  DetailPrint "tapcontrol remove returned: $R0"

  nsExec::ExecToStack '"$INSTDIR\colinux-daemon.exe" --remove-driver'
  Pop $R0 # return value/error/timeout

  ;---------------------------------------------------------------FILES--
  ;----------------------------------------------------------------------
  ;
  Delete "$INSTDIR\coLinux-console-fltk.exe"
  Delete "$INSTDIR\coLinux-console-nt.exe"
  Delete "$INSTDIR\coLinux-daemon.exe"
  Delete "$INSTDIR\coLinux-net-daemon.exe"
  Delete "$INSTDIR\coLinux-bridged-net-daemon.exe"
  Delete "$INSTDIR\colinux-slirp-net-daemon.exe"
  Delete "$INSTDIR\colinux-debug-daemon.exe"
;  Delete "$INSTDIR\coLinux-serial-daemon.exe"
  Delete "$INSTDIR\linux.sys"
  Delete "$INSTDIR\README.colinux.txt"
  Delete "$INSTDIR\cofs.txt"
  Delete "$INSTDIR\colinux-daemon.txt"
  Delete "$INSTDIR\news.txt"
  Delete "$INSTDIR\vmlinux"
  Delete "$INSTDIR\vmlinux-modules.tar.gz"
  Delete "$INSTDIR\default.coLinux.xml"
  Delete "$INSTDIR\colinux.bat"
  Delete "$INSTDIR\esd.exe"
  Delete "$INSTDIR\initrd.gz"
  Delete "$INSTDIR\metamolinux.bat"
  Delete "$INSTDIR\esd.bat"
  Delete "$INSTDIR\swap_device"
  Delete "$INSTDIR\bzip2.dll"
  Delete "$INSTDIR\bzip2.exe"
  Delete "$INSTDIR\metamolaunch.exe"
  Delete "$INSTDIR\metamolaunch.INI"
  Delete "$INSTDIR\metamosetup.exe"
  Delete "$INSTDIR\metamosetup.INI"
  Delete "$INSTDIR\sakura.exe"
  
  Delete "$INSTDIR\netdriver\OemWin2k.inf"
  Delete "$INSTDIR\netdriver\tap0801co.sys"
  Delete "$INSTDIR\netdriver\tapcontrol.exe"
  
  Delete "$INSTDIR\shared_disk\shared_disk.txt"
  
  ;--------------------------------------------------------------/FILES--
  ;----------------------------------------------------------------------


  Delete "$INSTDIR\Uninstall.exe"
  RMDir "$INSTDIR\netdriver"
  RMDir "$INSTDIR\shared_disk"
  RMDir /r "$INSTDIR\Xming"
  RMDir /r "$INSTDIR\sakura"
  RMDir /r "$INSTDIR\etc"
  RMDir /r "$INSTDIR\tmp"
  RMDir /r "$INSTDIR\bin"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\MetamoLinux"

SectionEnd


; TODO MetamoLinux runtime detection, to kill before install or upgrade

; LEGACY

;====================================================
; StrStr - Finds a given string in another given string.
;               Returns -1 if not found and the pos if found.
;          Input: head of the stack - string to find
;                      second in the stack - string to find in
;          Output: head of the stack
;====================================================
Function StrStr
  Push $0
  Exch
  Pop $0 ; $0 now have the string to find
  Push $1
  Exch 2
  Pop $1 ; $1 now have the string to find in
  Exch
  Push $2
  Push $3
  Push $4
  Push $5

  StrCpy $2 -1
  StrLen $3 $0
  StrLen $4 $1
  IntOp $4 $4 - $3

  StrStr_loop:
    IntOp $2 $2 + 1
    IntCmp $2 $4 0 0 StrStrReturn_notFound
    StrCpy $5 $1 $3 $2
    StrCmp $5 $0 StrStr_done StrStr_loop

  StrStrReturn_notFound:
    StrCpy $2 -1

  StrStr_done:
    Pop $5
    Pop $4
    Pop $3
    Exch $2
    Exch 2
    Pop $0
    Pop $1
FunctionEnd

