#ifndef INCLUDED_FREAD_H
#define INCLUDED_FREAD_H
/*
 *  fread.h:
 *         Prototype and others.
 *
 *  Copyright (C) Taichi Nakamura <pdf30044@biglobe.ne.jp> - Feb 2000
 *
 *
 *  This file is part of m2m, a free MPEG2-Program-Stream player.
 *  It's a frontend of mpeg2dec.
 *    
 *  m2m is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  m2m is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 
 *
 */
#include <stdint.h>
#if HAVE_LOCALE_H
# include <locale.h>
#endif
#if !HAVE_SETLOCALE
# define setlocale(Category, Locale) /* empty */
#endif

#if ENABLE_NLS
# include <libintl.h>
# define _(Text) gettext (Text)
#else
# undef bindtextdomain
# define bindtextdomain(Domain, Directory) /* empty */
# undef textdomain
# define textdomain(Domain) /* empty */
# define _(Text) Text
#endif

#define READ_BLOCK_SIZE 2048
#define READ_LAST_VBLOCK 1024000 // video
#define READ_LAST_LBLOCK 204800 // L-PCM
#define READ_LAST_ABLOCK 204800 // AC3
#define READ_LAST_MBLOCK 204800 // MPEG-AUDIO(not used)

#define M2M_VIDEO_THREAD_ID   0
#define M2M_AUDIO_THREAD_ID   1
#define M2M_DISP_THREAD_ID    2
#define M2M_LPCM_THREAD_ID    4
#define M2M_AC3_THREAD_ID     5
#define M2M_MPG123_THREAD_ID  6

#define IS_FULLSCREEN (commandline_params&1)
#define IS_BG         (commandline_params&2)
#define IS_AUTOSTART  (commandline_params&4)
#define HIDE_CONTROLL (commandline_params&8)
#define DISABLE_MENU  (commandline_params&16)
#define IS_LOOP       (commandline_params&32)
#define IS_ALSA       (commandline_params&256)
#define IS_ESD        (commandline_params&512)
#define SET_COMMANDLINE_PARAMS(X) { uint32_t bak=commandline_params; commandline_params=~0; commandline_params=(X)|bak; }
#define RESET_COMMANDLINE_PARAMS(X) { uint32_t bak=commandline_params; commandline_params=~0; commandline_params=(~(X))&bak; }

#define SET_MIN_TS( TS ,VAL ) { \
    wk_ts= TS ; \
    if( min2 == 0 || wk_ts<min2_ts )  min2=VAL,min2_ts=wk_ts; \
    else if( min1 == 0 || wk_ts<min1_ts ) min1=VAL,min1_ts=wk_ts; \
}

#define PACK_DUMP(B,MSG) fprintf(stderr,"%s:%02x%02x%02x%02x%02x%02x%02x%02x %02x%02x%02x%02x%02x%02x%02x%02x %02x%02x%02x%02x%02x%02x%02x%02x %02x%02x%02x%02x%02x%02x%02x%02x %02x\n",MSG,B[0x00],B[0x01],B[0x02],B[0x03],B[0x04],B[0x05],B[0x06],B[0x07],B[0x08],B[0x09],B[0x0a],B[0x0b],B[0x0c],B[0x0d],B[0x0e],B[0x0f],B[0x10],B[0x11],B[0x12],B[0x13],B[0x14],B[0x15],B[0x16],B[0x17],B[0x18],B[0x19],B[0x1a],B[0x1b],B[0x1c],B[0x1d],B[0x1e],B[0x1f],B[0x20]  );

typedef struct {
  int fd;
  long st; /* sector index */
  long ed; /* sector index */
  uint32_t sts; /* time stamp */
  uint32_t ets; /* time stamp */
  unsigned long int lbnum;
  uint8_t *name;
  uint8_t *addr;
} vob_file_t;

typedef enum {
  STATUS_TO_SEEK = 0, /* to mainloop */
  STATUS_STOP    = 1,
  STATUS_PLAY    = 3,
} play_status_t;

typedef struct m2m_buf_s {
   struct m2m_buf_s * p;
   struct m2m_buf_s * n;
   uint8_t type;
   uint8_t ch;
   int len;
   uint32_t ts;
   uint8_t * pos;
   uint8_t buf[READ_BLOCK_SIZE];
} m2m_buf_t;

#ifdef PREAD
extern unsigned long seekpos=0;
#endif

extern char **file_name ;
extern play_status_t play_status;
extern int m2m_brightness ;
extern pthread_mutex_t play_stat_mutex;
extern pthread_cond_t play_stat_cond;
extern char * device_name;
extern char * esd_host;
extern int title_no;
extern int audio_no;
extern int audio_rate;
extern uint32_t commandline_params;

extern uint32_t ts_v; /* video frame   DTS/PTS */
extern uint32_t ts_a; /* audio(master) PTS  */

/**** indicator and seek ******/
extern int get_number_of_chapter(void);
extern long get_total_vob_length(void);
extern long get_current_value(void);
extern long set_pg(int);
extern void set_current_value(long);
extern void chapter_echo(int,int);
extern long change_program_by_lba( long );
extern long change_program_by_index( int );
extern long change_program_by_offset( int );
extern long change_to_menu_program( void );
extern int find_cell_index_by_lba( __off64_t );
extern void check_cell_step( __off64_t *,int,__off64_t );
/**** threads ******/
extern void m2m_thread_control(int,int);
extern void fill_buffer(uint8_t **,uint8_t **);
extern void *disp_thread( void * );
extern void *video_thread( void * );
extern void *reader_thread( void * );
extern void *audio_lpcm_thread( void * );
/**** mpeg2 decode ******/
extern void mpeg2_decode_current_frame( uint8_t ** ,uint32_t );
extern void mpeg2_backward_frame( uint8_t ** );
extern void display_frame(void *);
extern void reset_and_decode(void);
extern int display_current_frame();
extern void dispframe( uint32_t );
/**** ifo ******/
extern int m2m_init_info(int);
int lba2chapter( __off64_t );
__off64_t chapter_lba( __off64_t ,int );
void chapter2voblist( vob_file_t ** ,int *,int * );
/**** buffer ******/
extern  m2m_buf_t * m2m_new_buffer( int );
extern  m2m_buf_t * m2m_next_buffer( int );
extern void m2m_free_buffer( m2m_buf_t * );
extern void m2m_flush_buffer( int );
/**** audio ******/


#ifdef __i386__
#define GET_DTS(SCT) (SCT[0x01d]<<24l)|(SCT[0x01e]<<16l)|(SCT[0x01f]<<8l)|SCT[0x020]
#define GET_PTS(SCT) (SCT[0x018]<<24l)|(SCT[0x019]<<16l)|(SCT[0x01a]<<8l)|SCT[0x01b]
#else
#define GET_DTS(SCT) *((uint32_t *)(SCT+0x01d))
#define GET_PTS(SCT) *((uint32_t *)(SCT+0x018))
#endif

#endif /* INCLUDED_FREAD_H */
