package map.model;

/**
 * 駅のラベル
 * @author ma38su
 */
public class Station extends Curve implements Label {

	/**
	 * 駅名
	 */
	private String name;

	/**
	 * 駅クラスを生成します
	 * @param name 駅名
	 * @param curve 駅の曲線データ
	 */
	public Station(String name, Curve curve) {
		super(curve.x, curve.y, 0);
		this.name = name;
	}
	public String getName() {
		return this.name;
	}
	public int getX() {
		return (super.x[0] + super.x[super.x.length - 1]) / 2;
	}
	public int getY() {
		return (super.y[0] + super.y[super.y.length - 1]) / 2;		
	}
}
