package storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class CityNameDatabase {

	public String getName(int code) {
		this.p.setPointer(code);
		Pointer entry = this.map.get(this.p);
		if (entry == null) {
			return null;
		}
		String name = null;
		try {
			this.random.seek(entry.pointer);
			name = this.random.readUTF();
		} catch (IOException e) {
			e.printStackTrace();
			name = null;
		}
		return name;
	}

	private RandomAccessFile random;
	private HashMap<Pointer, Pointer> map;
	private final Pointer p;
	
	@SuppressWarnings("unchecked")
	private HashMap<Pointer, Pointer> readIndexMap(File index) {
		ObjectInputStream in = null;
		HashMap<Pointer, Pointer> map = null;
		if (index.isFile()) {
			try {
				try {
					in = new ObjectInputStream(new FileInputStream(index));
					map = (HashMap<Pointer, Pointer>) in.readObject();
				} catch (Exception e) {
					this.map = null;
					index.delete();
				} finally {
					if (in != null) {
						in.close();
					}
				}
			} catch (Exception e) {
				map = null;
			}
		}
		return map;
	}

	public CityNameDatabase(String from, String db, String index) throws IOException {
		this.p = new Pointer();
		File disc = new File(db);
		BufferedReader bi = null;
		ObjectOutputStream out = null;
		if (disc.exists()) {
			this.map = this.readIndexMap(new File(index));
		} else {
			if (!disc.getParentFile().isDirectory()) {
				disc.getParentFile().mkdirs();
			}
		}
		if (this.map != null) {
			this.random = new RandomAccessFile(disc, "r");
		} else {
			this.map = new HashMap<Pointer, Pointer>();
			try {
				bi = new BufferedReader(new InputStreamReader(CityNameDatabase.class.getResourceAsStream(from), "SJIS"));
				this.random = new RandomAccessFile(disc, "rw");
				this.random.seek(0);
				this.random.setLength(0);
				String line;
				while ((line = bi.readLine()) != null) {
					String[] param = line.split(",");
					Pointer entry = new Pointer(this.random.getFilePointer());
					this.map.put(new Pointer(param[1]), entry);
					this.random.writeUTF(param[0]);
				}
				File file = new File(index);
				if (file.getParentFile().isDirectory()) {
					file.getParentFile().mkdirs();
				}
				out = new ObjectOutputStream(new FileOutputStream(file));
				out.writeObject(this.map);
				out.flush();
			} finally {
				if (bi != null) {
					bi.close();
				}
				if (out != null) {
					out.close();
				}
			}
		}
	}
}
