package view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

import controller.Controller;

/**
 * ダイアログを生成するクラス
 * @author Masayasu Fujiwara
 */
public class DialogFactory {
	
	/**
	 * バージョン確認します。
	 * @param version バージョン
	 * @param url URL
	 * @param comp コンポーネント
	 * @param controller コントローラ
	 */
	public static void versionDialog(String version, URL url, Component comp, Controller controller) {
		JDialog dialog = new JDialog();
		dialog.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		dialog.setTitle("更新情報");
		dialog.setLayout(new GridLayout(0, 1, 0, 0));
		if (version != null) {
			JPanel panel = new JPanel(new GridLayout(0, 1, 0, 10));
			panel.add(new JLabel("ver."+ version + " が最新です。", SwingConstants.CENTER));
			/**
			 * ファイル名を直接表示する
			 * panel.add(new JTextField(url.toString(), SwingConstants.CENTER));
			 */
			panel.add(new JTextField("http://ma38su.sourceforge.jp/map/download/", SwingConstants.CENTER));
			JCheckBox check = new JCheckBox("起動時に更新情報を確認する", controller.getSetting().isCheckUpdate());
			check.setActionCommand("check");
			check.addActionListener(controller);
			panel.add(check);
			dialog.add(panel);
		} else {
			dialog.add(new JLabel("新しい更新はみつかりませんでした。", SwingConstants.CENTER));
		}
		dialog.setSize(350, 120);
		if (comp != null) {
			dialog.setLocationRelativeTo(comp);
		}
		dialog.setVisible(true);
		dialog.setFocusable(true);
		dialog.setAlwaysOnTop(true);
	}
	
	public static void locationDialog(final MapPanel panel, Controller controller) {
		System.out.println();
		final JDialog dialog = new JDialog();
		dialog.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);
		dialog.setTitle("移動");
		dialog.setLayout(new GridLayout(0, 1, 0, 0));
		dialog.add(new JLabel("経度緯度を指定して移動します。", SwingConstants.CENTER));
		LayoutManager fieldLayout = new FlowLayout(FlowLayout.CENTER, 5, 3);
		JPanel xFieldPanel = new JPanel(fieldLayout);
		final JTextField xField = new JTextField(5);
		xField.setText(Float.toString((int) (controller.getLocationMouseX() * 100) / 100f));
		xFieldPanel.add(new JLabel("経度 :"));
		xFieldPanel.add(xField);

		JPanel yFieldPanel = new JPanel(fieldLayout);
		final JTextField yField = new JTextField(5);
		yField.setText(Float.toString((int) (controller.getLocationMouseY() * 100) / 100f));
		yFieldPanel.add(new JLabel("緯度 :"));
		yFieldPanel.add(yField);

		JPanel fieldPanel = new JPanel(fieldLayout);
		fieldPanel.add(xFieldPanel);
		fieldPanel.add(yFieldPanel);

		JPanel buttonPanel = new JPanel(fieldLayout);
		JButton export = new JButton("移動");
		export.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					double x = Double.parseDouble(xField.getText());
					double y = Double.parseDouble(yField.getText());
					panel.moveToLocation(x, y);
					dialog.setVisible(false);
				} catch (NumberFormatException ex) {
					JOptionPane.showMessageDialog(dialog, "数値を入力してください。", "警告", JOptionPane.ERROR_MESSAGE);
					return;
				}
			}
		});

		JButton cancel = new JButton("取消");
		cancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dialog.setVisible(false);
			}
		});

		buttonPanel.add(export);
		buttonPanel.add(cancel);

		dialog.add(fieldPanel);
		dialog.add(buttonPanel);
		dialog.pack();
		dialog.setLocationRelativeTo(panel);
		dialog.setAlwaysOnTop(true);
		dialog.setVisible(true);
		dialog.setFocusable(true);
	}
}
