package view;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import controller.Controller;

public class MapMenu extends JMenuBar {
	public MapMenu(Controller control) {
		JMenu menu0 = new JMenu("ファイル(F)");
		menu0.setMnemonic(KeyEvent.VK_F);

		JMenu menu1 = new JMenu("探索設定(S)");
		menu1.setMnemonic(KeyEvent.VK_S);

		JMenu menu2 = new JMenu("表示設定(V)");
		menu2.setMnemonic(KeyEvent.VK_V);
		
		JMenu menu3 = new JMenu("移動(M)");
		menu3.setMnemonic(KeyEvent.VK_M);

		JMenu helpMenu = new JMenu("ヘルプ(H)");
		helpMenu.setMnemonic(KeyEvent.VK_H);
		helpMenu.setActionCommand("menu_help");
		helpMenu.addActionListener(control);

		JMenuItem item0_1 = new JMenuItem("印刷");
		item0_1.setActionCommand("print");
		item0_1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P,
				InputEvent.CTRL_DOWN_MASK));

		JMenuItem item0_2 = new JMenuItem("エクスポート");
		item0_2.setActionCommand("export");
		item0_2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,
				InputEvent.CTRL_DOWN_MASK));

		JMenuItem item0_3 = new JMenuItem("終了");
		item0_3.setActionCommand("exit");
		item0_3.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,
				InputEvent.CTRL_DOWN_MASK));

		menu0.add(item0_1);
		menu0.add(item0_2);
		menu0.addSeparator();
		menu0.add(item0_3);

		JCheckBoxMenuItem item1_1 = new JCheckBoxMenuItem("Dijkstra", false);
		item1_1.setActionCommand("path_dijkstra");
		JCheckBoxMenuItem item1_2 = new JCheckBoxMenuItem("A*", true);
		item1_2.setActionCommand("path_a*");
		JCheckBoxMenuItem item1_3 = new JCheckBoxMenuItem("高速道路", true);
		item1_3.setActionCommand("highway");

		ButtonGroup group = new ButtonGroup();
		group.add(item1_1);
		group.add(item1_2);

		menu1.add(item1_1);
		menu1.add(item1_2);
		menu1.addSeparator();
		menu1.add(item1_3);

		JMenu item2_1 = new JMenu("ラベル表示");

		JCheckBoxMenuItem item2_1_1 = new JCheckBoxMenuItem("駅", true);
		item2_1_1.setActionCommand("labelStation");
		JCheckBoxMenuItem item2_1_2 = new JCheckBoxMenuItem("地名", true);
		item2_1_2.setActionCommand("labelCity");
		JCheckBoxMenuItem item2_1_3 = new JCheckBoxMenuItem("施設", true);
		item2_1_3.setActionCommand("labelFacility");

		item2_1.add(item2_1_1);
		item2_1.add(item2_1_2);
		item2_1.add(item2_1_3);

		JCheckBoxMenuItem item2_2 = new JCheckBoxMenuItem("頂点表示", false);
		item2_2.setActionCommand("node");
		JCheckBoxMenuItem item2_3 = new JCheckBoxMenuItem("アンチエイリアス", true);
		item2_3.setActionCommand("alias");
		JCheckBoxMenuItem item2_4 = new JCheckBoxMenuItem("水域区間の塗りつぶしβ", false);
		item2_4.setActionCommand("fill");

		menu2.add(item2_1);
		menu2.add(item2_2);
		menu2.add(item2_3);
		menu2.add(item2_4);

		item0_1.addActionListener(control);
		item0_2.addActionListener(control);
		item0_3.addActionListener(control);

		item1_1.addActionListener(control);
		item1_2.addActionListener(control);
		item1_3.addActionListener(control);

		item2_1_1.addActionListener(control);
		item2_1_2.addActionListener(control);
		item2_1_3.addActionListener(control);

		item2_2.addActionListener(control);
		item2_3.addActionListener(control);
		item2_4.addActionListener(control);

		JMenuItem menu3_1 = new JMenuItem("日本全域を表示倍率");
		menu3_1.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, InputEvent.CTRL_DOWN_MASK));
		menu3_1.setActionCommand("move_home");
		menu3_1.addActionListener(control);
		menu3.add(menu3_1);

		JMenuItem menu3_2 = new JMenuItem("数値地図を表示倍率");
		menu3_2.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_COLON, InputEvent.CTRL_DOWN_MASK));
		menu3_2.setActionCommand("move_sdf");
		menu3_2.addActionListener(control);
		menu3.add(menu3_2);

		menu3.addSeparator();
		
		JMenuItem menu3_3 = new JMenuItem("緯度経度を指定して移動");
		menu3_3.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK));
		menu3_3.setActionCommand("move_location");
		menu3_3.addActionListener(control);
		menu3.add(menu3_3);
		

		JMenuItem help01 = new JCheckBoxMenuItem("操作マニュアル", control.getSetting().isManual());
		help01.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F1, InputEvent.CTRL_DOWN_MASK));
		help01.setActionCommand("help");
		help01.addActionListener(control);
		helpMenu.add(help01);

		helpMenu.addSeparator();

		JMenuItem help02 = new JMenuItem("ソフトウェアの更新を確認(O)");
		help02.setMnemonic(KeyEvent.VK_O);
		help02.setActionCommand("version");
		help02.addActionListener(control);
		helpMenu.add(help02);

		final JCheckBoxMenuItem help03 = new JCheckBoxMenuItem("起動時に更新を確認する", control.getSetting().isCheckUpdate());
		help03.setActionCommand("check");
		help03.addActionListener(control);
		helpMenu.add(help03);
		
		control.setUpdateCheck(help03);

		this.add(menu0);
		this.add(menu1);
		this.add(menu2);
		this.add(menu3);
		this.add(helpMenu);
	}
}
