package labeling;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

import map.model.City;
import map.model.Station;


/**
 * そのままの位置にラベルを配置する
 * @author ma38su
 *
 */
public class DefaultLabeling implements Labeling {
	private final Graphics2D g;
	private final Rectangle screen;
	private final float scale;
	private final int height;
	public DefaultLabeling(final Graphics2D g, final Rectangle screen, final int height, final float scale) {
		this.scale = scale;
		this.g = g;
		this.screen = screen;
		this.height = height;
	}
	public void add(final Label[] labels) {
		for(Label data : labels) {
			int x = (int) ((data.getX() - this.screen.x) * this.scale);
			int y = this.height - (int) ((data.getY() - this.screen.y) * this.scale);

			this.g.fillOval(x - 2, y - 2, 4, 4);
			this.g.drawString(data.getName(), x + 2, y - 2);
		}
	}
	
	public void add(Labels labels) {
		for (Point point : labels.getLocation()) {
			int x = (int) ((point.getX() - this.screen.x) * this.scale);
			int y = this.height - (int) ((point.getY() - this.screen.y) * this.scale);

			this.g.fillOval(x - 2, y - 2, 4, 4);
			this.g.drawString(labels.getName(), x + 2, y - 2);			
		}
	}
	/**
	 * 不要
	 */
	public void draw() {
	}
	public void add(String name, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void drawRich() {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void init(Graphics2D g, float scale, int width, int height) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void add(City city, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void set(String city, int x, int y) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void add(Station[] labels) {
		// TODO 自動生成されたメソッド・スタブ
		
	}
	public void switchShadow() {
		// TODO 自動生成されたメソッド・スタブ
		
	}
}
