/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;
import jp.gr.java_conf.dangan.util.lha.DynamicHuffman;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh1Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 60;
    private static final int Threshold = 3;
    BitInputStream in;
    DynamicHuffman huffman;
    int[] offHiLen;
    short[] offHiTable;
    int offHiTableBits;
    DynamicHuffman markHuffman;

    public PreLh1Decoder(InputStream in) {
        if (in != null) {
            this.in = in instanceof BitInputStream ? (BitInputStream)in : new BitInputStream(in);
            this.huffman = new DynamicHuffman(314);
            this.markHuffman = null;
            this.offHiLen = PreLh1Decoder.createLenList();
            try {
                this.offHiTable = StaticHuffman.createTable(this.offHiLen);
            }
            catch (BadHuffmanTableException badHuffmanTableException) {
                // empty catch block
            }
        } else {
            throw new NullPointerException("in");
        }
        this.offHiTableBits = Bits.len(this.offHiTable.length - 1);
    }

    public int readCode() throws IOException {
        int node = this.huffman.childNode(0);
        while (node >= 0) {
            node = this.huffman.childNode(node - (this.in.readBoolean() ? 1 : 0));
        }
        int code = ~node;
        this.huffman.update(code);
        return code;
    }

    public int readOffset() throws IOException {
        short offHi = this.offHiTable[this.in.peekBits(this.offHiTableBits)];
        this.in.skipBits(this.offHiLen[offHi]);
        return offHi << 6 | this.in.readBits(6);
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit * 18 / 8 + 4);
        this.markHuffman = (DynamicHuffman)this.huffman.clone();
    }

    public void reset() throws IOException {
        this.in.reset();
        this.huffman = (DynamicHuffman)this.markHuffman.clone();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return Math.max(this.in.availableBits() / 18 - 4, 0);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.huffman = null;
        this.markHuffman = null;
        this.offHiLen = null;
        this.offHiTable = null;
        this.offHiTableBits = 0;
    }

    public int getDictionarySize() {
        return 4096;
    }

    public int getMaxMatch() {
        return 60;
    }

    public int getThreshold() {
        return 3;
    }

    private static int[] createLenList() {
        int length = 64;
        int[] nArray = new int[7];
        nArray[0] = 3;
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = 24;
        nArray[5] = 48;
        int[] list = nArray;
        int[] LenList = new int[64];
        int index = 0;
        int len = list[index++];
        int i = 0;
        while (i < 64) {
            if (list[index] == i) {
                ++index;
            }
            LenList[i] = ++len;
            ++i;
        }
        return LenList;
    }
}

