package map;

import java.awt.Polygon;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import util.Log;

/**
 * 国土数値情報のデータ読み込むクラス
 * @author ma38s
 */
public class KsjReader {

	private KsjReader() {
	}

	public static void translate() throws IOException {
		Polygon[] polygon = KsjReader.readPolygon("");
		ObjectOutputStream out = null;
		try {
			out = new ObjectOutputStream(new FileOutputStream("./data/prefecture.dat"));
			out.writeObject(polygon);
			out.flush();
		} finally {
			if (out != null) {
				out.close();
			}
		}
	}

	/**
	 * 
	 * @param name 入力ストリーム
	 * @return Polygon配列
	 * @throws IOException 入出力エラー
	 */
	public static Polygon[] readPolygon(String name) throws IOException {
		Polygon[] polygon = null;
		ObjectInputStream in = null;
		try {
			in = new ObjectInputStream(System.class.getResourceAsStream(name));
			polygon = (Polygon[]) in.readObject();
		} catch (ClassNotFoundException e) {
			// TODO
			Log.err(KsjReader.class, e);
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return polygon;
	}
	
	/**
	 * 都道府県内の各市区町村に対応した国土数値情報を読み込む（Serialize）
	 * @param code 都道府県番号
	 * @return 市区町村に対応した国土数値情報の行政界
	 * @throws IOException 入出力エラー
	 * @throws ClassNotFoundException 
	 */
	@SuppressWarnings("unchecked")
	public static Map<Integer, List<Polygon>> readSerializeKsj(String code) throws IOException {
		Map<Integer, List<Polygon>> map = null;
		ObjectInputStream in = null;
		try {
			in = new ObjectInputStream(KsjReader.class.getResourceAsStream("/.data/" + code + "/ksj.dat"));
			map = (LinkedHashMap<Integer, List<Polygon>>) in.readObject();
		} catch (ClassNotFoundException e) {
			throw new IllegalArgumentException(e);
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return map;
	}
}
