package pre.index;
import index.CellBounds;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;


public class CacheCell {
	private SortedMap<Integer, CellBounds> bounds;

	public CacheCell() {
		this.bounds = new TreeMap<Integer, CellBounds>();
	}
	public void add(int code, CellBounds bounds) {
		this.bounds.put(code, bounds);
	}
	public int size() {
		return this.bounds.size();
	}
	
	public void writeDisc(DataOutput disc) throws IOException {
		disc.writeByte(this.bounds.size()); /* セルと重なる領域の数 */
		for (Map.Entry<Integer, CellBounds> entry : this.bounds.entrySet()) {
			disc.writeShort(entry.getKey().intValue());
			CellBounds value = entry.getValue();
			value.writeDisc(disc);
		}
	}
}
