package pre.index;

import index.CellBounds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;

import map.Sdf25kReader;
import map.model.City;
import database.FileDatabase;

/**
 * 市区町村データの中間表現を作成する。
 * cell-boundに市区町村番号毎に出力する。
 * @author ma38su
 */
public class IntersectsSdf25k {
	public static void main(String[] args) throws IOException {
		String mapDir = "d:/java/.digital_map" + File.separatorChar;
		Sdf25kReader factory = new Sdf25kReader(new FileDatabase(mapDir, "/.data/prefecture.csv", null));
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(IntersectsSdf25k.class.getResourceAsStream("/.data/city.csv"), "SJIS"));
			String line;
			RandomAccessFile out = null;
			while ((line = in.readLine()) != null) {
				int code = Integer.parseInt(line.split(",")[1]);
				if (code / 10 != 4348) {
					continue;
				}
				System.out.println("code: "+ code);
				City city = factory.product(code);
				CellBounds cell = new CellBounds(city);
				try {
					out = new RandomAccessFile("d:/java/map/cell-bounds/" + Integer.toString(code) + ".clb", "rw");
					cell.writeDisc(out);
				} finally {
					if (out != null) {
						out.close();
						out = null;
					}
				}
			}
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}
}
