package pre.index;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * 都道府県の外接長方形を計算します。
 * slmファイルの領域から作成します。
 * @author ma38su
 */
public class PrefectureBoundsSDF25K {
	public static void main(String[] args) throws IOException {
		File dir = new File("D:/java/.digital_map/sdf25k/13/");
		int minX = Integer.MAX_VALUE;
		int minY = Integer.MAX_VALUE;
		int maxX = Integer.MIN_VALUE;
		int maxY = Integer.MIN_VALUE;
		for (File subdir : dir.listFiles()) {
			for (File file : subdir.listFiles()) {
				if (file.getName().endsWith(".slm")) {
					System.out.println(file);
					BufferedReader in = null;
					try {
						in = new BufferedReader(new InputStreamReader(new FileInputStream(file), "SJIS"));
						String[] param = in.readLine().split(",");
						int x = (int) ((Long.parseLong(param[0]) / 10) % Integer.MAX_VALUE);
						int y = (int) ((Long.parseLong(param[1]) / 10) % Integer.MAX_VALUE);
						param = in.readLine().split(",");
						int w = Integer.parseInt(param[0]);
						int h = Integer.parseInt(param[1]);
						if (minX > x) {
							minX = x;
						}
						if (minY > y) {
							minY = y;
						}
						if (maxX < x + w) {
							maxX = x + w;
						}
						if (maxY < y + h) {
							maxY = y + h;
						}
					} catch (Exception e) {
						System.out.println(file.getName());
						System.exit(0);
					} finally {
						in.close();
					}
				}
			}
		}
		System.out.printf("%d, %d, %d, %d\n", minX, minY, maxX - minX, maxY - minY);
	}
}
