import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import map.model.City;
import map.store.ChainStore;

/**
 * ローソンの店舗情報を取得するためのクラスです。
 * @author Masayasu Fujiwara
 */
public class LawsonPlugin extends ChainStore {

	/**
	 * 住所解析用のパターン
	 */
	private final Pattern ADDRESS_PARSER;
	
	/**
	 * Pluginロードのためのコンストラクタ
	 * キャッシュディレクトリを設定する必要がある。
	 */
	public LawsonPlugin() {
		super("ローソン");
		this.ADDRESS_PARSER = Pattern.compile("<td class=\".+\">([^\\d<>][^<>]+)</td>");
	}
	
	/**
	 * 市区町村番号からURLを取得する
	 * @param city 市区町村データ
	 * @param page ページ番号
	 * @return URL 店舗情報が掲載されているURL
	 */
	@Override
	protected URL getURL(City city, int page) {
		try {
			String url = "http://map.lawson.co.jp/c/f/?uc=116&page="+ page +"&vp=10&mx=30&admi2%5B%5D="+ (city.getCode() / 1000) + "&admi3%5B%5D="+ city.getCode();
			return new URL(url);
		} catch (MalformedURLException e) {
			return null;
		}
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
