package map.route;


import map.CityMap;
import map.model.Node;

/**
 * 経路探索を行うためのクラス
 * ヒープのコンパレータに距離関数を設定することで、A*アルゴリズムで探索を行う。
 * 設定しなければDijkstraのアルゴリズムにより探索を行う。
 * @author ma38su
 */
public class UnidirectShortestPathSearch implements ShortestPathAlgorithm {
	
	
	/**
	 * Heuristic関数
	 */
	private final HeuristicDistanceFunction heuristic;
	
	/**
	 * 地図データ
	 */
	private final CityMap maps;


	/**
	 * A* algorithm
	 * @param heuristic ヒューリステック関数
	 * @param maps 地図データ
	 */
	public UnidirectShortestPathSearch(HeuristicDistanceFunction heuristic, CityMap maps) {
		this.heuristic = heuristic;
		this.maps = maps;
	}

	/**
	 * 単方向探索によって最短経路探索を行う．
	 * @param start 
	 * @param terminal 
	 * @return 探索を行っているスレッド
	 */
	public SearchThread search(final Node start, final Node terminal) {
		this.maps.clearNode();
		this.maps.dump();
		Heap heap;
		if (this.heuristic == null) {
			heap = new Heap();
		} else {
			heap = new Heap(new HeuristicComparator(this.heuristic, terminal));
		}
		return new UnidirectSearchThread(this.toString(), start, terminal, this.maps, heap);
	}
	
	@Override
	public String toString() {
		if (this.heuristic == null) {
			return "Dijkstra";
		} else {
			return "A* / "+ this.heuristic.toString();
		}
	}
}