/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.gcat.scalc;

class Dms {
    private double degree;
    private int deg;
    private int min;
    private double sec;

    Dms(double degree) {
        this.degree = degree;
        this.deg = (int)degree;
        this.min = (int)((degree - (double)this.deg) * 60.0);
        if (this.min < 0) {
            this.min = 0;
        }
        this.sec = (degree - (double)this.deg - (double)this.min / 60.0) * 3600.0;
        if (this.sec < 0.0) {
            this.sec = 0.0;
        }
    }

    protected int getDeg() {
        return this.deg;
    }

    protected int getMin() {
        return this.min;
    }

    protected double getSec() {
        return this.sec;
    }

    protected double getValue() {
        return (double)this.deg + (double)this.min / 60.0 + this.sec / 3600.0;
    }

    protected String getDMSValue() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.deg);
        sb.append("\u00b0");
        String min_str = "0" + Integer.toString(this.min);
        sb.append(min_str.substring(min_str.length() - 2, min_str.length()));
        sb.append("'");
        String sec_str = Double.toString(this.sec);
        int e_pos = sec_str.indexOf("E");
        if (e_pos > 0) {
            String kt = sec_str.substring(e_pos + 1 + 1);
            StringBuffer sec_sb = new StringBuffer();
            try {
                int kt_s = Integer.parseInt(kt);
                while (kt_s > 0) {
                    sec_sb.append('0');
                    --kt_s;
                }
                int i = 0;
                while (i < sec_str.length()) {
                    char ch = sec_str.charAt(i);
                    if (ch == 'E') break;
                    if (ch != '.') {
                        sec_sb.append(ch);
                    }
                    ++i;
                }
                sec_str = sec_sb.toString();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < Math.min(6, sec_str.length())) {
            char ch = sec_str.charAt(i);
            if (i == 2) {
                sb.append('.');
            }
            if (ch != '.') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }
}

