package store;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.ma38su.util.Log;

import map.model.City;
import map.store.ChainStore;

/**
 * am/pmの店舗情報を取得するクラス
 * @author Masayasu Fujiwara
 */
public class AmpmPlugin extends ChainStore {
	
	private final Pattern ADDRESS_PARSER;
	
	public AmpmPlugin() {
		super("am/pm");
		this.ADDRESS_PARSER = Pattern.compile("<TD class=\"font2\">([^<>]+)</TD>");
	}

	@Override
	protected URL getURL(City city, int page) {
		URL url = null;
		try {
			url = new URL("http://www.mapion.co.jp/c/f?vp=10&p="+ (page * 10 - 9) +"&grp=ampm&uc=21&ob=0&mx=30&bool=admi2code*key1*key2*key3*key4*key5*key6*sales4*sales5*sales7&pg=&sfn=ampm_search-partinfo-list_00&oi=admi3code&admi2code="+ city.getPrefectureCode() +"&enc=sjis&oi=admi3code&ob=0&admi3=" + City.cityFormat(city.getCode()));
		} catch (MalformedURLException e) {
			Log.err(this, e);
		}
		return url;
	}

	@Override
	protected String parseAddress(String input) {
		Matcher matcher = this.ADDRESS_PARSER.matcher(input);
		if (matcher.find()) {
			return matcher.group(1);
		}
		return null;
	}
}
