import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

import tsp.Arrow;
import tsp.Controller;
import tsp.Heap;
import tsp.Node;
import tsp.RouteEntry;
import tsp.TspPanel;
import tsp.Heap.Entry;

public class Main {
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame frame = new JFrame("Christofides");
		frame.setLayout(new BorderLayout());
		final TspPanel panel = new TspPanel();
		Controller controller = new Controller(panel);
		panel.addMouseListener(controller);
		frame.add(panel, BorderLayout.CENTER);
		JPanel subPanel = new JPanel();
		JButton startButton = new JButton("計算開始");
		subPanel.add(startButton);
		startButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clearRoute();
				Set<Node> graph = new HashSet<Node>();
				Set<Node> nodes = new HashSet<Node>();
				Heap heap = new Heap();
				nodes.addAll(panel.getNodes());
				Iterator<Node> itr = nodes.iterator();
				if (itr.hasNext()) {
					Node node = itr.next();
					itr.remove();
					graph.add(node);
					while (!nodes.isEmpty()) {
						for (Node terminal : nodes) {
							double distance = node.getDistance(terminal);
							heap.put(new Arrow(node, terminal), distance);
						}
						Entry entry = heap.poll();
						RouteEntry route = new RouteEntry(entry.getKey());
						route.connect();
						node = route.getTerminal();
						graph.add(node);
						nodes.remove(node);
					}
				}
				Set<Node> set = new HashSet<Node>();
				for (Node node : graph) {
					if (node.getConnection() % 2 != 0) {
						set.add(node);
					}
				}
				System.out.println(set.size());
				while (!set.isEmpty()) {
					RouteEntry route = null;
					double min = Double.POSITIVE_INFINITY;
					for (Node start : set) {
						for (Node terminal : set) {
							if (!start.equals(terminal)) {
								double distance = start.getDistance(terminal);
								if (min > distance) {
									if (!start.hasEdge(terminal)) {
										min = distance;
										route = new RouteEntry(start, terminal);
									}
								}
							}
						}
					}
					if (route == null) {
						System.out.println(set.size());
						min = Double.POSITIVE_INFINITY;
						for (Node start : set) {
							for (Node terminal : set) {
								if (!start.equals(terminal)) {
									double distance = start.getDistance(terminal);
									if (min > distance) {
										min = distance;
										route = new RouteEntry(start, terminal);
									}
								}
							}
						}
						Node start = route.getStart();
						Node terminal = route.getTerminal();
						route = null;
						min = Double.POSITIVE_INFINITY;
						if (start.getConnection() > terminal.getConnection()) {
							for (Node node : start.getEdge()) {
								if (!node.equals(terminal)) {
									double distance = node.getDistance(terminal);
									if (min > distance) {
										min = distance;
										route = new RouteEntry(node, terminal);
									}
								}
							}
							start.disconnect(route.getStart());
							set.remove(start);
						} else {
							for (Node node : terminal.getEdge()) {
								if (!node.equals(start)) {
									double distance = node.getDistance(start);
									if (min > distance) {
										min = distance;
										route = new RouteEntry(node, start);
									}
								}
							}
							terminal.disconnect(route.getStart());
							set.remove(terminal);
						}
					}
					route.connect();
					set.remove(route.getStart());
					set.remove(route.getTerminal());
				}
			}
		});
		JButton clearButton = new JButton("やり直し");
		subPanel.add(clearButton);
		clearButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				panel.clear();
			}
		});

		frame.add(subPanel, BorderLayout.SOUTH);
		frame.setSize(600, 400);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}
