package tsp;

import java.util.HashMap;
import java.util.Map;

/**
 * 有向グラフにおける任意の頂点の距離テーブル
 * @author ma38su
 */
public class DistanceTable {

	/**
	 * 距離取得のためのキャッシュ
	 */
	private RouteEntry cache;
	
	/**
	 * 距離テーブルのマップ
	 */
	private Map<RouteEntry, Double> map;

	public DistanceTable() {
		this(10);
	}

	public DistanceTable(int initialCapacity) {
		this.map = new HashMap<RouteEntry, Double>(initialCapacity);
	}
	
	public void put(RouteEntry route, double value) {
		this.map.put(route, value);
	}

	/**
	 * 始点と終点から距離を取得します。
	 * @param s 始点
	 * @param t 終点
	 * @return 距離
	 */
	public Double get(Node s, Node t) {
		synchronized (this.cache) {
			this.cache.setRoute(s, t);
			return this.map.get(this.cache);
		}
	}
}
