package tsp;

import java.awt.Graphics2D;

/**
 * 有向グラフにおけるルート
 * @author Masayasu Fujiwara
 */
public class RouteEntry extends Arrow {
	public RouteEntry() {
	}
	public RouteEntry(Arrow arrow) {
		super(arrow.start, arrow.terminal);
	}

	public RouteEntry(Node start, Node terminal) {
		super(start, terminal);
	}
	
	public void connect() {
		this.start.connect(this.terminal);
		this.terminal.connect(this.start);
	}
	
	public void setRoute(Node start, Node terminal) {
		this.start = start;
		this.terminal = terminal;
	}
	
	/**
	 * 頂点間に直線を描画します。
	 * @param g Graphics2D
	 * @param num 数字
	 */
	public void draw(Graphics2D g) {
		g.drawLine(this.start.getX(), this.start.getY(), this.terminal.getX(), this.terminal.getY());
	}

	public void draw(Graphics2D g, int num) {
		g.drawLine(this.start.getX(), this.start.getY(), this.terminal.getX(), this.terminal.getY());
		g.drawString(Integer.toString(num), (this.start.getX() + this.terminal.getX()) / 2, (this.start.getY() + this.terminal.getY()) / 2);
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof RouteEntry) {
			RouteEntry entry = (RouteEntry) obj;
			return (this.start.equals(entry.start) && this.terminal.equals(entry.terminal)) || (this.start.equals(entry.terminal) && this.terminal.equals(entry.start));
//			return this.start.equals(entry.start) && this.terminal.equals(entry.terminal);
		}
		return false;
	}

	/**
	 * 2頂点間の距離を計算します。
	 * 値は保持せず、呼び出す度に再計算します。
	 * @return 2頂点間のユークリッド距離
	 */
	public double getDistance() {
		int dx = this.start.getX() - this.terminal.getX();
		int dy = this.start.getY() - this.terminal.getY();
		return Math.sqrt(dx * dx + dy * dy);
	}

	@Override
	public int hashCode() {
		return this.start.hashCode() + this.terminal.hashCode();
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Route[");
		sb.append(this.start);
		sb.append("][");
		sb.append(this.terminal);
		sb.append("]");
		return sb.toString();
	}
}
