package tsp;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

import javax.swing.JComponent;



public class TspPanel extends JComponent {
	private Image offs;

	private Set<Node> nodes;

	public TspPanel() {
		this.nodes = new HashSet<Node>();
		this.routes = new LinkedHashSet<RouteEntry>();
	}

	public void add(int x, int y) {
		if (this.screen.contains(x, y)) {
			this.nodes.add(new Node(x, y));
			this.repaint();
		}
	}

	
	private Set<RouteEntry> routes;

	public Collection<Node> getNodes() {
		return this.nodes;
	}

	public void clearRoute() {
		for (Node node : this.nodes) {
			node.clear();
		}
		this.routes.clear();
		this.repaint();
	}

	public void clear() {
		this.nodes.clear();
		this.routes.clear();
		this.repaint();
	}
	
	private final int MARGIN = 5;
	private Rectangle screen;
	
	@Override
	protected void paintComponent(Graphics g) {
		if (this.offs == null || this.getWidth() != this.offs.getWidth(null) || this.getHeight() != this.offs.getHeight(null)) {
			this.offs = this.createImage(this.getWidth(), this.getHeight());
			this.screen = new Rectangle(this.MARGIN, this.MARGIN, this.getWidth() - this.MARGIN * 2, this.getHeight() - this.MARGIN * 2);
		}
		Graphics2D g2 = (Graphics2D) this.offs.getGraphics();
		g2.setColor(Color.WHITE);
		g2.fill(this.screen);
		g2.setClip(this.screen);
		
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		g2.setColor(Color.BLACK);
//		int count = 0;
//		for (RouteEntry route : this.routes) {
//			g2.setColor(Color.getHSBColor(0.6f, 0.3f, (float) ++count / this.routes.size()));
//			route.draw(g2, count);
//		}
		Set<RouteEntry> set = new HashSet<RouteEntry>();
		for (Node start : this.nodes) {
			for (Node terminal : start.getEdge()) {
				RouteEntry route = new RouteEntry(start, terminal);
				if (!set.contains(route)) {
					set.add(route);
					route.draw(g2);
				}
			}
		}
		for (Node node : this.nodes) {
			if (node.getConnection() % 2 == 0) {
				node.draw(g2, Color.ORANGE);
			} else {
				node.draw(g2, Color.RED);
			}
		}
		g2.setClip(0, 0, this.getWidth(), this.getHeight());
		g2.setColor(Color.BLACK);
		g2.draw(this.screen);
		g.drawImage(this.offs, 0, 0, null);
	}
}
