package tsp.method;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import tsp.Node;
import tsp.TspPanel;

/**
 * cheapest insertionによる巡回セールスマン問題の構築法です。
 * @author ma38su
 */
public class CheapestInsertion implements TspConstruction {
	public List<Node> method(TspPanel panel) {
		Set<Node> nodes = new HashSet<Node>(panel.getNodes());
		List<Node> route = new ArrayList<Node>(nodes.size() + 1);
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node node = itr.next();
			int index = 0;
			while (!nodes.isEmpty()) {
				synchronized (route) {
					route.add(index, node);
				}
				if (nodes.remove(node) && nodes.isEmpty()) {
					break;
				}
				panel.set(route);
				node = null;
				index = -1;
				double min = Double.POSITIVE_INFINITY;
				for (Node n : nodes) {
					Node n0 = route.get(route.size() - 1);
					for (int i = 0; i < route.size(); i++) {
						Node n1 = route.get(i);
						double distance = n0.getDistance(n) + n.getDistance(n1) - n0.getDistance(n1);
						if (min > distance) {
							min = distance;
							index = i;
							node = n;
						}
						n0 = n1;
					}
				}
				assert index != -1;
				assert node != null;
			}
		}
		return route;
	}

	@Override
	public String toString() {
		return "cheapest insertion";
	}
}
