package tsp.method;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import tsp.Node;
import tsp.TspPanel;

/**
 * farthest insertionによる巡回セールスマン問題の構築法です。
 * @author ma38su
 */
public class FartherstInsertion implements TspConstruction {
	public List<Node> method(TspPanel panel) {
		Set<Node> nodes = new HashSet<Node>(panel.getNodes());
		List<Node> route = new ArrayList<Node>(nodes.size() + 1);
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node node = itr.next();
			int index = 0;
			while (!nodes.isEmpty()) {
				route.add(index, node);
				if (nodes.remove(node) && nodes.isEmpty()) {
					break;
				}
				panel.set(route);
				node = null;
				double max = Double.NEGATIVE_INFINITY;
				double min;
				for (Node n : nodes) {
					Node tmp = null;
					min = Double.POSITIVE_INFINITY;
					for (int i = 0; i < route.size(); i++) {
						Node t = route.get(i);
						double distance = n.getDistance(t);
						if (min > distance) {
							min = distance;
							tmp = n;
						}
					}
					assert tmp != null;
					assert min < Double.POSITIVE_INFINITY;
					if (min > max) {
						max = min;
						node = tmp;
					}
				}
				assert node != null;
				min = Double.POSITIVE_INFINITY;
				Node n0 = route.get(route.size() - 1);
				index = -1;
				for (int i = 0; i < route.size(); i++) {
					Node n1 = route.get(i);
					double distance = n0.getDistance(node) + node.getDistance(n1) - n0.getDistance(n1);
					if (min > distance) {
						min = distance;
						index = i;
					}
					n0 = n1;
				}
				assert index != -1;
			}
		}
		return route;
	}

	@Override
	public String toString() {
		return "farthest insertion";
	}
}
