package tsp.method;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import tsp.Node;
import tsp.TspPanel;

/**
 * nearest additionによる巡回セールスマン問題の構築法です。
 * @author ma38su
 */
public class NearestAddtion implements TspConstruction {
	public List<Node> method(TspPanel panel) {
		Set<Node> nodes = new HashSet<Node>(panel.getNodes());
		List<Node> route = new ArrayList<Node>(nodes.size() + 1);
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node node = itr.next();
			int index = 0;
			while (!nodes.isEmpty()) {
				route.add(index, node);
				if (nodes.remove(node) && nodes.isEmpty()) {
					break;
				}
				panel.set(route);
				node = null;
				index = -1;
				double min = Double.POSITIVE_INFINITY;
				for (Node n : nodes) {
					for (int i = 0; i < route.size(); i++) {
						double distance = n.getDistance(route.get(i));
						if (min > distance) {
							min = distance;
							index = i;
							node = n;
						}
					}
				}
				assert index != -1;
				assert node != null;
			}
		}
		return route;
	}

	@Override
	public String toString() {
		return "nearest addition";
	}
}
