package tsp.method;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import tsp.Node;
import tsp.TspPanel;

/**
 * nearest insertionによる巡回セールスマン問題の構築法です。
 * 巡回路に対して最近接頂点を最も最適な位置に挿入します。
 * 最近接頂点をみつけた後、すべての頂点について確認するべきかもしれません。
 * @author ma38su
 */
public class NearestInsetion implements TspConstruction {
	public List<Node> method(TspPanel panel) {
		Set<Node> nodes = new HashSet<Node>(panel.getNodes());
		List<Node> route = new ArrayList<Node>(nodes.size() + 1);
		Iterator<Node> itr = nodes.iterator();
		if (itr.hasNext()) {
			Node node = itr.next();
			int index = 0;
			while (!nodes.isEmpty()) {
				route.add(index, node);
				if (nodes.remove(node) && nodes.isEmpty()) {
					break;
				}
				panel.set(route);
				node = null;
				index = -1;
				double min = Double.POSITIVE_INFINITY;
				for (Node target : nodes) {
					Node n0 = route.get(route.size() - 1);
					for (int i = 0; i < route.size(); i++) {
						Node n1 = route.get(i);
						double distance = target.getDistance(n1);
						if (min > distance) {
							min = distance;
							int i2 = (i + 1) % route.size();
							if (n0.getDistance(target) > target.getDistance(route.get(i2))) {
								index = i2;
							} else {
								index = i;
							}
							node = target;
						}
						n0 = n1;
					}
				}
				assert index != -1;
				assert node != null;
			}
		}
		return route;
	}
	@Override
	public String toString() {
		return "nearest insertion";
	}
}
