package tsp.method;

import java.util.List;

import tsp.Node;

/**
 * 2-Optによる巡回セールスマン問題の改善法です。
 * @author ma38su
 */
public class Opt2 implements TspImprovement {
	public boolean method(List<Node> route) {
		int length = route.size();
		for (int i = 1; i < length - 1; i++) {
			Node s1 = route.get(i - 1);
			Node t1 = route.get(i % length);
			double d1 = s1.getDistance(t1);
			for (int j = i + 2; j <= length; j++) {
				Node s2 = route.get(j - 1);
				Node t2 = route.get(j % length);
				double before = d1 + s2.getDistance(t2);
				double after = s1.getDistance(s2) + t1.getDistance(t2);
				if (before > after) {
					for (int k = 0; k < (j - i) / 2; k++) {
						Node tmp = route.get((k + i) % length);
						route.set((k + i) % length, route.get((j - k - 1) % length));
						route.set((j - k - 1) % length, tmp);
					}
					return true;
				}
			}
		}
		return false;
	}

	@Override
	public String toString() {
		return "2-Opt";
	}
}
