/*
 * Decompiled with CFR 0.152.
 */
package MaceWindu;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaceWindu
extends JFrame {
    SerialPort COM;
    OutputStream ComOut;
    InputStream ComInputStream;
    BufferedReader COMReader;
    String PreviousPortname;
    String PortName;
    String TxString;
    String RecievedString;
    String ConvertedStr;
    String PreviousWriteText;
    String LookAndFeelString;
    String PathString;
    byte[] buffer = new byte[1024];
    byte[] ConvertedByte;
    byte[] RecievedDataBs;
    char ConvertedChar;
    char PressedKeyChar;
    int PressedKeyCode;
    int ConvertedInt;
    int RecievedData;
    int Recieve;
    int TxData;
    int UnsignedTxData;
    int BaudRate = 0;
    int DataBits = 8;
    int StopBits = 1;
    int Parity = 0;
    int HandShake = 0;
    boolean ButtonState = false;
    boolean PressedKeyCheck = false;
    private JDialog AboutDialog;
    private JButton AboutDialogOkButton;
    private JMenuItem AboutMenuItem;
    private JCheckBoxMenuItem AddFormatRepresentationSelectMenuCheckBox;
    private JCheckBoxMenuItem AddNSelectMenuCheckBox;
    private JCheckBoxMenuItem AddRSelectMenuCheckBox;
    public JComboBox BaudRateComboBox;
    private ButtonGroup ChangeLookAndFeelMenuButtonGroup;
    public JComboBox DataBitsComboBox;
    private JMenu FileMenu;
    private JCheckBoxMenuItem Fix8BitSelectMenuCheckBox;
    private JCheckBoxMenuItem FixCapitalLetterSelectMenuCheckBox;
    public JComboBox HandShakeComboBox;
    private JComboBox LafComboBox;
    private JDialog LafDialog;
    private JButton LafDialogApplyButton;
    private JButton LafDialogCloseButton;
    private JMenuItem LafMenuItem;
    private JMenuItem MaceWinduCloseMenuItem;
    public JLabel MsgLabel;
    public JComboBox ParityComboBox;
    public JComboBox PortsComboBox;
    private JRadioButtonMenuItem PressAnyKeySelectMenuButton;
    private JRadioButtonMenuItem PressReturnKeySelectMenuButton;
    private JRadioButtonMenuItem ReadBinSelectMenuButton;
    private JRadioButtonMenuItem ReadDecSelectMenuButton;
    private JMenu ReadFormatSelectMenu;
    private ButtonGroup ReadFormatSelectMenuButtonGroup;
    private JRadioButtonMenuItem ReadHexSelectMenuButton;
    private JRadioButtonMenuItem ReadLineSelectMenuButton;
    private ButtonGroup ReadModeSelectMenuButtonGroup;
    private JRadioButtonMenuItem ReadOctSelectMenuButton;
    private JMenu ReadPreferenceMenu;
    private JRadioButtonMenuItem ReadSelectMenuButton;
    private JRadioButtonMenuItem ReadStrSelectMenuButton;
    private JTextArea RecievedDataTextArea;
    public JComboBox StopBitsComboBox;
    private JMenu ToolsMenu;
    private JButton TxButton;
    private JRadioButtonMenuItem WriteBinSelectMenuButton;
    private JRadioButtonMenuItem WriteDecSelectMenuButton;
    private ButtonGroup WriteFormatSelectMenuButtonGroup;
    private JRadioButtonMenuItem WriteHexSelectMenuButton;
    private JRadioButtonMenuItem WriteOctSelectMenuButton;
    private JMenu WritePreferenceMenu;
    private JRadioButtonMenuItem WriteStrSelectMenuButton;
    private JTextField WriteTextField;
    private ButtonGroup WriteTriggerSelectMenuButtonGroup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;

    public MaceWindu() {
        this.PathString = System.getProperty("java.class.path");
        this.PathString = this.PathString.substring(0, this.PathString.lastIndexOf(File.separator) + 1);
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        this.initComponents();
        this.AvailableComPort();
        this.ReadListenerEnable();
        try {
            this.ChangeLookAndFeel(this.FileRead());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ReadFormatSelectMenuButtonGroup.add(this.ReadStrSelectMenuButton);
        this.ReadFormatSelectMenuButtonGroup.add(this.ReadBinSelectMenuButton);
        this.ReadFormatSelectMenuButtonGroup.add(this.ReadOctSelectMenuButton);
        this.ReadFormatSelectMenuButtonGroup.add(this.ReadDecSelectMenuButton);
        this.ReadFormatSelectMenuButtonGroup.add(this.ReadHexSelectMenuButton);
        this.ReadModeSelectMenuButtonGroup.add(this.ReadSelectMenuButton);
        this.ReadModeSelectMenuButtonGroup.add(this.ReadLineSelectMenuButton);
        this.WriteFormatSelectMenuButtonGroup.add(this.WriteStrSelectMenuButton);
        this.WriteFormatSelectMenuButtonGroup.add(this.WriteBinSelectMenuButton);
        this.WriteFormatSelectMenuButtonGroup.add(this.WriteOctSelectMenuButton);
        this.WriteFormatSelectMenuButtonGroup.add(this.WriteDecSelectMenuButton);
        this.WriteFormatSelectMenuButtonGroup.add(this.WriteHexSelectMenuButton);
        this.WriteTriggerSelectMenuButtonGroup.add(this.PressReturnKeySelectMenuButton);
        this.WriteTriggerSelectMenuButtonGroup.add(this.PressAnyKeySelectMenuButton);
        this.ReadSelectMenuButton.setSelected(true);
        this.ReadStrSelectMenuButton.setSelected(true);
        this.WriteStrSelectMenuButton.setSelected(true);
        this.PressReturnKeySelectMenuButton.setSelected(true);
    }

    private void ChangeLookAndFeel(String LafString) {
        try {
            UIManager.setLookAndFeel(LafString);
            SwingUtilities.updateComponentTreeUI(this);
            SwingUtilities.updateComponentTreeUI(this.LafDialog);
            SwingUtilities.updateComponentTreeUI(this.AboutDialog);
        }
        catch (Exception e) {
            this.MsgLabel.setText("Some Expention While Change LookAndFeel");
        }
    }

    private int ConvertStr2Int(String Strvalue, int Intvalue) {
        try {
            return Integer.parseInt(Strvalue);
        }
        catch (NumberFormatException e) {
            return Intvalue;
        }
    }

    private byte[] toByte(int IntData) {
        byte[] ByteData = new byte[]{(byte)(0xFF & IntData), (byte)(0xFF00 & IntData), (byte)(0xFF0000 & IntData), (byte)(0xFF000000 & IntData)};
        return ByteData;
    }

    private void AvailableComPort() {
        this.PortsComboBox.removeAllItems();
        this.PortsComboBox.addItem("-Ports-");
        Object portID = null;
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        if (portEnum.hasMoreElements()) {
            while (portEnum.hasMoreElements()) {
                CommPortIdentifier currPortId = (CommPortIdentifier)portEnum.nextElement();
                this.PortsComboBox.addItem(currPortId.getName());
            }
            this.PortsComboBox.setSelectedIndex(0);
        } else {
            JOptionPane.showMessageDialog(this.rootPane, "There Is No Available COM Port");
        }
    }

    private void OpenComPort(String port) {
        try {
            CommPortIdentifier comID = CommPortIdentifier.getPortIdentifier((String)port);
            CommPort commPort = comID.open("Com", 2000);
            this.COM = (SerialPort)commPort;
            this.COM.setSerialPortParams(this.BaudRate, this.DataBits, this.StopBits, this.Parity);
            this.COM.setFlowControlMode(this.HandShake);
            this.MsgLabel.setText(this.PortName + " Opened Successfully");
            this.ComboBoxEnSelect(true);
            this.ReadListenerEnable();
            this.ReadEnable();
            this.WriteEnable();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Failed to Open " + this.PortName);
            this.ComboBoxEnSelect(false);
        }
    }

    private void CloseComPort() {
        try {
            this.COM.close();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Failed To Close " + this.PreviousPortname);
        }
    }

    private void ComboBoxEnSelect(boolean i) {
        if (i) {
            this.BaudRateComboBox.setEnabled(true);
            this.DataBitsComboBox.setEnabled(true);
            this.StopBitsComboBox.setEnabled(true);
            this.ParityComboBox.setEnabled(true);
            this.HandShakeComboBox.setEnabled(true);
        } else {
            this.BaudRateComboBox.setEnabled(false);
            this.DataBitsComboBox.setEnabled(false);
            this.StopBitsComboBox.setEnabled(false);
            this.ParityComboBox.setEnabled(false);
            this.HandShakeComboBox.setEnabled(false);
        }
    }

    public void WriteEnable() {
        try {
            this.ComOut = this.COM.getOutputStream();
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error_OutputStream");
        }
    }

    public void ReadEnable() {
        try {
            this.COM.enableReceiveThreshold(1);
            this.ComInputStream = this.COM.getInputStream();
            this.COMReader = new BufferedReader(new InputStreamReader(this.COM.getInputStream()));
        }
        catch (Exception e) {
            this.MsgLabel.setText("Exception In ReadEnable()");
        }
    }

    private void Read() {
        block19: {
            try {
                if (this.ReadStrSelectMenuButton.isSelected()) {
                    try {
                        this.RecievedData = this.ComInputStream.read();
                        this.ConvertedChar = (char)this.RecievedData;
                        this.ConvertedStr = String.valueOf(this.ConvertedChar);
                        this.RecievedDataTextArea.append(this.ConvertedStr);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.RecievedDataTextArea.setCaretPosition(this.RecievedDataTextArea.getText().length());
                    break block19;
                }
                try {
                    this.RecievedData = this.ComInputStream.read();
                    if (this.ReadBinSelectMenuButton.isSelected()) {
                        this.ConvertedStr = Integer.toBinaryString(this.RecievedData);
                        if (this.Fix8BitSelectMenuCheckBox.isSelected()) {
                            while (this.ConvertedStr.length() <= 7) {
                                this.ConvertedStr = "0" + this.ConvertedStr;
                            }
                        }
                        if (this.AddFormatRepresentationSelectMenuCheckBox.isSelected()) {
                            this.ConvertedStr = "0b" + this.ConvertedStr;
                        }
                        this.RecievedDataTextArea.append(this.ConvertedStr + " ");
                    }
                    if (this.ReadOctSelectMenuButton.isSelected()) {
                        this.ConvertedStr = Integer.toOctalString(this.RecievedData);
                        if (this.AddFormatRepresentationSelectMenuCheckBox.isSelected()) {
                            this.ConvertedStr = "0" + this.ConvertedStr;
                        }
                        this.RecievedDataTextArea.append(this.ConvertedStr + " ");
                    }
                    if (this.ReadDecSelectMenuButton.isSelected()) {
                        this.RecievedDataTextArea.append(String.valueOf(this.RecievedData) + " ");
                    }
                    if (this.ReadHexSelectMenuButton.isSelected()) {
                        this.ConvertedStr = Integer.toHexString(this.RecievedData);
                        if (this.FixCapitalLetterSelectMenuCheckBox.isSelected()) {
                            this.ConvertedStr = this.ConvertedStr.toUpperCase();
                        }
                        if (this.Fix8BitSelectMenuCheckBox.isSelected()) {
                            while (this.ConvertedStr.length() == 1) {
                                this.ConvertedStr = "0" + this.ConvertedStr;
                            }
                        }
                        if (this.AddFormatRepresentationSelectMenuCheckBox.isSelected()) {
                            this.ConvertedStr = "0x" + this.ConvertedStr;
                        }
                        this.RecievedDataTextArea.append(this.ConvertedStr + " ");
                    }
                }
                catch (Exception e) {
                    this.MsgLabel.setText("An Error Occured At Read()");
                }
                this.RecievedDataTextArea.setCaretPosition(this.RecievedDataTextArea.getText().length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ReadLine() {
        try {
            while (this.COMReader.ready()) {
                this.RecievedString = this.COMReader.readLine();
                this.RecievedDataTextArea.append(this.RecievedString);
                this.RecievedDataTextArea.setCaretPosition(this.RecievedDataTextArea.getText().length());
            }
        }
        catch (IOException e) {
            this.MsgLabel.setText("An Error Occured At ReadLine()");
        }
    }

    private void ReadListenerEnable() {
        try {
            this.COM.addEventListener((SerialPortEventListener)new SerialPortlistener());
            this.COM.notifyOnDataAvailable(true);
            this.COM.enableReceiveThreshold(1);
        }
        catch (TooManyListenersException e) {
            this.MsgLabel.setText("Error : TooManyListenersException");
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error Occured While ReadListenerEnable");
        }
    }

    private void initComponents() {
        this.LafDialog = new JDialog();
        this.jPanel3 = new JPanel();
        this.LafComboBox = new JComboBox();
        this.LafDialogCloseButton = new JButton();
        this.LafDialogApplyButton = new JButton();
        this.ReadModeSelectMenuButtonGroup = new ButtonGroup();
        this.ReadFormatSelectMenuButtonGroup = new ButtonGroup();
        this.WriteFormatSelectMenuButtonGroup = new ButtonGroup();
        this.WriteTriggerSelectMenuButtonGroup = new ButtonGroup();
        this.ChangeLookAndFeelMenuButtonGroup = new ButtonGroup();
        this.AboutDialog = new JDialog();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.AboutDialogOkButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.RecievedDataTextArea = new JTextArea();
        this.TxButton = new JButton();
        this.PortsComboBox = new JComboBox();
        this.BaudRateComboBox = new JComboBox();
        this.DataBitsComboBox = new JComboBox();
        this.StopBitsComboBox = new JComboBox();
        this.ParityComboBox = new JComboBox();
        this.HandShakeComboBox = new JComboBox();
        this.WriteTextField = new JTextField();
        this.MsgLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.FileMenu = new JMenu();
        this.MaceWinduCloseMenuItem = new JMenuItem();
        this.WritePreferenceMenu = new JMenu();
        this.jMenu4 = new JMenu();
        this.PressReturnKeySelectMenuButton = new JRadioButtonMenuItem();
        this.PressAnyKeySelectMenuButton = new JRadioButtonMenuItem();
        this.jMenu2 = new JMenu();
        this.WriteStrSelectMenuButton = new JRadioButtonMenuItem();
        this.WriteBinSelectMenuButton = new JRadioButtonMenuItem();
        this.WriteOctSelectMenuButton = new JRadioButtonMenuItem();
        this.WriteDecSelectMenuButton = new JRadioButtonMenuItem();
        this.WriteHexSelectMenuButton = new JRadioButtonMenuItem();
        this.AddRSelectMenuCheckBox = new JCheckBoxMenuItem();
        this.AddNSelectMenuCheckBox = new JCheckBoxMenuItem();
        this.ReadPreferenceMenu = new JMenu();
        this.jMenu3 = new JMenu();
        this.ReadSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadLineSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadFormatSelectMenu = new JMenu();
        this.ReadStrSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadBinSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadOctSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadDecSelectMenuButton = new JRadioButtonMenuItem();
        this.ReadHexSelectMenuButton = new JRadioButtonMenuItem();
        this.Fix8BitSelectMenuCheckBox = new JCheckBoxMenuItem();
        this.FixCapitalLetterSelectMenuCheckBox = new JCheckBoxMenuItem();
        this.AddFormatRepresentationSelectMenuCheckBox = new JCheckBoxMenuItem();
        this.ToolsMenu = new JMenu();
        this.LafMenuItem = new JMenuItem();
        this.AboutMenuItem = new JMenuItem();
        this.LafDialog.setDefaultCloseOperation(0);
        this.LafDialog.setTitle("Look And Feel");
        this.LafDialog.setAlwaysOnTop(true);
        this.LafDialog.setBounds(new Rectangle(0, 0, 0, 0));
        this.LafDialog.setCursor(new Cursor(0));
        this.LafDialog.setModal(true);
        this.LafDialog.setResizable(false);
        this.LafComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.LafComboBoxItemStateChanged(evt);
            }
        });
        this.LafDialogCloseButton.setText("Close");
        this.LafDialogCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.LafDialogCloseButtonActionPerformed(evt);
            }
        });
        this.LafDialogApplyButton.setText("Apply");
        this.LafDialogApplyButton.setEnabled(false);
        this.LafDialogApplyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MaceWindu.this.LafDialogApplyButtonMouseClicked(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.LafComboBox, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 340, Short.MAX_VALUE).addComponent(this.LafDialogApplyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.LafDialogCloseButton))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.LafComboBox, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.LafDialogCloseButton).addComponent(this.LafDialogApplyButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout LafDialogLayout = new GroupLayout(this.LafDialog.getContentPane());
        this.LafDialog.getContentPane().setLayout(LafDialogLayout);
        LafDialogLayout.setHorizontalGroup(LafDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        LafDialogLayout.setVerticalGroup(LafDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2));
        this.AboutDialog.setDefaultCloseOperation(0);
        this.AboutDialog.setTitle("About");
        this.AboutDialog.setModal(true);
        this.jLabel1.setFont(new Font("TakaoPGothic", 0, 24));
        this.jLabel1.setText("MaceWindu");
        this.jLabel2.setText("Version : 1.1.0");
        this.AboutDialogOkButton.setText("OK");
        this.AboutDialogOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.AboutDialogOkButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Auther : Simon Kojima");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(127, 127, 127).addComponent(this.jLabel1, -2, 143, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGap(70, 70, 70).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)))).addContainerGap(130, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.AboutDialogOkButton).addGap(175, 175, 175)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jLabel1, -2, 30, -2).addGap(36, 36, 36).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 131, Short.MAX_VALUE).addComponent(this.AboutDialogOkButton).addContainerGap()));
        GroupLayout AboutDialogLayout = new GroupLayout(this.AboutDialog.getContentPane());
        this.AboutDialog.getContentPane().setLayout(AboutDialogLayout);
        AboutDialogLayout.setHorizontalGroup(AboutDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        AboutDialogLayout.setVerticalGroup(AboutDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.setDefaultCloseOperation(3);
        this.setTitle("MaceWindu");
        this.setResizable(false);
        this.jPanel1.setMaximumSize(new Dimension(50000, 50000));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.RecievedDataTextArea.setEditable(false);
        this.RecievedDataTextArea.setColumns(20);
        this.RecievedDataTextArea.setLineWrap(true);
        this.RecievedDataTextArea.setRows(5);
        this.RecievedDataTextArea.setWrapStyleWord(true);
        this.RecievedDataTextArea.setAutoscrolls(false);
        this.RecievedDataTextArea.setCursor(new Cursor(2));
        this.RecievedDataTextArea.setFocusable(false);
        this.jScrollPane1.setViewportView(this.RecievedDataTextArea);
        this.TxButton.setText("Transmitt");
        this.TxButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.TxButtonActionPerformed(evt);
            }
        });
        this.PortsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Ports-"}));
        this.PortsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.PortsComboBoxItemStateChanged(evt);
            }
        });
        this.BaudRateComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Baud Rate-", "300", "600", "1200", "2400", "4800", "9600", "19200", "38400", "57600", "115200"}));
        this.BaudRateComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.BaudRateComboBoxItemStateChanged(evt);
            }
        });
        this.DataBitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Data Bits-", "5", "6", "7", "8"}));
        this.DataBitsComboBox.setSelectedIndex(4);
        this.DataBitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.DataBitsComboBoxItemStateChanged(evt);
            }
        });
        this.StopBitsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Stop Bits-", "1", "1.5", "2"}));
        this.StopBitsComboBox.setSelectedIndex(1);
        this.StopBitsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.StopBitsComboBoxItemStateChanged(evt);
            }
        });
        this.ParityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Parity-", "Even", "Mark", "None", "Odd", "Space"}));
        this.ParityComboBox.setSelectedIndex(3);
        this.ParityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.ParityComboBoxItemStateChanged(evt);
            }
        });
        this.HandShakeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-Hand Shake-", "None", "RTSCTS_IN", "TRSCTS_OUT", "XOnXOff_IN", "XOnXOff_OUT"}));
        this.HandShakeComboBox.setSelectedIndex(1);
        this.HandShakeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MaceWindu.this.HandShakeComboBoxItemStateChanged(evt);
            }
        });
        this.WriteTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MaceWindu.this.WriteTextFieldKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                MaceWindu.this.WriteTextFieldKeyTyped(evt);
            }
        });
        this.MsgLabel.setText("MsgLabel");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.WriteTextField, -2, 763, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.TxButton)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.PortsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BaudRateComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DataBitsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StopBitsComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ParityComboBox, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.HandShakeComboBox, -2, 170, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.MsgLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PortsComboBox, -2, -1, -2).addComponent(this.BaudRateComboBox, -2, -1, -2).addComponent(this.DataBitsComboBox, -2, -1, -2).addComponent(this.StopBitsComboBox, -2, -1, -2).addComponent(this.ParityComboBox, -2, -1, -2).addComponent(this.HandShakeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 304, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.WriteTextField, -2, -1, -2).addComponent(this.TxButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.MsgLabel).addContainerGap(7, Short.MAX_VALUE)));
        this.FileMenu.setText("File");
        this.MaceWinduCloseMenuItem.setText("Exit");
        this.MaceWinduCloseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.MaceWinduCloseMenuItemActionPerformed(evt);
            }
        });
        this.FileMenu.add(this.MaceWinduCloseMenuItem);
        this.jMenuBar1.add(this.FileMenu);
        this.WritePreferenceMenu.setText("Write Preference");
        this.jMenu4.setText("Write Trigger");
        this.PressReturnKeySelectMenuButton.setText("Press Return Key");
        this.jMenu4.add(this.PressReturnKeySelectMenuButton);
        this.PressAnyKeySelectMenuButton.setText("Press Any Key");
        this.jMenu4.add(this.PressAnyKeySelectMenuButton);
        this.WritePreferenceMenu.add(this.jMenu4);
        this.jMenu2.setText("Write Format");
        this.WriteStrSelectMenuButton.setText("String");
        this.WriteStrSelectMenuButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MaceWindu.this.WriteStrSelectMenuButtonStateChanged(evt);
            }
        });
        this.jMenu2.add(this.WriteStrSelectMenuButton);
        this.WriteBinSelectMenuButton.setText("Binary");
        this.jMenu2.add(this.WriteBinSelectMenuButton);
        this.WriteOctSelectMenuButton.setText("Octal");
        this.jMenu2.add(this.WriteOctSelectMenuButton);
        this.WriteDecSelectMenuButton.setText("Decimal");
        this.jMenu2.add(this.WriteDecSelectMenuButton);
        this.WriteHexSelectMenuButton.setText("Hexadecimal");
        this.jMenu2.add(this.WriteHexSelectMenuButton);
        this.WritePreferenceMenu.add(this.jMenu2);
        this.AddRSelectMenuCheckBox.setText("Add \\r");
        this.WritePreferenceMenu.add(this.AddRSelectMenuCheckBox);
        this.AddNSelectMenuCheckBox.setText("Add \\n");
        this.WritePreferenceMenu.add(this.AddNSelectMenuCheckBox);
        this.jMenuBar1.add(this.WritePreferenceMenu);
        this.ReadPreferenceMenu.setText("Read Preference");
        this.jMenu3.setText("Read Mode");
        this.ReadSelectMenuButton.setText("Read");
        this.jMenu3.add(this.ReadSelectMenuButton);
        this.ReadLineSelectMenuButton.setText("ReadLine");
        this.jMenu3.add(this.ReadLineSelectMenuButton);
        this.ReadPreferenceMenu.add(this.jMenu3);
        this.ReadFormatSelectMenu.setText("Read Format");
        this.ReadStrSelectMenuButton.setText("String");
        this.ReadFormatSelectMenu.add(this.ReadStrSelectMenuButton);
        this.ReadBinSelectMenuButton.setText("Binary");
        this.ReadFormatSelectMenu.add(this.ReadBinSelectMenuButton);
        this.ReadOctSelectMenuButton.setText("Octal");
        this.ReadFormatSelectMenu.add(this.ReadOctSelectMenuButton);
        this.ReadDecSelectMenuButton.setText("Decimal");
        this.ReadFormatSelectMenu.add(this.ReadDecSelectMenuButton);
        this.ReadHexSelectMenuButton.setText("Hexadecimal");
        this.ReadFormatSelectMenu.add(this.ReadHexSelectMenuButton);
        this.ReadPreferenceMenu.add(this.ReadFormatSelectMenu);
        this.Fix8BitSelectMenuCheckBox.setSelected(true);
        this.Fix8BitSelectMenuCheckBox.setText("Fix to 8bit");
        this.ReadPreferenceMenu.add(this.Fix8BitSelectMenuCheckBox);
        this.FixCapitalLetterSelectMenuCheckBox.setSelected(true);
        this.FixCapitalLetterSelectMenuCheckBox.setText("Fix to Capital Letter");
        this.ReadPreferenceMenu.add(this.FixCapitalLetterSelectMenuCheckBox);
        this.AddFormatRepresentationSelectMenuCheckBox.setSelected(true);
        this.AddFormatRepresentationSelectMenuCheckBox.setText("Add Format Representation");
        this.ReadPreferenceMenu.add(this.AddFormatRepresentationSelectMenuCheckBox);
        this.jMenuBar1.add(this.ReadPreferenceMenu);
        this.ToolsMenu.setText("Tools");
        this.LafMenuItem.setText("Look And Feel");
        this.LafMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.LafMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.LafMenuItem);
        this.AboutMenuItem.setText("About");
        this.AboutMenuItem.setToolTipText("");
        this.AboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaceWindu.this.AboutMenuItemActionPerformed(evt);
            }
        });
        this.ToolsMenu.add(this.AboutMenuItem);
        this.jMenuBar1.add(this.ToolsMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void WriteStr(String StrSend) {
        if (this.BaudRateComboBox.getSelectedIndex() == 0) {
            this.MsgLabel.setText("Error : Please Select Baud Rate");
        }
        try {
            byte[] data = StrSend.getBytes();
            this.ComOut.write(data);
        }
        catch (Exception e) {
            this.MsgLabel.setText("Error Occured At WriteStr()");
        }
    }

    private void Write(int IntSend) {
        if (this.BaudRateComboBox.getSelectedIndex() == 0) {
            this.MsgLabel.setText("Error : Please Select Baud Rate");
        }
        try {
            this.ComOut.write(IntSend);
        }
        catch (Exception e) {
            this.MsgLabel.setText("An Error Occured At Write()");
        }
    }

    private void PortsComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.PortName = this.PortsComboBox.getSelectedItem().toString();
            if (this.PortsComboBox.getSelectedIndex() >= 1) {
                this.ComboBoxEnSelect(true);
                this.MsgLabel.setVisible(true);
                this.CloseComPort();
                this.OpenComPort(this.PortName);
                this.PreviousPortname = this.PortsComboBox.getSelectedItem().toString();
            } else {
                this.ComboBoxEnSelect(false);
                this.MsgLabel.setVisible(false);
            }
        }
    }

    private void BaudRateComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1 && this.BaudRateComboBox.getSelectedIndex() >= 1) {
            this.BaudRate = this.ConvertStr2Int(this.BaudRateComboBox.getSelectedItem().toString(), 0);
            if (this.BaudRate != 0) {
                try {
                    this.OpenComPort(this.PortName);
                }
                catch (Exception e) {
                    this.MsgLabel.setText("Failed to Change BaudRate");
                }
            } else {
                this.MsgLabel.setText("Unknown BaudRate Value");
            }
        }
    }

    private void DataBitsComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1 && this.DataBitsComboBox.getSelectedIndex() >= 1) {
            this.DataBits = this.ConvertStr2Int(this.DataBitsComboBox.getSelectedItem().toString(), 0);
            if (this.DataBits != 0) {
                try {
                    this.OpenComPort(this.PortName);
                }
                catch (Exception e) {
                    this.MsgLabel.setText("Failed to Change Data Bits");
                }
            }
        }
    }

    private void StopBitsComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1 && this.StopBitsComboBox.getSelectedIndex() >= 1) {
            if (this.StopBitsComboBox.getSelectedIndex() == 1) {
                this.StopBits = 1;
            }
            if (this.StopBitsComboBox.getSelectedIndex() == 2) {
                this.StopBits = 3;
            }
            if (this.StopBitsComboBox.getSelectedIndex() == 3) {
                this.StopBits = 2;
            }
            try {
                this.OpenComPort(this.PortName);
            }
            catch (Exception e) {
                this.MsgLabel.setText("Failed to Change Stop Bits");
            }
        }
    }

    private void ParityComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1 && this.ParityComboBox.getSelectedIndex() >= 1) {
            if (this.ParityComboBox.getSelectedIndex() == 1) {
                this.Parity = 2;
            }
            if (this.ParityComboBox.getSelectedIndex() == 2) {
                this.Parity = 3;
            }
            if (this.ParityComboBox.getSelectedIndex() == 3) {
                this.Parity = 0;
            }
            if (this.ParityComboBox.getSelectedIndex() == 4) {
                this.Parity = 1;
            }
            if (this.ParityComboBox.getSelectedIndex() == 5) {
                this.Parity = 4;
            }
            try {
                this.OpenComPort(this.PortName);
                this.MsgLabel.setText("");
            }
            catch (Exception e) {
                this.MsgLabel.setText("Failed to Change Parity");
            }
        }
    }

    private void HandShakeComboBoxItemStateChanged(ItemEvent evt) {
        this.CloseComPort();
        if (evt.getStateChange() == 1 && this.HandShakeComboBox.getSelectedIndex() >= 1) {
            if (this.HandShakeComboBox.getSelectedIndex() == 1) {
                this.HandShake = 0;
            }
            if (this.HandShakeComboBox.getSelectedIndex() == 2) {
                this.HandShake = 1;
            }
            if (this.HandShakeComboBox.getSelectedIndex() == 3) {
                this.HandShake = 2;
            }
            if (this.HandShakeComboBox.getSelectedIndex() == 4) {
                this.HandShake = 4;
            }
            if (this.HandShakeComboBox.getSelectedIndex() == 5) {
                this.HandShake = 8;
            }
            try {
                this.OpenComPort(this.PortName);
            }
            catch (Exception e) {
                this.MsgLabel.setText("Failed to Change HandShake");
            }
        }
    }

    private void TxButtonActionPerformed(ActionEvent evt) {
        if (this.WriteStrSelectMenuButton.isSelected()) {
            this.TxString = this.WriteTextField.getText();
            if (this.AddNSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\n";
            }
            if (this.AddRSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\r";
            }
            this.WriteStr(this.TxString);
        }
        if (this.WriteBinSelectMenuButton.isSelected()) {
            this.TxData = Integer.parseInt(this.WriteTextField.getText(), 2);
            this.Write(this.TxData);
        }
        if (this.WriteOctSelectMenuButton.isSelected()) {
            this.TxData = Integer.parseInt(this.WriteTextField.getText(), 8);
            this.Write(this.TxData);
        }
        if (this.WriteDecSelectMenuButton.isSelected()) {
            this.TxData = Integer.parseInt(this.WriteTextField.getText(), 10);
            this.Write(this.TxData);
        }
        if (this.WriteHexSelectMenuButton.isSelected()) {
            this.TxData = Integer.parseInt(this.WriteTextField.getText(), 16);
            this.Write(this.TxData);
        }
    }

    private void WriteTextFieldKeyReleased(KeyEvent evt) {
        if (this.PressAnyKeySelectMenuButton.isSelected()) {
            this.TxString = this.WriteTextField.getText();
            if (this.AddNSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\n";
            }
            if (this.AddRSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\r";
            }
            this.WriteStr(this.TxString);
            this.WriteTextField.setText(null);
        }
        if (this.WriteDecSelectMenuButton.isSelected() && this.PressedKeyCheck && this.WriteTextField.getText() != null) {
            this.ConvertedInt = Integer.valueOf(this.WriteTextField.getText());
            if (this.ConvertedInt > 255) {
                JOptionPane.showMessageDialog(this.rootPane, "Can't Transmitt Over a Byte");
            }
        }
        if (this.WriteOctSelectMenuButton.isSelected() && this.PressedKeyCheck && this.WriteTextField.getText() != null) {
            this.ConvertedInt = Integer.parseInt(this.WriteTextField.getText(), 8);
            if (this.ConvertedInt > 255) {
                JOptionPane.showMessageDialog(this.rootPane, "Can't Transmitt Over a Byte");
            }
        }
        if (this.WriteHexSelectMenuButton.isSelected()) {
            this.WriteTextField.setText(this.WriteTextField.getText().toUpperCase());
        }
    }

    private void WriteTextFieldKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\u001b') {
            this.WriteTextField.setText(null);
        }
        if (this.PressReturnKeySelectMenuButton.isSelected() && evt.getKeyChar() == '\n') {
            this.TxButton.doClick();
        }
        if (this.PressAnyKeySelectMenuButton.isSelected()) {
            this.TxString = this.WriteTextField.getText();
            if (this.AddNSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\n";
            }
            if (this.AddRSelectMenuCheckBox.isSelected()) {
                this.TxString = this.TxString + "\r";
            }
            this.WriteStr(this.TxString);
            this.WriteTextField.setText(null);
        }
        if (this.WriteBinSelectMenuButton.isSelected()) {
            if (evt.getKeyChar() == '0' || evt.getKeyChar() == '1') {
                if (this.WriteTextField.getText().length() >= 8) {
                    this.WriteTextField.setText(this.WriteTextField.getText().substring(0, 7));
                }
            } else {
                evt.consume();
            }
        }
        if (this.WriteDecSelectMenuButton.isSelected()) {
            this.PressedKeyChar = evt.getKeyChar();
            if (this.PressedKeyChar >= '0' && this.PressedKeyChar <= '9') {
                this.PressedKeyCheck = true;
                if (this.WriteTextField.getText().length() >= 3) {
                    this.WriteTextField.setText(this.WriteTextField.getText().substring(0, 2));
                }
            } else {
                evt.consume();
                this.PressedKeyCheck = false;
            }
        }
        if (this.WriteOctSelectMenuButton.isSelected()) {
            this.PressedKeyChar = evt.getKeyChar();
            if (this.PressedKeyChar >= '0' && this.PressedKeyChar <= '8') {
                this.PressedKeyCheck = true;
                if (this.WriteTextField.getText().length() >= 3) {
                    this.WriteTextField.setText(this.WriteTextField.getText().substring(0, 2));
                }
            } else {
                evt.consume();
                this.PressedKeyCheck = false;
            }
        }
        if (this.WriteHexSelectMenuButton.isSelected()) {
            this.PressedKeyChar = evt.getKeyChar();
            if (this.PressedKeyChar >= '0' && this.PressedKeyChar <= '9' || this.PressedKeyChar >= 'A' && this.PressedKeyChar <= 'F' || this.PressedKeyChar >= 'a' && this.PressedKeyChar <= 'f') {
                this.WriteTextField.setText(this.WriteTextField.getText().toUpperCase());
                this.PressedKeyCheck = true;
                if (this.WriteTextField.getText().length() >= 2) {
                    this.WriteTextField.setText(this.WriteTextField.getText().substring(0, 1));
                }
            } else {
                evt.consume();
                this.PressedKeyCheck = false;
            }
        }
    }

    private void WriteStrSelectMenuButtonStateChanged(ChangeEvent evt) {
        if (this.WriteStrSelectMenuButton.isSelected()) {
            this.AddRSelectMenuCheckBox.setEnabled(true);
            this.AddNSelectMenuCheckBox.setEnabled(true);
            this.PressAnyKeySelectMenuButton.setEnabled(true);
        } else {
            this.AddRSelectMenuCheckBox.setEnabled(false);
            this.AddNSelectMenuCheckBox.setEnabled(false);
            this.PressAnyKeySelectMenuButton.setEnabled(false);
            this.PressReturnKeySelectMenuButton.setSelected(true);
        }
    }

    private void AvailableLaf() {
        this.LafComboBox.removeAllItems();
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        String[] ret = new String[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.LafComboBox.addItem(info[i].getClassName());
        }
        this.LafDialogApplyButton.setEnabled(false);
    }

    private void FileSave(String str) {
        try {
            File file = new File(this.PathString + "MaceWindu.ini");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(str);
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String FileRead() throws IOException {
        String str = null;
        try {
            File file = new File(this.PathString + "MaceWindu.ini");
            FileReader fileReader = new FileReader(file);
            BufferedReader br = new BufferedReader(fileReader);
            str = br.readLine();
            br.close();
        }
        catch (FileNotFoundException e) {
            this.MsgLabel.setText("MaceWindu.ini Not Found");
        }
        return str;
    }

    private void LafMenuItemActionPerformed(ActionEvent evt) {
        this.AvailableLaf();
        this.LafDialog.setSize(500, 120);
        this.LafDialog.setLocationRelativeTo(null);
        this.LafDialog.setVisible(true);
    }

    private void LafDialogCloseButtonActionPerformed(ActionEvent evt) {
        this.LafDialog.dispose();
    }

    private void LafComboBoxItemStateChanged(ItemEvent evt) {
        this.LafDialogApplyButton.setEnabled(true);
    }

    private void LafDialogApplyButtonMouseClicked(MouseEvent evt) {
        this.LafDialogApplyButton.setEnabled(false);
        this.ChangeLookAndFeel(this.LafComboBox.getSelectedItem().toString());
        this.FileSave(this.LafComboBox.getSelectedItem().toString());
    }

    private void MaceWinduCloseMenuItemActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void AboutMenuItemActionPerformed(ActionEvent evt) {
        this.AboutDialog.setSize(400, 300);
        this.AboutDialog.setLocationRelativeTo(null);
        this.AboutDialog.setVisible(true);
    }

    private void AboutDialogOkButtonActionPerformed(ActionEvent evt) {
        this.AboutDialog.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MaceWindu().setVisible(true);
            }
        });
    }

    public class SerialPortlistener
    implements SerialPortEventListener {
        public void serialEvent(SerialPortEvent e) {
            if (e.getEventType() == 1) {
                if (MaceWindu.this.ReadSelectMenuButton.isSelected()) {
                    MaceWindu.this.Read();
                }
                if (MaceWindu.this.ReadLineSelectMenuButton.isSelected()) {
                    MaceWindu.this.ReadLine();
                }
            }
        }
    }
}

