<?php
/**
 * コンテナクラス
 *
 * PHP versions 5
 *
 * LICENSE: This source file is licensed under the terms of the GNU General Public License.
 *
 * @package    Magic3 Framework
 * @author     平田直毅(Naoki Hirata) <naoki@aplo.co.jp>
 * @copyright  Copyright 2006-2007 Magic3 Project.
 * @license    http://www.gnu.org/copyleft/gpl.html  GPL License
 * @version    SVN: $Id$
 * @link       http://www.magic3.org
 */
require_once($gEnvManager->getContainerPath() . '/baseWidgetContainer.php');
require_once($gEnvManager->getCurrentWidgetDbPath() . '/admin_mainDb.php');
require_once($gEnvManager->getIncludePath() . '/common/userInfo.php');		// ユーザ情報クラス

class admin_mainUserlistWidgetContainer extends BaseWidgetContainer
{
	private $db;	// DB接続オブジェクト
	private $sysDb;		// システムDBオブジェクト
	private $mode;			// 画面モード
	private $userId;	// ユーザID
	private $serialNo;	// シリアルNo
	const DEFAULT_LIST_COUNT = 30;			// 最大リスト表示数
		
	/**
	 * コンストラクタ
	 */
	function __construct()
	{
		global $gInstanceManager;
		
		// 親クラスを呼び出す
		parent::__construct();
		
		// DB接続オブジェクト作成
		$this->db = new admin_mainDb();
		$this->sysDb = $gInstanceManager->getSytemDbObject();
	}
	/**
	 * テンプレートファイルを設定
	 *
	 * _assign()でデータを埋め込むテンプレートファイルのファイル名を返す。
	 * 読み込むディレクトリは、「自ウィジェットディレクトリ/include/template」に固定。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。そのまま_assign()に渡る
	 * @return string 						テンプレートファイル名。テンプレートライブラリを使用しない場合は空文字列「''」を返す。
	 */
	function _setTemplate($request, &$param)
	{	
		return 'userlist.tmpl.html';
	}
	/**
	 * テンプレートにデータ埋め込む
	 *
	 * _setTemplate()で指定したテンプレートファイルにデータを埋め込む。
	 *
	 * @param RequestManager $request		HTTPリクエスト処理クラス
	 * @param object         $param			任意使用パラメータ。_setTemplate()と共有。
	 * @param								なし
	 */
	function _assign($request, &$param)
	{
		global $gEnvManager;
		
		$isRegistered = false;		// 登録更新完了したかどうか
		$act = $request->trimValueOf('act');
		$userInfo = $gEnvManager->getCurrentUserInfo();
		$this->serialNo = $request->trimValueOf('serial');		// 選択項目のシリアル番号
		
		$name = $request->trimValueOf('item_name');
		$account = $request->trimValueOf('item_account');
		$password = $request->trimValueOf('password');
		$isAdmin = ($request->trimValueOf('item_isadmin') == 'on') ? 1 : 0;			// 管理者権限があるかどうか
		$canLogin = ($request->trimValueOf('item_canlogin') == 'on') ? 1 : 0;		// ログインできるかどうか
			
		if ($act == 'select'){		// 行選択のとき
			if ($this->serialNo == 0){		// ユーザIDが0のときは、新規追加モードにする
				$this->mode = 'add';
			} else {
				// 設定データを取得
				$ret = $this->db->getUserBySerial($this->serialNo, $row);
				if ($ret){
					// 値を再設定
					$this->tmpl->addVar("_widget", "name", $row['lu_name']);
					$this->tmpl->addVar("_widget", "account", $row['lu_account']);
					$this->tmpl->addVar("_widget", "password", $row['lu_password']);

					// 項目表示、デフォルト値チェックボックス
					$isAdmin = '';
					if ($row['lu_user_type'] >= UserInfo::USER_TYPE_SYS_ADMIN){	// システム管理者
						$isAdmin = 'checked';
					}
					$canLogin = '';
					if ($row['lu_enable_login']){
						$canLogin = 'checked';
					}
					$this->tmpl->addVar("_widget", "is_admin", $isAdmin);
					$this->tmpl->addVar("_widget", "can_login", $canLogin);
					
					// ユーザID
					$this->userId = $row['lu_id'];
				}
			}
		} else if ($act == 'update'){		// 行更新のとき
			// 入力チェック
			$this->checkInput($name, '名前');
			//$this->checkSingleByte($account, 'アカウント');
			$this->checkInput($account, 'アカウント');
			//$this->checkSingleByte($password, 'パスワード');
			
			// アカウント重複チェック
			// 設定データを取得
			$ret = $this->db->getUserBySerial($this->serialNo, $row);
			if ($ret){
				if ($row['lu_account'] != $account && $this->sysDb->isExistsAccount($account)) $this->setMsg(self::MSG_USER_ERR, 'アカウントが重複しています');
			}
			
			// エラーなしの場合は、データを更新
			if ($this->getMsgCount() == 0){
				$ret = $this->db->updateUser($this->serialNo, $name, $account, $password, $isAdmin, $canLogin, $userInfo->userId, $newSerial);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを更新しました');
					$isRegistered = true;		// 登録成功
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ更新に失敗しました');
				}
			}
			if ($isRegistered){
				// 設定データを取得
				$ret = $this->db->getUserBySerial($newSerial, $row);
				if ($ret){
					$this->serialNo = $newSerial;
					
					// 値を再設定
					$this->tmpl->addVar("_widget", "name", $row['lu_name']);
					$this->tmpl->addVar("_widget", "account", $row['lu_account']);
					$this->tmpl->addVar("_widget", "password", $row['lu_password']);

					// 項目表示、デフォルト値チェックボックス
					$isAdmin = '';
					if ($row['lu_user_type'] >= UserInfo::USER_TYPE_SYS_ADMIN){	// システム管理者
						$isAdmin = 'checked';
					}
					$canLogin = '';
					if ($row['lu_enable_login']){
						$canLogin = 'checked';
					}
					$this->tmpl->addVar("_widget", "is_admin", $isAdmin);
					$this->tmpl->addVar("_widget", "can_login", $canLogin);
				}
			} else {
				// 入力値を戻す
				$this->tmpl->addVar("_widget", "name", $name);
				$this->tmpl->addVar("_widget", "account", $account);
				$this->tmpl->addVar("_widget", "password", $password);
				$isAdminCheck = '';
				if ($isAdmin) $isAdminCheck = 'checked';
				if ($canLogin) $canLoginCheck = 'checked';
				$this->tmpl->addVar("_widget", "is_admin", $isAdminCheck);
				$this->tmpl->addVar("_widget", "can_login", $canLoginCheck);
			}
			// ユーザID
			$this->userId = $row['lu_id'];
		} else if ($act == 'add'){		// 新規追加のとき
			// 入力チェック
			$this->checkInput($name, '名前');
			//$this->checkSingleByte($account, 'アカウント');
			$this->checkInput($account, 'アカウント');
			//$this->checkSingleByte($password, 'パスワード');
			// アカウント重複チェック
			if ($this->sysDb->isExistsAccount($account)) $this->setMsg(self::MSG_USER_ERR, 'アカウントが重複しています');
						
			// エラーなしの場合は、データを登録
			if ($this->getMsgCount() == 0){
				$ret = $this->db->addNewUser($name, $account, $password, $isAdmin, $canLogin, $userInfo->userId);
				if ($ret){		// データ追加成功のとき
					$this->setMsg(self::MSG_GUIDANCE, 'データを追加しました');
					$isRegistered = true;		// 登録成功
				} else {
					$this->setMsg(self::MSG_APP_ERR, 'データ追加に失敗しました');
				}
			}
			if (!$isRegistered){
				// 入力値を戻す
				$this->tmpl->addVar("_widget", "name", $name);
				$this->tmpl->addVar("_widget", "account", $account);
				$this->tmpl->addVar("_widget", "password", $password);
				$isAdminCheck = '';
				if ($isAdmin) $isAdminCheck = 'checked';
				if ($canLogin) $canLoginCheck = 'checked';
				$this->tmpl->addVar("_widget", "is_admin", $isAdminCheck);
				$this->tmpl->addVar("_widget", "can_login", $canLoginCheck);
			}
		} else if ($act == 'delete'){		// 削除のとき
			$ret = $this->db->delUser($this->serialNo, $userInfo->userId);
			if ($ret){		// データ削除成功のとき
				$this->setMsg(self::MSG_GUIDANCE, 'データを削除しました');
				
				// シリアル番号初期化
				$this->serialNo = 0;
			} else {
				$this->setMsg(self::MSG_APP_ERR, 'データ削除に失敗しました');
			}
		}
		if ($this->serialNo == 0){		// ユーザIDが0のときは新規とする
			$this->tmpl->addVar("_widget", "sel_item_id", '新規');			// ユーザID
			$this->tmpl->addVar("_widget", "new_selected", 'checked');// ユーザIDが0のときは新規追加をチェック状態にする
			
			$this->tmpl->setAttribute('add_button', 'visibility', 'visible');// 新規登録ボタン表示
		} else {
			$this->tmpl->addVar("_widget", "sel_item_id", $this->userId);			// ユーザID
			
			$this->tmpl->setAttribute('update_button', 'visibility', 'visible');// 更新ボタン表示
		}
		// 選択中のシリアル番号
		$this->tmpl->addVar("_widget", "serial", $this->serialNo);
		
		$maxListCount = self::DEFAULT_LIST_COUNT;				// 表示項目数
		$pageNo = $request->trimValueOf('page');				// ページ番号
		if (empty($pageNo)) $pageNo = 1;
		
		// 総数を取得
		$totalCount = $this->db->getAllUserListCount();

		// 表示するページ番号の修正
		$pageCount = (int)(($totalCount -1) / $maxListCount) + 1;		// 総ページ数
		if ($pageNo < 1) $pageNo = 1;
		if ($pageNo > $pageCount) $pageNo = $pageCount;
		$this->firstNo = ($pageNo -1) * $maxListCount + 1;		// 先頭番号
		
		// ページング用リンク作成
		$pageLink = '';
		if ($pageCount > 1){	// ページが2ページ以上のときリンクを作成
			for ($i = 1; $i <= $pageCount; $i++){
				if ($i == $pageNo){
					$link = '&nbsp;' . $i;
				} else {
					$link = '&nbsp;<a href="#" onclick="selpage(\'' . $i . '\');return false;">' . $i . '</a>';
				}
				$pageLink .= $link;
			}
		}
		$this->tmpl->addVar("_widget", "page_link", $pageLink);
		$this->tmpl->addVar("_widget", "total_count", $totalCount);
		$this->tmpl->addVar("_widget", "page", $pageNo);	// ページ番号
		
		// ユーザリストを取得
		$this->db->getAllUserList($maxListCount, $pageNo, array($this, 'userListLoop'));
		
		// ディレクトリを設定
		$this->tmpl->addVar("_widget", "script_url", $gEnvManager->getScriptsUrl());
	}
	/**
	 * ユーザリスト、取得したデータをテンプレートに設定する
	 *
	 * @param int $index			行番号(0～)
	 * @param array $fetchedRow		フェッチ取得した行
	 * @param object $param			未使用
	 * @return bool					true=処理続行の場合、false=処理終了の場合
	 */
	function userListLoop($index, $fetchedRow, $param)
	{
		$isAdmin = '';
		if ($fetchedRow['lu_user_type'] >= UserInfo::USER_TYPE_SYS_ADMIN){	// システム管理者
			$isAdmin = 'checked';
		}
		$canLogin = '';
		if ($fetchedRow['lu_enable_login']){
			$canLogin = 'checked';
		}
		// 行カラーの設定
		$lineColor = '';
		if ($index % 2 != 0){
			$lineColor = 'class="even"';		// 偶数行
		}
		// 項目選択のラジオボタンの状態
		$id = $this->convertToDispString($fetchedRow['lu_id']);
		$selected = '';
		if ($id == $this->userId){
			$selected = 'checked';
		}
		// ユーザ種別
		switch ($fetchedRow['lu_user_type']){
			case UserInfo::USER_TYPE_TMP:
				$userType = '<font color="orange">仮登録</font>';
				break;
			case UserInfo::USER_TYPE_NORMAL:
				$userType = '<font color="green">通常ユーザ</font>';
				break;
			case UserInfo::USER_TYPE_SYS_ADMIN:
				$userType = '<font color="red">管理者</font>';
				break;
			default:
				$userType = '該当なし';
				break;
		}
		$row = array(
			'line_color' => $lineColor,											// 行のカラー
			'no' => $index + 1,													// 行番号
			'serial' => $this->convertToDispString($fetchedRow['lu_serial']),			// シリアル番号
			'id' => $this->convertToDispString($fetchedRow['lu_id']),			// ID
			'name' => $this->convertToDispString($fetchedRow['lu_name']),		// 名前
			'account' => $this->convertToDispString($fetchedRow['lu_account']),		// アカウント
			'user_type' => $userType,		// ユーザ種別
			'update_dt' => $this->convertToDispDateTime($fetchedRow['lu_create_dt']),	// 更新日時
			'is_admin' => $isAdmin,													// 管理者権限があるかどうか
			'can_login' => $canLogin,												// ログイン可能かどうか
			'selected' => $selected												// 項目選択用ラジオボタン
		);
		$this->tmpl->addVars('userlist', $row);
		$this->tmpl->parseTemplate('userlist', 'a');
		return true;
	}
}
?>
